/* The following code was generated by JFlex 1.7.0 tweaked for IntelliJ platform */

/* It's an automatically generated code. Do not modify it. */
package com.intellij.lexer;

import com.intellij.psi.tree.IElementType;
import com.intellij.psi.*;
import com.intellij.psi.xml.*;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.7.0
 * from the specification file <tt>_HtmlLexer.flex</tt>
 */
public class _HtmlLexer implements FlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int DOC_TYPE = 2;
  public static final int COMMENT = 4;
  public static final int START_TAG_NAME = 6;
  public static final int END_TAG_NAME = 8;
  public static final int BEFORE_TAG_ATTRIBUTES = 10;
  public static final int TAG_ATTRIBUTES = 12;
  public static final int ATTRIBUTE_VALUE_START = 14;
  public static final int ATTRIBUTE_VALUE_DQ = 16;
  public static final int ATTRIBUTE_VALUE_SQ = 18;
  public static final int PROCESSING_INSTRUCTION = 20;
  public static final int TAG_CHARACTERS = 22;
  public static final int C_COMMENT_START = 24;
  public static final int C_COMMENT_END = 26;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13
  };

  /** 
   * Translates characters to character classes
   * Chosen bits are [11, 6, 4]
   * Total runtime size is 14112 bytes
   */
  public static int ZZ_CMAP(int ch) {
    return ZZ_CMAP_A[(ZZ_CMAP_Y[(ZZ_CMAP_Z[ch>>10]<<6)|((ch>>4)&0x3f)]<<4)|(ch&0xf)];
  }

  /* The ZZ_CMAP_Z table has 1088 entries */
  static final char ZZ_CMAP_Z[] = zzUnpackCMap(
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7\1\10\2\11\1\12\1\13\6\14\1\15\23\14\1\16"+
    "\1\14\1\17\1\20\12\14\1\21\10\11\1\22\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1"+
    "\32\1\33\1\34\1\35\2\11\1\14\1\36\3\11\1\37\10\11\1\40\1\41\5\14\1\42\1\43"+
    "\11\11\1\44\2\11\1\45\5\11\1\46\4\11\1\47\1\50\4\11\51\14\1\51\3\14\1\52\1"+
    "\53\4\14\1\54\12\11\1\55\u0381\11");

  /* The ZZ_CMAP_Y table has 2944 entries */
  static final char ZZ_CMAP_Y[] = zzUnpackCMap(
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\1\1\11\1\12\1\13\1\14\1\13\1\14\34"+
    "\13\1\15\1\16\1\17\10\1\1\20\1\21\1\13\1\22\4\13\1\23\10\13\1\24\12\13\1\25"+
    "\1\13\1\26\1\25\1\13\1\27\4\1\1\13\1\30\1\31\2\1\2\13\1\30\1\1\1\32\1\25\5"+
    "\13\1\33\1\34\1\35\1\1\1\36\1\13\1\1\1\37\5\13\1\40\1\41\1\42\1\13\1\30\1"+
    "\43\1\13\1\44\1\45\1\1\1\13\1\46\4\1\1\13\1\47\4\1\1\50\2\13\1\51\1\1\1\52"+
    "\1\16\1\25\1\53\1\54\1\55\1\56\1\57\1\60\2\16\1\61\1\54\1\55\1\62\1\1\1\63"+
    "\1\1\1\64\1\65\1\22\1\55\1\66\1\1\1\67\1\16\1\70\1\71\1\54\1\55\1\66\1\1\1"+
    "\60\1\16\1\41\1\72\1\73\1\74\1\75\1\1\1\67\2\1\1\76\1\36\1\55\1\51\1\1\1\77"+
    "\1\16\1\1\1\100\1\36\1\55\1\101\1\1\1\57\1\16\1\102\1\76\1\36\1\13\1\103\1"+
    "\57\1\104\1\16\1\42\1\105\1\106\1\13\1\107\1\110\3\1\1\25\2\13\1\111\1\110"+
    "\3\1\1\112\1\113\1\114\1\115\1\116\1\117\2\1\1\67\3\1\1\120\1\13\1\121\1\1"+
    "\1\122\7\1\2\13\1\30\1\123\1\1\1\124\1\125\1\126\1\127\1\1\2\13\1\130\2\13"+
    "\1\131\24\13\1\132\1\133\2\13\1\132\2\13\1\134\1\135\1\14\3\13\1\135\3\13"+
    "\1\30\2\1\1\13\1\1\5\13\1\136\1\25\45\13\1\137\1\13\1\25\1\30\4\13\1\30\1"+
    "\140\1\141\1\16\1\13\1\16\1\13\1\16\1\141\1\67\3\13\1\142\1\1\1\143\4\1\5"+
    "\13\1\27\1\144\1\13\1\145\4\13\1\40\1\13\1\146\3\1\1\13\1\147\1\150\2\13\1"+
    "\151\1\13\1\75\3\1\1\13\1\110\3\13\1\150\4\1\1\152\5\1\1\105\2\13\1\142\1"+
    "\153\3\1\1\154\1\13\1\155\1\42\2\13\1\40\1\1\2\13\1\142\1\1\1\37\1\42\1\13"+
    "\1\147\1\46\5\1\1\156\1\157\14\13\4\1\21\13\1\136\2\13\1\136\1\160\1\13\1"+
    "\147\3\13\1\161\1\162\1\163\1\121\1\162\2\1\1\164\4\1\1\165\1\1\1\121\6\1"+
    "\1\166\1\167\1\170\1\171\1\172\3\1\1\173\147\1\2\13\1\146\2\13\1\146\10\13"+
    "\1\174\1\175\2\13\1\130\3\13\1\176\1\1\1\13\1\110\4\177\4\1\1\123\35\1\1\200"+
    "\2\1\1\201\1\25\4\13\1\202\1\25\4\13\1\131\1\105\1\13\1\147\1\25\4\13\1\146"+
    "\1\1\1\13\1\30\3\1\1\13\40\1\133\13\1\40\4\1\135\13\1\40\2\1\10\13\1\121\4"+
    "\1\2\13\1\147\20\13\1\121\1\13\1\203\1\1\2\13\1\146\1\123\1\13\1\147\4\13"+
    "\1\40\2\1\1\204\1\205\5\13\1\206\1\13\1\146\1\27\3\1\1\204\1\207\1\13\1\31"+
    "\1\1\3\13\1\142\1\205\2\13\1\142\3\1\1\210\1\42\1\13\1\40\1\13\1\110\1\1\1"+
    "\13\1\121\1\50\2\13\1\31\1\123\1\1\1\211\1\212\2\13\1\46\1\1\1\213\1\1\1\13"+
    "\1\214\3\13\1\215\1\216\1\217\1\30\1\64\1\220\1\221\1\177\2\13\1\131\1\40"+
    "\7\13\1\31\1\1\72\13\1\142\1\13\1\222\2\13\1\151\20\1\26\13\1\147\6\13\1\75"+
    "\2\1\1\110\1\223\1\55\1\224\1\225\6\13\1\16\1\1\1\154\25\13\1\147\1\1\4\13"+
    "\1\205\2\13\1\27\2\1\1\151\7\1\1\211\7\13\1\121\2\1\1\25\1\30\1\25\1\30\1"+
    "\226\4\13\1\146\1\227\1\230\2\1\1\231\1\13\1\14\1\232\2\147\2\1\7\13\1\30"+
    "\30\1\1\13\1\121\3\13\1\67\2\1\2\13\1\1\1\13\1\233\2\13\1\40\1\13\1\147\2"+
    "\13\1\234\3\1\11\13\1\147\1\1\2\13\1\234\1\13\1\151\2\13\1\27\3\13\1\142\11"+
    "\1\23\13\1\110\1\13\1\40\1\27\11\1\1\235\2\13\1\236\1\13\1\40\1\13\1\110\1"+
    "\13\1\146\4\1\1\13\1\237\1\13\1\40\1\13\1\75\4\1\3\13\1\240\4\1\1\67\1\241"+
    "\1\13\1\142\2\1\1\13\1\121\1\13\1\121\2\1\1\120\1\13\1\150\1\1\3\13\1\40\1"+
    "\13\1\40\1\13\1\31\1\13\1\16\6\1\4\13\1\46\3\1\3\13\1\31\3\13\1\31\60\1\1"+
    "\154\2\13\1\27\4\1\1\154\2\13\2\1\1\13\1\46\1\1\1\154\1\13\1\110\2\1\2\13"+
    "\1\242\1\154\2\13\1\31\1\243\1\244\2\1\1\13\1\22\1\151\5\1\1\245\1\246\1\46"+
    "\2\13\1\146\2\1\1\71\1\54\1\55\1\66\1\1\1\247\1\16\11\1\3\13\1\150\1\250\3"+
    "\1\3\13\1\1\1\251\13\1\2\13\1\146\2\1\1\252\2\1\3\13\1\1\1\253\3\1\2\13\1"+
    "\30\5\1\1\13\1\75\30\1\4\13\1\1\1\123\34\1\3\13\1\46\20\1\1\55\1\13\1\146"+
    "\1\1\1\67\2\1\1\205\1\13\67\1\71\13\1\75\16\1\14\13\1\142\53\1\2\13\1\146"+
    "\75\1\44\13\1\110\33\1\43\13\1\46\1\13\1\146\7\1\1\13\1\147\1\1\3\13\1\1\1"+
    "\142\1\1\1\154\1\254\1\13\67\1\4\13\1\150\1\67\3\1\1\154\4\1\1\67\1\1\76\13"+
    "\1\121\1\1\57\13\1\31\20\1\1\16\77\1\6\13\1\30\1\121\1\46\1\75\66\1\5\13\1"+
    "\211\3\13\1\141\1\255\1\256\1\257\3\13\1\260\1\261\1\13\1\262\1\263\1\36\24"+
    "\13\1\264\1\13\1\36\1\131\1\13\1\131\1\13\1\211\1\13\1\211\1\146\1\13\1\146"+
    "\1\13\1\55\1\13\1\55\1\13\1\213\3\1\14\13\1\150\3\1\4\13\1\142\113\1\1\257"+
    "\1\13\1\265\1\266\1\267\1\270\1\271\1\272\1\273\1\151\1\274\1\151\24\1\55"+
    "\13\1\110\2\1\103\13\1\150\15\13\1\147\150\13\1\16\25\1\41\13\1\147\36\1");

  /* The ZZ_CMAP_A table has 3024 entries */
  static final char ZZ_CMAP_A[] = zzUnpackCMap(
    "\11\0\2\10\1\0\2\10\22\0\1\10\1\14\1\11\1\60\1\51\1\0\1\43\1\12\2\42\3\0\1"+
    "\6\1\5\1\45\12\2\1\4\1\52\1\13\1\7\1\41\1\44\1\0\1\62\1\36\1\20\1\15\1\26"+
    "\1\62\1\1\1\27\1\40\2\1\1\32\1\30\1\1\1\16\1\24\3\1\1\21\1\34\2\1\1\61\1\23"+
    "\1\1\1\46\1\50\1\47\1\0\1\4\1\0\1\54\1\37\1\20\1\15\1\26\1\62\1\53\1\27\1"+
    "\40\2\1\1\33\1\31\1\57\1\17\1\25\1\56\1\1\1\55\1\22\1\35\2\1\1\61\1\23\1\1"+
    "\1\0\1\42\10\0\1\3\24\0\1\1\12\0\1\1\4\0\1\1\5\0\27\1\1\0\12\1\4\0\14\1\16"+
    "\0\5\1\7\0\1\1\1\0\1\1\1\0\5\1\1\0\2\1\2\0\4\1\1\0\1\1\6\0\1\1\1\0\3\1\1\0"+
    "\1\1\1\0\4\1\1\0\23\1\1\0\13\1\10\0\6\1\1\0\26\1\2\0\1\1\6\0\10\1\10\0\13"+
    "\1\5\0\3\1\33\0\6\1\1\0\1\1\17\0\2\1\7\0\2\1\12\0\3\1\2\0\2\1\1\0\16\1\15"+
    "\0\11\1\13\0\1\1\30\0\6\1\4\0\2\1\4\0\1\1\5\0\6\1\4\0\1\1\11\0\1\1\3\0\1\1"+
    "\7\0\11\1\7\0\5\1\1\0\10\1\6\0\26\1\3\0\1\1\2\0\1\1\7\0\11\1\4\0\10\1\2\0"+
    "\2\1\2\0\26\1\1\0\7\1\1\0\1\1\3\0\4\1\3\0\1\1\20\0\1\1\15\0\2\1\1\0\1\1\5"+
    "\0\6\1\4\0\2\1\1\0\2\1\1\0\2\1\1\0\2\1\17\0\4\1\1\0\1\1\3\0\3\1\20\0\11\1"+
    "\1\0\2\1\1\0\2\1\1\0\5\1\3\0\1\1\2\0\1\1\30\0\1\1\13\0\10\1\2\0\1\1\3\0\1"+
    "\1\1\0\6\1\3\0\3\1\1\0\4\1\3\0\2\1\1\0\1\1\1\0\2\1\3\0\2\1\3\0\3\1\3\0\14"+
    "\1\13\0\10\1\1\0\2\1\10\0\3\1\5\0\1\1\4\0\10\1\1\0\6\1\1\0\5\1\3\0\1\1\3\0"+
    "\2\1\15\0\13\1\2\0\1\1\6\0\3\1\10\0\1\1\5\0\22\1\3\0\10\1\1\0\11\1\1\0\1\1"+
    "\2\0\7\1\11\0\1\1\1\0\2\1\15\0\2\1\1\0\1\1\2\0\2\1\1\0\1\1\2\0\1\1\6\0\4\1"+
    "\1\0\7\1\1\0\3\1\1\0\1\1\1\0\1\1\2\0\2\1\1\0\4\1\1\0\2\1\11\0\1\1\2\0\5\1"+
    "\1\0\1\1\25\0\14\1\1\0\24\1\13\0\5\1\22\0\7\1\4\0\4\1\3\0\1\1\3\0\2\1\7\0"+
    "\3\1\4\0\15\1\14\0\1\1\1\0\6\1\1\0\1\1\5\0\1\1\2\0\13\1\1\0\15\1\1\0\4\1\2"+
    "\0\7\1\1\0\1\1\1\0\4\1\2\0\1\1\1\0\4\1\2\0\7\1\1\0\1\1\1\0\4\1\2\0\16\1\2"+
    "\0\6\1\2\0\15\1\2\0\1\1\1\0\10\1\7\0\15\1\1\0\6\1\23\0\1\1\4\0\1\1\3\0\5\1"+
    "\2\0\22\1\1\0\1\1\5\0\17\1\1\0\16\1\2\0\5\1\13\0\14\1\13\0\1\1\15\0\7\1\7"+
    "\0\16\1\15\0\2\1\11\0\4\1\1\0\4\1\3\0\2\1\11\0\10\1\1\0\1\1\1\0\1\1\1\0\1"+
    "\1\1\0\6\1\1\0\7\1\1\0\1\1\3\0\3\1\1\0\7\1\3\0\4\1\2\0\6\1\14\0\2\3\7\0\1"+
    "\1\15\0\1\1\2\0\1\1\4\0\1\1\2\0\12\1\1\0\1\1\3\0\5\1\6\0\1\1\1\0\1\1\1\0\1"+
    "\1\1\0\4\1\1\0\13\1\2\0\4\1\5\0\5\1\4\0\1\1\4\0\2\1\13\0\5\1\6\0\4\1\3\0\2"+
    "\1\14\0\10\1\7\0\10\1\1\0\7\1\6\0\2\1\12\0\5\1\5\0\2\1\3\0\7\1\6\0\3\1\12"+
    "\0\2\1\13\0\11\1\2\0\27\1\2\0\7\1\1\0\3\1\1\0\4\1\1\0\4\1\2\0\6\1\3\0\1\1"+
    "\1\0\1\1\2\0\5\1\1\0\12\1\12\0\5\1\1\0\3\1\1\0\10\1\4\0\7\1\3\0\1\1\3\0\2"+
    "\1\1\0\1\1\3\0\2\1\2\0\5\1\2\0\1\1\1\0\1\1\30\0\3\1\3\0\6\1\2\0\6\1\2\0\6"+
    "\1\11\0\7\1\4\0\5\1\3\0\5\1\5\0\1\1\1\0\10\1\1\0\5\1\1\0\1\1\1\0\2\1\1\0\2"+
    "\1\1\0\12\1\6\0\12\1\2\0\6\1\2\0\6\1\2\0\6\1\2\0\3\1\3\0\14\1\1\0\16\1\1\0"+
    "\2\1\1\0\2\1\1\0\10\1\6\0\4\1\4\0\16\1\2\0\1\1\1\0\14\1\1\0\2\1\3\0\1\1\2"+
    "\0\4\1\1\0\2\1\12\0\10\1\6\0\6\1\1\0\3\1\1\0\12\1\3\0\1\1\12\0\4\1\25\0\1"+
    "\1\1\0\1\1\3\0\7\1\1\0\1\1\1\0\4\1\1\0\17\1\1\0\2\1\14\0\3\1\7\0\4\1\11\0"+
    "\2\1\1\0\1\1\20\0\4\1\10\0\1\1\13\0\10\1\5\0\3\1\2\0\1\1\2\0\2\1\2\0\4\1\1"+
    "\0\14\1\1\0\1\1\1\0\7\1\1\0\21\1\1\0\4\1\2\0\10\1\1\0\7\1\1\0\14\1\1\0\4\1"+
    "\1\0\5\1\1\0\1\1\3\0\14\1\2\0\10\1\1\0\2\1\1\0\1\1\2\0\1\1\1\0\12\1\1\0\4"+
    "\1\1\0\1\1\1\0\1\1\6\0\1\1\4\0\1\1\1\0\1\1\1\0\1\1\1\0\3\1\1\0\2\1\1\0\1\1"+
    "\2\0\1\1\1\0\1\1\1\0\1\1\1\0\1\1\1\0\1\1\1\0\2\1\1\0\1\1\2\0\4\1\1\0\7\1\1"+
    "\0\4\1\1\0\4\1\1\0\1\1\1\0\12\1\1\0\5\1\1\0\3\1\1\0\5\1\1\0\5\1");

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\1\11\0\1\2\3\0\1\1\2\3\4\1\1\4"+
    "\1\5\4\4\1\6\1\4\3\7\1\10\1\7\1\11"+
    "\1\12\1\13\1\14\2\12\1\15\1\16\1\12\1\17"+
    "\1\5\1\20\1\21\1\5\1\22\1\23\1\21\1\24"+
    "\1\25\2\24\1\2\1\26\1\4\3\27\1\30\1\7"+
    "\3\30\1\31\1\32\1\0\1\33\1\34\14\0\1\34"+
    "\1\35\1\21\2\0\1\36\2\0\1\37\1\40\12\0"+
    "\1\41\1\0\1\42\1\43\1\0\1\44\3\0\1\17"+
    "\1\45\1\4\3\0\1\46\2\0\1\47";

  private static int [] zzUnpackAction() {
    int [] result = new int[122];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\63\0\146\0\231\0\314\0\377\0\u0132\0\u0165"+
    "\0\u0198\0\u01cb\0\u01fe\0\u0231\0\u0264\0\u0297\0\u02ca\0\u02fd"+
    "\0\u0330\0\u0363\0\u0396\0\u03c9\0\u03fc\0\u03fc\0\u042f\0\u0462"+
    "\0\u0495\0\u04c8\0\u04fb\0\u03fc\0\u0396\0\u03fc\0\u052e\0\u0561"+
    "\0\u03fc\0\u0396\0\u03fc\0\u03fc\0\u0594\0\u03fc\0\u0396\0\u05c7"+
    "\0\u05fa\0\u03fc\0\u062d\0\u0660\0\u0693\0\u03fc\0\u06c6\0\u06f9"+
    "\0\u03fc\0\u03fc\0\u072c\0\u03fc\0\u03fc\0\u0396\0\u075f\0\u0792"+
    "\0\u03fc\0\u07c5\0\u03fc\0\u0396\0\u062d\0\u03fc\0\u07f8\0\u082b"+
    "\0\u0396\0\u085e\0\u03fc\0\u0891\0\u08c4\0\u03fc\0\u08f7\0\u092a"+
    "\0\u095d\0\u0990\0\u09c3\0\u09f6\0\u0a29\0\u0462\0\u0495\0\u0a5c"+
    "\0\u0a8f\0\u0ac2\0\u0af5\0\u03fc\0\u03fc\0\u0b28\0\u0b5b\0\u0b8e"+
    "\0\u03fc\0\u0bc1\0\u0bf4\0\u0c27\0\u03fc\0\u0c5a\0\u0c8d\0\u0cc0"+
    "\0\u0cf3\0\u0d26\0\u0d59\0\u0d8c\0\u0dbf\0\u0df2\0\u0e25\0\u03fc"+
    "\0\u0e58\0\u03fc\0\u03fc\0\u0e8b\0\u03fc\0\u0ebe\0\u0ef1\0\u0f24"+
    "\0\u03fc\0\u03fc\0\u0f57\0\u0f8a\0\u0fbd\0\u0ff0\0\u03fc\0\u1023"+
    "\0\u1056\0\u03fc";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[122];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\3\17\1\20\4\17\1\21\2\17\1\22\27\17\1\23"+
    "\4\17\1\24\1\25\6\17\1\25\2\17\3\26\1\27"+
    "\4\26\1\27\1\30\1\31\11\26\2\32\1\26\1\33"+
    "\11\26\1\34\1\26\1\35\17\26\6\36\1\37\4\36"+
    "\1\40\25\36\1\41\1\36\1\42\2\36\1\43\14\36"+
    "\1\44\1\45\1\44\1\27\1\45\3\44\1\27\2\44"+
    "\1\46\1\44\24\45\2\44\1\47\7\44\5\45\1\44"+
    "\2\45\1\44\1\45\1\44\1\27\1\45\3\44\1\27"+
    "\2\44\1\50\1\44\24\45\2\44\1\47\7\44\5\45"+
    "\1\44\2\45\3\44\1\51\4\44\1\51\30\44\1\52"+
    "\1\44\1\47\1\44\1\53\15\44\3\54\1\55\3\54"+
    "\1\56\1\27\3\44\25\54\1\52\3\54\1\53\15\54"+
    "\3\57\1\60\4\57\1\27\1\61\1\62\26\57\1\52"+
    "\3\57\1\63\15\57\11\64\1\65\31\64\1\66\4\64"+
    "\1\67\24\64\1\65\30\64\1\66\4\64\1\67\12\64"+
    "\41\70\1\71\2\70\1\72\16\70\3\73\1\27\4\73"+
    "\1\27\2\73\1\46\25\73\1\52\1\73\1\74\1\73"+
    "\1\75\15\73\1\76\1\77\4\76\1\100\6\76\24\77"+
    "\2\76\1\101\3\76\1\102\3\76\5\77\1\76\2\77"+
    "\1\76\1\77\4\76\1\100\6\76\24\77\2\76\1\101"+
    "\3\76\1\103\3\76\5\77\1\76\2\77\10\17\1\0"+
    "\2\17\1\0\27\17\1\0\4\17\1\24\1\0\6\17"+
    "\1\0\5\17\1\20\4\17\1\21\2\17\1\0\27\17"+
    "\1\0\4\17\1\24\1\0\6\17\1\0\2\17\3\0"+
    "\1\21\4\0\1\21\53\0\1\104\2\0\1\104\7\0"+
    "\1\105\24\104\3\0\1\106\1\107\5\0\5\104\1\0"+
    "\2\104\1\0\1\110\2\0\1\110\10\0\16\110\1\111"+
    "\5\110\12\0\1\111\1\112\1\110\1\113\1\114\1\115"+
    "\2\110\10\17\1\0\2\17\1\0\27\17\1\0\4\17"+
    "\1\24\12\17\66\0\1\27\4\0\1\27\52\0\11\116"+
    "\1\64\51\116\12\117\1\64\50\117\34\0\2\120\46\0"+
    "\2\121\46\0\1\122\70\0\1\123\47\0\2\45\1\0"+
    "\3\45\6\0\24\45\12\0\5\45\1\0\2\45\45\0"+
    "\1\124\20\0\1\51\4\0\1\51\113\0\1\125\21\0"+
    "\7\54\5\0\25\54\1\0\3\54\1\0\20\54\1\55"+
    "\3\54\1\0\1\27\3\0\25\54\1\0\3\54\1\0"+
    "\15\54\10\57\1\0\30\57\1\0\3\57\1\126\20\57"+
    "\1\60\4\57\1\27\30\57\1\0\3\57\1\126\25\57"+
    "\1\0\30\57\1\125\3\57\1\126\15\57\51\0\1\64"+
    "\11\0\41\70\1\0\2\70\1\127\57\70\1\71\21\70"+
    "\1\0\3\77\1\0\1\77\2\0\1\77\3\0\25\77"+
    "\1\0\2\77\7\0\5\77\1\0\2\77\6\0\1\130"+
    "\115\0\1\131\22\0\2\104\1\0\3\104\6\0\24\104"+
    "\12\0\5\104\1\0\2\104\6\0\1\132\6\0\1\133"+
    "\46\0\1\134\2\0\1\134\10\0\24\134\12\0\5\134"+
    "\1\0\2\134\1\0\2\110\1\0\3\110\6\0\24\110"+
    "\11\0\1\135\5\110\1\0\2\110\1\0\2\110\1\0"+
    "\3\110\6\0\5\110\1\136\16\110\11\0\1\135\5\110"+
    "\1\0\2\110\1\0\2\110\1\0\3\110\6\0\10\110"+
    "\1\137\3\110\1\140\7\110\11\0\1\135\5\110\1\0"+
    "\2\110\1\0\2\110\1\0\3\110\6\0\20\110\1\141"+
    "\3\110\11\0\1\135\5\110\1\0\2\110\1\0\2\110"+
    "\1\0\3\110\6\0\22\110\1\142\1\110\11\0\1\135"+
    "\5\110\1\0\2\110\2\0\1\143\56\0\1\144\37\0"+
    "\2\145\53\0\2\146\45\0\1\147\24\0\1\150\27\0"+
    "\1\151\37\0\1\152\14\0\41\57\1\0\3\57\1\126"+
    "\15\57\41\70\1\0\21\70\41\0\1\150\27\0\1\153"+
    "\72\0\2\154\44\0\2\134\1\0\3\134\6\0\24\134"+
    "\12\0\5\134\1\0\2\134\1\0\2\110\1\0\3\110"+
    "\6\0\24\110\11\0\1\155\5\110\1\0\2\110\1\0"+
    "\2\110\1\0\3\110\6\0\2\110\1\156\21\110\11\0"+
    "\1\135\5\110\1\0\2\110\1\0\2\110\1\0\3\110"+
    "\6\0\10\110\1\136\13\110\11\0\1\135\5\110\1\0"+
    "\2\110\1\0\2\110\1\0\3\110\6\0\2\110\1\111"+
    "\21\110\11\0\1\135\5\110\1\0\2\110\1\0\2\110"+
    "\1\0\3\110\6\0\24\110\11\0\1\135\2\110\1\140"+
    "\2\110\1\0\2\110\2\0\1\143\47\0\1\155\12\0"+
    "\1\157\12\0\1\157\2\0\1\157\5\0\1\157\7\0"+
    "\2\157\14\0\1\157\5\0\1\157\32\0\2\160\61\0"+
    "\2\161\70\0\1\162\27\0\1\163\74\0\1\164\43\0"+
    "\2\110\1\0\3\110\6\0\24\110\11\0\1\135\2\110"+
    "\1\136\2\110\1\0\2\110\2\0\1\157\12\0\1\157"+
    "\2\0\1\157\5\0\1\157\7\0\2\157\12\0\1\155"+
    "\1\0\1\157\5\0\1\157\40\0\1\165\30\0\1\147"+
    "\32\0\1\150\42\0\2\166\60\0\1\167\65\0\1\170"+
    "\63\0\2\171\63\0\1\172\34\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[4233];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\1\11\0\1\1\3\0\6\1\2\11\5\1\1\11"+
    "\1\1\1\11\2\1\1\11\1\1\2\11\1\1\1\11"+
    "\3\1\1\11\3\1\1\11\2\1\2\11\1\1\2\11"+
    "\3\1\1\11\1\1\1\11\2\1\1\11\4\1\1\11"+
    "\1\1\1\0\1\11\1\1\14\0\2\11\1\1\2\0"+
    "\1\11\2\0\1\1\1\11\12\0\1\11\1\0\2\11"+
    "\1\0\1\11\3\0\2\11\1\1\3\0\1\11\2\0"+
    "\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[122];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
  public _HtmlLexer() {
    this((java.io.Reader)null);
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public _HtmlLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    int size = 0;
    for (int i = 0, length = packed.length(); i < length; i += 2) {
      size += packed.charAt(i);
    }
    char[] map = new char[size];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < packed.length()) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      {@code false}, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position {@code pos} from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + ZZ_CMAP(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return XmlTokenType.XML_DATA_CHARACTERS;
            } 
            // fall through
          case 40: break;
          case 2: 
            { return XmlTokenType.XML_PI_TARGET;
            } 
            // fall through
          case 41: break;
          case 3: 
            { return XmlTokenType.XML_REAL_WHITE_SPACE;
            } 
            // fall through
          case 42: break;
          case 4: 
            { return XmlTokenType.XML_BAD_CHARACTER;
            } 
            // fall through
          case 43: break;
          case 5: 
            { return XmlTokenType.XML_WHITE_SPACE;
            } 
            // fall through
          case 44: break;
          case 6: 
            { yybegin(YYINITIAL); return XmlTokenType.XML_DOCTYPE_END;
            } 
            // fall through
          case 45: break;
          case 7: 
            { return XmlTokenType.XML_COMMENT_CHARACTERS;
            } 
            // fall through
          case 46: break;
          case 8: 
            { // according to HTML spec (http://www.w3.org/html/wg/drafts/html/master/syntax.html#comments)
  // comments should start with <!-- and end with -->. The comment <!--> is not valid, but should terminate
  // comment token. Please note that it's not true for XML (http://www.w3.org/TR/REC-xml/#sec-comments)
  int loc = getTokenStart();
  char prev = zzBuffer.charAt(loc - 1);
  char prevPrev = zzBuffer.charAt(loc - 2);
  if (prev == '-' && prevPrev == '-') {
    yybegin(YYINITIAL); return XmlTokenType.XML_BAD_CHARACTER;
  }
  return XmlTokenType.XML_COMMENT_CHARACTERS;
            } 
            // fall through
          case 47: break;
          case 9: 
            { yybegin(C_COMMENT_START); return XmlTokenType.XML_CONDITIONAL_COMMENT_START;
            } 
            // fall through
          case 48: break;
          case 10: 
            { yybegin(YYINITIAL); yypushback(1); break;
            } 
            // fall through
          case 49: break;
          case 11: 
            { yybegin(BEFORE_TAG_ATTRIBUTES); return XmlTokenType.XML_NAME;
            } 
            // fall through
          case 50: break;
          case 12: 
            { return XmlTokenType.XML_START_TAG_START;
            } 
            // fall through
          case 51: break;
          case 13: 
            { yybegin(TAG_ATTRIBUTES); return XmlTokenType.XML_WHITE_SPACE;
            } 
            // fall through
          case 52: break;
          case 14: 
            { yybegin(YYINITIAL); return XmlTokenType.XML_TAG_END;
            } 
            // fall through
          case 53: break;
          case 15: 
            { return XmlTokenType.XML_NAME;
            } 
            // fall through
          case 54: break;
          case 16: 
            { yybegin(ATTRIBUTE_VALUE_START); return XmlTokenType.XML_EQ;
            } 
            // fall through
          case 55: break;
          case 17: 
            { yybegin(TAG_ATTRIBUTES); return XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
            } 
            // fall through
          case 56: break;
          case 18: 
            { yybegin(ATTRIBUTE_VALUE_DQ); return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
            } 
            // fall through
          case 57: break;
          case 19: 
            { yybegin(ATTRIBUTE_VALUE_SQ); return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
            } 
            // fall through
          case 58: break;
          case 20: 
            { return XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
            } 
            // fall through
          case 59: break;
          case 21: 
            { yybegin(TAG_ATTRIBUTES); return XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER;
            } 
            // fall through
          case 60: break;
          case 22: 
            { yybegin(YYINITIAL); return XmlTokenType.XML_PI_END;
            } 
            // fall through
          case 61: break;
          case 23: 
            { return XmlTokenType.XML_TAG_CHARACTERS;
            } 
            // fall through
          case 62: break;
          case 24: 
            { yybegin(COMMENT); return XmlTokenType.XML_COMMENT_CHARACTERS;
            } 
            // fall through
          case 63: break;
          case 25: 
            { yybegin(COMMENT); return XmlTokenType.XML_CONDITIONAL_COMMENT_END;
            } 
            // fall through
          case 64: break;
          case 26: 
            { yybegin(START_TAG_NAME); yypushback(yylength());
            } 
            // fall through
          case 65: break;
          case 27: 
            { yybegin(PROCESSING_INSTRUCTION); return XmlTokenType.XML_PI_START;
            } 
            // fall through
          case 66: break;
          case 28: 
            { return XmlTokenType.XML_END_TAG_START;
            } 
            // fall through
          case 67: break;
          case 29: 
            { yybegin(YYINITIAL); return XmlTokenType.XML_EMPTY_ELEMENT_END;
            } 
            // fall through
          case 68: break;
          case 30: 
            { yybegin(COMMENT); return XmlTokenType.XML_CONDITIONAL_COMMENT_START_END;
            } 
            // fall through
          case 69: break;
          case 31: 
            { yybegin(END_TAG_NAME); yypushback(yylength());
            } 
            // fall through
          case 70: break;
          case 32: 
            { return XmlTokenType.XML_ENTITY_REF_TOKEN;
            } 
            // fall through
          case 71: break;
          case 33: 
            { yybegin(YYINITIAL); return XmlTokenType.XML_COMMENT_END;
            } 
            // fall through
          case 72: break;
          case 34: 
            { yybegin(C_COMMENT_END); return XmlTokenType.XML_CONDITIONAL_COMMENT_END_START;
            } 
            // fall through
          case 73: break;
          case 35: 
            { yybegin(COMMENT); return XmlTokenType.XML_COMMENT_START;
            } 
            // fall through
          case 74: break;
          case 36: 
            { return XmlTokenType.XML_CHAR_ENTITY_REF;
            } 
            // fall through
          case 75: break;
          case 37: 
            { yybegin(YYINITIAL); return XmlTokenType.XML_BAD_CHARACTER;
            } 
            // fall through
          case 76: break;
          case 38: 
            { return XmlTokenType.XML_DOCTYPE_PUBLIC;
            } 
            // fall through
          case 77: break;
          case 39: 
            { yybegin(DOC_TYPE); return XmlTokenType.XML_DOCTYPE_START;
            } 
            // fall through
          case 78: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
