/*
 * Copyright 2000-2009 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.openapi.compiler;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

/**
 * @deprecated this interface is part of the obsolete build system which runs as part of the IDE process. Since IDEA 15 implementations of
 * this class aren't used by the IDE, you should integrate into 'external build system' instead
 * (http://www.jetbrains.org/intellij/sdk/docs/reference_guide/frameworks_and_external_apis/external_builder_api.html).
 */
@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion = "2020.3")
public interface PackagingCompiler extends FileProcessingCompiler{
  /**
   * Called when the compiler detects that an item in the output directory is outdated
   * and will be recompiled. Note that this method will be called before, and independently from,
   * subsequent calls to {@link #process}.
   *
   * @param context the current compile context.
   * @param url     the URL of a file in the output directory which will be recompiled.
   * @param state   the validity state of the file specified by {@code url}.
   */
  void processOutdatedItem(CompileContext context, String url, @Nullable ValidityState state);
}
