/*
 * Copyright 2000-2009 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.openapi.compiler;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.ApiStatus;

/**
 * @deprecated this interface is part of the obsolete build system which runs as part of the IDE process. Since IDEA 15 implementations of
 * this class aren't used by the IDE, you should integrate into 'external build system' instead
 * (http://www.jetbrains.org/intellij/sdk/docs/reference_guide/frameworks_and_external_apis/external_builder_api.html).
 */
@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion = "2020.3")
public interface SourceGeneratingCompiler extends GeneratingCompiler {
  
  /**
   * Used by make subsystem to obtain the file that should be opened in the editor instead of generated file if there were errors found 
   * while compiling the generated file
   * 
   *
   * @param context current compile context
   * @param module the module to which the generated file was attributed
   * @param outputRoot the compiler output root 
   * @param generatedFile - the file that was generated by this compiler
   * @return substituting file that should be used for navigation in UI or null if no such substitutor is available 
   *
   */
  VirtualFile getPresentableFile(CompileContext context, Module module, VirtualFile outputRoot, VirtualFile generatedFile);
}
