/*
 * Copyright 2000-2009 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.openapi.localVcs;

import com.intellij.openapi.LineNumberConstants;

public interface UpToDateLineNumberProvider {
  int ABSENT_LINE_NUMBER = LineNumberConstants.ABSENT_LINE_NUMBER;
  int FAKE_LINE_NUMBER = LineNumberConstants.FAKE_LINE_NUMBER;

  int getLineCount();
  int getLineNumber(int currentNumber);
  boolean isLineChanged(int currentNumber);
  boolean isRangeChanged(final int start, final int end);
}
