/*
 * Copyright 2000-2009 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.actions;

import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeComponent;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.packaging.elements.PackagingElement;

public class LayoutTreeFindUsagesAction extends ArtifactEditorFindUsagesActionBase {
  private final LayoutTreeComponent myLayoutTreeComponent;

  public LayoutTreeFindUsagesAction(LayoutTreeComponent layoutTreeComponent, ArtifactsStructureConfigurableContext artifactContext) {
    super(layoutTreeComponent.getLayoutTree(), artifactContext);
    myLayoutTreeComponent = layoutTreeComponent;
  }

  @Override
  protected ProjectStructureElement getSelectedElement() {
    PackagingElement<?> packagingElement = myLayoutTreeComponent.getSelection().getElementIfSingle();
    if (packagingElement == null) return null;

    return ArtifactProjectStructureElement.getProjectStructureElementFor(packagingElement, getContext(), myArtifactContext);
  }
}
