// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

/**
 * Generates native VCS ignored files (e.g. .gitignore, .hgignore)
 * The content of the file being generated by using the correspond {@link IgnoredFileContentProvider}
 * The ignored masks provided by {@link IgnoredFileProvider}
 */
public interface IgnoredFileGenerator {

  void generateFile(@NotNull VirtualFile ignoreFileRoot, @NotNull AbstractVcs vcs, boolean notify);
}
