/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.psi.tree;

import com.intellij.lang.ASTNode;
import org.jetbrains.annotations.NotNull;

/**
 * An additional interface to be implemented by {@link IElementType} instances for tokens which should be parsed lazily, but 
 * for some reasons extending {@link ILazyParseableElementType} is impossible.
 */
@FunctionalInterface
public interface ILazyParseableElementTypeBase {
  
  /**
   * Parses the contents of the specified chameleon node and returns the AST tree
   * representing the parsed contents.
   *
   * @param chameleon the node to parse.
   * @return the parsed contents of the node.
   */
  ASTNode parseContents(@NotNull ASTNode chameleon);

  /**
   * @return whether it's safe during lazy parsing to reuse tokens that were previously collapsed into a single token of this
   * type via {@link com.intellij.lang.PsiBuilder.Marker#collapse}. This can increase lazy-parsing speed
   * (by not having to run the lexer again), but requires additional memory to store the tokens.
   */
  default boolean reuseCollapsedTokens() {
    return false;
  }
}
