/* The following code was generated by JFlex 1.7.0 tweaked for IntelliJ platform */

package com.intellij.sh.lexer;

import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.IntStack;
import com.intellij.lexer.FlexLexer;
import static com.intellij.sh.lexer.ShTokenTypes.*;
import com.intellij.openapi.util.text.StringUtil;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.7.0
 * from the specification file <tt>sh.flex</tt>
 */
public class _ShLexerGen implements FlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int ARITHMETIC_EXPRESSION = 2;
  public static final int OLD_ARITHMETIC_EXPRESSION = 4;
  public static final int LET_EXPRESSION = 6;
  public static final int EVAL_EXPRESSION = 8;
  public static final int TEST_EXPRESSION = 10;
  public static final int CONDITIONAL_EXPRESSION = 12;
  public static final int IF_CONDITION = 14;
  public static final int OTHER_CONDITIONS = 16;
  public static final int CASE_CONDITION = 18;
  public static final int CASE_PATTERN = 20;
  public static final int STRING_EXPRESSION = 22;
  public static final int REGULAR_EXPRESSION = 24;
  public static final int HERE_STRING = 26;
  public static final int HERE_DOC_START_MARKER = 28;
  public static final int HERE_DOC_END_MARKER = 30;
  public static final int HERE_DOC_PIPELINE = 32;
  public static final int HERE_DOC_BODY = 34;
  public static final int PARAMETER_EXPANSION = 36;
  public static final int PARAMETER_EXPANSION_WITHOUT_SEPARATOR = 38;
  public static final int PARAMETER_EXPANSION_EXPR = 40;
  public static final int PARENTHESES_COMMAND_SUBSTITUTION = 42;
  public static final int BACKQUOTE_COMMAND_SUBSTITUTION = 44;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  1,  2,  3,  2,  3,  4,  5,  6,  6,  7,  8,  9, 10,  0,  1, 
     0,  1, 11, 12, 13, 14, 15, 15, 16, 16, 17, 18, 19, 19, 20, 20, 
    21, 22, 23, 23, 24, 24, 25, 25, 26, 26,  0,  1,  0, 1
  };

  /** 
   * Translates characters to character classes
   * Chosen bits are [11, 6, 4]
   * Total runtime size is 14304 bytes
   */
  public static int ZZ_CMAP(int ch) {
    return ZZ_CMAP_A[(ZZ_CMAP_Y[(ZZ_CMAP_Z[ch>>10]<<6)|((ch>>4)&0x3f)]<<4)|(ch&0xf)];
  }

  /* The ZZ_CMAP_Z table has 1088 entries */
  static final char ZZ_CMAP_Z[] = zzUnpackCMap(
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7\1\10\2\11\1\12\1\13\6\14\1\15\23\14\1\16"+
    "\1\14\1\17\1\20\12\14\1\21\10\11\1\22\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1"+
    "\32\1\33\1\34\1\35\2\11\1\14\1\36\3\11\1\37\10\11\1\40\1\41\5\14\1\42\1\43"+
    "\11\11\1\44\2\11\1\45\5\11\1\46\4\11\1\47\1\50\4\11\51\14\1\51\3\14\1\52\1"+
    "\53\4\14\1\54\12\11\1\55\u0381\11");

  /* The ZZ_CMAP_Y table has 2944 entries */
  static final char ZZ_CMAP_Y[] = zzUnpackCMap(
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7\2\1\1\10\1\11\1\12\1\13\1\12\1\13\34\12\1"+
    "\14\1\15\1\16\10\1\1\17\1\20\1\12\1\21\4\12\1\22\10\12\1\23\12\12\1\24\1\12"+
    "\1\25\1\24\1\12\1\26\4\1\1\12\1\27\1\30\2\1\2\12\1\27\1\1\1\31\1\24\5\12\1"+
    "\32\1\33\1\34\1\1\1\35\1\12\1\1\1\36\5\12\1\37\1\40\1\41\1\12\1\27\1\42\1"+
    "\12\1\43\1\44\1\1\1\12\1\45\4\1\1\12\1\46\4\1\1\47\2\12\1\50\1\1\1\51\1\52"+
    "\1\24\1\53\1\54\1\55\1\56\1\57\1\60\1\52\1\15\1\61\1\54\1\55\1\62\1\1\1\63"+
    "\1\64\1\65\1\66\1\21\1\55\1\67\1\1\1\70\1\52\1\71\1\72\1\54\1\55\1\67\1\1"+
    "\1\60\1\52\1\40\1\73\1\74\1\75\1\76\1\1\1\70\1\64\1\1\1\77\1\35\1\55\1\50"+
    "\1\1\1\100\1\52\1\1\1\101\1\35\1\55\1\102\1\1\1\57\1\52\1\103\1\77\1\35\1"+
    "\12\1\104\1\57\1\105\1\52\1\106\1\107\1\110\1\12\1\111\1\112\1\1\1\64\1\1"+
    "\1\24\2\12\1\113\1\112\1\114\2\1\1\115\1\116\1\117\1\120\1\121\1\122\2\1\1"+
    "\70\1\1\1\114\1\1\1\123\1\12\1\124\1\1\1\125\7\1\2\12\1\27\1\126\1\114\1\127"+
    "\1\130\1\131\1\132\1\114\2\12\1\133\2\12\1\134\24\12\1\135\1\136\2\12\1\135"+
    "\2\12\1\137\1\140\1\141\3\12\1\140\3\12\1\27\2\1\1\12\1\1\5\12\1\142\1\24"+
    "\45\12\1\143\1\12\1\24\1\27\4\12\1\27\1\144\1\145\1\15\1\12\1\15\1\12\1\15"+
    "\1\145\1\70\3\12\1\146\1\1\1\147\1\114\2\1\1\114\5\12\1\26\1\150\1\12\1\151"+
    "\4\12\1\37\1\12\1\152\2\1\1\64\1\12\1\153\1\154\2\12\1\155\1\12\1\76\1\114"+
    "\2\1\1\12\1\112\3\12\1\154\2\1\2\114\1\156\5\1\1\107\2\12\1\146\1\157\1\114"+
    "\2\1\1\160\1\12\1\161\1\41\2\12\1\37\1\1\2\12\1\146\1\1\1\162\1\41\1\12\1"+
    "\153\1\45\5\1\1\163\1\164\14\12\4\1\21\12\1\142\2\12\1\142\1\165\1\12\1\153"+
    "\3\12\1\166\1\167\1\170\1\124\1\167\7\1\1\171\1\1\1\124\6\1\1\172\1\173\1"+
    "\174\1\175\1\176\3\1\1\177\147\1\2\12\1\152\2\12\1\152\10\12\1\200\1\201\2"+
    "\12\1\133\3\12\1\202\1\1\1\12\1\112\4\203\4\1\1\126\35\1\1\204\2\1\1\205\1"+
    "\24\4\12\1\206\1\24\4\12\1\134\1\107\1\12\1\153\1\24\4\12\1\152\1\1\1\12\1"+
    "\27\3\1\1\12\40\1\133\12\1\37\4\1\135\12\1\37\2\1\10\12\1\124\4\1\2\12\1\153"+
    "\20\12\1\124\1\12\1\207\1\1\2\12\1\152\1\126\1\12\1\153\4\12\1\37\2\1\1\210"+
    "\1\211\5\12\1\212\1\12\1\152\1\26\3\1\1\210\1\213\1\12\1\30\1\1\3\12\1\146"+
    "\1\211\2\12\1\146\1\1\1\114\1\1\1\214\1\41\1\12\1\37\1\12\1\112\1\1\1\12\1"+
    "\124\1\47\2\12\1\30\1\126\1\114\1\215\1\216\2\12\1\45\1\1\1\217\1\114\1\12"+
    "\1\220\3\12\1\221\1\222\1\223\1\27\1\65\1\224\1\225\1\203\2\12\1\134\1\37"+
    "\7\12\1\30\1\114\72\12\1\146\1\12\1\226\2\12\1\155\20\1\26\12\1\153\6\12\1"+
    "\76\2\1\1\112\1\227\1\55\1\230\1\231\6\12\1\15\1\1\1\160\25\12\1\153\1\1\4"+
    "\12\1\211\2\12\1\26\2\1\1\155\7\1\1\215\7\12\1\124\1\1\1\114\1\24\1\27\1\24"+
    "\1\27\1\232\4\12\1\152\1\233\1\234\2\1\1\235\1\12\1\141\1\236\2\153\2\1\7"+
    "\12\1\27\30\1\1\12\1\124\3\12\1\70\2\1\2\12\1\1\1\12\1\237\2\12\1\37\1\12"+
    "\1\153\2\12\1\240\3\1\11\12\1\153\1\114\2\12\1\240\1\12\1\155\2\12\1\26\3"+
    "\12\1\146\11\1\23\12\1\112\1\12\1\37\1\26\11\1\1\241\2\12\1\242\1\12\1\37"+
    "\1\12\1\112\1\12\1\152\4\1\1\12\1\243\1\12\1\37\1\12\1\76\4\1\3\12\1\244\4"+
    "\1\1\70\1\245\1\12\1\146\2\1\1\12\1\124\1\12\1\124\2\1\1\123\1\12\1\154\1"+
    "\1\3\12\1\37\1\12\1\37\1\12\1\30\1\12\1\15\6\1\4\12\1\45\3\1\3\12\1\30\3\12"+
    "\1\30\60\1\1\160\2\12\1\26\2\1\1\64\1\1\1\160\2\12\2\1\1\12\1\45\1\114\1\160"+
    "\1\12\1\112\1\64\1\1\2\12\1\246\1\160\2\12\1\30\1\247\1\250\2\1\1\12\1\21"+
    "\1\155\5\1\1\251\1\252\1\45\2\12\1\152\1\1\1\114\1\72\1\54\1\55\1\67\1\1\1"+
    "\253\1\15\11\1\3\12\1\154\1\254\1\114\2\1\3\12\1\1\1\255\1\114\12\1\2\12\1"+
    "\152\2\1\1\256\2\1\3\12\1\1\1\257\1\114\2\1\2\12\1\27\1\1\1\114\3\1\1\12\1"+
    "\76\1\1\1\114\26\1\4\12\1\114\1\126\34\1\3\12\1\45\20\1\1\55\1\12\1\152\1"+
    "\1\1\70\1\114\1\1\1\211\1\12\67\1\71\12\1\76\16\1\14\12\1\146\53\1\2\12\1"+
    "\152\75\1\44\12\1\112\33\1\43\12\1\45\1\12\1\152\1\114\6\1\1\12\1\153\1\1"+
    "\3\12\1\1\1\146\1\114\1\160\1\260\1\12\67\1\4\12\1\154\1\70\3\1\1\160\4\1"+
    "\1\70\1\1\76\12\1\124\1\1\57\12\1\30\20\1\1\15\77\1\6\12\1\27\1\124\1\45\1"+
    "\76\66\1\5\12\1\215\3\12\1\145\1\261\1\262\1\263\3\12\1\264\1\265\1\12\1\266"+
    "\1\267\1\35\24\12\1\270\1\12\1\35\1\134\1\12\1\134\1\12\1\215\1\12\1\215\1"+
    "\152\1\12\1\152\1\12\1\55\1\12\1\55\1\12\1\271\3\272\14\12\1\154\3\1\4\12"+
    "\1\146\1\114\112\1\1\263\1\12\1\273\1\274\1\275\1\276\1\277\1\300\1\301\1"+
    "\155\1\302\1\155\24\1\55\12\1\112\2\1\103\12\1\154\15\12\1\153\150\12\1\15"+
    "\25\1\41\12\1\153\36\1");

  /* The ZZ_CMAP_A table has 3120 entries */
  static final char ZZ_CMAP_A[] = zzUnpackCMap(
    "\11\0\1\55\1\1\1\0\1\4\1\2\22\0\1\57\1\6\1\7\1\5\1\11\1\64\1\44\1\10\1\36"+
    "\1\37\1\34\1\35\1\53\1\22\1\16\1\47\1\24\1\26\3\30\1\27\1\25\1\33\2\20\1\51"+
    "\1\43\1\65\1\45\1\56\1\52\1\23\6\32\21\17\1\31\2\17\1\40\1\3\1\41\1\54\1\21"+
    "\1\50\1\71\1\32\1\72\1\73\1\62\1\75\1\17\1\100\1\66\2\17\1\61\1\17\1\67\1"+
    "\74\2\17\1\76\1\70\1\63\1\77\1\102\1\101\1\31\2\17\1\60\1\42\1\46\1\12\13"+
    "\0\1\15\12\0\1\15\4\0\1\15\5\0\27\15\1\14\12\15\4\0\14\15\16\0\5\15\7\0\1"+
    "\15\1\0\1\15\1\0\5\15\1\0\2\15\2\0\4\15\1\0\1\15\6\0\1\15\1\0\3\15\1\0\1\15"+
    "\1\0\4\15\1\0\23\15\1\0\13\15\10\0\6\15\1\0\26\15\2\0\1\15\6\0\10\15\10\0"+
    "\13\15\5\0\3\15\15\0\12\13\4\0\6\15\1\0\1\15\17\0\2\15\7\0\2\15\12\13\3\15"+
    "\2\0\2\15\1\0\16\15\15\0\11\15\13\0\1\15\16\0\12\13\6\15\4\0\2\15\4\0\1\15"+
    "\5\0\6\15\4\0\1\15\11\0\1\15\3\0\1\15\7\0\11\15\7\0\5\15\1\0\10\15\6\0\26"+
    "\15\3\0\1\15\2\0\1\15\7\0\12\15\4\0\12\13\1\15\4\0\10\15\2\0\2\15\2\0\26\15"+
    "\1\0\7\15\1\0\1\15\3\0\4\15\3\0\1\15\20\0\1\15\15\0\2\15\1\0\1\15\5\0\6\15"+
    "\4\0\2\15\1\0\2\15\1\0\2\15\1\0\2\15\17\0\4\15\1\0\1\15\7\0\12\13\2\0\3\15"+
    "\20\0\11\15\1\0\2\15\1\0\2\15\1\0\5\15\3\0\1\15\2\0\1\15\30\0\1\15\13\0\10"+
    "\15\2\0\1\15\3\0\1\15\1\0\6\15\3\0\3\15\1\0\4\15\3\0\2\15\1\0\1\15\1\0\2\15"+
    "\3\0\2\15\3\0\3\15\3\0\14\15\13\0\10\15\1\0\2\15\10\0\3\15\5\0\1\15\4\0\10"+
    "\15\1\0\6\15\1\0\5\15\3\0\1\15\3\0\2\15\15\0\13\15\2\0\1\15\6\0\3\15\10\0"+
    "\1\15\12\0\6\15\5\0\22\15\3\0\10\15\1\0\11\15\1\0\1\15\2\0\7\15\11\0\1\15"+
    "\1\0\2\15\14\0\12\13\7\0\2\15\1\0\1\15\2\0\2\15\1\0\1\15\2\0\1\15\6\0\4\15"+
    "\1\0\7\15\1\0\3\15\1\0\1\15\1\0\1\15\2\0\2\15\1\0\4\15\1\0\2\15\11\0\1\15"+
    "\2\0\5\15\1\0\1\15\11\0\12\13\2\0\14\15\1\0\24\15\13\0\5\15\22\0\7\15\4\0"+
    "\4\15\3\0\1\15\3\0\2\15\7\0\3\15\4\0\15\15\14\0\1\15\1\0\6\15\1\0\1\15\5\0"+
    "\1\15\2\0\13\15\1\0\15\15\1\0\4\15\2\0\7\15\1\0\1\15\1\0\4\15\2\0\1\15\1\0"+
    "\4\15\2\0\7\15\1\0\1\15\1\0\4\15\2\0\17\15\1\0\16\15\2\0\6\15\2\0\15\15\2"+
    "\0\1\15\1\0\10\15\7\0\15\15\1\0\6\15\23\0\1\15\4\0\1\15\3\0\5\15\2\0\22\15"+
    "\1\0\1\15\5\0\17\15\1\0\16\15\2\0\5\15\13\0\14\15\13\0\1\15\15\0\7\15\7\0"+
    "\16\15\15\0\2\15\12\13\3\0\3\15\11\0\4\15\1\0\4\15\3\0\2\15\11\0\10\15\1\0"+
    "\1\15\1\0\1\15\1\0\1\15\1\0\6\15\1\0\7\15\1\0\1\15\3\0\3\15\1\0\7\15\3\0\4"+
    "\15\2\0\6\15\5\0\1\15\15\0\1\15\2\0\1\15\4\0\1\15\2\0\12\15\1\0\1\15\3\0\5"+
    "\15\6\0\1\15\1\0\1\15\1\0\1\15\1\0\4\15\1\0\13\15\2\0\4\15\5\0\5\15\4\0\1"+
    "\15\4\0\2\15\13\0\5\15\6\0\4\15\3\0\2\15\14\0\10\15\7\0\10\15\1\0\7\15\6\0"+
    "\2\15\12\0\5\15\5\0\2\15\3\0\7\15\6\0\3\15\12\13\2\15\13\0\11\15\2\0\27\15"+
    "\2\0\7\15\1\0\3\15\1\0\4\15\1\0\4\15\2\0\6\15\3\0\1\15\1\0\1\15\2\0\5\15\1"+
    "\0\12\15\12\13\5\15\1\0\3\15\1\0\10\15\4\0\7\15\3\0\1\15\3\0\2\15\1\0\1\15"+
    "\3\0\2\15\2\0\5\15\2\0\1\15\1\0\1\15\30\0\3\15\3\0\6\15\2\0\6\15\2\0\6\15"+
    "\11\0\7\15\4\0\5\15\3\0\5\15\5\0\1\15\1\0\10\15\1\0\5\15\1\0\1\15\1\0\2\15"+
    "\1\0\2\15\1\0\12\15\6\0\12\15\2\0\6\15\2\0\6\15\2\0\6\15\2\0\3\15\3\0\14\15"+
    "\1\0\16\15\1\0\2\15\1\0\2\15\1\0\10\15\6\0\4\15\4\0\16\15\2\0\1\15\1\0\14"+
    "\15\1\0\2\15\3\0\1\15\2\0\4\15\1\0\2\15\12\0\10\15\6\0\6\15\1\0\3\15\1\0\12"+
    "\15\3\0\1\15\12\0\4\15\13\0\12\13\1\15\1\0\1\15\3\0\7\15\1\0\1\15\1\0\4\15"+
    "\1\0\17\15\1\0\2\15\14\0\3\15\7\0\4\15\11\0\2\15\1\0\1\15\20\0\4\15\10\0\1"+
    "\15\13\0\10\15\5\0\3\15\2\0\1\15\2\0\2\15\2\0\4\15\1\0\14\15\1\0\1\15\1\0"+
    "\7\15\1\0\21\15\1\0\4\15\2\0\10\15\1\0\7\15\1\0\14\15\1\0\4\15\1\0\5\15\1"+
    "\0\1\15\3\0\14\15\2\0\13\15\1\0\10\15\2\0\22\13\1\0\2\15\1\0\1\15\2\0\1\15"+
    "\1\0\12\15\1\0\4\15\1\0\1\15\1\0\1\15\6\0\1\15\4\0\1\15\1\0\1\15\1\0\1\15"+
    "\1\0\3\15\1\0\2\15\1\0\1\15\2\0\1\15\1\0\1\15\1\0\1\15\1\0\1\15\1\0\1\15\1"+
    "\0\2\15\1\0\1\15\2\0\4\15\1\0\7\15\1\0\4\15\1\0\4\15\1\0\1\15\1\0\12\15\1"+
    "\0\5\15\1\0\3\15\1\0\5\15\1\0\5\15");

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\33\0\1\1\2\2\1\1\1\3\1\4\1\5\1\6"+
    "\1\7\1\10\2\11\1\12\1\11\4\12\1\11\1\13"+
    "\1\14\1\15\1\16\1\17\1\20\1\21\1\22\1\23"+
    "\1\24\1\25\1\26\3\11\1\27\7\11\1\4\1\1"+
    "\1\5\1\30\1\1\2\11\1\12\1\31\4\12\1\32"+
    "\1\33\1\17\1\21\1\22\1\34\1\35\1\36\1\37"+
    "\1\40\1\25\1\41\1\27\2\42\1\43\1\44\1\11"+
    "\1\45\2\46\1\45\1\3\1\1\2\45\1\47\1\5"+
    "\1\46\1\17\1\21\1\50\1\5\1\22\1\20\6\11"+
    "\1\51\3\11\1\52\1\1\1\53\2\52\1\54\1\11"+
    "\1\1\2\11\1\55\1\56\1\57\1\11\2\60\1\11"+
    "\1\61\1\11\6\62\1\61\2\11\1\63\1\1\1\63"+
    "\2\1\1\64\2\65\2\66\2\67\1\70\2\71\1\72"+
    "\2\73\1\72\1\74\1\75\1\76\2\72\5\77\1\72"+
    "\1\100\1\101\1\75\3\76\1\102\1\75\2\103\2\3"+
    "\3\0\1\7\1\104\1\0\1\104\1\105\1\106\1\107"+
    "\1\0\1\11\1\110\2\12\1\111\1\11\1\112\1\113"+
    "\1\114\1\115\1\116\1\117\1\120\5\121\1\122\1\123"+
    "\1\124\1\125\1\126\1\127\6\11\1\130\1\131\1\132"+
    "\1\133\1\134\1\135\2\11\1\136\1\137\4\11\1\140"+
    "\1\11\1\141\3\0\2\12\1\142\1\143\1\111\1\0"+
    "\1\144\1\145\1\146\1\147\1\150\1\151\1\152\1\153"+
    "\1\154\1\127\1\155\1\156\1\157\1\11\2\45\1\0"+
    "\1\105\1\160\1\11\1\161\2\162\1\163\3\11\1\0"+
    "\3\11\3\0\1\164\1\0\1\11\1\3\3\11\1\0"+
    "\1\11\11\0\1\72\1\0\1\75\1\0\2\77\1\165"+
    "\1\72\1\166\1\167\2\103\1\0\1\3\3\0\1\170"+
    "\1\11\1\171\1\172\2\121\1\173\1\174\6\11\1\175"+
    "\1\176\3\11\1\177\3\11\1\172\1\200\1\201\1\202"+
    "\1\3\1\203\1\0\2\11\2\0\4\11\1\57\1\0"+
    "\2\61\1\11\2\63\2\66\1\74\1\204\1\0\1\11"+
    "\1\0\1\7\1\205\1\206\1\207\1\210\1\211\1\212"+
    "\1\11\1\213\1\214\4\11\1\3\1\11\1\0\1\11"+
    "\1\46\1\3\1\0\3\11\1\215\1\216\1\11\1\217"+
    "\2\11\1\220";

  private static int [] zzUnpackAction() {
    int [] result = new int[416];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\103\0\206\0\311\0\u010c\0\u014f\0\u0192\0\u01d5"+
    "\0\u0218\0\u025b\0\u029e\0\u02e1\0\u0324\0\u0367\0\u03aa\0\u03ed"+
    "\0\u0430\0\u0473\0\u04b6\0\u04f9\0\u053c\0\u057f\0\u05c2\0\u0605"+
    "\0\u0648\0\u068b\0\u06ce\0\u0711\0\u0711\0\u0754\0\u0797\0\u07da"+
    "\0\u081d\0\u0860\0\u0711\0\u08a3\0\u08e6\0\u0929\0\u096c\0\u09af"+
    "\0\u09f2\0\u0a35\0\u0a78\0\u0abb\0\u0afe\0\u0b41\0\u0b84\0\u0bc7"+
    "\0\u0c0a\0\u0c4d\0\u0c90\0\u0711\0\u0cd3\0\u0711\0\u0711\0\u0711"+
    "\0\u0d16\0\u0711\0\u0d59\0\u0d9c\0\u0ddf\0\u0e22\0\u0e65\0\u0ea8"+
    "\0\u0eeb\0\u0f2e\0\u0f71\0\u0fb4\0\u0ff7\0\u103a\0\u107d\0\u10c0"+
    "\0\u0711\0\u1103\0\u1146\0\u1189\0\u11cc\0\u120f\0\u1252\0\u1295"+
    "\0\u12d8\0\u131b\0\u135e\0\u13a1\0\u13e4\0\u1427\0\u146a\0\u14ad"+
    "\0\u0711\0\u0711\0\u0711\0\u14f0\0\u1533\0\u1576\0\u15b9\0\u0711"+
    "\0\u15fc\0\u0711\0\u0711\0\u163f\0\u1682\0\u0711\0\u16c5\0\u1708"+
    "\0\u174b\0\u178e\0\u17d1\0\u1814\0\u0711\0\u1857\0\u0bc7\0\u189a"+
    "\0\u18dd\0\u0711\0\u1920\0\u1963\0\u19a6\0\u19e9\0\u1a2c\0\u1a6f"+
    "\0\u1ab2\0\u1af5\0\u1b38\0\u0bc7\0\u1b7b\0\u1bbe\0\u1c01\0\u1c44"+
    "\0\u1c87\0\u0711\0\u1cca\0\u1814\0\u0711\0\u1d0d\0\u1d50\0\u1d93"+
    "\0\u17d1\0\u1dd6\0\u0711\0\u1e19\0\u1e5c\0\u0711\0\u1e9f\0\u1ee2"+
    "\0\u1f25\0\u1f68\0\u0b84\0\u0bc7\0\u0c90\0\u0711\0\u0cd3\0\u0d16"+
    "\0\u1fab\0\u1fee\0\u2031\0\u2074\0\u20b7\0\u20fa\0\u213d\0\u2180"+
    "\0\u21c3\0\u0711\0\u2206\0\u2249\0\u228c\0\u0711\0\u22cf\0\u2312"+
    "\0\u0711\0\u2355\0\u0711\0\u0711\0\u2398\0\u23db\0\u241e\0\u2461"+
    "\0\u0711\0\u17d1\0\u24a4\0\u24e7\0\u252a\0\u256d\0\u25b0\0\u25f3"+
    "\0\u2636\0\u2679\0\u0711\0\u26bc\0\u26ff\0\u2742\0\u2785\0\u0711"+
    "\0\u27c8\0\u280b\0\u284e\0\u2891\0\u28d4\0\u2917\0\u295a\0\u299d"+
    "\0\u0711\0\u0711\0\u29e0\0\u2a23\0\u2a66\0\u0711\0\u0711\0\u2aa9"+
    "\0\u2aec\0\u0711\0\u2b2f\0\u2b72\0\u2bb5\0\u2bf8\0\u0711\0\u0711"+
    "\0\u0711\0\u0711\0\u0711\0\u0711\0\u0711\0\u2c3b\0\u0711\0\u2c7e"+
    "\0\u2cc1\0\u2d04\0\u0711\0\u2d47\0\u0711\0\u0711\0\u0711\0\u0711"+
    "\0\u2d8a\0\u2dcd\0\u2e10\0\u2e53\0\u2e96\0\u2ed9\0\u0711\0\u0711"+
    "\0\u0711\0\u2f1c\0\u096c\0\u096c\0\u2f5f\0\u2fa2\0\u2fe5\0\u096c"+
    "\0\u3028\0\u306b\0\u30ae\0\u30f1\0\u3134\0\u3177\0\u0711\0\u1103"+
    "\0\u31ba\0\u107d\0\u31fd\0\u3240\0\u0711\0\u0711\0\u3283\0\u32c6"+
    "\0\u0711\0\u0711\0\u0711\0\u0711\0\u0711\0\u0711\0\u0711\0\u0711"+
    "\0\u0711\0\u3309\0\u0711\0\u0711\0\u334c\0\u338f\0\u33d2\0\u3415"+
    "\0\u178e\0\u3458\0\u0711\0\u0711\0\u0711\0\u349b\0\u0711\0\u096c"+
    "\0\u34de\0\u3521\0\u3564\0\u35a7\0\u35ea\0\u362d\0\u3670\0\u1c87"+
    "\0\u1d50\0\u36b3\0\u0711\0\u36f6\0\u3739\0\u377c\0\u37bf\0\u3802"+
    "\0\u3845\0\u3888\0\u38cb\0\u20b7\0\u390e\0\u3951\0\u3994\0\u39d7"+
    "\0\u3a1a\0\u2206\0\u3a5d\0\u3aa0\0\u3ae3\0\u3b26\0\u0711\0\u23db"+
    "\0\u3b69\0\u3bac\0\u3bef\0\u3c32\0\u0711\0\u0711\0\u3c75\0\u3cb8"+
    "\0\u0797\0\u3cfb\0\u3d3e\0\u3d81\0\u3dc4\0\u0711\0\u3e07\0\u0711"+
    "\0\u2bf8\0\u3e4a\0\u3e8d\0\u0711\0\u096c\0\u3ed0\0\u3f13\0\u3f56"+
    "\0\u3f99\0\u3fdc\0\u401f\0\u0711\0\u0711\0\u4062\0\u40a5\0\u40e8"+
    "\0\u096c\0\u412b\0\u416e\0\u41b1\0\u32c6\0\u0711\0\u0711\0\u1189"+
    "\0\u41f4\0\u0711\0\u4237\0\u427a\0\u42bd\0\u4300\0\u4343\0\u4386"+
    "\0\u43c9\0\u440c\0\u444f\0\u4492\0\u44d5\0\u4518\0\u455b\0\u459e"+
    "\0\u45e1\0\u0711\0\u4624\0\u4667\0\u46aa\0\u3c32\0\u46ed\0\u4730"+
    "\0\u4773\0\u29e0\0\u096c\0\u096c\0\u096c\0\u096c\0\u096c\0\u096c"+
    "\0\u47b6\0\u096c\0\u096c\0\u47f9\0\u483c\0\u487f\0\u48c2\0\u4905"+
    "\0\u4948\0\u498b\0\u49ce\0\u1af5\0\u4a11\0\u0860\0\u4a54\0\u4a97"+
    "\0\u4ada\0\u096c\0\u096c\0\u4b1d\0\u096c\0\u4b60\0\u4ba3\0\u096c";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[416];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\34\1\35\1\36\1\37\1\40\1\41\1\42\1\43"+
    "\1\44\1\45\3\46\1\47\1\46\1\47\1\50\1\47"+
    "\1\46\1\51\1\52\1\53\1\54\2\55\2\47\1\50"+
    "\1\51\1\56\1\57\1\60\1\61\1\62\1\63\1\64"+
    "\1\65\1\66\1\67\1\46\1\70\1\46\1\51\2\46"+
    "\1\40\1\71\1\40\1\72\1\73\1\74\1\75\1\46"+
    "\1\76\1\77\1\47\1\100\1\47\1\101\1\102\1\47"+
    "\1\103\1\47\1\104\1\47\1\105\1\47\1\34\1\35"+
    "\1\36\1\37\1\40\1\106\1\42\1\43\1\44\1\45"+
    "\3\46\1\47\1\46\1\47\1\50\1\47\1\46\1\51"+
    "\1\52\1\53\1\54\2\55\2\47\1\50\1\51\1\56"+
    "\1\57\1\60\1\61\1\62\1\63\1\64\1\65\1\66"+
    "\1\67\1\46\1\70\1\46\1\51\2\46\1\40\1\71"+
    "\1\40\1\72\1\73\1\74\1\75\1\46\1\76\1\77"+
    "\1\47\1\100\1\47\1\101\1\102\1\47\1\103\1\47"+
    "\1\104\1\47\1\105\1\47\1\34\1\35\1\36\1\107"+
    "\1\40\1\41\1\110\1\43\1\44\1\45\1\111\2\34"+
    "\1\112\1\113\1\114\1\115\1\114\1\116\1\113\1\117"+
    "\1\120\1\121\2\122\2\114\1\115\1\123\1\124\1\57"+
    "\1\60\1\61\1\62\1\125\1\64\1\126\1\127\1\67"+
    "\1\130\1\70\1\131\1\132\1\133\1\134\1\40\1\135"+
    "\1\40\1\72\3\114\1\136\1\137\15\114\1\34\1\35"+
    "\1\36\1\107\1\40\1\106\1\110\1\43\1\44\1\45"+
    "\1\111\2\34\1\112\1\113\1\114\1\115\1\114\1\116"+
    "\1\113\1\117\1\120\1\121\2\122\2\114\1\115\1\123"+
    "\1\124\1\57\1\60\1\61\1\62\1\125\1\64\1\126"+
    "\1\127\1\67\1\130\1\70\1\131\1\132\1\133\1\134"+
    "\1\40\1\135\1\40\1\72\3\114\1\136\1\137\15\114"+
    "\1\34\1\140\1\141\1\107\1\40\1\41\1\110\1\142"+
    "\1\44\1\45\1\111\2\34\1\112\1\113\1\114\1\115"+
    "\1\114\1\116\1\113\1\117\1\120\1\121\2\122\2\114"+
    "\1\115\1\123\1\124\1\57\1\60\1\61\1\62\1\125"+
    "\1\143\1\126\1\127\1\67\1\130\1\70\1\131\1\132"+
    "\1\133\1\134\1\40\1\135\1\40\1\72\1\144\2\114"+
    "\1\136\1\137\15\114\1\34\1\140\1\141\1\107\1\40"+
    "\1\106\1\110\1\142\1\44\1\45\1\111\2\34\1\112"+
    "\1\113\1\114\1\115\1\114\1\116\1\113\1\117\1\120"+
    "\1\121\2\122\2\114\1\115\1\123\1\124\1\57\1\60"+
    "\1\61\1\62\1\125\1\143\1\126\1\127\1\67\1\130"+
    "\1\70\1\131\1\132\1\133\1\134\1\40\1\135\1\40"+
    "\1\72\1\144\2\114\1\136\1\137\15\114\1\145\1\146"+
    "\1\147\1\150\1\151\2\145\1\43\1\152\1\153\24\145"+
    "\1\154\1\146\3\145\1\146\4\145\1\155\4\145\1\151"+
    "\1\145\1\40\23\145\1\34\1\140\1\141\1\37\1\40"+
    "\1\41\1\156\1\43\1\44\1\45\3\46\1\47\1\46"+
    "\1\47\1\50\1\47\1\46\1\51\1\52\1\53\1\54"+
    "\2\55\2\47\1\50\1\51\1\56\1\57\1\157\1\61"+
    "\1\62\1\160\1\143\1\161\1\66\1\67\1\46\1\162"+
    "\1\46\1\51\2\46\1\40\1\71\1\40\1\72\3\47"+
    "\1\46\1\76\15\47\1\34\1\140\1\141\1\37\1\40"+
    "\1\106\1\156\1\43\1\44\1\45\3\46\1\47\1\46"+
    "\1\47\1\50\1\47\1\46\1\51\1\52\1\53\1\54"+
    "\2\55\2\47\1\50\1\51\1\56\1\57\1\157\1\61"+
    "\1\62\1\160\1\143\1\161\1\66\1\67\1\46\1\162"+
    "\1\46\1\51\2\46\1\40\1\71\1\40\1\72\3\47"+
    "\1\46\1\76\15\47\1\34\1\35\1\36\1\37\1\40"+
    "\1\41\1\163\1\43\1\44\1\45\3\46\1\47\1\46"+
    "\1\47\1\50\1\47\1\46\1\51\1\52\1\53\1\54"+
    "\2\55\2\47\1\50\1\51\1\56\1\57\1\60\1\61"+
    "\1\62\1\63\1\64\1\65\1\164\1\67\1\46\1\70"+
    "\1\46\1\51\2\46\1\40\1\71\1\40\1\72\3\47"+
    "\1\46\1\76\15\47\1\34\1\35\1\36\1\37\1\40"+
    "\1\106\1\163\1\43\1\44\1\45\3\46\1\47\1\46"+
    "\1\47\1\50\1\47\1\46\1\51\1\52\1\53\1\54"+
    "\2\55\2\47\1\50\1\51\1\56\1\57\1\60\1\61"+
    "\1\62\1\63\1\64\1\65\1\164\1\67\1\46\1\70"+
    "\1\46\1\51\2\46\1\40\1\71\1\40\1\72\3\47"+
    "\1\46\1\76\15\47\1\34\1\35\1\36\1\37\1\40"+
    "\1\41\1\42\1\43\1\44\1\45\3\46\1\47\1\46"+
    "\1\47\1\50\1\47\1\46\1\51\1\52\1\53\1\54"+
    "\2\55\2\47\1\50\1\51\1\56\1\57\1\60\1\61"+
    "\1\62\1\63\1\165\1\65\1\66\1\67\1\46\1\70"+
    "\1\46\1\51\2\46\1\40\1\71\1\40\1\72\1\73"+
    "\1\74\1\75\1\46\1\76\1\166\1\47\1\100\1\47"+
    "\1\101\1\102\1\47\1\103\1\47\1\104\1\47\1\105"+
    "\1\47\1\34\1\35\1\36\1\37\1\40\1\106\1\42"+
    "\1\43\1\44\1\45\3\46\1\47\1\46\1\47\1\50"+
    "\1\47\1\46\1\51\1\52\1\53\1\54\2\55\2\47"+
    "\1\50\1\51\1\56\1\57\1\60\1\61\1\62\1\63"+
    "\1\165\1\65\1\66\1\67\1\46\1\70\1\46\1\51"+
    "\2\46\1\40\1\71\1\40\1\72\1\73\1\74\1\75"+
    "\1\46\1\76\1\166\1\47\1\100\1\47\1\101\1\102"+
    "\1\47\1\103\1\47\1\104\1\47\1\105\1\47\1\167"+
    "\1\35\1\36\1\170\1\40\1\41\1\171\1\43\1\44"+
    "\1\45\11\172\1\173\10\172\2\173\1\57\1\174\2\167"+
    "\1\63\4\167\1\172\1\167\1\172\1\173\2\172\1\40"+
    "\1\175\1\40\1\167\1\172\1\176\2\172\1\177\15\172"+
    "\1\167\1\35\1\36\1\170\1\40\1\106\1\171\1\43"+
    "\1\44\1\45\11\172\1\173\10\172\2\173\1\57\1\174"+
    "\2\167\1\63\4\167\1\172\1\167\1\172\1\173\2\172"+
    "\1\40\1\175\1\40\1\167\1\172\1\176\2\172\1\177"+
    "\15\172\3\200\1\201\3\200\1\202\1\200\1\203\24\200"+
    "\1\204\11\200\1\205\32\200\1\206\2\34\1\207\1\210"+
    "\2\206\1\43\1\44\1\211\24\206\1\212\1\213\10\206"+
    "\1\205\4\206\1\214\1\206\1\214\23\206\1\215\1\216"+
    "\1\217\1\220\1\221\1\222\1\215\1\43\1\44\1\45"+
    "\24\215\1\223\1\224\2\215\1\225\1\226\1\227\3\215"+
    "\1\226\4\215\1\221\1\230\1\231\5\215\1\232\16\215"+
    "\1\216\1\217\1\220\1\221\1\233\1\215\1\43\1\44"+
    "\1\45\24\215\1\223\1\224\2\215\1\225\1\226\1\227"+
    "\3\215\1\226\4\215\1\221\1\230\1\231\5\215\1\232"+
    "\15\215\1\234\1\140\1\141\1\235\1\236\2\234\1\237"+
    "\1\240\25\234\2\34\2\234\3\34\10\234\1\40\1\234"+
    "\1\40\23\234\1\241\2\242\1\243\1\244\2\241\2\242"+
    "\25\241\2\242\2\241\3\242\10\241\1\245\1\241\1\245"+
    "\23\241\1\34\1\246\1\247\1\37\1\40\1\41\1\42"+
    "\1\43\1\44\1\45\3\46\1\47\1\46\1\47\1\50"+
    "\1\47\1\46\1\51\1\52\1\53\1\54\2\55\2\47"+
    "\1\50\1\51\1\56\1\57\1\60\1\61\1\62\1\63"+
    "\1\64\1\65\1\66\1\67\1\46\1\70\1\46\1\51"+
    "\2\46\1\40\1\71\1\40\1\72\3\47\1\46\1\76"+
    "\15\47\1\34\1\246\1\247\1\37\1\40\1\106\1\42"+
    "\1\43\1\44\1\45\3\46\1\47\1\46\1\47\1\50"+
    "\1\47\1\46\1\51\1\52\1\53\1\54\2\55\2\47"+
    "\1\50\1\51\1\56\1\57\1\60\1\61\1\62\1\63"+
    "\1\64\1\65\1\66\1\67\1\46\1\70\1\46\1\51"+
    "\2\46\1\40\1\71\1\40\1\72\3\47\1\46\1\76"+
    "\15\47\1\250\1\251\1\252\100\250\1\253\1\254\1\255"+
    "\1\256\1\257\1\260\1\261\1\43\1\44\1\262\5\253"+
    "\1\263\1\264\1\263\2\261\1\265\1\266\1\267\2\270"+
    "\2\263\1\264\2\261\1\271\1\253\1\272\4\253\1\261"+
    "\1\273\1\274\1\205\1\275\1\261\1\276\1\277\1\257"+
    "\1\253\1\257\1\300\3\263\1\301\1\253\15\263\1\253"+
    "\1\254\1\255\1\256\1\257\2\253\1\43\1\44\1\262"+
    "\5\253\1\263\1\264\1\263\2\253\1\265\1\266\1\267"+
    "\2\270\2\263\1\264\2\253\1\271\1\253\1\272\5\253"+
    "\1\273\1\253\1\205\4\253\1\257\1\253\1\257\1\300"+
    "\3\263\2\253\15\263\3\302\1\303\3\302\1\146\1\302"+
    "\1\146\34\302\3\146\32\302\104\0\1\35\101\0\1\46"+
    "\1\304\1\305\100\46\3\0\1\306\1\40\50\0\1\40"+
    "\1\0\1\40\23\0\1\41\2\0\100\41\36\0\1\307"+
    "\1\0\1\310\42\0\10\44\1\311\72\44\5\0\2\312"+
    "\1\0\1\313\1\312\3\0\1\314\1\0\1\314\1\312"+
    "\1\314\7\312\2\314\2\312\1\0\1\315\1\0\1\316"+
    "\11\0\1\312\5\0\1\317\3\314\2\0\15\314\3\0"+
    "\1\320\1\0\2\46\3\0\24\46\11\0\1\46\1\0"+
    "\4\46\4\0\4\46\1\0\15\46\3\0\1\320\1\0"+
    "\2\46\3\0\3\46\1\47\1\46\3\47\2\46\10\47"+
    "\1\46\1\321\7\0\1\322\1\0\1\46\1\0\4\46"+
    "\4\0\3\47\1\46\1\0\15\47\3\0\1\320\1\0"+
    "\1\323\1\46\3\0\6\46\1\324\3\46\5\324\2\46"+
    "\1\324\2\46\11\0\1\46\1\0\4\46\4\0\4\46"+
    "\1\0\15\46\3\0\1\320\1\0\2\46\3\0\24\46"+
    "\1\307\1\0\1\310\6\0\1\46\1\0\4\46\4\0"+
    "\4\46\1\0\15\46\3\0\1\320\1\0\2\46\3\0"+
    "\12\46\5\325\1\326\1\46\1\325\2\46\11\0\1\46"+
    "\1\0\4\46\4\0\4\46\1\0\15\46\3\0\1\320"+
    "\1\0\1\323\1\46\3\0\6\46\1\324\3\46\1\50"+
    "\1\324\1\50\1\324\1\50\2\46\1\324\2\46\11\0"+
    "\1\46\1\0\4\46\4\0\4\46\1\0\15\46\3\0"+
    "\1\320\1\0\2\46\3\0\6\46\1\50\3\46\5\50"+
    "\2\46\1\50\2\46\11\0\1\46\1\0\4\46\4\0"+
    "\4\46\1\0\15\46\3\0\1\320\1\0\1\323\1\46"+
    "\3\0\6\46\1\50\3\46\5\50\2\46\1\50\2\46"+
    "\11\0\1\46\1\0\4\46\4\0\4\46\1\0\15\46"+
    "\3\0\1\320\1\0\2\46\3\0\24\46\1\307\1\0"+
    "\1\310\4\0\1\327\1\0\1\46\1\0\4\46\4\0"+
    "\4\46\1\0\15\46\36\0\1\330\103\0\1\331\103\0"+
    "\1\332\103\0\1\333\103\0\1\334\1\0\1\335\56\0"+
    "\1\336\1\0\1\337\1\0\1\337\1\340\1\341\2\342"+
    "\2\0\1\336\10\0\1\343\11\0\1\344\62\0\1\345"+
    "\3\0\1\346\1\0\1\347\11\0\1\350\27\0\1\320"+
    "\1\0\2\46\3\0\3\46\1\47\1\46\3\47\2\46"+
    "\10\47\1\46\1\321\7\0\1\322\1\0\1\46\1\0"+
    "\4\46\4\0\1\47\1\351\1\47\1\46\1\0\15\47"+
    "\3\0\1\320\1\0\2\46\3\0\3\46\1\47\1\46"+
    "\3\47\2\46\10\47\1\46\1\321\7\0\1\322\1\0"+
    "\1\46\1\0\4\46\4\0\1\352\2\47\1\46\1\0"+
    "\2\47\1\353\11\47\1\354\3\0\1\320\1\0\2\46"+
    "\3\0\3\46\1\47\1\46\3\47\2\46\10\47\1\46"+
    "\1\321\7\0\1\322\1\0\1\46\1\0\4\46\4\0"+
    "\1\47\1\355\1\47\1\46\1\0\12\47\1\356\2\47"+
    "\36\0\1\357\5\0\1\360\11\0\1\361\6\0\1\362"+
    "\20\0\1\320\1\0\2\46\3\0\3\46\1\47\1\46"+
    "\3\47\2\46\10\47\1\46\1\321\7\0\1\322\1\0"+
    "\1\46\1\0\4\46\4\0\3\47\1\46\1\0\1\47"+
    "\1\363\5\47\1\364\5\47\3\0\1\320\1\0\2\46"+
    "\3\0\3\46\1\47\1\46\3\47\2\46\10\47\1\46"+
    "\1\321\7\0\1\322\1\0\1\46\1\0\4\46\4\0"+
    "\1\47\1\365\1\47\1\46\1\0\15\47\3\0\1\320"+
    "\1\0\2\46\3\0\3\46\1\47\1\46\3\47\2\46"+
    "\10\47\1\46\1\321\7\0\1\322\1\0\1\46\1\0"+
    "\4\46\4\0\3\47\1\46\1\0\3\47\1\366\11\47"+
    "\3\0\1\320\1\0\2\46\3\0\3\46\1\47\1\46"+
    "\3\47\2\46\10\47\1\46\1\321\7\0\1\322\1\0"+
    "\1\46\1\0\4\46\4\0\3\47\1\46\1\0\6\47"+
    "\1\367\6\47\3\0\1\320\1\0\2\46\3\0\3\46"+
    "\1\47\1\46\3\47\2\46\10\47\1\46\1\321\7\0"+
    "\1\322\1\0\1\46\1\0\4\46\4\0\3\47\1\46"+
    "\1\0\1\370\5\47\1\371\2\47\1\372\3\47\3\0"+
    "\1\320\1\0\2\46\3\0\3\46\1\47\1\46\3\47"+
    "\2\46\10\47\1\46\1\321\7\0\1\322\1\0\1\46"+
    "\1\0\4\46\4\0\3\47\1\46\1\0\1\47\1\373"+
    "\13\47\3\0\1\320\1\0\2\46\3\0\3\46\1\47"+
    "\1\46\3\47\2\46\10\47\1\46\1\321\7\0\1\322"+
    "\1\0\1\46\1\0\4\46\4\0\3\47\1\46\1\0"+
    "\12\47\1\374\2\47\1\41\2\0\3\41\1\375\74\41"+
    "\2\113\1\376\100\113\45\0\1\377\52\0\1\u0100\1\0"+
    "\3\u0100\2\0\10\u0100\1\0\1\u0101\7\0\1\322\13\0"+
    "\3\u0100\2\0\15\u0100\3\0\1\u0102\1\0\2\113\7\0"+
    "\4\113\1\0\11\113\25\0\3\113\2\0\15\113\3\0"+
    "\1\u0102\1\0\2\113\6\0\1\u0100\1\113\3\114\1\0"+
    "\1\113\10\114\1\0\1\u0101\7\0\1\322\13\0\3\114"+
    "\2\0\15\114\5\0\1\u0103\12\0\1\u0104\3\0\5\u0104"+
    "\2\0\1\u0104\71\0\1\u0105\22\0\1\u0106\61\0\5\u0107"+
    "\1\u0108\1\0\1\u0107\54\0\1\u0103\12\0\1\u0104\3\0"+
    "\1\115\1\u0104\1\115\1\u0104\1\115\2\0\1\u0104\67\0"+
    "\1\115\3\0\5\115\2\0\1\115\54\0\1\u0103\12\0"+
    "\1\115\3\0\5\115\2\0\1\115\103\0\1\u0109\10\0"+
    "\1\u010a\72\0\1\u010b\7\0\1\327\77\0\1\334\1\0"+
    "\1\335\1\u010c\55\0\1\336\1\0\1\337\1\0\1\337"+
    "\1\340\1\341\2\342\2\0\1\336\10\0\1\343\1\u010d"+
    "\10\0\1\344\71\0\1\u010e\102\0\1\u010f\102\0\1\u0110"+
    "\73\0\1\345\3\0\1\346\1\0\1\347\1\u0111\10\0"+
    "\1\u0112\71\0\1\u0113\73\0\1\357\5\0\1\360\1\u0114"+
    "\10\0\1\361\6\0\1\u0115\16\0\1\140\104\0\1\u0102"+
    "\1\0\2\113\6\0\1\u0100\1\113\3\114\1\0\1\113"+
    "\10\114\1\0\1\u0101\7\0\1\322\13\0\1\114\1\u0116"+
    "\1\114\2\0\15\114\1\145\2\0\1\150\3\145\3\0"+
    "\24\145\2\0\3\145\1\0\4\145\1\0\6\145\1\0"+
    "\23\145\1\0\1\146\101\0\2\145\1\u0117\1\150\100\145"+
    "\2\0\1\u0118\1\151\2\145\3\0\24\145\2\0\3\145"+
    "\1\0\4\145\1\0\4\145\1\151\1\145\1\40\23\145"+
    "\10\u0119\1\311\72\u0119\5\0\2\312\1\0\1\313\1\312"+
    "\3\0\1\314\1\0\1\314\1\312\1\314\7\312\2\314"+
    "\2\312\1\0\1\u011a\1\0\1\316\11\0\1\312\5\0"+
    "\1\317\3\314\2\0\15\314\36\0\1\u011b\102\0\1\307"+
    "\1\0\1\310\4\0\1\u011c\77\0\1\146\1\0\1\335"+
    "\56\0\1\336\1\0\1\337\1\0\1\337\1\340\1\341"+
    "\2\342\2\0\1\336\10\0\1\146\11\0\1\344\62\0"+
    "\1\307\1\0\1\310\4\0\1\377\47\0\1\u011d\32\0"+
    "\1\u010e\100\0\1\u011e\1\u011f\41\0\1\320\1\0\2\46"+
    "\3\0\3\46\1\47\1\46\3\47\2\46\10\47\1\46"+
    "\1\321\7\0\1\322\1\0\1\46\1\0\4\46\4\0"+
    "\3\47\1\46\1\0\1\47\1\u0120\5\47\1\364\5\47"+
    "\1\167\2\0\1\u0121\1\0\1\167\1\171\3\0\11\167"+
    "\1\171\10\167\2\171\2\0\2\167\2\0\4\167\1\0"+
    "\1\167\1\171\2\167\1\0\1\167\1\0\23\167\1\172"+
    "\1\304\1\u0122\1\u0123\2\172\1\173\14\172\1\173\10\172"+
    "\2\173\14\172\1\173\30\172\1\167\2\0\1\u0121\1\0"+
    "\1\167\1\171\3\0\11\167\1\171\10\167\2\171\1\u0124"+
    "\1\0\1\u0125\1\167\2\0\4\167\1\0\1\167\1\171"+
    "\2\167\1\0\1\167\1\0\24\167\2\0\1\u0126\1\0"+
    "\1\172\1\173\3\0\11\172\1\173\10\172\2\173\2\0"+
    "\2\167\2\0\3\167\1\172\1\0\1\172\1\173\2\172"+
    "\1\0\1\167\1\0\1\167\4\172\1\167\15\172\1\167"+
    "\2\0\1\u0126\1\0\1\172\1\173\3\0\11\172\1\173"+
    "\10\172\2\173\1\u0124\1\0\1\u0125\1\167\2\0\3\167"+
    "\1\172\1\0\1\172\1\173\2\172\1\0\1\167\1\0"+
    "\1\167\4\172\1\167\15\172\1\167\2\0\1\u0121\1\0"+
    "\1\167\1\171\3\0\11\167\1\171\10\167\2\171\1\345"+
    "\1\0\2\167\1\346\1\0\4\167\1\0\1\167\1\171"+
    "\2\167\1\0\1\167\1\0\24\167\2\0\1\u0126\1\0"+
    "\1\172\1\173\3\0\11\172\1\173\10\172\2\173\2\0"+
    "\2\167\2\0\3\167\1\172\1\0\1\172\1\173\2\172"+
    "\1\0\1\167\1\0\1\167\4\172\1\167\2\172\1\u0127"+
    "\12\172\1\167\2\0\1\u0121\1\0\1\167\1\171\3\0"+
    "\11\167\1\171\10\167\2\171\1\357\1\0\2\167\2\0"+
    "\4\167\1\0\1\167\1\171\2\167\1\0\1\167\1\0"+
    "\23\167\3\200\1\u0128\3\200\1\0\1\200\1\0\24\200"+
    "\1\0\11\200\1\0\135\200\5\0\2\312\2\0\1\312"+
    "\3\0\1\314\1\0\1\314\1\312\1\314\7\312\2\314"+
    "\2\312\1\0\1\u011a\1\0\1\316\11\0\1\312\5\0"+
    "\1\317\3\314\2\0\15\314\1\206\2\0\1\u0129\3\206"+
    "\3\0\24\206\2\0\10\206\1\0\4\206\1\0\1\206"+
    "\1\0\24\206\1\0\102\206\2\0\1\u012a\1\210\2\206"+
    "\3\0\24\206\2\0\10\206\1\0\4\206\1\214\1\206"+
    "\1\214\23\206\36\0\1\u012b\47\0\1\u012c\1\214\50\0"+
    "\1\214\1\0\1\214\23\0\1\215\2\0\1\u012d\3\215"+
    "\3\0\24\215\2\0\2\215\3\0\3\215\1\0\5\215"+
    "\2\0\23\215\1\0\1\216\101\0\1\215\1\u012e\1\u012f"+
    "\1\u012d\100\215\2\0\1\u0130\1\221\2\215\3\0\24\215"+
    "\2\0\2\215\3\0\3\215\1\0\4\215\1\221\1\0"+
    "\1\231\23\215\1\222\2\0\1\u0131\3\222\3\41\24\222"+
    "\2\41\2\222\3\41\3\222\1\41\5\222\2\41\23\222"+
    "\3\0\1\u0132\1\231\50\0\1\231\1\0\1\231\23\0"+
    "\1\215\2\0\1\u012d\3\215\3\0\24\215\1\357\1\0"+
    "\2\215\2\0\1\360\3\215\1\0\5\215\1\361\1\0"+
    "\23\215\1\222\2\0\1\u0131\2\222\1\u0133\3\41\24\222"+
    "\2\41\2\222\3\41\3\222\1\41\5\222\2\41\23\222"+
    "\1\234\2\0\1\u0134\3\234\2\0\25\234\2\0\2\234"+
    "\3\0\10\234\1\0\1\234\1\0\24\234\1\0\102\234"+
    "\2\0\1\u0135\1\236\2\234\2\0\25\234\2\0\2\234"+
    "\3\0\10\234\1\40\1\234\1\40\23\234\1\u0136\2\0"+
    "\1\u0137\3\u0136\2\0\25\u0136\2\0\2\u0136\3\0\10\u0136"+
    "\1\0\1\u0136\1\0\23\u0136\1\u0138\2\0\1\u0139\3\u0138"+
    "\2\0\25\u0138\2\0\2\u0138\3\0\10\u0138\1\0\1\u0138"+
    "\1\0\23\u0138\1\241\2\0\1\u013a\3\241\2\0\25\241"+
    "\2\0\2\241\3\0\10\241\1\0\1\241\1\0\24\241"+
    "\1\0\102\241\2\0\1\u013b\1\244\2\241\2\0\25\241"+
    "\2\0\2\241\3\0\10\241\1\245\1\241\1\245\23\241"+
    "\3\0\1\u013c\1\245\50\0\1\245\1\0\1\245\24\0"+
    "\1\246\101\0\1\250\2\0\100\250\1\0\1\251\102\0"+
    "\1\254\101\0\2\263\1\u013d\100\263\3\0\1\u013e\1\257"+
    "\50\0\1\257\1\0\1\257\30\0\1\u013f\100\0\1\u0140"+
    "\13\0\3\263\2\0\10\263\25\0\3\263\2\0\15\263"+
    "\3\0\1\u0140\1\0\1\u0141\11\0\1\263\1\u0142\1\263"+
    "\2\0\5\u0142\2\263\1\u0142\25\0\3\263\2\0\15\263"+
    "\3\0\1\u0140\13\0\3\263\2\0\5\u0143\1\u0144\1\263"+
    "\1\u0143\25\0\3\263\2\0\15\263\3\0\1\u0140\1\0"+
    "\1\u0141\11\0\1\263\1\u0142\1\263\2\0\1\264\1\u0142"+
    "\1\264\1\u0142\1\264\2\263\1\u0142\25\0\3\263\2\0"+
    "\15\263\3\0\1\u0140\13\0\1\263\1\264\1\263\2\0"+
    "\5\264\2\263\1\264\25\0\3\263\2\0\15\263\3\0"+
    "\1\u0140\1\0\1\u0141\11\0\1\263\1\264\1\263\2\0"+
    "\5\264\2\263\1\264\25\0\3\263\2\0\15\263\36\0"+
    "\1\u0145\104\0\1\u0146\111\0\1\u013f\55\0\1\261\12\0"+
    "\1\261\7\0\1\261\4\0\1\261\103\0\1\261\103\0"+
    "\1\261\112\0\1\u013f\16\0\7\302\1\0\1\302\1\0"+
    "\34\302\3\0\32\302\1\u0147\1\302\5\u0147\1\u0148\1\u0147"+
    "\1\u0148\34\u0147\3\u0148\32\u0147\3\0\1\u0149\1\0\2\46"+
    "\3\0\24\46\11\0\1\46\1\0\4\46\4\0\4\46"+
    "\1\0\15\46\1\0\1\304\1\0\1\u0149\1\0\2\46"+
    "\3\0\24\46\11\0\1\46\1\0\4\46\4\0\4\46"+
    "\1\0\15\46\1\0\1\40\1\u014a\100\0\37\u014b\1\0"+
    "\43\u014b\103\u014c\3\313\1\u014d\4\313\1\311\72\313\15\0"+
    "\1\314\1\0\3\314\2\0\10\314\25\0\3\314\2\0"+
    "\15\314\36\0\1\u014e\44\0\2\46\1\u014f\100\46\3\0"+
    "\1\320\1\0\2\46\3\0\24\46\7\0\1\u0150\1\0"+
    "\1\46\1\0\4\46\4\0\4\46\1\0\15\46\3\0"+
    "\1\320\1\0\2\46\3\0\1\46\1\323\1\46\1\323"+
    "\1\46\2\323\3\46\10\323\2\46\11\0\1\46\1\0"+
    "\4\46\4\0\3\323\1\46\1\0\15\323\3\0\1\320"+
    "\1\0\2\46\3\0\6\46\1\324\3\46\5\324\2\46"+
    "\1\324\2\46\11\0\1\46\1\0\4\46\4\0\4\46"+
    "\1\0\15\46\3\0\1\320\1\0\2\46\3\0\12\46"+
    "\5\325\2\46\1\325\2\46\11\0\1\46\1\0\4\46"+
    "\4\0\4\46\1\0\15\46\3\0\1\320\1\0\2\46"+
    "\3\0\6\46\1\u0151\3\46\5\u0151\1\46\2\u0151\2\46"+
    "\11\0\1\46\1\0\4\46\4\0\1\46\1\u0151\2\46"+
    "\1\0\3\46\3\u0151\1\46\1\u0151\5\46\5\0\1\u0152"+
    "\12\0\1\u0153\3\0\5\u0153\2\0\1\u0153\54\0\1\u0152"+
    "\12\0\1\u0153\3\0\1\336\1\u0153\1\336\1\u0153\1\336"+
    "\2\0\1\u0153\67\0\1\336\3\0\5\336\2\0\1\336"+
    "\54\0\1\u0152\12\0\1\336\3\0\5\336\2\0\1\336"+
    "\125\0\1\u0154\27\0\1\320\1\0\2\46\3\0\3\46"+
    "\1\47\1\46\3\47\2\46\10\47\1\46\1\321\7\0"+
    "\1\322\1\0\1\46\1\0\4\46\4\0\2\47\1\u0155"+
    "\1\46\1\0\15\47\3\0\1\320\1\0\2\46\3\0"+
    "\3\46\1\47\1\46\3\47\2\46\10\47\1\46\1\321"+
    "\7\0\1\322\1\0\1\46\1\0\4\46\4\0\3\47"+
    "\1\46\1\0\1\u0156\1\47\1\u0157\12\47\3\0\1\320"+
    "\1\0\2\46\3\0\3\46\1\47\1\46\3\47\2\46"+
    "\10\47\1\46\1\321\7\0\1\322\1\0\1\46\1\0"+
    "\4\46\4\0\3\47\1\46\1\0\3\47\1\u0158\11\47"+
    "\3\0\1\320\1\0\2\46\3\0\3\46\1\47\1\46"+
    "\3\47\2\46\10\47\1\46\1\321\7\0\1\322\1\0"+
    "\1\46\1\0\4\46\4\0\3\47\1\46\1\0\3\47"+
    "\1\u0159\11\47\3\0\1\320\1\0\2\46\3\0\3\46"+
    "\1\47\1\46\3\47\2\46\10\47\1\46\1\321\7\0"+
    "\1\322\1\0\1\46\1\0\4\46\4\0\3\47\1\46"+
    "\1\0\2\47\1\u015a\12\47\3\0\1\320\1\0\2\46"+
    "\3\0\3\46\1\47\1\46\3\47\2\46\10\47\1\46"+
    "\1\321\7\0\1\322\1\0\1\46\1\0\4\46\4\0"+
    "\1\47\1\u015b\1\47\1\46\1\0\15\47\22\0\1\u015c"+
    "\42\0\1\u015d\20\0\1\320\1\0\2\46\3\0\3\46"+
    "\1\47\1\46\3\47\2\46\10\47\1\46\1\321\7\0"+
    "\1\322\1\0\1\46\1\0\4\46\4\0\1\u015e\2\47"+
    "\1\46\1\0\15\47\3\0\1\320\1\0\2\46\3\0"+
    "\3\46\1\47\1\46\3\47\2\46\10\47\1\46\1\321"+
    "\7\0\1\322\1\0\1\46\1\0\4\46\4\0\3\47"+
    "\1\46\1\0\2\47\1\u015f\12\47\3\0\1\320\1\0"+
    "\2\46\3\0\3\46\1\47\1\46\3\47\2\46\10\47"+
    "\1\46\1\321\7\0\1\322\1\0\1\46\1\0\4\46"+
    "\4\0\3\47\1\46\1\0\1\47\1\u0160\13\47\3\0"+
    "\1\320\1\0\2\46\3\0\3\46\1\47\1\46\3\47"+
    "\2\46\10\47\1\46\1\321\7\0\1\322\1\0\1\46"+
    "\1\0\4\46\4\0\3\47\1\46\1\0\10\47\1\u0161"+
    "\4\47\3\0\1\320\1\0\2\46\3\0\3\46\1\47"+
    "\1\46\3\47\2\46\10\47\1\46\1\321\7\0\1\322"+
    "\1\0\1\46\1\0\4\46\4\0\3\47\1\46\1\0"+
    "\1\47\1\u0162\13\47\3\0\1\320\1\0\2\46\3\0"+
    "\3\46\1\47\1\46\3\47\2\46\10\47\1\46\1\321"+
    "\7\0\1\322\1\0\1\46\1\0\4\46\4\0\2\47"+
    "\1\u0163\1\46\1\0\15\47\3\0\1\320\1\0\2\46"+
    "\3\0\3\46\1\47\1\46\3\47\2\46\10\47\1\46"+
    "\1\321\7\0\1\322\1\0\1\46\1\0\4\46\4\0"+
    "\3\47\1\46\1\0\1\u0164\14\47\1\375\2\0\100\375"+
    "\1\0\1\113\1\0\1\u0102\1\0\2\113\7\0\4\113"+
    "\1\0\11\113\25\0\3\113\2\0\15\113\45\0\1\u0150"+
    "\50\0\1\u0103\1\0\1\u0103\1\0\2\u0103\3\0\10\u0103"+
    "\25\0\3\u0103\2\0\15\u0103\20\0\1\u0104\3\0\5\u0104"+
    "\2\0\1\u0104\73\0\5\u0107\2\0\1\u0107\67\0\1\u0165"+
    "\3\0\5\u0165\1\0\2\u0165\26\0\1\u0165\6\0\3\u0165"+
    "\1\0\1\u0165\52\0\1\u0166\57\0\1\u015c\22\0\1\u0167"+
    "\17\0\1\u015d\20\0\1\u0102\1\0\2\113\6\0\1\u0100"+
    "\1\113\3\114\1\0\1\113\10\114\1\0\1\u0101\7\0"+
    "\1\322\13\0\2\114\1\u0168\2\0\15\114\2\145\1\0"+
    "\1\150\3\145\3\0\24\145\2\0\3\145\1\0\4\145"+
    "\1\0\6\145\1\0\24\145\1\151\1\u0169\1\150\77\145"+
    "\36\0\1\u016a\110\0\1\u011f\36\0\1\167\1\u016b\1\u016c"+
    "\1\u0121\2\167\1\171\14\167\1\171\10\167\2\171\14\167"+
    "\1\171\31\167\1\304\1\0\1\u016d\1\0\1\172\1\173"+
    "\3\0\11\172\1\173\10\172\2\173\2\0\2\167\2\0"+
    "\3\167\1\172\1\0\1\172\1\173\2\172\1\0\1\167"+
    "\1\0\1\167\4\172\1\167\15\172\1\167\1\u016b\1\u016c"+
    "\1\u0126\1\167\1\172\1\173\3\167\11\172\1\173\10\172"+
    "\2\173\11\167\1\172\1\167\1\172\1\173\2\172\4\167"+
    "\4\172\1\167\15\172\37\u016e\1\0\43\u016e\1\167\2\u016f"+
    "\1\u0121\1\u016f\1\167\1\171\3\u016f\11\167\1\171\10\167"+
    "\2\171\2\u016f\2\167\2\u016f\4\167\1\u016f\1\167\1\171"+
    "\2\167\1\u016f\1\167\1\u016f\23\167\1\172\1\u0170\1\u0171"+
    "\1\u0123\2\172\1\173\14\172\1\173\10\172\2\173\14\172"+
    "\1\173\30\172\1\167\2\0\1\u0126\1\0\1\172\1\173"+
    "\3\0\11\172\1\173\10\172\2\173\2\0\2\167\2\0"+
    "\3\167\1\172\1\0\1\172\1\173\2\172\1\0\1\167"+
    "\1\0\1\167\4\172\1\167\3\172\1\u0172\11\172\1\206"+
    "\1\214\1\u0173\100\206\1\0\1\214\1\u0174\100\0\1\215"+
    "\1\0\1\215\1\u012d\77\215\3\0\1\u0175\77\0\1\215"+
    "\1\u012e\1\0\1\220\3\215\3\0\24\215\2\0\2\215"+
    "\3\0\3\215\1\0\5\215\2\0\24\215\1\231\1\u0176"+
    "\1\u012d\77\215\1\222\1\0\1\215\1\u0131\77\222\1\0"+
    "\1\231\1\u0177\100\0\1\u0133\2\0\1\u0178\3\u0133\3\375"+
    "\24\u0133\2\375\2\u0133\3\375\3\u0133\1\375\5\u0133\2\375"+
    "\23\u0133\1\234\1\40\1\u0179\100\234\1\u0136\2\0\1\u0137"+
    "\3\u0136\1\u017a\1\0\25\u0136\2\0\2\u0136\3\0\10\u0136"+
    "\1\0\1\u0136\1\0\24\u0136\1\0\101\u0136\1\u0138\2\0"+
    "\1\u0139\3\u0138\1\0\1\u017a\25\u0138\2\0\2\u0138\3\0"+
    "\10\u0138\1\0\1\u0138\1\0\24\u0138\1\0\101\u0138\1\241"+
    "\1\245\1\u017b\100\241\1\0\1\245\1\u017c\101\0\1\263"+
    "\1\0\1\u0140\13\0\3\263\2\0\10\263\25\0\3\263"+
    "\2\0\15\263\1\0\1\257\1\u017d\113\0\1\u0141\1\0"+
    "\1\u0141\1\0\2\u0141\3\0\10\u0141\25\0\3\u0141\2\0"+
    "\15\u0141\3\0\1\u0140\13\0\1\263\1\u0142\1\263\2\0"+
    "\5\u0142\2\263\1\u0142\25\0\3\263\2\0\15\263\3\0"+
    "\1\u0140\13\0\3\263\2\0\5\u0143\2\263\1\u0143\25\0"+
    "\3\263\2\0\15\263\3\0\1\u0140\13\0\1\263\1\u017e"+
    "\1\263\2\0\5\u017e\1\263\2\u017e\25\0\1\263\1\u017e"+
    "\1\263\2\0\3\263\3\u017e\1\263\1\u017e\5\263\3\302"+
    "\1\303\3\302\1\0\1\302\1\0\34\302\3\0\32\302"+
    "\3\0\1\u017f\100\0\1\40\1\0\1\306\1\40\50\0"+
    "\1\40\1\0\1\40\23\0\37\u014b\1\u0180\43\u014b\41\0"+
    "\1\u0181\41\0\3\313\1\u014d\4\313\1\u0182\72\313\1\0"+
    "\1\46\1\0\1\320\1\0\2\46\3\0\24\46\11\0"+
    "\1\46\1\0\4\46\4\0\4\46\1\0\15\46\13\0"+
    "\1\u0152\1\0\1\u0152\1\0\2\u0152\3\0\10\u0152\25\0"+
    "\3\u0152\2\0\15\u0152\20\0\1\u0153\3\0\5\u0153\2\0"+
    "\1\u0153\52\0\1\320\1\0\2\46\3\0\3\46\1\47"+
    "\1\46\3\47\2\46\10\47\1\46\1\321\7\0\1\322"+
    "\1\0\1\46\1\0\4\46\4\0\3\47\1\46\1\0"+
    "\7\47\1\u0183\5\47\3\0\1\320\1\0\2\46\3\0"+
    "\3\46\1\47\1\46\3\47\2\46\10\47\1\46\1\321"+
    "\7\0\1\322\1\0\1\46\1\0\4\46\4\0\1\47"+
    "\1\u0184\1\47\1\46\1\0\15\47\3\0\1\320\1\0"+
    "\2\46\3\0\3\46\1\47\1\46\3\47\2\46\10\47"+
    "\1\46\1\321\7\0\1\322\1\0\1\46\1\0\4\46"+
    "\4\0\3\47\1\46\1\0\4\47\1\u0185\10\47\3\0"+
    "\1\320\1\0\2\46\3\0\3\46\1\47\1\46\3\47"+
    "\2\46\10\47\1\46\1\321\7\0\1\322\1\0\1\46"+
    "\1\0\4\46\4\0\1\u0186\2\47\1\46\1\0\15\47"+
    "\3\0\1\320\1\0\2\46\3\0\3\46\1\47\1\46"+
    "\3\47\2\46\10\47\1\46\1\321\7\0\1\322\1\0"+
    "\1\46\1\0\4\46\4\0\2\47\1\u0187\1\46\1\0"+
    "\15\47\3\0\1\320\1\0\2\46\3\0\3\46\1\47"+
    "\1\46\3\47\2\46\10\47\1\46\1\321\7\0\1\322"+
    "\1\0\1\46\1\0\4\46\4\0\3\47\1\46\1\0"+
    "\1\47\1\u0188\13\47\3\0\1\320\1\0\2\46\3\0"+
    "\3\46\1\47\1\46\3\47\2\46\10\47\1\46\1\321"+
    "\7\0\1\322\1\0\1\46\1\0\4\46\4\0\1\47"+
    "\1\u0189\1\47\1\46\1\0\15\47\3\0\1\320\1\0"+
    "\2\46\3\0\3\46\1\47\1\46\3\47\2\46\10\47"+
    "\1\46\1\321\7\0\1\322\1\0\1\46\1\0\4\46"+
    "\4\0\1\47\1\u018a\1\47\1\46\1\0\15\47\3\0"+
    "\1\320\1\0\2\46\3\0\3\46\1\47\1\46\3\47"+
    "\2\46\10\47\1\46\1\321\7\0\1\322\1\0\1\46"+
    "\1\0\4\46\4\0\1\47\1\u018b\1\47\1\46\1\0"+
    "\15\47\3\0\1\320\1\0\2\46\3\0\3\46\1\47"+
    "\1\46\3\47\2\46\10\47\1\46\1\321\7\0\1\322"+
    "\1\0\1\46\1\0\4\46\4\0\3\47\1\46\1\0"+
    "\4\47\1\u018c\10\47\3\0\1\320\1\0\2\46\3\0"+
    "\3\46\1\47\1\46\3\47\2\46\10\47\1\46\1\321"+
    "\7\0\1\322\1\0\1\46\1\0\4\46\4\0\3\47"+
    "\1\46\1\0\1\u018d\14\47\3\0\1\320\1\0\2\46"+
    "\3\0\3\46\1\47\1\46\3\47\2\46\10\47\1\46"+
    "\1\321\7\0\1\322\1\0\1\46\1\0\4\46\4\0"+
    "\1\u018e\2\47\1\46\1\0\15\47\1\145\1\151\1\0"+
    "\1\u0118\1\151\2\145\3\0\24\145\2\0\3\145\1\0"+
    "\4\145\1\0\4\145\1\151\1\145\1\40\23\145\1\167"+
    "\2\0\1\u018f\1\0\1\167\1\171\3\0\11\167\1\171"+
    "\10\167\2\171\2\0\2\167\2\0\4\167\1\0\1\167"+
    "\1\171\2\167\1\0\1\167\1\0\24\167\1\u016b\1\0"+
    "\1\u0121\1\0\1\167\1\171\3\0\11\167\1\171\10\167"+
    "\2\171\2\0\2\167\2\0\4\167\1\0\1\167\1\171"+
    "\2\167\1\0\1\167\1\0\23\167\1\172\1\u0190\1\u0191"+
    "\1\u0123\2\172\1\173\14\172\1\173\10\172\2\173\14\172"+
    "\1\173\30\172\37\u016e\1\167\43\u016e\41\0\1\u0192\41\0"+
    "\1\167\2\0\1\u0193\1\0\1\172\1\173\3\0\11\172"+
    "\1\173\10\172\2\173\2\0\2\167\2\0\3\167\1\172"+
    "\1\0\1\172\1\173\2\172\1\0\1\167\1\0\1\167"+
    "\4\172\1\167\15\172\1\167\1\u0170\1\0\1\u0126\1\0"+
    "\1\172\1\173\3\0\11\172\1\173\10\172\2\173\2\0"+
    "\2\167\2\0\3\167\1\172\1\0\1\172\1\173\2\172"+
    "\1\0\1\167\1\0\1\167\4\172\1\167\15\172\1\167"+
    "\2\0\1\u0126\1\0\1\172\1\173\3\0\11\172\1\173"+
    "\10\172\2\173\2\0\2\167\2\0\3\167\1\172\1\0"+
    "\1\172\1\173\2\172\1\0\1\167\1\0\1\167\4\172"+
    "\1\167\4\172\1\u0194\10\172\1\206\1\214\1\0\1\u012a"+
    "\1\210\2\206\3\0\24\206\2\0\10\206\1\0\4\206"+
    "\1\214\1\206\1\214\23\206\1\0\1\214\1\0\1\u012c"+
    "\1\214\50\0\1\214\1\0\1\214\24\0\1\u012e\1\u0195"+
    "\100\0\1\215\1\231\1\0\1\u0130\1\221\2\215\3\0"+
    "\24\215\2\0\2\215\3\0\3\215\1\0\4\215\1\221"+
    "\1\0\1\231\23\215\1\0\1\231\1\0\1\u0132\1\231"+
    "\50\0\1\231\1\0\1\231\23\0\1\u0133\1\0\1\215"+
    "\1\u0178\77\u0133\1\234\1\40\1\0\1\u0135\1\236\2\234"+
    "\2\0\25\234\2\0\2\234\3\0\10\234\1\40\1\234"+
    "\1\40\23\234\1\241\1\245\1\0\1\u013b\1\244\2\241"+
    "\2\0\25\241\2\0\2\241\3\0\10\241\1\245\1\241"+
    "\1\245\23\241\1\0\1\245\1\0\1\u013c\1\245\50\0"+
    "\1\245\1\0\1\245\24\0\1\257\1\0\1\u013e\1\257"+
    "\50\0\1\257\1\0\1\257\23\0\1\u0148\1\0\101\u0148"+
    "\6\0\1\u0196\14\0\1\u0196\10\0\2\u0196\14\0\1\u0196"+
    "\71\0\1\u0197\44\0\1\320\1\0\2\46\3\0\3\46"+
    "\1\47\1\46\3\47\2\46\10\47\1\46\1\321\7\0"+
    "\1\322\1\0\1\46\1\0\4\46\4\0\3\47\1\46"+
    "\1\0\4\47\1\u0198\10\47\3\0\1\320\1\0\2\46"+
    "\3\0\3\46\1\47\1\46\3\47\2\46\10\47\1\46"+
    "\1\321\7\0\1\322\1\0\1\46\1\0\4\46\4\0"+
    "\2\47\1\u0199\1\46\1\0\15\47\3\0\1\320\1\0"+
    "\2\46\3\0\3\46\1\47\1\46\3\47\2\46\10\47"+
    "\1\46\1\321\7\0\1\322\1\0\1\46\1\0\4\46"+
    "\4\0\1\u019a\2\47\1\46\1\0\15\47\3\0\1\320"+
    "\1\0\2\46\3\0\3\46\1\47\1\46\3\47\2\46"+
    "\10\47\1\46\1\321\7\0\1\322\1\0\1\46\1\0"+
    "\4\46\4\0\1\47\1\u019b\1\47\1\46\1\0\15\47"+
    "\1\167\1\0\1\167\1\u0121\2\167\1\171\14\167\1\171"+
    "\10\167\2\171\14\167\1\171\31\167\2\0\1\170\1\0"+
    "\1\172\1\173\3\0\11\172\1\173\10\172\2\173\2\0"+
    "\2\167\2\0\3\167\1\172\1\0\1\172\1\173\2\172"+
    "\1\0\1\167\1\0\1\167\4\172\1\167\15\172\1\167"+
    "\1\u0190\1\0\1\u016d\1\0\1\172\1\173\3\0\11\172"+
    "\1\173\10\172\2\173\2\0\2\167\2\0\3\167\1\172"+
    "\1\0\1\172\1\173\2\172\1\0\1\167\1\0\1\167"+
    "\4\172\1\167\15\172\41\0\1\167\41\0\1\172\1\46"+
    "\1\u019c\1\u0123\2\172\1\173\14\172\1\173\10\172\2\173"+
    "\14\172\1\173\30\172\1\0\1\u012e\1\0\1\u0175\105\0"+
    "\1\u0196\14\0\1\u0196\10\0\2\u0196\3\0\1\u0197\10\0"+
    "\1\u0196\33\0\1\320\1\0\2\46\3\0\3\46\1\47"+
    "\1\46\3\47\2\46\10\47\1\46\1\321\7\0\1\322"+
    "\1\0\1\46\1\0\4\46\4\0\2\47\1\u019d\1\46"+
    "\1\0\15\47\3\0\1\320\1\0\2\46\3\0\3\46"+
    "\1\47\1\46\3\47\2\46\10\47\1\46\1\321\7\0"+
    "\1\322\1\0\1\46\1\0\4\46\4\0\3\47\1\46"+
    "\1\0\1\u019e\14\47\1\167\1\46\1\0\1\u0126\1\0"+
    "\1\172\1\173\3\0\11\172\1\173\10\172\2\173\2\0"+
    "\2\167\2\0\3\167\1\172\1\0\1\172\1\173\2\172"+
    "\1\0\1\167\1\0\1\167\4\172\1\167\15\172\3\0"+
    "\1\320\1\0\2\46\3\0\3\46\1\47\1\46\3\47"+
    "\2\46\10\47\1\46\1\321\7\0\1\322\1\0\1\46"+
    "\1\0\4\46\4\0\3\47\1\46\1\0\6\47\1\u019f"+
    "\6\47\3\0\1\320\1\0\2\46\3\0\3\46\1\47"+
    "\1\46\3\47\2\46\10\47\1\46\1\321\7\0\1\322"+
    "\1\0\1\46\1\0\4\46\4\0\3\47\1\46\1\0"+
    "\1\47\1\u01a0\13\47";

  private static int [] zzUnpackTrans() {
    int [] result = new int[19430];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\33\0\2\11\5\1\1\11\20\1\1\11\1\1\3\11"+
    "\1\1\1\11\16\1\1\11\17\1\3\11\4\1\1\11"+
    "\1\1\2\11\2\1\1\11\6\1\1\11\4\1\1\11"+
    "\17\1\1\11\2\1\1\11\5\1\1\11\2\1\1\11"+
    "\7\1\1\11\13\1\1\11\3\1\1\11\2\1\1\11"+
    "\1\1\2\11\4\1\1\11\11\1\1\11\4\1\1\11"+
    "\5\1\3\0\2\11\1\0\2\1\2\11\1\0\1\1"+
    "\1\11\4\1\7\11\1\1\1\11\3\1\1\11\1\1"+
    "\4\11\6\1\3\11\15\1\1\11\3\0\2\1\2\11"+
    "\1\1\1\0\11\11\1\1\2\11\4\1\1\0\1\1"+
    "\3\11\1\1\1\11\4\1\1\0\3\1\3\0\1\11"+
    "\1\0\5\1\1\0\1\1\11\0\1\1\1\0\1\11"+
    "\1\0\4\1\2\11\2\1\1\0\1\1\3\0\1\11"+
    "\1\1\1\11\3\1\1\11\7\1\2\11\10\1\2\11"+
    "\2\1\1\11\1\0\2\1\2\0\5\1\1\0\4\1"+
    "\1\11\4\1\1\0\1\1\1\0\20\1\1\0\3\1"+
    "\1\0\12\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[416];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
  public _ShLexerGen() {
    this(null);
  }

  private static final int DOUBLE_PARENTHESES = 2;
  private static final int PARENTHESES = 1;

  private boolean isArithmeticExpansion;
  private boolean isBackquoteOpen;
  private boolean isQuoteOpen;
  private String heredocMarker;
  private boolean heredocWithWhiteSpaceIgnore;
  private int regexStart = -1;
  private int regexGroups = 0;
  private int herestringStartPosition = -1;
  private final IntStack stateStack = new IntStack(1_000);
  private final IntStack parenStack = new IntStack(1_000);

  private void pushState(int state) {
    int currentState = yystate();
    assert currentState != YYINITIAL || stateStack.empty() : "Can't push initial state into the not empty stack";
    stateStack.push(currentState);
    yybegin(state);
  }

  private void popState() {
    assert !stateStack.empty() : "States stack is empty";
    yybegin(stateStack.pop());
  }

  private void popState(int currentState) {
    if (yystate() == currentState) {
      assert !stateStack.empty() : "States stack is empty";
      yybegin(stateStack.pop());
    }
  }

  private void pushParentheses(int parentheses) {
    parenStack.push(parentheses);
  }

  private void popParentheses() {
    assert !parenStack.empty() : "Parentheses stack is empty";
    parenStack.pop();
  }

  private boolean shouldCloseDoubleParen() {
    return !parenStack.empty() && parenStack.peek() == DOUBLE_PARENTHESES;
  }

  private boolean shouldCloseSingleParen() {
    return !parenStack.empty() && parenStack.peek() == PARENTHESES;
  }

  protected void onReset() {
    stateStack.clear();
    parenStack.clear();
    heredocWithWhiteSpaceIgnore = false;
    heredocMarker = null;
    isArithmeticExpansion = false;
    isQuoteOpen = false;
    isBackquoteOpen = false;
    herestringStartPosition = -1;
    regexStart = -1;
    regexGroups = 0;
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public _ShLexerGen(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    int size = 0;
    for (int i = 0, length = packed.length(); i < length; i += 2) {
      size += packed.charAt(i);
    }
    char[] map = new char[size];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < packed.length()) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      {@code false}, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position {@code pos} from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL.charAt(zzMarkedPosL-1)) {
        case '\n':
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':  // fall through
          zzAtBOL = true;
          break;
        case '\r': 
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL.charAt(zzMarkedPosL) != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzEndReadL = zzEndRead;
            zzBufferL = zzBuffer;
            if (eof) 
              zzAtBOL = false;
            else 
              zzAtBOL = zzBufferL.charAt(zzMarkedPosL) != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + ZZ_CMAP(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return BAD_CHARACTER;
            } 
            // fall through
          case 145: break;
          case 2: 
            { return LINEFEED;
            } 
            // fall through
          case 146: break;
          case 3: 
            { return WHITESPACE;
            } 
            // fall through
          case 147: break;
          case 4: 
            { return COMMENT;
            } 
            // fall through
          case 148: break;
          case 5: 
            { return BANG;
            } 
            // fall through
          case 149: break;
          case 6: 
            { pushState(STRING_EXPRESSION); return OPEN_QUOTE;
            } 
            // fall through
          case 150: break;
          case 7: 
            { return RAW_STRING;
            } 
            // fall through
          case 151: break;
          case 8: 
            { return DOLLAR;
            } 
            // fall through
          case 152: break;
          case 9: 
            { return WORD;
            } 
            // fall through
          case 153: break;
          case 10: 
            { return INT;
            } 
            // fall through
          case 154: break;
          case 11: 
            { pushParentheses(PARENTHESES); return LEFT_PAREN;
            } 
            // fall through
          case 155: break;
          case 12: 
            { if (shouldCloseSingleParen()) popParentheses();
                                    popState(PARENTHESES_COMMAND_SUBSTITUTION); return RIGHT_PAREN;
            } 
            // fall through
          case 156: break;
          case 13: 
            { pushState(CONDITIONAL_EXPRESSION); return LEFT_SQUARE;
            } 
            // fall through
          case 157: break;
          case 14: 
            { switch (yystate()) {
                                      case OLD_ARITHMETIC_EXPRESSION: popState(); return ARITH_SQUARE_RIGHT;
                                      case CONDITIONAL_EXPRESSION: popState(); return RIGHT_SQUARE;
                                      default: return RIGHT_SQUARE; }
            } 
            // fall through
          case 158: break;
          case 15: 
            { return PIPE;
            } 
            // fall through
          case 159: break;
          case 16: 
            { return SEMI;
            } 
            // fall through
          case 160: break;
          case 17: 
            { return AMP;
            } 
            // fall through
          case 161: break;
          case 18: 
            { return ASSIGN;
            } 
            // fall through
          case 162: break;
          case 19: 
            { return RIGHT_CURLY;
            } 
            // fall through
          case 163: break;
          case 20: 
            { if (yystate() == BACKQUOTE_COMMAND_SUBSTITUTION) { popState(); isBackquoteOpen = false; return CLOSE_BACKQUOTE; }
                                    else { pushState(BACKQUOTE_COMMAND_SUBSTITUTION); isBackquoteOpen = true; return OPEN_BACKQUOTE; }
            } 
            // fall through
          case 164: break;
          case 21: 
            { return GT;
            } 
            // fall through
          case 165: break;
          case 22: 
            { return LEFT_CURLY;
            } 
            // fall through
          case 166: break;
          case 23: 
            { return LT;
            } 
            // fall through
          case 167: break;
          case 24: 
            { return BITWISE_NEGATION;
            } 
            // fall through
          case 168: break;
          case 25: 
            { return MINUS;
            } 
            // fall through
          case 169: break;
          case 26: 
            { return MULT;
            } 
            // fall through
          case 170: break;
          case 27: 
            { return PLUS;
            } 
            // fall through
          case 171: break;
          case 28: 
            { return DIV;
            } 
            // fall through
          case 172: break;
          case 29: 
            { return COLON;
            } 
            // fall through
          case 173: break;
          case 30: 
            { return QMARK;
            } 
            // fall through
          case 174: break;
          case 31: 
            { return COMMA;
            } 
            // fall through
          case 175: break;
          case 32: 
            { return XOR;
            } 
            // fall through
          case 176: break;
          case 33: 
            { return MOD;
            } 
            // fall through
          case 177: break;
          case 34: 
            { popState(); return LINEFEED;
            } 
            // fall through
          case 178: break;
          case 35: 
            { if (isQuoteOpen) { isQuoteOpen = false; return CLOSE_QUOTE; }
                                    else { isQuoteOpen = true; return OPEN_QUOTE; }
            } 
            // fall through
          case 179: break;
          case 36: 
            { popState(); return SEMI;
            } 
            // fall through
          case 180: break;
          case 37: 
            { return EVAL_CONTENT;
            } 
            // fall through
          case 181: break;
          case 38: 
            { popState(); yypushback(yylength());
            } 
            // fall through
          case 182: break;
          case 39: 
            { if (isBackquoteOpen) { popState(); yypushback(yylength()); }
                                   else { pushState(BACKQUOTE_COMMAND_SUBSTITUTION); isBackquoteOpen = true; return OPEN_BACKQUOTE; }
            } 
            // fall through
          case 183: break;
          case 40: 
            { if (isBackquoteOpen) { popState(); yypushback(yylength()); }
                                    else { pushState(BACKQUOTE_COMMAND_SUBSTITUTION); isBackquoteOpen = true; return OPEN_BACKQUOTE; }
            } 
            // fall through
          case 184: break;
          case 41: 
            { popState(); return RIGHT_PAREN;
            } 
            // fall through
          case 185: break;
          case 42: 
            { return STRING_CONTENT;
            } 
            // fall through
          case 186: break;
          case 43: 
            { popState(); return CLOSE_QUOTE;
            } 
            // fall through
          case 187: break;
          case 44: 
            { pushState(BACKQUOTE_COMMAND_SUBSTITUTION); isBackquoteOpen = true; return OPEN_BACKQUOTE;
            } 
            // fall through
          case 188: break;
          case 45: 
            { regexGroups++; return WORD;
            } 
            // fall through
          case 189: break;
          case 46: 
            { if (regexGroups <= 0) { regexGroups = 0; popState(); return RIGHT_PAREN; } else { regexGroups--; return WORD; }
            } 
            // fall through
          case 190: break;
          case 47: 
            { if (regexGroups <= 0 && regexStart != getTokenStart()) { regexStart = -1; popState(); }; return WHITESPACE;
            } 
            // fall through
          case 191: break;
          case 48: 
            { herestringStartPosition=-1; popState(); return LINEFEED;
            } 
            // fall through
          case 192: break;
          case 49: 
            { if (herestringStartPosition != getTokenStart()) { herestringStartPosition=-1; popState(); } return WHITESPACE;
            } 
            // fall through
          case 193: break;
          case 50: 
            { herestringStartPosition=-1; popState(); yypushback(1);
            } 
            // fall through
          case 194: break;
          case 51: 
            { if ((yycharat(yylength()-1) == '\'' || yycharat(yylength()-1) == '"') && yylength() > 2)
                                      heredocMarker = yytext().subSequence(1, yylength()-1).toString();
                                    else heredocMarker = yytext().toString();
                                    heredocMarker = heredocMarker.replaceAll("(\\\\)(.)", "$2");
                                    yybegin(HERE_DOC_PIPELINE);
                                    return HEREDOC_MARKER_START;
            } 
            // fall through
          case 195: break;
          case 52: 
            { if (yytext().toString().equals(heredocMarker))
                                  { heredocMarker = null; heredocWithWhiteSpaceIgnore = false; popState(); return HEREDOC_MARKER_END; }
                                    else { yypushback(yylength()); yybegin(HERE_DOC_BODY); }
            } 
            // fall through
          case 196: break;
          case 53: 
            { yypushback(yylength()); yybegin(HERE_DOC_BODY);
            } 
            // fall through
          case 197: break;
          case 54: 
            { if (!heredocWithWhiteSpaceIgnore) yybegin(HERE_DOC_BODY); return HEREDOC_CONTENT;
            } 
            // fall through
          case 198: break;
          case 55: 
            { yybegin(HERE_DOC_END_MARKER); return LINEFEED;
            } 
            // fall through
          case 199: break;
          case 56: 
            { return HEREDOC_CONTENT;
            } 
            // fall through
          case 200: break;
          case 57: 
            { yybegin(HERE_DOC_END_MARKER); return HEREDOC_CONTENT;
            } 
            // fall through
          case 201: break;
          case 58: 
            { popState(PARAMETER_EXPANSION_WITHOUT_SEPARATOR); return WORD;
            } 
            // fall through
          case 202: break;
          case 59: 
            { popState(PARAMETER_EXPANSION_WITHOUT_SEPARATOR); return LINEFEED;
            } 
            // fall through
          case 203: break;
          case 60: 
            { popState(PARAMETER_EXPANSION_WITHOUT_SEPARATOR); return WHITESPACE;
            } 
            // fall through
          case 204: break;
          case 61: 
            { pushState(PARAMETER_EXPANSION_EXPR); return PARAM_SEPARATOR;
            } 
            // fall through
          case 205: break;
          case 62: 
            { pushState(PARAMETER_EXPANSION_WITHOUT_SEPARATOR); return PARAM_SEPARATOR;
            } 
            // fall through
          case 206: break;
          case 63: 
            { popState(PARAMETER_EXPANSION_WITHOUT_SEPARATOR); return INT;
            } 
            // fall through
          case 207: break;
          case 64: 
            { popState(PARAMETER_EXPANSION_WITHOUT_SEPARATOR); pushState(CONDITIONAL_EXPRESSION); return LEFT_SQUARE;
            } 
            // fall through
          case 208: break;
          case 65: 
            { if (yystate() == PARAMETER_EXPANSION_WITHOUT_SEPARATOR)
                                        { popState(); yypushback(yylength()); }
                                        else { popState(); return RIGHT_CURLY; }
            } 
            // fall through
          case 209: break;
          case 66: 
            { popState(PARAMETER_EXPANSION_WITHOUT_SEPARATOR);             return LEFT_CURLY;
            } 
            // fall through
          case 210: break;
          case 67: 
            { popState(); return WORD;
            } 
            // fall through
          case 211: break;
          case 68: 
            { return VAR;
            } 
            // fall through
          case 212: break;
          case 69: 
            { pushState(PARENTHESES_COMMAND_SUBSTITUTION); yypushback(1); return DOLLAR;
            } 
            // fall through
          case 213: break;
          case 70: 
            { pushState(OLD_ARITHMETIC_EXPRESSION); return ARITH_SQUARE_LEFT;
            } 
            // fall through
          case 214: break;
          case 71: 
            { pushState(PARAMETER_EXPANSION); yypushback(1); return DOLLAR;
            } 
            // fall through
          case 215: break;
          case 72: 
            // lookahead expression with fixed lookahead length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzMarkedPos, -1);
            { return WORD;
            } 
            // fall through
          case 216: break;
          case 73: 
            { return OCTAL;
            } 
            // fall through
          case 217: break;
          case 74: 
            { return PLUS_ASSIGN;
            } 
            // fall through
          case 218: break;
          case 75: 
            { pushState(ARITHMETIC_EXPRESSION); pushParentheses(DOUBLE_PARENTHESES);
                                    return LEFT_DOUBLE_PAREN;
            } 
            // fall through
          case 219: break;
          case 76: 
            { if (shouldCloseDoubleParen()) { popState(); popParentheses(); return RIGHT_DOUBLE_PAREN; }
                                    else if (shouldCloseSingleParen()) {
                                      popState(PARENTHESES_COMMAND_SUBSTITUTION); yypushback(1); popParentheses(); return RIGHT_PAREN;
                                    } else return RIGHT_DOUBLE_PAREN;
            } 
            // fall through
          case 220: break;
          case 77: 
            { pushState(CONDITIONAL_EXPRESSION); return LEFT_DOUBLE_BRACKET;
            } 
            // fall through
          case 221: break;
          case 78: 
            { popState(CONDITIONAL_EXPRESSION); return RIGHT_DOUBLE_BRACKET;
            } 
            // fall through
          case 222: break;
          case 79: 
            { return OR_OR;
            } 
            // fall through
          case 223: break;
          case 80: 
            { return PIPE_AMP;
            } 
            // fall through
          case 224: break;
          case 81: 
            { return FILEDESCRIPTOR;
            } 
            // fall through
          case 225: break;
          case 82: 
            { return AND_AND;
            } 
            // fall through
          case 226: break;
          case 83: 
            { return REDIRECT_AMP_GREATER;
            } 
            // fall through
          case 227: break;
          case 84: 
            { return OUTPUT_PROCESS_SUBSTITUTION;
            } 
            // fall through
          case 228: break;
          case 85: 
            { return REDIRECT_GREATER_BAR;
            } 
            // fall through
          case 229: break;
          case 86: 
            { return REDIRECT_GREATER_AMP;
            } 
            // fall through
          case 230: break;
          case 87: 
            { return SHIFT_RIGHT;
            } 
            // fall through
          case 231: break;
          case 88: 
            { return INPUT_PROCESS_SUBSTITUTION;
            } 
            // fall through
          case 232: break;
          case 89: 
            { return REDIRECT_LESS_AMP;
            } 
            // fall through
          case 233: break;
          case 90: 
            { return REDIRECT_LESS_GREATER;
            } 
            // fall through
          case 234: break;
          case 91: 
            { if (yystate() != HERE_DOC_PIPELINE)
                                    { pushState(HERE_DOC_START_MARKER); return HEREDOC_MARKER_TAG; }
                                    else return SHIFT_LEFT;
            } 
            // fall through
          case 235: break;
          case 92: 
            { return IN;
            } 
            // fall through
          case 236: break;
          case 93: 
            { pushState(IF_CONDITION); return IF;
            } 
            // fall through
          case 237: break;
          case 94: 
            { return DO;
            } 
            // fall through
          case 238: break;
          case 95: 
            { popState(IF_CONDITION); return FI;
            } 
            // fall through
          case 239: break;
          case 96: 
            { if (getTokenStart() == 0) return SHEBANG; else return COMMENT;
            } 
            // fall through
          case 240: break;
          case 97: 
            { return NE;
            } 
            // fall through
          case 241: break;
          case 98: 
            { return MINUS_MINUS;
            } 
            // fall through
          case 242: break;
          case 99: 
            { return MINUS_ASSIGN;
            } 
            // fall through
          case 243: break;
          case 100: 
            { return EXPONENT;
            } 
            // fall through
          case 244: break;
          case 101: 
            { return MULT_ASSIGN;
            } 
            // fall through
          case 245: break;
          case 102: 
            { return PLUS_PLUS;
            } 
            // fall through
          case 246: break;
          case 103: 
            { return BIT_OR_ASSIGN;
            } 
            // fall through
          case 247: break;
          case 104: 
            { return BIT_AND_ASSIGN;
            } 
            // fall through
          case 248: break;
          case 105: 
            { return EQ;
            } 
            // fall through
          case 249: break;
          case 106: 
            { return DIV_ASSIGN;
            } 
            // fall through
          case 250: break;
          case 107: 
            { return BIT_XOR_ASSIGN;
            } 
            // fall through
          case 251: break;
          case 108: 
            { return GE;
            } 
            // fall through
          case 252: break;
          case 109: 
            { return MOD_ASSIGN;
            } 
            // fall through
          case 253: break;
          case 110: 
            { return LE;
            } 
            // fall through
          case 254: break;
          case 111: 
            { return SHIFT_LEFT;
            } 
            // fall through
          case 255: break;
          case 112: 
            { if (isArithmeticExpansion) { pushState(ARITHMETIC_EXPRESSION);
                                       pushParentheses(DOUBLE_PARENTHESES); isArithmeticExpansion = false; return LEFT_DOUBLE_PAREN; }
                                   else return STRING_CONTENT;
            } 
            // fall through
          case 256: break;
          case 113: 
            { regexStart = getTokenEnd(); regexGroups = 0; pushState(REGULAR_EXPRESSION); return REGEXP;
            } 
            // fall through
          case 257: break;
          case 114: 
            { pushState(CASE_PATTERN);    return CASE_END;
            } 
            // fall through
          case 258: break;
          case 115: 
            { if (yystate() == CASE_CONDITION) {pushState(CASE_PATTERN); return IN; } else return WORD;
            } 
            // fall through
          case 259: break;
          case 116: 
            { if (isArithmeticExpansion) { pushState(ARITHMETIC_EXPRESSION);
                                       pushParentheses(DOUBLE_PARENTHESES); isArithmeticExpansion = false; return LEFT_DOUBLE_PAREN; }
                                    else { yypushback(1); regexGroups++; return WORD; }
            } 
            // fall through
          case 260: break;
          case 117: 
            { popState(PARAMETER_EXPANSION_WITHOUT_SEPARATOR); return OCTAL;
            } 
            // fall through
          case 261: break;
          case 118: 
            { popState(PARAMETER_EXPANSION_WITHOUT_SEPARATOR);
                                       if (isArithmeticExpansion) { pushState(ARITHMETIC_EXPRESSION);
                                          pushParentheses(DOUBLE_PARENTHESES); isArithmeticExpansion = false; return LEFT_DOUBLE_PAREN; }
                                      else return WORD;
            } 
            // fall through
          case 262: break;
          case 119: 
            { popState(PARAMETER_EXPANSION_WITHOUT_SEPARATOR); pushState(CONDITIONAL_EXPRESSION); return LEFT_DOUBLE_BRACKET;
            } 
            // fall through
          case 263: break;
          case 120: 
            { yypushback(2); return DOLLAR;
            } 
            // fall through
          case 264: break;
          case 121: 
            // lookahead expression with fixed lookahead length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzMarkedPos, -2);
            { return WORD;
            } 
            // fall through
          case 265: break;
          case 122: 
            { return HEX;
            } 
            // fall through
          case 266: break;
          case 123: 
            { return REDIRECT_AMP_GREATER_GREATER;
            } 
            // fall through
          case 267: break;
          case 124: 
            { pushState(LET_EXPRESSION); return LET;
            } 
            // fall through
          case 268: break;
          case 125: 
            { if (yystate() != HERE_DOC_PIPELINE)
                                    { pushState(HERE_DOC_START_MARKER); heredocWithWhiteSpaceIgnore = true; return HEREDOC_MARKER_TAG; }
                                    else return SHIFT_LEFT;
            } 
            // fall through
          case 269: break;
          case 126: 
            { herestringStartPosition = getTokenEnd(); pushState(HERE_STRING); return REDIRECT_HERE_STRING;
            } 
            // fall through
          case 270: break;
          case 127: 
            { pushState(OTHER_CONDITIONS); return FOR;
            } 
            // fall through
          case 271: break;
          case 128: 
            { return SHIFT_RIGHT_ASSIGN;
            } 
            // fall through
          case 272: break;
          case 129: 
            { return SHIFT_LEFT_ASSIGN;
            } 
            // fall through
          case 273: break;
          case 130: 
            { return LET;
            } 
            // fall through
          case 274: break;
          case 131: 
            { isArithmeticExpansion = true; yypushback(2); return DOLLAR;
            } 
            // fall through
          case 275: break;
          case 132: 
            { popState(PARAMETER_EXPANSION_WITHOUT_SEPARATOR); return HEX;
            } 
            // fall through
          case 276: break;
          case 133: 
            { return ELIF;
            } 
            // fall through
          case 277: break;
          case 134: 
            { return ELSE;
            } 
            // fall through
          case 278: break;
          case 135: 
            { popState(CASE_CONDITION); return ESAC;
            } 
            // fall through
          case 279: break;
          case 136: 
            { pushState(EVAL_EXPRESSION); return EVAL;
            } 
            // fall through
          case 280: break;
          case 137: 
            { pushState(TEST_EXPRESSION); return TEST;
            } 
            // fall through
          case 281: break;
          case 138: 
            { return THEN;
            } 
            // fall through
          case 282: break;
          case 139: 
            { pushState(CASE_CONDITION); return CASE;
            } 
            // fall through
          case 283: break;
          case 140: 
            { popState(OTHER_CONDITIONS); return DONE;
            } 
            // fall through
          case 284: break;
          case 141: 
            { pushState(OTHER_CONDITIONS); return UNTIL;
            } 
            // fall through
          case 285: break;
          case 142: 
            { pushState(OTHER_CONDITIONS); return WHILE;
            } 
            // fall through
          case 286: break;
          case 143: 
            { pushState(OTHER_CONDITIONS); return SELECT;
            } 
            // fall through
          case 287: break;
          case 144: 
            { return FUNCTION;
            } 
            // fall through
          case 288: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
