// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.sh.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.sh.ShFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShResolveScopeProvider extends ResolveScopeProvider {
  @Override
  public @Nullable GlobalSearchScope getResolveScope(@NotNull VirtualFile file, Project project) {
    if (file.getFileType() instanceof ShFileType) {
      return GlobalSearchScope.fileScope(project, file);
    }
    return null;
  }
}