/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.ui.components;

import com.intellij.ide.IdeBundle;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import org.jetbrains.annotations.NotNull;

import javax.swing.*;
import java.awt.*;

public class JBPasswordField extends JPasswordField implements ComponentWithEmptyText {
  private final TextComponentEmptyText myEmptyText;

  public JBPasswordField() {
    myEmptyText = new TextComponentEmptyText(this);
  }

  @Override
  protected void paintComponent(Graphics g) {
    super.paintComponent(g);
    myEmptyText.paintStatusText(g);
  }

  @NotNull
  @Override
  public StatusText getEmptyText() {
    return myEmptyText;
  }

  public void setPasswordIsStored(boolean stored) {
    if (stored) {
      myEmptyText.setText(IdeBundle.message("text.password.hidden"), SimpleTextAttributes.GRAY_ATTRIBUTES);
    }
    else {
      myEmptyText.clear();
    }
  }
}
