// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.xdebugger.impl.inline;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import org.jetbrains.annotations.NotNull;

final class AddInlineWatchAction extends XDebuggerActionBase {

  AddInlineWatchAction() {
    super(true);
  }

  @NotNull
  @Override
  protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
    return debuggerSupport.getAddToInlineWatchesActionHandler();
  }

  @Override
  public void actionPerformed(@NotNull AnActionEvent event) {
    super.actionPerformed(event);
  }
}
