/*
 * Copyright 2003-2020 Dave Griffith, Bas Leijdekkers
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.*;
import org.jetbrains.annotations.NotNull;

class NCSSVisitor extends JavaRecursiveElementWalkingVisitor {
  private int m_statementCount;

  @Override
  public void visitClass(PsiClass aClass) {
    // no call to super, to keep this from drilling down
  }

  @Override
  public void visitStatement(@NotNull PsiStatement statement) {
    super.visitStatement(statement);
    if (statement instanceof PsiEmptyStatement ||
        statement instanceof PsiBlockStatement) {
      return;
    }
    final PsiElement parent = statement.getParent();
    if (parent instanceof PsiForStatement) {
      final PsiForStatement forStatement = (PsiForStatement)parent;
      if (forStatement.getInitialization() == statement || forStatement.getUpdate() == statement) {
        return;
      }
    }
    m_statementCount++;
  }

  int getStatementCount() {
    return m_statementCount;
  }
}
