/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package git4idea.rebase;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public enum GitRebaseResumeMode {
  CONTINUE("--continue"),
  SKIP("--skip");

  @NotNull private final String myCommandLineArgument;

  GitRebaseResumeMode(@NotNull @NonNls String argument) {
    myCommandLineArgument = argument;
  }

  @NonNls
  @NotNull
  public String asCommandLineArgument() {
    return myCommandLineArgument;
  }
}
