/*
 * Copyright 2000-2009 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package git4idea.update

import com.intellij.openapi.ui.DialogPanel
import com.intellij.ui.layout.*
import com.intellij.util.ui.JBUI
import git4idea.config.GitVcsSettings
import git4idea.config.UpdateMethod

internal class GitUpdateOptionsPanel(private val settings: GitVcsSettings) {
  val panel = createPanel()

  private fun createPanel(): DialogPanel = panel {
    row {
      updateMethodButtonGroup(
        get = { settings.updateMethod },
        set = { settings.updateMethod = it }
      )
    }
  }.withBorder(JBUI.Borders.empty(16, 5, 0, 5))

  fun isModified(): Boolean = panel.isModified()

  fun applyTo() = panel.apply()

  fun updateFrom() = panel.reset()
}

private fun LayoutBuilder.updateMethodButtonGroup(get: () -> UpdateMethod, set: (UpdateMethod) -> Unit) =
  buttonGroup(get, set) {
    getUpdateMethods().forEach { method ->
      row {
        radioButton(method.presentation).bindValue(method)
      }
    }
  }

internal fun getUpdateMethods(): List<UpdateMethod> = listOf(UpdateMethod.MERGE, UpdateMethod.REBASE)