// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package icons;

import com.intellij.ui.IconManager;
import org.jetbrains.annotations.NotNull;

import javax.swing.*;

/**
 * NOTE THIS FILE IS AUTO-GENERATED
 * DO NOT EDIT IT BY HAND, run "Generate icon classes" configuration instead
 */
public final class StudioIcons {
  private static @NotNull Icon load(@NotNull String path, long cacheKey, int flags) {
    return IconManager.getInstance().loadRasterizedIcon(path, StudioIcons.class.getClassLoader(), cacheKey, flags);
  }

  public static final class Avd {
    /** 32x32 */ public static final @NotNull Icon DEVICE_AUTOMOTIVE_LARGE = load("studio/icons/avd/device-automotive-large.svg", -3994201804260195336L, 2);
    /** 16x16 */ public static final @NotNull Icon DEVICE_AUTOMOTIVE = load("studio/icons/avd/device-automotive.svg", 4302025736479087782L, 2);
    /** 32x32 */ public static final @NotNull Icon DEVICE_CAR_LARGE = load("studio/icons/avd/device-car-large.svg", 6521100181124681011L, 2);
    /** 16x16 */ public static final @NotNull Icon DEVICE_CAR = load("studio/icons/avd/device-car.svg", -952084969727350864L, 2);
    /** 32x32 */ public static final @NotNull Icon DEVICE_GLASS_LARGE = load("studio/icons/avd/device-glass-large.svg", 2669903690582636887L, 2);
    /** 16x16 */ public static final @NotNull Icon DEVICE_GLASS = load("studio/icons/avd/device-glass.svg", 7993860056391207918L, 2);
    /** 32x32 */ public static final @NotNull Icon DEVICE_MOBILE_LARGE = load("studio/icons/avd/device-mobile-large.svg", 7809347405285447853L, 2);
    /** 16x16 */ public static final @NotNull Icon DEVICE_MOBILE = load("studio/icons/avd/device-mobile.svg", -1387649431230459639L, 2);
    /** 16x16 */ public static final @NotNull Icon DEVICE_PHONE = load("studio/icons/avd/device-phone.svg", 3959314490228129597L, 2);
    /** 16x16 */ public static final @NotNull Icon DEVICE_PLAY_STORE = load("studio/icons/avd/device-play-store.svg", 8317211153904123730L, 2);
    /** 16x16 */ public static final @NotNull Icon DEVICE_TABLET = load("studio/icons/avd/device-tablet.svg", 6790884150577066996L, 2);
    /** 32x32 */ public static final @NotNull Icon DEVICE_TV_LARGE = load("studio/icons/avd/device-tv-large.svg", 7497733483021271074L, 2);
    /** 16x16 */ public static final @NotNull Icon DEVICE_TV = load("studio/icons/avd/device-tv.svg", 1395706001679939973L, 2);
    /** 32x32 */ public static final @NotNull Icon DEVICE_WEAR_LARGE = load("studio/icons/avd/device-wear-large.svg", 5154184304520803299L, 2);
    /** 16x16 */ public static final @NotNull Icon DEVICE_WEAR = load("studio/icons/avd/device-wear.svg", -9021429282010024437L, 2);
    /** 16x16 */ public static final @NotNull Icon EDIT = load("studio/icons/avd/edit.svg", 8065545716025973114L, 2);
    /** 48x48 */ public static final @NotNull Icon LANDSCAPE = load("studio/icons/avd/landscape.svg", 3433207017311288279L, 2);
    /** 16x16 */ public static final @NotNull Icon PAIR_OVER_WIFI = load("studio/icons/avd/pair-over-wifi.svg", 2351889585726561684L, 2);
    /** 48x48 */ public static final @NotNull Icon PORTRAIT = load("studio/icons/avd/portrait.svg", -32661621270585747L, 2);
    /** 16x16 */ public static final @NotNull Icon RUN = load("studio/icons/avd/run.svg", 315030659650671846L, 2);
  }

  public static final class Common {
    /** 16x16 */ public static final @NotNull Icon ADD = load("studio/icons/common/add.svg", -5842594557581562518L, 2);
    /** 16x16 */ public static final @NotNull Icon BACK_ARROW = load("studio/icons/common/back-arrow.svg", -2431193017155721390L, 2);
    /** 16x16 */ public static final @NotNull Icon CHECKED = load("studio/icons/common/checked.svg", 4341271407904996268L, 2);
    /** 16x16 */ public static final @NotNull Icon CLEAR = load("studio/icons/common/clear.svg", 8826341959605631227L, 2);
    /** 16x16 */ public static final @NotNull Icon CLOSE = load("studio/icons/common/close.svg", -6338346790573684173L, 2);
    /** 16x16 */ public static final @NotNull Icon CROP = load("studio/icons/common/crop.svg", -3917679422024857618L, 2);
    /** 16x16 */ public static final @NotNull Icon DELETE = load("studio/icons/common/delete.svg", 1522865553512510659L, 2);
    /** 16x16 */ public static final @NotNull Icon EDIT = load("studio/icons/common/edit.svg", 8065545716025973114L, 2);
    /** 16x16 */ public static final @NotNull Icon ERROR_INLINE_SELECTED = load("studio/icons/common/error-inline-selected.svg", 4437192581179819370L, 0);
    /** 16x16 */ public static final @NotNull Icon ERROR_INLINE = load("studio/icons/common/error-inline.svg", -7132467363886437547L, 2);
    /** 16x16 */ public static final @NotNull Icon ERROR = load("studio/icons/common/error.svg", 6733530542263358807L, 2);
    /** 16x16 */ public static final @NotNull Icon EXPORT = load("studio/icons/common/export.svg", -700001593099746811L, 2);
    /** 16x16 */ public static final @NotNull Icon FILTER = load("studio/icons/common/filter.svg", 6511190735926504880L, 2);
    /** 16x16 */ public static final @NotNull Icon GRID_VIEW = load("studio/icons/common/grid-view.svg", 2238347048025890422L, 2);
    /** 16x16 */ public static final @NotNull Icon HELP = load("studio/icons/common/help.svg", -3013982107611186494L, 2);
    /** 16x16 */ public static final @NotNull Icon IMPORT_DATA = load("studio/icons/common/import-data.svg", -5924640987553050241L, 2);
    /** 16x16 */ public static final @NotNull Icon INFO_INLINE_SELECTED = load("studio/icons/common/info-inline-selected.svg", -3056609109802351975L, 0);
    /** 16x16 */ public static final @NotNull Icon INFO_INLINE = load("studio/icons/common/info-inline.svg", -4158930680824995951L, 2);
    /** 16x16 */ public static final @NotNull Icon INFO = load("studio/icons/common/info.svg", 8495695035745937620L, 2);
    /** 16x16 */ public static final @NotNull Icon LINK = load("studio/icons/common/link.svg", -8313849774111557345L, 2);
    /** 16x16 */ public static final @NotNull Icon LIST_VIEW = load("studio/icons/common/list-view.svg", -5302439726526809026L, 2);
    /** 16x16 */ public static final @NotNull Icon LOCKED_INLINE_SELECTED = load("studio/icons/common/locked-inline-selected.svg", 1325896476061850431L, 0);
    /** 16x16 */ public static final @NotNull Icon LOCKED_INLINE = load("studio/icons/common/locked-inline.svg", 1694852065049977839L, 2);
    /** 16x16 */ public static final @NotNull Icon MISSING = load("studio/icons/common/missing.svg", 8071394755737518859L, 2);
    /** 14x14 */ public static final @NotNull Icon MOVE_DOWN_SELECTED = load("studio/icons/common/move-down-selected.svg", -8239736696896587213L, 0);
    /** 16x16 */ public static final @NotNull Icon OVERFLOW = load("studio/icons/common/overflow.svg", -3549540369308872295L, 2);
    /** 14x24 */ public static final @NotNull Icon PROPERTY_BOUND_FOCUS_LARGE = load("studio/icons/common/property-bound-focus-large.svg", 4257872407146859556L, 2);
    /** 14x20 */ public static final @NotNull Icon PROPERTY_BOUND_FOCUS = load("studio/icons/common/property-bound-focus.svg", -7573892047265407138L, 2);
    /** 14x24 */ public static final @NotNull Icon PROPERTY_BOUND_LARGE = load("studio/icons/common/property-bound-large.svg", 5076559568113919184L, 2);
    /** 14x20 */ public static final @NotNull Icon PROPERTY_BOUND = load("studio/icons/common/property-bound.svg", -6241083381785729505L, 2);
    /** 14x24 */ public static final @NotNull Icon PROPERTY_UNBOUND_FOCUS_LARGE = load("studio/icons/common/property-unbound-focus-large.svg", -9083772766717528632L, 2);
    /** 14x20 */ public static final @NotNull Icon PROPERTY_UNBOUND_FOCUS = load("studio/icons/common/property-unbound-focus.svg", -2822239757754754246L, 2);
    /** 14x24 */ public static final @NotNull Icon PROPERTY_UNBOUND_LARGE = load("studio/icons/common/property-unbound-large.svg", -7477728109498458542L, 2);
    /** 14x20 */ public static final @NotNull Icon PROPERTY_UNBOUND = load("studio/icons/common/property-unbound.svg", -210831111548366370L, 2);
    /** 16x16 */ public static final @NotNull Icon REMOVE = load("studio/icons/common/remove.svg", 4372461928027382704L, 2);
    /** 16x16 */ public static final @NotNull Icon REORDER = load("studio/icons/common/reorder.svg", -7736856852583818752L, 2);
    /** 16x16 */ public static final @NotNull Icon RESET_ZOOM = load("studio/icons/common/reset-zoom.svg", 1666443238163380756L, 2);
    /** 16x16 */ public static final @NotNull Icon SEARCH = load("studio/icons/common/search.svg", -7778173973123731297L, 2);
    /** 16x16 */ public static final @NotNull Icon SUCCESS_INLINE_SELECTED = load("studio/icons/common/success-inline-selected.svg", 6301223580303242779L, 0);
    /** 16x16 */ public static final @NotNull Icon SUCCESS_INLINE = load("studio/icons/common/success-inline.svg", -6208394216614807112L, 2);
    /** 16x16 */ public static final @NotNull Icon SUCCESS = load("studio/icons/common/success.svg", -8069711246047991909L, 2);
    /** 16x16 */ public static final @NotNull Icon VISIBILITY_INLINE_SELECTED = load("studio/icons/common/visibility-inline-selected.svg", -5083655685831220308L, 0);
    /** 16x16 */ public static final @NotNull Icon VISIBILITY_INLINE = load("studio/icons/common/visibility-inline.svg", -4273610881501573099L, 2);
    /** 16x16 */ public static final @NotNull Icon WARNING_INLINE_SELECTED = load("studio/icons/common/warning-inline-selected.svg", -6572538731691235073L, 0);
    /** 16x16 */ public static final @NotNull Icon WARNING_INLINE = load("studio/icons/common/warning-inline.svg", -3617112128301786062L, 2);
    /** 16x16 */ public static final @NotNull Icon WARNING = load("studio/icons/common/warning.svg", 5768200555634361770L, 2);
    /** 16x16 */ public static final @NotNull Icon ZOOM_ACTUAL = load("studio/icons/common/zoom-actual.svg", 7480586591505638996L, 2);
    /** 16x16 */ public static final @NotNull Icon ZOOM_IN = load("studio/icons/common/zoom-in.svg", -6578918784525128649L, 2);
    /** 16x16 */ public static final @NotNull Icon ZOOM_OUT = load("studio/icons/common/zoom-out.svg", 3394620307499867198L, 2);
    /** 16x16 */ public static final @NotNull Icon ZOOM_SELECT = load("studio/icons/common/zoom-select.svg", 6591258971795193721L, 2);
  }

  public static final class Compose {
    public static final class Toolbar {
      /** 16x16 */ public static final @NotNull Icon INSPECT_PREVIEW = load("studio/icons/compose/toolbar/inspect-preview.svg", -8866979517567251577L, 2);
      /** 16x16 */ public static final @NotNull Icon INTERACTIVE_PREVIEW = load("studio/icons/compose/toolbar/interactive-preview.svg", 2908023751368337997L, 2);
      /** 16x16 */ public static final @NotNull Icon RUN_CONFIGURATION = load("studio/icons/compose/toolbar/run-configuration.svg", -4705149059809427012L, 2);
      /** 16x16 */ public static final @NotNull Icon RUN_ON_DEVICE = load("studio/icons/compose/toolbar/run-on-device.svg", -4246199315453408769L, 2);
      /** 16x16 */ public static final @NotNull Icon STOP_INTERACTIVE_MODE = load("studio/icons/compose/toolbar/stop-interactive-mode.svg", 7756865492231184894L, 2);
    }
  }

  public static final class Cursors {
    /** 32x32 */ public static final @NotNull Icon EW_RESIZE = load("studio/icons/cursors/ew-resize.svg", -7274134314819400903L, 0);
    /** 32x32 */ public static final @NotNull Icon GRAB = load("studio/icons/cursors/grab.svg", -9148468669517695373L, 0);
    /** 32x32 */ public static final @NotNull Icon GRABBING = load("studio/icons/cursors/grabbing.svg", 2166232782907237413L, 0);
    /** 32x32 */ public static final @NotNull Icon MOVE = load("studio/icons/cursors/move.svg", 6230314801948651984L, 0);
    /** 32x32 */ public static final @NotNull Icon NESW_RESIZE = load("studio/icons/cursors/nesw-resize.svg", -4883929295662796774L, 0);
    /** 32x32 */ public static final @NotNull Icon NS_RESIZE = load("studio/icons/cursors/ns-resize.svg", -929693207884973917L, 0);
    /** 32x32 */ public static final @NotNull Icon NWSE_RESIZE = load("studio/icons/cursors/nwse-resize.svg", -6131249053729294209L, 0);
  }

  public static final class DatabaseInspector {
    /** 16x16 */ public static final @NotNull Icon ALLOW_DATABASES_TO_CLOSE = load("studio/icons/database-inspector/allow-databases-to-close.svg", -2878826733921240516L, 2);
    /** 16x16 */ public static final @NotNull Icon COLUMN = load("studio/icons/database-inspector/column.svg", -6312079522241483030L, 2);
    /** 16x16 */ public static final @NotNull Icon DATABASE_UNAVAILABLE = load("studio/icons/database-inspector/database-unavailable.svg", 2719887641150997051L, 2);
    /** 16x16 */ public static final @NotNull Icon DATABASE = load("studio/icons/database-inspector/database.svg", 7528425474056360240L, 2);
    /** 16x16 */ public static final @NotNull Icon KEEP_DATABASES_OPEN = load("studio/icons/database-inspector/keep-databases-open.svg", 4482561606613357585L, 2);
    /** 16x16 */ public static final @NotNull Icon NEW_QUERY = load("studio/icons/database-inspector/new-query.svg", -9072018179279660705L, 2);
    /** 16x16 */ public static final @NotNull Icon PRIMARY_KEY = load("studio/icons/database-inspector/primary-key.svg", 1535749471447140688L, 2);
    /** 16x16 */ public static final @NotNull Icon SCHEMA = load("studio/icons/database-inspector/schema.svg", 330278769295726122L, 2);
    /** 16x16 */ public static final @NotNull Icon TABLE = load("studio/icons/database-inspector/table.svg", 2036772163276011632L, 2);
    /** 16x16 */ public static final @NotNull Icon VIEW = load("studio/icons/database-inspector/view.svg", 8048825355871657186L, 2);
  }

  public static final class DeviceConfiguration {
    /** 16x16 */ public static final @NotNull Icon COUNTRY_CODE = load("studio/icons/device-configuration/country-code.svg", -6405018790512292857L, 2);
    /** 16x16 */ public static final @NotNull Icon DENSITY = load("studio/icons/device-configuration/density.svg", -8133467874362105311L, 2);
    /** 16x16 */ public static final @NotNull Icon DIMENSION = load("studio/icons/device-configuration/dimension.svg", -2310882805149993447L, 2);
    /** 16x16 */ public static final @NotNull Icon KEYBOARD = load("studio/icons/device-configuration/keyboard.svg", 3218034774343728538L, 2);
    /** 16x16 */ public static final @NotNull Icon LAYOUT_DIRECTION = load("studio/icons/device-configuration/layout-direction.svg", 3314308338284211517L, 2);
    /** 16x16 */ public static final @NotNull Icon LOCALE = load("studio/icons/device-configuration/locale.svg", -872686294861902776L, 2);
    /** 16x16 */ public static final @NotNull Icon NAVIGATION_METHOD = load("studio/icons/device-configuration/navigation-method.svg", -5059625012799929198L, 2);
    /** 16x16 */ public static final @NotNull Icon NAVIGATION_STATE = load("studio/icons/device-configuration/navigation-state.svg", 6279862295584848204L, 2);
    /** 16x16 */ public static final @NotNull Icon NETWORK_CODE = load("studio/icons/device-configuration/network-code.svg", 4336635421333062469L, 2);
    /** 16x16 */ public static final @NotNull Icon NIGHT_MODE = load("studio/icons/device-configuration/night-mode.svg", 6751505044156820646L, 2);
    /** 16x16 */ public static final @NotNull Icon ORIENTATION = load("studio/icons/device-configuration/orientation.svg", -266603419761437456L, 2);
    /** 16x16 */ public static final @NotNull Icon SCREEN_HEIGHT = load("studio/icons/device-configuration/screen-height.svg", 2569230773892227405L, 2);
    /** 16x16 */ public static final @NotNull Icon SCREEN_RATIO = load("studio/icons/device-configuration/screen-ratio.svg", 6946542512286761717L, 2);
    /** 16x16 */ public static final @NotNull Icon SCREEN_SIZE = load("studio/icons/device-configuration/screen-size.svg", -6845702732942800133L, 2);
    /** 16x16 */ public static final @NotNull Icon SCREEN_WIDTH = load("studio/icons/device-configuration/screen-width.svg", -5425388567873380223L, 2);
    /** 16x16 */ public static final @NotNull Icon SMALLEST_SCREEN_SIZE = load("studio/icons/device-configuration/smallest-screen-size.svg", 6726711351710650917L, 2);
    /** 16x16 */ public static final @NotNull Icon TEXT_INPUT = load("studio/icons/device-configuration/text-input.svg", -66845347904350082L, 2);
    /** 16x16 */ public static final @NotNull Icon TOUCH_SCREEN = load("studio/icons/device-configuration/touch-screen.svg", 1247973386033161714L, 2);
    /** 16x16 */ public static final @NotNull Icon UI_MODE = load("studio/icons/device-configuration/ui-mode.svg", 5338107437486759804L, 2);
    /** 16x16 */ public static final @NotNull Icon VERSION = load("studio/icons/device-configuration/version.svg", 1671679741635738722L, 2);
  }

  public static final class DeviceExplorer {
    /** 16x16 */ public static final @NotNull Icon MULTIPLE_DEVICES = load("studio/icons/device-explorer/multiple-devices.svg", -3593204179522301248L, 2);
    /** 16x16 */ public static final @NotNull Icon PHYSICAL_DEVICE_CAR = load("studio/icons/device-explorer/physical-device-car.svg", -6931636442289209384L, 2);
    /** 16x16 */ public static final @NotNull Icon PHYSICAL_DEVICE_PHONE = load("studio/icons/device-explorer/physical-device-phone.svg", -1347063477656651606L, 2);
    /** 16x16 */ public static final @NotNull Icon PHYSICAL_DEVICE_TV = load("studio/icons/device-explorer/physical-device-tv.svg", -7169620100578332532L, 2);
    /** 16x16 */ public static final @NotNull Icon PHYSICAL_DEVICE_WEAR = load("studio/icons/device-explorer/physical-device-wear.svg", -2649296354790427158L, 2);
    /** 16x16 */ public static final @NotNull Icon SD_CARD_FOLDER = load("studio/icons/device-explorer/sd-card-folder.svg", 778821411903294793L, 2);
    /** 16x16 */ public static final @NotNull Icon SHARED_PREFS = load("studio/icons/device-explorer/shared-prefs.svg", -9084733821181438684L, 2);
    /** 16x16 */ public static final @NotNull Icon VIRTUAL_DEVICE_CAR = load("studio/icons/device-explorer/virtual-device-car.svg", -4312854554318447392L, 2);
    /** 16x16 */ public static final @NotNull Icon VIRTUAL_DEVICE_PHONE = load("studio/icons/device-explorer/virtual-device-phone.svg", 7099648329317162992L, 2);
    /** 16x16 */ public static final @NotNull Icon VIRTUAL_DEVICE_TV = load("studio/icons/device-explorer/virtual-device-tv.svg", 1080051559026713304L, 2);
    /** 16x16 */ public static final @NotNull Icon VIRTUAL_DEVICE_WEAR = load("studio/icons/device-explorer/virtual-device-wear.svg", 501701164624475299L, 2);
  }

  public static final class Emulator {
    /** 16x16 */ public static final @NotNull Icon BACK = load("studio/icons/emulator/back.svg", -1546466169780681495L, 2);
    /** 16x16 */ public static final @NotNull Icon HOME = load("studio/icons/emulator/home.svg", 288914013019377833L, 2);
    /** 16x16 */ public static final @NotNull Icon OVERVIEW = load("studio/icons/emulator/overview.svg", -4157638281734804147L, 2);
    /** 16x16 */ public static final @NotNull Icon POWER = load("studio/icons/emulator/power.svg", -8742035670854922281L, 2);
    /** 16x16 */ public static final @NotNull Icon ROTATE_LEFT = load("studio/icons/emulator/rotate-left.svg", -1383391697496108089L, 2);
    /** 16x16 */ public static final @NotNull Icon ROTATE_RIGHT = load("studio/icons/emulator/rotate-right.svg", -1360621185847988217L, 2);
    /** 16x16 */ public static final @NotNull Icon SCREENSHOT = load("studio/icons/emulator/screenshot.svg", 7581640391500159634L, 2);
    /** 16x16 */ public static final @NotNull Icon SNAPSHOTS = load("studio/icons/emulator/snapshots.svg", 1949197866079279313L, 2);
    /** 16x16 */ public static final @NotNull Icon VOLUME_DOWN = load("studio/icons/emulator/volume-down.svg", 4261860009241430545L, 2);
    /** 16x16 */ public static final @NotNull Icon VOLUME_UP = load("studio/icons/emulator/volume-up.svg", 3393021705709540698L, 2);
  }

  public static final class LayoutEditor {
    public static final class Extras {
      /** 24x24 */ public static final @NotNull Icon DOWNLOAD_OVERLAY_LEGACY_LARGE = load("studio/icons/layout-editor/extras/download-overlay-legacy-large.svg", -4603040831505779325L, 2);
      /** 16x16 */ public static final @NotNull Icon DOWNLOAD_OVERLAY_LEGACY = load("studio/icons/layout-editor/extras/download-overlay-legacy.svg", -1306445403753524762L, 2);
      /** 16x16 */ public static final @NotNull Icon PALETTE_DOWNLOAD_SELECTED = load("studio/icons/layout-editor/extras/palette-download-selected.svg", -6520934645100795088L, 0);
      /** 16x16 */ public static final @NotNull Icon PALETTE_DOWNLOAD = load("studio/icons/layout-editor/extras/palette-download.svg", -612403820227949672L, 2);
      /** 24x24 */ public static final @NotNull Icon PIPETTE_LARGE = load("studio/icons/layout-editor/extras/pipette-large.svg", 6592678781647011964L, 2);
      /** 16x16 */ public static final @NotNull Icon PIPETTE = load("studio/icons/layout-editor/extras/pipette.svg", -3615772689540665999L, 2);
      /** 16x16 */ public static final @NotNull Icon ROOT_INLINE_SELECTED = load("studio/icons/layout-editor/extras/root-inline-selected.svg", 8041655775354480310L, 0);
      /** 16x16 */ public static final @NotNull Icon ROOT_INLINE = load("studio/icons/layout-editor/extras/root-inline.svg", -5308230700314429004L, 2);
      /** 16x16 */ public static final @NotNull Icon VISIBILITY_GONE_INLINE_SELECTED = load("studio/icons/layout-editor/extras/visibility-gone-inline-selected.svg", -6137761646880356395L, 0);
      /** 16x16 */ public static final @NotNull Icon VISIBILITY_GONE_INLINE = load("studio/icons/layout-editor/extras/visibility-gone-inline.svg", -1692230448983267686L, 2);
    }

    public static final class Menu {
      /** 16x16 */ public static final @NotNull Icon CAST = load("studio/icons/layout-editor/menu/cast.svg", 7942599325197794817L, 2);
      /** 16x16 */ public static final @NotNull Icon GROUP = load("studio/icons/layout-editor/menu/group.svg", 3261162986806787205L, 2);
      /** 16x16 */ public static final @NotNull Icon ITEM = load("studio/icons/layout-editor/menu/item.svg", -5356719346008934769L, 2);
      /** 16x16 */ public static final @NotNull Icon MENU = load("studio/icons/layout-editor/menu/menu.svg", 8162758691992467150L, 2);
      /** 16x16 */ public static final @NotNull Icon SEARCH = load("studio/icons/layout-editor/menu/search.svg", -1880493903304901736L, 2);
      /** 16x16 */ public static final @NotNull Icon SWITCH = load("studio/icons/layout-editor/menu/switch.svg", -4633855078210083207L, 2);
    }

    public static final class Motion {
      /** 16x16 */ public static final @NotNull Icon ADD_CONSTRAINT_SET = load("studio/icons/layout-editor/motion/add-constraint-set.svg", 1567504458105428602L, 2);
      /** 16x16 */ public static final @NotNull Icon ADD_GESTURE = load("studio/icons/layout-editor/motion/add-gesture.svg", 1568861149773526106L, 2);
      /** 16x16 */ public static final @NotNull Icon ADD_KEYFRAME = load("studio/icons/layout-editor/motion/add-keyframe.svg", 4944557387156951463L, 2);
      /** 16x16 */ public static final @NotNull Icon ADD_TRANSITION = load("studio/icons/layout-editor/motion/add-transition.svg", 9194071676050025678L, 2);
      /** 16x16 */ public static final @NotNull Icon BASE_LAYOUT = load("studio/icons/layout-editor/motion/base-layout.svg", 6994449884104825233L, 2);
      /** 16x16 */ public static final @NotNull Icon CONSTRAINT_SET = load("studio/icons/layout-editor/motion/constraint-set.svg", -4968154309653337853L, 2);
      /** 16x16 */ public static final @NotNull Icon END_CONSTRAINT_SELECTED = load("studio/icons/layout-editor/motion/end-constraint-selected.svg", -1493946427617841283L, 2);
      /** 16x16 */ public static final @NotNull Icon END_CONSTRAINT = load("studio/icons/layout-editor/motion/end-constraint.svg", 8951938763455934820L, 2);
      /** 16x16 */ public static final @NotNull Icon GESTURE = load("studio/icons/layout-editor/motion/gesture.svg", -5279209786580355472L, 2);
      /** 16x16 */ public static final @NotNull Icon GO_TO_END = load("studio/icons/layout-editor/motion/go-to-end.svg", -1042515831673610218L, 2);
      /** 16x16 */ public static final @NotNull Icon GO_TO_START = load("studio/icons/layout-editor/motion/go-to-start.svg", 7856290473481422013L, 2);
      /** 16x16 */ public static final @NotNull Icon KEYFRAME = load("studio/icons/layout-editor/motion/keyframe.svg", -6271788614706262465L, 2);
      /** 16x16 */ public static final @NotNull Icon LOOP = load("studio/icons/layout-editor/motion/loop.svg", -7305645440425086976L, 2);
      /** 16x16 */ public static final @NotNull Icon MAX_SCALE = load("studio/icons/layout-editor/motion/max-scale.svg", 2288195273702650142L, 2);
      /** 16x16 */ public static final @NotNull Icon MIN_SCALE = load("studio/icons/layout-editor/motion/min-scale.svg", -6561843062356095799L, 2);
      /** 16x16 */ public static final @NotNull Icon MOTION_LAYOUT = load("studio/icons/layout-editor/motion/motion-layout.svg", 1394878088952081381L, 2);
      /** 16x16 */ public static final @NotNull Icon NEXT_TICK = load("studio/icons/layout-editor/motion/next-tick.svg", 7769153742645846110L, 2);
      /** 16x16 */ public static final @NotNull Icon PAUSE = load("studio/icons/layout-editor/motion/pause.svg", -8489643897206833400L, 2);
      /** 16x16 */ public static final @NotNull Icon PLAY_BACKWARD = load("studio/icons/layout-editor/motion/play-backward.svg", -6082792465141957556L, 2);
      /** 16x16 */ public static final @NotNull Icon PLAY_FORWARD = load("studio/icons/layout-editor/motion/play-forward.svg", 1797737590574914341L, 2);
      /** 16x16 */ public static final @NotNull Icon PLAY_YOYO = load("studio/icons/layout-editor/motion/play-yoyo.svg", 3949521846391977572L, 2);
      /** 16x16 */ public static final @NotNull Icon PLAY = load("studio/icons/layout-editor/motion/play.svg", -513511394561550052L, 2);
      /** 16x16 */ public static final @NotNull Icon PREVIOUS_TICK = load("studio/icons/layout-editor/motion/previous-tick.svg", 4742324462102535933L, 2);
      /** 16x16 */ public static final @NotNull Icon SLOW_MOTION = load("studio/icons/layout-editor/motion/slow-motion.svg", 6079676395018086399L, 2);
      /** 16x16 */ public static final @NotNull Icon START_CONSTRAINT = load("studio/icons/layout-editor/motion/start-constraint.svg", 2857951727402611634L, 2);
      /** 16x16 */ public static final @NotNull Icon TIMELINE_ADD = load("studio/icons/layout-editor/motion/timeline-add.svg", -6195456658474349080L, 2);
      /** 16x16 */ public static final @NotNull Icon TIMELINE_END_CONSTRAINT = load("studio/icons/layout-editor/motion/timeline-end-constraint.svg", -4094566725048345511L, 2);
      /** 16x16 */ public static final @NotNull Icon TIMELINE_KEYFRAME_HEADER = load("studio/icons/layout-editor/motion/timeline-keyframe-header.svg", 1090056128385010394L, 2);
      /** 16x16 */ public static final @NotNull Icon TIMELINE_KEYFRAME_SELECTED = load("studio/icons/layout-editor/motion/timeline-keyframe-selected.svg", 6183783743253607033L, 2);
      /** 16x16 */ public static final @NotNull Icon TIMELINE_KEYFRAME = load("studio/icons/layout-editor/motion/timeline-keyframe.svg", -3384598763945928609L, 2);
      /** 16x16 */ public static final @NotNull Icon TIMELINE_START_CONSTRAINT_SELECTED = load("studio/icons/layout-editor/motion/timeline-start-constraint-selected.svg", -6791510278291170176L, 2);
      /** 16x16 */ public static final @NotNull Icon TIMELINE_START_CONSTRAINT = load("studio/icons/layout-editor/motion/timeline-start-constraint.svg", -2481885075206972812L, 2);
      /** 16x16 */ public static final @NotNull Icon TRANSITION = load("studio/icons/layout-editor/motion/transition.svg", -8140059623289253739L, 2);
    }

    public static final class Palette {
      /** 16x16 */ public static final @NotNull Icon AD_VIEW = load("studio/icons/layout-editor/palette/ad-view.svg", 6985153561687911773L, 2);
      /** 16x16 */ public static final @NotNull Icon ADAPTER_VIEW_FLIPPER = load("studio/icons/layout-editor/palette/adapter-view-flipper.svg", -3708434585428073372L, 2);
      /** 16x16 */ public static final @NotNull Icon ANALOG_CLOCK = load("studio/icons/layout-editor/palette/analog-clock.svg", -7627104223780705062L, 2);
      /** 16x16 */ public static final @NotNull Icon APP_BAR_LAYOUT = load("studio/icons/layout-editor/palette/app-bar-layout.svg", -6877987480147181777L, 2);
      /** 16x16 */ public static final @NotNull Icon AUTO_COMPLETE_TEXT_VIEW = load("studio/icons/layout-editor/palette/auto-complete-text-view.svg", 4504061102649265668L, 2);
      /** 16x16 */ public static final @NotNull Icon BARRIER_HORIZONTAL = load("studio/icons/layout-editor/palette/barrier-horizontal.svg", -3922903140068074083L, 2);
      /** 16x16 */ public static final @NotNull Icon BARRIER_VERTICAL = load("studio/icons/layout-editor/palette/barrier-vertical.svg", 9093704535793285986L, 2);
      /** 16x16 */ public static final @NotNull Icon BOTTOM_APP_BAR = load("studio/icons/layout-editor/palette/bottom-app-bar.svg", -4644310155928528024L, 2);
      /** 16x16 */ public static final @NotNull Icon BOTTOM_NAVIGATION_VIEW = load("studio/icons/layout-editor/palette/bottom-navigation-view.svg", 6016110949000037987L, 2);
      /** 16x16 */ public static final @NotNull Icon BUTTON = load("studio/icons/layout-editor/palette/button.svg", 989211856997864851L, 2);
      /** 16x16 */ public static final @NotNull Icon CALENDAR_VIEW = load("studio/icons/layout-editor/palette/calendar-view.svg", 3233619517858323525L, 2);
      /** 16x16 */ public static final @NotNull Icon CARD_VIEW = load("studio/icons/layout-editor/palette/card-view.svg", -5706755308277792629L, 2);
      /** 16x16 */ public static final @NotNull Icon CHECK_BOX = load("studio/icons/layout-editor/palette/check-box.svg", -7773009585063550849L, 2);
      /** 16x16 */ public static final @NotNull Icon CHECKED_TEXT_VIEW = load("studio/icons/layout-editor/palette/checked-text-view.svg", -3453248790321737453L, 2);
      /** 16x16 */ public static final @NotNull Icon CHIP_GROUP = load("studio/icons/layout-editor/palette/chip-group.svg", -1481517432572184952L, 2);
      /** 16x16 */ public static final @NotNull Icon CHIP = load("studio/icons/layout-editor/palette/chip.svg", -4941608104388700908L, 2);
      /** 16x16 */ public static final @NotNull Icon CHRONOMETER = load("studio/icons/layout-editor/palette/chronometer.svg", 8243051018061211731L, 2);
      /** 16x16 */ public static final @NotNull Icon COLLAPSING_TOOLBAR_LAYOUT = load("studio/icons/layout-editor/palette/collapsing-toolbar-layout.svg", 4787201477063662472L, 2);
      /** 16x16 */ public static final @NotNull Icon CONSTRAINT_HELPER = load("studio/icons/layout-editor/palette/constraint-helper.svg", -4305800611766420471L, 2);
      /** 16x16 */ public static final @NotNull Icon CONSTRAINT_LAYOUT = load("studio/icons/layout-editor/palette/constraint-layout.svg", 5963934262045894713L, 2);
      /** 16x16 */ public static final @NotNull Icon CONSTRAINT_SET = load("studio/icons/layout-editor/palette/constraint-set.svg", 6873313167521175796L, 2);
      /** 16x16 */ public static final @NotNull Icon COORDINATOR_LAYOUT = load("studio/icons/layout-editor/palette/coordinator-layout.svg", 911398816178186742L, 2);
      /** 16x16 */ public static final @NotNull Icon CUSTOM_VIEW = load("studio/icons/layout-editor/palette/custom-view.svg", -436978900731330151L, 2);
      /** 16x16 */ public static final @NotNull Icon DATE_PICKER = load("studio/icons/layout-editor/palette/date-picker.svg", -617053677999883207L, 2);
      /** 16x16 */ public static final @NotNull Icon DATE_TEXTFIELD = load("studio/icons/layout-editor/palette/date-textfield.svg", 4152958106461394950L, 2);
      /** 16x16 */ public static final @NotNull Icon EDIT_TEXT = load("studio/icons/layout-editor/palette/edit-text.svg", 1666615653723058894L, 2);
      /** 16x16 */ public static final @NotNull Icon EMAIL_TEXTFIELD = load("studio/icons/layout-editor/palette/email-textfield.svg", -1019577083150318540L, 2);
      /** 16x16 */ public static final @NotNull Icon EXPANDABLE_LIST_VIEW = load("studio/icons/layout-editor/palette/expandable-list-view.svg", -5881027217151464233L, 2);
      /** 16x16 */ public static final @NotNull Icon FLOATING_ACTION_BUTTON = load("studio/icons/layout-editor/palette/floating-action-button.svg", 8918505131547156851L, 2);
      /** 16x16 */ public static final @NotNull Icon FLOW = load("studio/icons/layout-editor/palette/flow.svg", -7665229953750309665L, 2);
      /** 16x16 */ public static final @NotNull Icon FRAGMENT = load("studio/icons/layout-editor/palette/fragment.svg", 2346336933603461169L, 2);
      /** 16x16 */ public static final @NotNull Icon FRAME_LAYOUT = load("studio/icons/layout-editor/palette/frame-layout.svg", 5992393544716573794L, 2);
      /** 16x16 */ public static final @NotNull Icon GRID_LAYOUT_COMPAT = load("studio/icons/layout-editor/palette/grid-layout-compat.svg", 752798772573529228L, 2);
      /** 16x16 */ public static final @NotNull Icon GRID_LAYOUT = load("studio/icons/layout-editor/palette/grid-layout.svg", -5119225601969987737L, 2);
      /** 16x16 */ public static final @NotNull Icon GRID_VIEW = load("studio/icons/layout-editor/palette/grid-view.svg", 2530286576436767715L, 2);
      /** 16x16 */ public static final @NotNull Icon GROUP = load("studio/icons/layout-editor/palette/group.svg", 3025642651059612187L, 2);
      /** 16x16 */ public static final @NotNull Icon GUIDELINE_HORIZONTAL = load("studio/icons/layout-editor/palette/guideline-horizontal.svg", -3384159110986122177L, 2);
      /** 16x16 */ public static final @NotNull Icon GUIDELINE_VERTICAL = load("studio/icons/layout-editor/palette/guideline-vertical.svg", -6425905690818287286L, 2);
      /** 16x16 */ public static final @NotNull Icon HORIZONTAL_DIVIDER = load("studio/icons/layout-editor/palette/horizontal-divider.svg", 7643645923617046444L, 2);
      /** 16x16 */ public static final @NotNull Icon HORIZONTAL_SCROLL_VIEW = load("studio/icons/layout-editor/palette/horizontal-scroll-view.svg", -7195163030141391139L, 2);
      /** 16x16 */ public static final @NotNull Icon IMAGE_BUTTON = load("studio/icons/layout-editor/palette/image-button.svg", 4578433289668318201L, 2);
      /** 16x16 */ public static final @NotNull Icon IMAGE_SWITCHER = load("studio/icons/layout-editor/palette/image-switcher.svg", -7287077976628812323L, 2);
      /** 16x16 */ public static final @NotNull Icon IMAGE_VIEW = load("studio/icons/layout-editor/palette/image-view.svg", 8690101490238529439L, 2);
      /** 16x16 */ public static final @NotNull Icon INCLUDE = load("studio/icons/layout-editor/palette/include.svg", 6112180059253538906L, 2);
      /** 16x16 */ public static final @NotNull Icon LAYER = load("studio/icons/layout-editor/palette/layer.svg", 3922255677507329922L, 2);
      /** 16x16 */ public static final @NotNull Icon LINEAR_LAYOUT_HORZ = load("studio/icons/layout-editor/palette/linear-layout-horz.svg", -83744380464036086L, 2);
      /** 16x16 */ public static final @NotNull Icon LINEAR_LAYOUT_VERT = load("studio/icons/layout-editor/palette/linear-layout-vert.svg", -7822855520364167775L, 2);
      /** 16x16 */ public static final @NotNull Icon LIST_VIEW = load("studio/icons/layout-editor/palette/list-view.svg", -6541492684230661857L, 2);
      /** 16x16 */ public static final @NotNull Icon MAP_FRAGMENT = load("studio/icons/layout-editor/palette/map-fragment.svg", 5684283268402869467L, 2);
      /** 16x16 */ public static final @NotNull Icon MAP_VIEW = load("studio/icons/layout-editor/palette/map-view.svg", 1901180382930829001L, 2);
      /** 16x16 */ public static final @NotNull Icon MENU = load("studio/icons/layout-editor/palette/menu.svg", 8162758691992467150L, 2);
      /** 16x16 */ public static final @NotNull Icon MERGE = load("studio/icons/layout-editor/palette/merge.svg", 510319926238327767L, 2);
      /** 16x16 */ public static final @NotNull Icon MULTI_AUTO_COMPLETE_TEXT_VIEW = load("studio/icons/layout-editor/palette/multi-auto-complete-text-view.svg", 5447422427002567217L, 2);
      /** 16x16 */ public static final @NotNull Icon NAV_HOST_FRAGMENT = load("studio/icons/layout-editor/palette/nav-host-fragment.svg", 2516677636282259030L, 2);
      /** 16x16 */ public static final @NotNull Icon NAVIGATION_VIEW = load("studio/icons/layout-editor/palette/navigation-view.svg", 347086903884070743L, 2);
      /** 16x16 */ public static final @NotNull Icon NESTED_SCROLL_VIEW = load("studio/icons/layout-editor/palette/nested-scroll-view.svg", -1641368334266016393L, 2);
      /** 16x16 */ public static final @NotNull Icon NUMBER_DECIMAL_TEXTFIELD = load("studio/icons/layout-editor/palette/number-decimal-textfield.svg", 6840381422859865964L, 2);
      /** 16x16 */ public static final @NotNull Icon NUMBER_PICKER = load("studio/icons/layout-editor/palette/number-picker.svg", -4313191192513284225L, 2);
      /** 16x16 */ public static final @NotNull Icon NUMBER_SIGNED_TEXTFIELD = load("studio/icons/layout-editor/palette/number-signed-textfield.svg", -4324510216651594531L, 2);
      /** 16x16 */ public static final @NotNull Icon NUMBER_TEXTFIELD = load("studio/icons/layout-editor/palette/number-textfield.svg", 6814738333262680037L, 2);
      /** 16x16 */ public static final @NotNull Icon PASSWORD_NUMERIC_TEXTFIELD = load("studio/icons/layout-editor/palette/password-numeric-textfield.svg", -8182282248839307957L, 2);
      /** 16x16 */ public static final @NotNull Icon PASSWORD_TEXTFIELD = load("studio/icons/layout-editor/palette/password-textfield.svg", -8738420506919668956L, 2);
      /** 16x16 */ public static final @NotNull Icon PHONE_TEXTFIELD = load("studio/icons/layout-editor/palette/phone-textfield.svg", -3324473808594128964L, 2);
      /** 16x16 */ public static final @NotNull Icon PLACEHOLDER = load("studio/icons/layout-editor/palette/placeholder.svg", -8254581813218625436L, 2);
      /** 16x16 */ public static final @NotNull Icon POSTAL_ADDRESS_TEXTFIELD = load("studio/icons/layout-editor/palette/postal-address-textfield.svg", -6021813862888772215L, 2);
      /** 16x16 */ public static final @NotNull Icon PROGRESS_BAR_HORIZONTAL = load("studio/icons/layout-editor/palette/progress-bar-horizontal.svg", 4962891460727159706L, 2);
      /** 16x16 */ public static final @NotNull Icon PROGRESS_BAR = load("studio/icons/layout-editor/palette/progress-bar.svg", 3590155072818470136L, 2);
      /** 16x16 */ public static final @NotNull Icon QUICK_CONTACT_BADGE = load("studio/icons/layout-editor/palette/quick-contact-badge.svg", 3485505884414879714L, 2);
      /** 16x16 */ public static final @NotNull Icon RADIO_BUTTON = load("studio/icons/layout-editor/palette/radio-button.svg", -3094023304897488089L, 2);
      /** 16x16 */ public static final @NotNull Icon RADIO_GROUP = load("studio/icons/layout-editor/palette/radio-group.svg", -7987883180850456918L, 2);
      /** 16x16 */ public static final @NotNull Icon RATING_BAR = load("studio/icons/layout-editor/palette/rating-bar.svg", 1725645369983517263L, 2);
      /** 16x16 */ public static final @NotNull Icon RECYCLER_VIEW = load("studio/icons/layout-editor/palette/recycler-view.svg", 544286921822042722L, 2);
      /** 16x16 */ public static final @NotNull Icon RELATIVE_LAYOUT = load("studio/icons/layout-editor/palette/relative-layout.svg", -8161294682583950786L, 2);
      /** 16x16 */ public static final @NotNull Icon REQUEST_FOCUS = load("studio/icons/layout-editor/palette/request-focus.svg", 3001511154489534738L, 2);
      /** 16x16 */ public static final @NotNull Icon SCROLL_VIEW = load("studio/icons/layout-editor/palette/scroll-view.svg", -6589769363466052090L, 2);
      /** 16x16 */ public static final @NotNull Icon SEARCH_VIEW = load("studio/icons/layout-editor/palette/search-view.svg", 4914710458542789104L, 2);
      /** 16x16 */ public static final @NotNull Icon SEEK_BAR_DISCRETE = load("studio/icons/layout-editor/palette/seek-bar-discrete.svg", -6859010167537333873L, 2);
      /** 16x16 */ public static final @NotNull Icon SEEK_BAR = load("studio/icons/layout-editor/palette/seek-bar.svg", 1977247941586076324L, 2);
      /** 16x16 */ public static final @NotNull Icon SPACE = load("studio/icons/layout-editor/palette/space.svg", -2179376884849428589L, 2);
      /** 16x16 */ public static final @NotNull Icon SPINNER = load("studio/icons/layout-editor/palette/spinner.svg", -9131392831905400885L, 2);
      /** 16x16 */ public static final @NotNull Icon STACK_VIEW = load("studio/icons/layout-editor/palette/stack-view.svg", -3318726306824500512L, 2);
      /** 16x16 */ public static final @NotNull Icon SURFACE_VIEW = load("studio/icons/layout-editor/palette/surface-view.svg", -8300530109188211780L, 2);
      /** 16x16 */ public static final @NotNull Icon SWITCH = load("studio/icons/layout-editor/palette/switch.svg", 8813073479283244000L, 2);
      /** 16x16 */ public static final @NotNull Icon TAB_HOST = load("studio/icons/layout-editor/palette/tab-host.svg", -1864635916409943650L, 2);
      /** 16x16 */ public static final @NotNull Icon TAB_ITEM = load("studio/icons/layout-editor/palette/tab-item.svg", 7300703330280418854L, 2);
      /** 16x16 */ public static final @NotNull Icon TAB_LAYOUT = load("studio/icons/layout-editor/palette/tab-layout.svg", -8031601188260803535L, 2);
      /** 16x16 */ public static final @NotNull Icon TAB_WIDGET = load("studio/icons/layout-editor/palette/tab-widget.svg", 6112678835626709808L, 2);
      /** 16x16 */ public static final @NotNull Icon TABLE_LAYOUT = load("studio/icons/layout-editor/palette/table-layout.svg", -1564778545066620927L, 2);
      /** 16x16 */ public static final @NotNull Icon TABLE_ROW = load("studio/icons/layout-editor/palette/table-row.svg", -7880449933236028799L, 2);
      /** 16x16 */ public static final @NotNull Icon TEXT_CLOCK = load("studio/icons/layout-editor/palette/text-clock.svg", -7049954230590858579L, 2);
      /** 16x16 */ public static final @NotNull Icon TEXT_INPUT_LAYOUT = load("studio/icons/layout-editor/palette/text-input-layout.svg", 8310182646118509937L, 2);
      /** 16x16 */ public static final @NotNull Icon TEXT_SWITCHER = load("studio/icons/layout-editor/palette/text-switcher.svg", 4575235940396877909L, 2);
      /** 16x16 */ public static final @NotNull Icon TEXT_VIEW = load("studio/icons/layout-editor/palette/text-view.svg", -2237842215091995846L, 2);
      /** 16x16 */ public static final @NotNull Icon TEXTFIELD_MULTILINE = load("studio/icons/layout-editor/palette/textfield-multiline.svg", 306405423899084204L, 2);
      /** 16x16 */ public static final @NotNull Icon TEXTFIELD = load("studio/icons/layout-editor/palette/textfield.svg", 3489707003017901758L, 2);
      /** 16x16 */ public static final @NotNull Icon TEXTURE_VIEW = load("studio/icons/layout-editor/palette/texture-view.svg", 4608356457584417156L, 2);
      /** 16x16 */ public static final @NotNull Icon TIME_PICKER = load("studio/icons/layout-editor/palette/time-picker.svg", 5767695045282116489L, 2);
      /** 16x16 */ public static final @NotNull Icon TIME_TEXTFIELD = load("studio/icons/layout-editor/palette/time-textfield.svg", -397291170455190394L, 2);
      /** 16x16 */ public static final @NotNull Icon TOGGLE_BUTTON = load("studio/icons/layout-editor/palette/toggle-button.svg", 7261779818590812417L, 2);
      /** 16x16 */ public static final @NotNull Icon TOOLBAR = load("studio/icons/layout-editor/palette/toolbar.svg", 5140740274921251007L, 2);
      /** 16x16 */ public static final @NotNull Icon UNKNOWN_VIEW = load("studio/icons/layout-editor/palette/unknown-view.svg", -5221983138965490772L, 2);
      /** 16x16 */ public static final @NotNull Icon VERTICAL_DIVIDER = load("studio/icons/layout-editor/palette/vertical-divider.svg", -2956732905556096895L, 2);
      /** 16x16 */ public static final @NotNull Icon VIDEO_VIEW = load("studio/icons/layout-editor/palette/video-view.svg", 556257609711859664L, 2);
      /** 16x16 */ public static final @NotNull Icon VIEW_ANIMATOR = load("studio/icons/layout-editor/palette/view-animator.svg", 1015506761018549428L, 2);
      /** 16x16 */ public static final @NotNull Icon VIEW_FLIPPER = load("studio/icons/layout-editor/palette/view-flipper.svg", 3656310723108913499L, 2);
      /** 16x16 */ public static final @NotNull Icon VIEW_PAGER = load("studio/icons/layout-editor/palette/view-pager.svg", -8985445068565053085L, 2);
      /** 16x16 */ public static final @NotNull Icon VIEW_STUB = load("studio/icons/layout-editor/palette/view-stub.svg", 5683999353442258918L, 2);
      /** 16x16 */ public static final @NotNull Icon VIEW_SWITCHER = load("studio/icons/layout-editor/palette/view-switcher.svg", -8581832592341116680L, 2);
      /** 16x16 */ public static final @NotNull Icon VIEW = load("studio/icons/layout-editor/palette/view.svg", -4703503252437940381L, 2);
      /** 16x16 */ public static final @NotNull Icon WEB_VIEW = load("studio/icons/layout-editor/palette/web-view.svg", 2376130785557090235L, 2);
    }

    public static final class Properties {
      /** 16x16 */ public static final @NotNull Icon ADD_CONNECTION = load("studio/icons/layout-editor/properties/add-connection.svg", -771883650299649360L, 2);
      /** 12x12 */ public static final @NotNull Icon DESIGN_PROPERTY_ENABLED = load("studio/icons/layout-editor/properties/design-property-enabled.svg", -6025489037594808157L, 2);
      /** 12x12 */ public static final @NotNull Icon DESIGN_PROPERTY = load("studio/icons/layout-editor/properties/design-property.svg", -6359002848217712107L, 2);
      /** 16x16 */ public static final @NotNull Icon FAVORITES_HOVER = load("studio/icons/layout-editor/properties/favorites-hover.svg", -88429060465870734L, 2);
      /** 16x16 */ public static final @NotNull Icon FAVORITES_SELECTED = load("studio/icons/layout-editor/properties/favorites-selected.svg", -3443128573650112455L, 2);
      /** 16x16 */ public static final @NotNull Icon FAVORITES = load("studio/icons/layout-editor/properties/favorites.svg", 5967612840276097962L, 2);
      /** 14x14 */ public static final @NotNull Icon FLAG = load("studio/icons/layout-editor/properties/flag.svg", 4899062594414535322L, 2);
      /** 16x16 */ public static final @NotNull Icon GONE_TOOLS_ATTRIBUTE = load("studio/icons/layout-editor/properties/gone-tools-attribute.svg", -3807646959917717371L, 2);
      /** 16x16 */ public static final @NotNull Icon GONE = load("studio/icons/layout-editor/properties/gone.svg", -7556434937555527520L, 2);
      /** 16x16 */ public static final @NotNull Icon IMAGE_PICKER = load("studio/icons/layout-editor/properties/image-picker.svg", -3254944745081626207L, 2);
      /** 16x16 */ public static final @NotNull Icon INVISIBLE_TOOLS_ATTRIBUTE = load("studio/icons/layout-editor/properties/invisible-tools-attribute.svg", -3058672114555014052L, 2);
      /** 16x16 */ public static final @NotNull Icon INVISIBLE = load("studio/icons/layout-editor/properties/invisible.svg", 4354686969565349543L, 2);
      /** 16x16 */ public static final @NotNull Icon MODIFY_NAV = load("studio/icons/layout-editor/properties/modify-nav.svg", 8588572381080249261L, 2);
      /** 16x16 */ public static final @NotNull Icon MODIFY_TEXT = load("studio/icons/layout-editor/properties/modify-text.svg", -7298042233005252467L, 2);
      /** 16x16 */ public static final @NotNull Icon MODIFY_THEME = load("studio/icons/layout-editor/properties/modify-theme.svg", 5605306863992875503L, 2);
      /** 16x16 */ public static final @NotNull Icon PACKED_HORIZONTAL = load("studio/icons/layout-editor/properties/packed-horizontal.svg", 3332355690370993468L, 2);
      /** 16x16 */ public static final @NotNull Icon PACKED_VERTICAL = load("studio/icons/layout-editor/properties/packed-vertical.svg", 9203222769060244261L, 2);
      /** 16x16 */ public static final @NotNull Icon SPREAD_HORIZONTAL = load("studio/icons/layout-editor/properties/spread-horizontal.svg", -737493059999184218L, 2);
      /** 16x16 */ public static final @NotNull Icon SPREAD_INSIDE_HORIZONTAL = load("studio/icons/layout-editor/properties/spread-inside-horizontal.svg", 1969579754011687537L, 2);
      /** 16x16 */ public static final @NotNull Icon SPREAD_INSIDE_VERTICAL = load("studio/icons/layout-editor/properties/spread-inside-vertical.svg", -5257490116295844161L, 2);
      /** 16x16 */ public static final @NotNull Icon SPREAD_VERTICAL = load("studio/icons/layout-editor/properties/spread-vertical.svg", -2039703538982310321L, 2);
      /** 16x16 */ public static final @NotNull Icon TEXT_ALIGN_CENTER = load("studio/icons/layout-editor/properties/text-align-center.svg", 8072677023777671846L, 2);
      /** 16x16 */ public static final @NotNull Icon TEXT_ALIGN_LAYOUT_LEFT = load("studio/icons/layout-editor/properties/text-align-layout-left.svg", 6821663807020884434L, 2);
      /** 16x16 */ public static final @NotNull Icon TEXT_ALIGN_LAYOUT_RIGHT = load("studio/icons/layout-editor/properties/text-align-layout-right.svg", -6845852027200439914L, 2);
      /** 16x16 */ public static final @NotNull Icon TEXT_ALIGN_LEFT = load("studio/icons/layout-editor/properties/text-align-left.svg", -555561282026353099L, 2);
      /** 16x16 */ public static final @NotNull Icon TEXT_ALIGN_RIGHT = load("studio/icons/layout-editor/properties/text-align-right.svg", 1806039603519838998L, 2);
      /** 16x16 */ public static final @NotNull Icon TEXT_STYLE_BOLD = load("studio/icons/layout-editor/properties/text-style-bold.svg", 8118703768226144723L, 2);
      /** 16x16 */ public static final @NotNull Icon TEXT_STYLE_ITALIC = load("studio/icons/layout-editor/properties/text-style-italic.svg", -8510766997354975618L, 2);
      /** 16x16 */ public static final @NotNull Icon TEXT_STYLE_UPPERCASE = load("studio/icons/layout-editor/properties/text-style-uppercase.svg", 5951659864640964812L, 2);
      /** 16x16 */ public static final @NotNull Icon TOGGLE_PROPERTIES = load("studio/icons/layout-editor/properties/toggle-properties.svg", -6552600570879044185L, 2);
      /** 12x12 */ public static final @NotNull Icon TOOLS_ATTRIBUTE = load("studio/icons/layout-editor/properties/tools-attribute.svg", -7577949047120572437L, 2);
      /** 16x16 */ public static final @NotNull Icon VISIBLE_TOOLS_ATTRIBUTE = load("studio/icons/layout-editor/properties/visible-tools-attribute.svg", 3494283607248088021L, 2);
      /** 16x16 */ public static final @NotNull Icon VISIBLE = load("studio/icons/layout-editor/properties/visible.svg", 6981387136330717972L, 2);
    }

    public static final class Toolbar {
      /** 16x16 */ public static final @NotNull Icon ACCESSIBILITY = load("studio/icons/layout-editor/toolbar/accessibility.svg", -7410110638072385354L, 2);
      /** 16x16 */ public static final @NotNull Icon ADD_COMPONENT = load("studio/icons/layout-editor/toolbar/add-component.svg", 4064173764801872655L, 2);
      /** 16x16 */ public static final @NotNull Icon ADD_LOCALE = load("studio/icons/layout-editor/toolbar/add-locale.svg", 1506122689802776705L, 2);
      /** 16x16 */ public static final @NotNull Icon ANDROID_API = load("studio/icons/layout-editor/toolbar/android-api.svg", 3652559814563348554L, 2);
      /** 16x16 */ public static final @NotNull Icon ARROW_DOWN = load("studio/icons/layout-editor/toolbar/arrow-down.svg", -8862689633495850634L, 2);
      /** 16x16 */ public static final @NotNull Icon ARROW_LEFT = load("studio/icons/layout-editor/toolbar/arrow-left.svg", 4704314817573594097L, 2);
      /** 16x16 */ public static final @NotNull Icon ARROW_RIGHT = load("studio/icons/layout-editor/toolbar/arrow-right.svg", -1522586295160744889L, 2);
      /** 16x16 */ public static final @NotNull Icon ARROW_UP = load("studio/icons/layout-editor/toolbar/arrow-up.svg", -4473595809009274477L, 2);
      /** 16x16 */ public static final @NotNull Icon AUTO_CONNECT = load("studio/icons/layout-editor/toolbar/auto-connect.svg", 5552493127178726538L, 2);
      /** 16x16 */ public static final @NotNull Icon AUTO_CORRECT_OFF = load("studio/icons/layout-editor/toolbar/auto-correct-off.svg", -6022925157594992438L, 2);
      /** 16x16 */ public static final @NotNull Icon BARRIER_HORIZONTAL = load("studio/icons/layout-editor/toolbar/barrier-horizontal.svg", 1486555004505738582L, 2);
      /** 16x16 */ public static final @NotNull Icon BARRIER_VERTICAL = load("studio/icons/layout-editor/toolbar/barrier-vertical.svg", 4805982697340033484L, 2);
      /** 16x16 */ public static final @NotNull Icon BASELINE_ALIGNED_CONSTRAINT = load("studio/icons/layout-editor/toolbar/baseline-aligned-constraint.svg", -7005907382788758061L, 2);
      /** 16x16 */ public static final @NotNull Icon BASELINE_ALIGNED_OFF = load("studio/icons/layout-editor/toolbar/baseline-aligned-off.svg", 8011037049289186216L, 2);
      /** 16x16 */ public static final @NotNull Icon BASELINE_ALIGNED_WHITE = load("studio/icons/layout-editor/toolbar/baseline-aligned-white.svg", -5913168602501675379L, 0);
      /** 16x16 */ public static final @NotNull Icon BASELINE_ALIGNED = load("studio/icons/layout-editor/toolbar/baseline-aligned.svg", -6977666213301665539L, 2);
      /** 16x16 */ public static final @NotNull Icon BOTTOM_ALIGNED_CONSTRAINT = load("studio/icons/layout-editor/toolbar/bottom-aligned-constraint.svg", -3604158571904483844L, 2);
      /** 16x16 */ public static final @NotNull Icon BOTTOM_ALIGNED = load("studio/icons/layout-editor/toolbar/bottom-aligned.svg", -4863293210367498979L, 2);
      /** 16x16 */ public static final @NotNull Icon CENTER_HORIZONTAL_CONSTRAINT = load("studio/icons/layout-editor/toolbar/center-horizontal-constraint.svg", -3204991341841618951L, 2);
      /** 16x16 */ public static final @NotNull Icon CENTER_HORIZONTAL_PARENT_CONSTRAINT = load("studio/icons/layout-editor/toolbar/center-horizontal-parent-constraint.svg", -36474309756332181L, 2);
      /** 16x16 */ public static final @NotNull Icon CENTER_HORIZONTAL_PARENT = load("studio/icons/layout-editor/toolbar/center-horizontal-parent.svg", 4994327996396841474L, 2);
      /** 16x16 */ public static final @NotNull Icon CENTER_HORIZONTAL = load("studio/icons/layout-editor/toolbar/center-horizontal.svg", -8022841469043474303L, 2);
      /** 16x16 */ public static final @NotNull Icon CENTER_VERTICAL_CONSTRAINT = load("studio/icons/layout-editor/toolbar/center-vertical-constraint.svg", 5184937785691343321L, 2);
      /** 16x16 */ public static final @NotNull Icon CENTER_VERTICAL_PARENT_CONSTRAINT = load("studio/icons/layout-editor/toolbar/center-vertical-parent-constraint.svg", -7469144171990741032L, 2);
      /** 16x16 */ public static final @NotNull Icon CENTER_VERTICAL_PARENT = load("studio/icons/layout-editor/toolbar/center-vertical-parent.svg", -8756344127862818877L, 2);
      /** 16x16 */ public static final @NotNull Icon CENTER_VERTICAL = load("studio/icons/layout-editor/toolbar/center-vertical.svg", -6376785912221525728L, 2);
      /** 16x16 */ public static final @NotNull Icon CLEAR_CONSTRAINTS_WHITE = load("studio/icons/layout-editor/toolbar/clear-constraints-white.svg", 5853742998445572319L, 0);
      /** 16x16 */ public static final @NotNull Icon CLEAR_CONSTRAINTS = load("studio/icons/layout-editor/toolbar/clear-constraints.svg", -9050027073195109586L, 2);
      /** 16x16 */ public static final @NotNull Icon CLEAR_WEIGHT = load("studio/icons/layout-editor/toolbar/clear-weight.svg", 8016418204190189850L, 2);
      /** 16x16 */ public static final @NotNull Icon CONSTRAIN_BOTTOM_TO_BOTTOM = load("studio/icons/layout-editor/toolbar/constrain-bottom-to-bottom.svg", 8297417955411127976L, 2);
      /** 16x16 */ public static final @NotNull Icon CONSTRAIN_BOTTOM_TO_TOP = load("studio/icons/layout-editor/toolbar/constrain-bottom-to-top.svg", -2744932345171006303L, 2);
      /** 16x16 */ public static final @NotNull Icon CONSTRAIN_END_TO_END = load("studio/icons/layout-editor/toolbar/constrain-end-to-end.svg", 282851219684044714L, 2);
      /** 16x16 */ public static final @NotNull Icon CONSTRAIN_END_TO_START = load("studio/icons/layout-editor/toolbar/constrain-end-to-start.svg", -8028540157170841678L, 2);
      /** 16x16 */ public static final @NotNull Icon CONSTRAIN_START_TO_END = load("studio/icons/layout-editor/toolbar/constrain-start-to-end.svg", 5531326016346008209L, 2);
      /** 16x16 */ public static final @NotNull Icon CONSTRAIN_START_TO_START = load("studio/icons/layout-editor/toolbar/constrain-start-to-start.svg", -8416538121524456433L, 2);
      /** 16x16 */ public static final @NotNull Icon CONSTRAIN_TO_BOTTOM = load("studio/icons/layout-editor/toolbar/constrain-to-bottom.svg", -6448532375957481784L, 2);
      /** 16x16 */ public static final @NotNull Icon CONSTRAIN_TO_END = load("studio/icons/layout-editor/toolbar/constrain-to-end.svg", -5622162285734938254L, 2);
      /** 16x16 */ public static final @NotNull Icon CONSTRAIN_TO_START = load("studio/icons/layout-editor/toolbar/constrain-to-start.svg", 2199336422851068798L, 2);
      /** 16x16 */ public static final @NotNull Icon CONSTRAIN_TO_TOP = load("studio/icons/layout-editor/toolbar/constrain-to-top.svg", 8043549054258911416L, 2);
      /** 16x16 */ public static final @NotNull Icon CONSTRAIN_TOP_TO_BOTTOM = load("studio/icons/layout-editor/toolbar/constrain-top-to-bottom.svg", 3313733091506695493L, 2);
      /** 16x16 */ public static final @NotNull Icon CONSTRAIN_TOP_TO_TOP = load("studio/icons/layout-editor/toolbar/constrain-top-to-top.svg", -5883756751026795584L, 2);
      /** 16x16 */ public static final @NotNull Icon CONSTRAINT_SET = load("studio/icons/layout-editor/toolbar/constraint-set.svg", -4888557045209701707L, 2);
      /** 16x16 */ public static final @NotNull Icon CREATE_CONSTRAINTS = load("studio/icons/layout-editor/toolbar/create-constraints.svg", -2270721804386836483L, 2);
      /** 16x16 */ public static final @NotNull Icon CREATE_HORIZ_CHAIN = load("studio/icons/layout-editor/toolbar/create-horiz-chain.svg", -6812732372176983018L, 2);
      /** 16x16 */ public static final @NotNull Icon CREATE_VERT_CHAIN = load("studio/icons/layout-editor/toolbar/create-vert-chain.svg", -3917138149321946118L, 2);
      /** 16x16 */ public static final @NotNull Icon CYCLE_CHAIN_PACKED = load("studio/icons/layout-editor/toolbar/cycle-chain-packed.svg", -3218796165926163468L, 2);
      /** 16x16 */ public static final @NotNull Icon CYCLE_CHAIN_SPREAD_INLINE = load("studio/icons/layout-editor/toolbar/cycle-chain-spread-inline.svg", 7198419965827692859L, 2);
      /** 16x16 */ public static final @NotNull Icon CYCLE_CHAIN_SPREAD = load("studio/icons/layout-editor/toolbar/cycle-chain-spread.svg", 314815446455412581L, 2);
      /** 16x16 */ public static final @NotNull Icon DEVICE_AUTOMOTIVE = load("studio/icons/layout-editor/toolbar/device-automotive.svg", 4302025736479087782L, 2);
      /** 16x16 */ public static final @NotNull Icon DEVICE_PHONE = load("studio/icons/layout-editor/toolbar/device-phone.svg", 3276051888349296259L, 2);
      /** 16x16 */ public static final @NotNull Icon DEVICE_SCREEN = load("studio/icons/layout-editor/toolbar/device-screen.svg", 4452748302628840795L, 2);
      /** 16x16 */ public static final @NotNull Icon DEVICE_TABLET = load("studio/icons/layout-editor/toolbar/device-tablet.svg", -3721383486316449531L, 2);
      /** 16x16 */ public static final @NotNull Icon DEVICE_TV = load("studio/icons/layout-editor/toolbar/device-tv.svg", 1548409209816357049L, 2);
      /** 16x16 */ public static final @NotNull Icon DEVICE_WEAR = load("studio/icons/layout-editor/toolbar/device-wear.svg", 627837050725453535L, 2);
      /** 16x16 */ public static final @NotNull Icon DISTRIBUTE_HORIZONTAL_CONSTRAINT = load("studio/icons/layout-editor/toolbar/distribute-horizontal-constraint.svg", 1138617470067756826L, 2);
      /** 16x16 */ public static final @NotNull Icon DISTRIBUTE_HORIZONTAL = load("studio/icons/layout-editor/toolbar/distribute-horizontal.svg", -1742010568392369846L, 2);
      /** 16x16 */ public static final @NotNull Icon DISTRIBUTE_VERTICAL_CONSTRAINT = load("studio/icons/layout-editor/toolbar/distribute-vertical-constraint.svg", -4324957428390539046L, 2);
      /** 16x16 */ public static final @NotNull Icon DISTRIBUTE_VERTICAL = load("studio/icons/layout-editor/toolbar/distribute-vertical.svg", 7179457918450565160L, 2);
      /** 16x16 */ public static final @NotNull Icon DISTRIBUTE_WEIGHT = load("studio/icons/layout-editor/toolbar/distribute-weight.svg", -6693173761444571527L, 2);
      /** 16x16 */ public static final @NotNull Icon EXPAND_HORIZONTAL = load("studio/icons/layout-editor/toolbar/expand-horizontal.svg", -1989396660989592251L, 2);
      /** 16x16 */ public static final @NotNull Icon EXPAND_TO_FIT = load("studio/icons/layout-editor/toolbar/expand-to-fit.svg", -7568409477917452018L, 2);
      /** 16x16 */ public static final @NotNull Icon EXPAND_VERTICAL = load("studio/icons/layout-editor/toolbar/expand-vertical.svg", -3014278976232508347L, 2);
      /** 16x16 */ public static final @NotNull Icon GROUP = load("studio/icons/layout-editor/toolbar/group.svg", -351014025580931926L, 2);
      /** 16x16 */ public static final @NotNull Icon GUIDELINE_HORIZONTAL = load("studio/icons/layout-editor/toolbar/guideline-horizontal.svg", 103345428906582504L, 2);
      /** 16x16 */ public static final @NotNull Icon GUIDELINE_VERTICAL = load("studio/icons/layout-editor/toolbar/guideline-vertical.svg", -4995498352509888994L, 2);
      /** 16x16 */ public static final @NotNull Icon HIDE_CONSTRAINTS = load("studio/icons/layout-editor/toolbar/hide-constraints.svg", 4583417778177054000L, 2);
      /** 16x16 */ public static final @NotNull Icon HORIZONTAL_CENTER_ALIGNED_CONSTRAINT = load("studio/icons/layout-editor/toolbar/horizontal-center-aligned-constraint.svg", 100055356837424980L, 2);
      /** 16x16 */ public static final @NotNull Icon HORIZONTAL_CENTER_ALIGNED = load("studio/icons/layout-editor/toolbar/horizontal-center-aligned.svg", 5486589603897602848L, 2);
      /** 16x16 */ public static final @NotNull Icon INFER_CONSTRAINTS = load("studio/icons/layout-editor/toolbar/infer-constraints.svg", 1152358138924177719L, 2);
      /** 16x16 */ public static final @NotNull Icon INSERT_HORIZ_CHAIN = load("studio/icons/layout-editor/toolbar/insert-horiz-chain.svg", 5467455908297509802L, 2);
      /** 16x16 */ public static final @NotNull Icon INSERT_VERT_CHAIN = load("studio/icons/layout-editor/toolbar/insert-vert-chain.svg", 3426159165023944074L, 2);
      /** 16x16 */ public static final @NotNull Icon LANGUAGE = load("studio/icons/layout-editor/toolbar/language.svg", -6498652208086529603L, 2);
      /** 16x16 */ public static final @NotNull Icon LAYER = load("studio/icons/layout-editor/toolbar/layer.svg", 9145255697088184535L, 2);
      /** 16x16 */ public static final @NotNull Icon LEFT_ALIGNED_CONSTRAINT = load("studio/icons/layout-editor/toolbar/left-aligned-constraint.svg", -6818670377336202169L, 2);
      /** 16x16 */ public static final @NotNull Icon LEFT_ALIGNED = load("studio/icons/layout-editor/toolbar/left-aligned.svg", -7688674443102678673L, 2);
      /** 16x16 */ public static final @NotNull Icon LOCK = load("studio/icons/layout-editor/toolbar/lock.svg", -119206592836850483L, 2);
      /** 16x16 */ public static final @NotNull Icon MARGIN = load("studio/icons/layout-editor/toolbar/margin.svg", 8127113126230085470L, 2);
      /** 16x16 */ public static final @NotNull Icon MATCH_PARENT_HEIGHT = load("studio/icons/layout-editor/toolbar/match-parent-height.svg", 1037837668623165103L, 2);
      /** 16x16 */ public static final @NotNull Icon MATCH_PARENT_WIDTH = load("studio/icons/layout-editor/toolbar/match-parent-width.svg", 6590220933286350864L, 2);
      /** 16x16 */ public static final @NotNull Icon MOVE_DOWN_VERT_CHAIN = load("studio/icons/layout-editor/toolbar/move-down-vert-chain.svg", -4847430044579463791L, 2);
      /** 16x16 */ public static final @NotNull Icon MOVE_LEFT_HORIZ_CHAIN = load("studio/icons/layout-editor/toolbar/move-left-horiz-chain.svg", -1769733881162007747L, 2);
      /** 16x16 */ public static final @NotNull Icon MOVE_RIGHT_HORIZ_CHAIN = load("studio/icons/layout-editor/toolbar/move-right-horiz-chain.svg", -4625835633789682027L, 2);
      /** 16x16 */ public static final @NotNull Icon MOVE_UP_VERT_CHAIN = load("studio/icons/layout-editor/toolbar/move-up-vert-chain.svg", -4068373322060327028L, 2);
      /** 16x16 */ public static final @NotNull Icon NORMAL_RENDER = load("studio/icons/layout-editor/toolbar/normal-render.svg", -3482913108916924318L, 2);
      /** 16x16 */ public static final @NotNull Icon ORIENT_HORIZONTAL = load("studio/icons/layout-editor/toolbar/orient-horizontal.svg", 6495192806835299719L, 2);
      /** 16x16 */ public static final @NotNull Icon ORIENT_VERTICAL = load("studio/icons/layout-editor/toolbar/orient-vertical.svg", 1750273972390587316L, 2);
      /** 16x16 */ public static final @NotNull Icon PACK_HORIZONTAL = load("studio/icons/layout-editor/toolbar/pack-horizontal.svg", 9032291736056766211L, 2);
      /** 16x16 */ public static final @NotNull Icon PACK_VERTICAL = load("studio/icons/layout-editor/toolbar/pack-vertical.svg", 2009982742043944187L, 2);
      /** 16x16 */ public static final @NotNull Icon PAN_TOOL_SELECTED = load("studio/icons/layout-editor/toolbar/pan-tool-selected.svg", -700132153928644514L, 2);
      /** 16x16 */ public static final @NotNull Icon PAN_TOOL = load("studio/icons/layout-editor/toolbar/pan-tool.svg", -4192926542547204783L, 2);
      /** 16x16 */ public static final @NotNull Icon PERCENT = load("studio/icons/layout-editor/toolbar/percent.svg", -2679911194509126447L, 2);
      /** 16x16 */ public static final @NotNull Icon QUESTION = load("studio/icons/layout-editor/toolbar/question.svg", 8918748425492799696L, 2);
      /** 16x16 */ public static final @NotNull Icon REFRESH = load("studio/icons/layout-editor/toolbar/refresh.svg", -5917319455826090460L, 2);
      /** 16x16 */ public static final @NotNull Icon REMOVE_FROM_HORIZ_CHAIN = load("studio/icons/layout-editor/toolbar/remove-from-horiz-chain.svg", -4375677402147372462L, 2);
      /** 16x16 */ public static final @NotNull Icon REMOVE_FROM_VERT_CHAIN = load("studio/icons/layout-editor/toolbar/remove-from-vert-chain.svg", 9052037528250135745L, 2);
      /** 16x16 */ public static final @NotNull Icon RIGHT_ALIGNED_CONSTRAINT = load("studio/icons/layout-editor/toolbar/right-aligned-constraint.svg", 2845873392474534002L, 2);
      /** 16x16 */ public static final @NotNull Icon RIGHT_ALIGNED = load("studio/icons/layout-editor/toolbar/right-aligned.svg", 1607418038729941558L, 2);
      /** 16x16 */ public static final @NotNull Icon ROTATE_BUTTON = load("studio/icons/layout-editor/toolbar/rotate-button.svg", -6895487021377576191L, 2);
      /** 16x16 */ public static final @NotNull Icon SEARCH = load("studio/icons/layout-editor/toolbar/search.svg", 5152984432248861511L, 2);
      /** 16x16 */ public static final @NotNull Icon SHOW_CONSTRAINTS = load("studio/icons/layout-editor/toolbar/show-constraints.svg", 7966229828695504264L, 2);
      /** 16x16 */ public static final @NotNull Icon THEME_BUTTON = load("studio/icons/layout-editor/toolbar/theme-button.svg", -290307800038328780L, 2);
      /** 16x16 */ public static final @NotNull Icon TOOLS_ATTRIBUTE_OFF = load("studio/icons/layout-editor/toolbar/tools-attribute-off.svg", -558410625615534057L, 2);
      /** 16x16 */ public static final @NotNull Icon TOOLS_ATTRIBUTE_ON = load("studio/icons/layout-editor/toolbar/tools-attribute-on.svg", 417928858300068725L, 2);
      /** 16x16 */ public static final @NotNull Icon TOP_ALIGNED_CONSTRAINT = load("studio/icons/layout-editor/toolbar/top-aligned-constraint.svg", -3415313043093201348L, 2);
      /** 16x16 */ public static final @NotNull Icon TOP_ALIGNED = load("studio/icons/layout-editor/toolbar/top-aligned.svg", 238516758755672984L, 2);
      /** 16x16 */ public static final @NotNull Icon UNLOCK = load("studio/icons/layout-editor/toolbar/unlock.svg", -7705298945679909056L, 2);
      /** 16x16 */ public static final @NotNull Icon VARIANTS = load("studio/icons/layout-editor/toolbar/variants.svg", -6263950115726917490L, 2);
      /** 16x16 */ public static final @NotNull Icon VERTICAL_CENTER_ALIGNED_CONSTRAINT = load("studio/icons/layout-editor/toolbar/vertical-center-aligned-constraint.svg", -6041537420715670181L, 2);
      /** 16x16 */ public static final @NotNull Icon VERTICAL_CENTER_ALIGNED = load("studio/icons/layout-editor/toolbar/vertical-center-aligned.svg", -6803476066442631567L, 2);
      /** 16x16 */ public static final @NotNull Icon VIEW_MODE = load("studio/icons/layout-editor/toolbar/view-mode.svg", 2075891638608520776L, 2);
      /** 16x16 */ public static final @NotNull Icon VIEWPORT_RENDER = load("studio/icons/layout-editor/toolbar/viewport-render.svg", 3484646457093338295L, 2);
      /** 16x16 */ public static final @NotNull Icon VIRTUAL_DEVICES = load("studio/icons/layout-editor/toolbar/virtual-devices.svg", 2959354952001332072L, 2);
      /** 16x16 */ public static final @NotNull Icon WRAP_HEIGHT = load("studio/icons/layout-editor/toolbar/wrap-height.svg", 3862720925038612553L, 2);
      /** 16x16 */ public static final @NotNull Icon WRAP_WIDTH = load("studio/icons/layout-editor/toolbar/wrap-width.svg", 8748295710305098453L, 2);
    }
  }

  public static final class LayoutInspector {
    /** 16x16 */ public static final @NotNull Icon CLEAR_OVERLAY = load("studio/icons/layout-inspector/clear-overlay.svg", 7202017734371670193L, 2);
    /** 16x16 */ public static final @NotNull Icon COLOR_PICKER = load("studio/icons/layout-inspector/color-picker.svg", 6021856461484559940L, 2);
    /** 16x16 */ public static final @NotNull Icon LOAD_OVERLAY = load("studio/icons/layout-inspector/load-overlay.svg", 8884037285144017601L, 2);
    /** 16x16 */ public static final @NotNull Icon MODE_2D = load("studio/icons/layout-inspector/mode-2d.svg", 3956074451153461726L, 2);
    /** 16x16 */ public static final @NotNull Icon MODE_3D = load("studio/icons/layout-inspector/mode-3d.svg", 1061848752959895656L, 2);
    /** 16x16 */ public static final @NotNull Icon RESET_VIEW = load("studio/icons/layout-inspector/reset-view.svg", -5316384752952678581L, 2);
  }

  public static final class Logcat {
    public static final class Toolbar {
      /** 16x16 */ public static final @NotNull Icon SETTINGS = load("studio/icons/logcat/toolbar/settings.svg", 8661200190395343530L, 2);
      /** 16x16 */ public static final @NotNull Icon SNAPSHOT = load("studio/icons/logcat/toolbar/snapshot.svg", -3379704893135137765L, 2);
      /** 16x16 */ public static final @NotNull Icon VIDEO_CAPTURE = load("studio/icons/logcat/toolbar/video-capture.svg", 1552605722654562194L, 2);
      /** 16x16 */ public static final @NotNull Icon WRAP_TEXT = load("studio/icons/logcat/toolbar/wrap-text.svg", -3023085265376989150L, 2);
    }
  }

  public static final class Misc {
    /** 16x16 */ public static final @NotNull Icon BUILD_TYPE = load("studio/icons/misc/build-type.svg", -3493372806323648667L, 2);
    /** 16x16 */ public static final @NotNull Icon COMPOSABLE_FUNCTION = load("studio/icons/misc/composable-function.svg", 781846808272488472L, 2);
    /** 16x16 */ public static final @NotNull Icon DEPENDENCY_CONSUMER = load("studio/icons/misc/dependency-consumer.svg", -8844260788277013421L, 2);
    /** 16x16 */ public static final @NotNull Icon DEPENDENCY_PROVIDER = load("studio/icons/misc/dependency-provider.svg", 1818386565869777562L, 2);
    /** 16x16 */ public static final @NotNull Icon GRADLE_VARIABLE = load("studio/icons/misc/gradle-variable.svg", -6791554246124566178L, 2);
    /** 16x16 */ public static final @NotNull Icon PRODUCT_FLAVOR_DIMENSION = load("studio/icons/misc/product-flavor-dimension.svg", 11709053216456561L, 2);
    /** 16x16 */ public static final @NotNull Icon PRODUCT_FLAVOR = load("studio/icons/misc/product-flavor.svg", 7065424204340839956L, 2);
    /** 16x16 */ public static final @NotNull Icon SIGNING_CONFIG = load("studio/icons/misc/signing-config.svg", 2003231780330543924L, 2);
  }

  public static final class NavEditor {
    public static final class ExistingDestinations {
      /** 73x94 */ public static final @NotNull Icon ACTIVITY = load("studio/icons/nav-editor/existing-destinations/activity.svg", 1460438687821283693L, 2);
      /** 73x94 */ public static final @NotNull Icon DESTINATION = load("studio/icons/nav-editor/existing-destinations/destination.svg", -8593642985879440775L, 2);
      /** 53x78 */ public static final @NotNull Icon NESTED = load("studio/icons/nav-editor/existing-destinations/nested.svg", -3401511147173859667L, 2);
      /** 73x94 */ public static final @NotNull Icon PLACEHOLDER = load("studio/icons/nav-editor/existing-destinations/placeholder.svg", -2628868004447793859L, 2);
    }

    public static final class Properties {
      /** 16x16 */ public static final @NotNull Icon ACTION = load("studio/icons/nav-editor/properties/action.svg", 9071540957107703120L, 2);
      /** 16x16 */ public static final @NotNull Icon ARGUMENT = load("studio/icons/nav-editor/properties/argument.svg", 7638035016737525196L, 2);
      /** 16x16 */ public static final @NotNull Icon DEEPLINK = load("studio/icons/nav-editor/properties/deeplink.svg", 4372010186382963245L, 2);
      /** 16x16 */ public static final @NotNull Icon GLOBAL_ACTION = load("studio/icons/nav-editor/properties/global-action.svg", 79676203681661817L, 2);
      /** 16x16 */ public static final @NotNull Icon POP_ACTION = load("studio/icons/nav-editor/properties/pop-action.svg", -3877974873335907877L, 2);
      /** 16x16 */ public static final @NotNull Icon SOURCE = load("studio/icons/nav-editor/properties/source.svg", -2594678411179703567L, 2);
    }

    public static final class Surface {
      /** 56x56 */ public static final @NotNull Icon DEEPLINK = load("studio/icons/nav-editor/surface/deeplink.svg", -3173325413811656938L, 2);
      /** 56x56 */ public static final @NotNull Icon POP_ACTION = load("studio/icons/nav-editor/surface/pop-action.svg", -6626240543408425964L, 2);
      /** 56x56 */ public static final @NotNull Icon START_DESTINATION = load("studio/icons/nav-editor/surface/start-destination.svg", -7694545907387064857L, 2);
    }

    public static final class Toolbar {
      /** 16x16 */ public static final @NotNull Icon ACTION = load("studio/icons/nav-editor/toolbar/action.svg", -8905670794680066959L, 2);
      /** 16x16 */ public static final @NotNull Icon ADD_DESTINATION = load("studio/icons/nav-editor/toolbar/add-destination.svg", 693971312509264003L, 2);
      /** 16x16 */ public static final @NotNull Icon ASSIGN_START = load("studio/icons/nav-editor/toolbar/assign-start.svg", 2511555673269733050L, 2);
      /** 16x16 */ public static final @NotNull Icon AUTO_ARRANGE = load("studio/icons/nav-editor/toolbar/auto-arrange.svg", -1740125312111053972L, 2);
      /** 16x16 */ public static final @NotNull Icon DEEPLINK = load("studio/icons/nav-editor/toolbar/deeplink.svg", 4554828892389597688L, 2);
      /** 16x16 */ public static final @NotNull Icon NESTED_GRAPH = load("studio/icons/nav-editor/toolbar/nested-graph.svg", -6154396111253415823L, 2);
    }

    public static final class Tree {
      /** 16x16 */ public static final @NotNull Icon ACTIVITY = load("studio/icons/nav-editor/tree/activity.svg", -1725814066386288854L, 2);
      /** 16x16 */ public static final @NotNull Icon FRAGMENT = load("studio/icons/nav-editor/tree/fragment.svg", -8889621128329436147L, 2);
      /** 16x16 */ public static final @NotNull Icon INCLUDE_GRAPH = load("studio/icons/nav-editor/tree/include-graph.svg", -2429162155455394728L, 2);
      /** 16x16 */ public static final @NotNull Icon NESTED_GRAPH = load("studio/icons/nav-editor/tree/nested-graph.svg", -455359996827436713L, 2);
      /** 16x16 */ public static final @NotNull Icon PLACEHOLDER = load("studio/icons/nav-editor/tree/placeholder.svg", 1720166078892344253L, 2);
    }
  }

  public static final class Profiler {
    public static final class Events {
      /** 22x22 */ public static final @NotNull Icon ALLOCATION_TRACKING_FULL = load("studio/icons/profiler/events/allocation-tracking-full.svg", -7539703526207082721L, 2);
      /** 22x22 */ public static final @NotNull Icon ALLOCATION_TRACKING_NONE = load("studio/icons/profiler/events/allocation-tracking-none.svg", -9036993259759385056L, 2);
      /** 22x22 */ public static final @NotNull Icon ALLOCATION_TRACKING_SAMPLED = load("studio/icons/profiler/events/allocation-tracking-sampled.svg", -1085715403593925418L, 2);
      /** 22x22 */ public static final @NotNull Icon BACK_BUTTON = load("studio/icons/profiler/events/back-button.svg", 3112280027094274353L, 2);
      /** 22x22 */ public static final @NotNull Icon GARBAGE_EVENT = load("studio/icons/profiler/events/garbage-event.svg", -8310441577950544224L, 2);
      /** 22x22 */ public static final @NotNull Icon GPS = load("studio/icons/profiler/events/gps.svg", 391993986512011730L, 2);
      /** 22x22 */ public static final @NotNull Icon KEYBOARD_EVENT = load("studio/icons/profiler/events/keyboard-event.svg", -50813414595004354L, 2);
      /** 22x22 */ public static final @NotNull Icon ROTATE_EVENT = load("studio/icons/profiler/events/rotate-event.svg", 5756191706147256061L, 2);
      /** 22x22 */ public static final @NotNull Icon VOLUME_DOWN = load("studio/icons/profiler/events/volume-down.svg", 70650392454850731L, 2);
      /** 22x22 */ public static final @NotNull Icon VOLUME_UP = load("studio/icons/profiler/events/volume-up.svg", 3450304328795564814L, 2);
    }

    public static final class Files {
      /** 16x16 */ public static final @NotNull Icon PROFILER_CAPTURE = load("studio/icons/profiler/files/profiler-capture.png", 0L, 1);
    }

    public static final class Overlays {
      /** 16x16 */ public static final @NotNull Icon ARRAY_STACK = load("studio/icons/profiler/overlays/array-stack.svg", -2624166456579466855L, 0);
      /** 16x16 */ public static final @NotNull Icon CLASS_STACK = load("studio/icons/profiler/overlays/class-stack.svg", -7617593965268697776L, 0);
      /** 16x16 */ public static final @NotNull Icon FIELD_STACK = load("studio/icons/profiler/overlays/field-stack.svg", -4504649205650046197L, 0);
      /** 16x16 */ public static final @NotNull Icon INTERFACE_STACK = load("studio/icons/profiler/overlays/interface-stack.svg", 7902907405577251399L, 0);
      /** 16x16 */ public static final @NotNull Icon METHOD_STACK = load("studio/icons/profiler/overlays/method-stack.svg", 4883549742894697131L, 0);
      /** 16x16 */ public static final @NotNull Icon PACKAGE_STACK = load("studio/icons/profiler/overlays/package-stack.svg", 6312069166894373436L, 0);
      /** 16x16 */ public static final @NotNull Icon THREAD_SUSPENDED_STACK = load("studio/icons/profiler/overlays/thread-suspended-stack.svg", 3728281770061071649L, 0);
      /** 20x20 */ public static final @NotNull Icon TRANSPARENT_TILE = load("studio/icons/profiler/overlays/transparent-tile.svg", 5628672494685163841L, 0);
    }

    public static final class Sessions {
      /** 16x16 */ public static final @NotNull Icon ALLOCATIONS = load("studio/icons/profiler/sessions/allocations.svg", -7502527280733067856L, 2);
      /** 16x16 */ public static final @NotNull Icon BOOKMARK = load("studio/icons/profiler/sessions/bookmark.svg", -409545614505742791L, 2);
      /** 16x16 */ public static final @NotNull Icon CPU = load("studio/icons/profiler/sessions/cpu.svg", 504809494470731488L, 2);
      /** 16x16 */ public static final @NotNull Icon HEAP = load("studio/icons/profiler/sessions/heap.svg", -8085296329329630326L, 2);
      /** 16x16 */ public static final @NotNull Icon SAVE = load("studio/icons/profiler/sessions/save.svg", -4027118038203442191L, 2);
    }

    public static final class Sidebar {
      /** 44x44 */ public static final @NotNull Icon FILE = load("studio/icons/profiler/sidebar/file.svg", 420396439766621853L, 2);
      /** 44x44 */ public static final @NotNull Icon ISSUE = load("studio/icons/profiler/sidebar/issue.svg", -89703417210320745L, 2);
    }

    public static final class Toolbar {
      /** 16x16 */ public static final @NotNull Icon CAPTURE_CLOCK = load("studio/icons/profiler/toolbar/capture-clock.svg", 3441683744563454289L, 0);
      /** 16x16 */ public static final @NotNull Icon CLOCK = load("studio/icons/profiler/toolbar/clock.svg", -6968489103953582155L, 2);
      /** 16x16 */ public static final @NotNull Icon COLLAPSE_SESSION = load("studio/icons/profiler/toolbar/collapse-session.svg", -3997554684561302916L, 2);
      /** 16x16 */ public static final @NotNull Icon EXPAND_SESSION = load("studio/icons/profiler/toolbar/expand-session.svg", -8644598481268380018L, 2);
      /** 16x16 */ public static final @NotNull Icon FORCE_GARBAGE_COLLECTION = load("studio/icons/profiler/toolbar/force-garbage-collection.svg", 6133963305628546453L, 2);
      /** 16x16 */ public static final @NotNull Icon GOTO_LIVE = load("studio/icons/profiler/toolbar/goto-live.svg", 8227221903814917863L, 2);
      /** 16x16 */ public static final @NotNull Icon HEAP_DUMP = load("studio/icons/profiler/toolbar/heap-dump.svg", -7956148510422841176L, 2);
      /** 16x16 */ public static final @NotNull Icon PAUSE_LIVE = load("studio/icons/profiler/toolbar/pause-live.svg", -5451017705187036457L, 2);
      /** 16x16 */ public static final @NotNull Icon RECORD = load("studio/icons/profiler/toolbar/record.svg", 2197265987768799328L, 2);
      /** 16x16 */ public static final @NotNull Icon STOP_RECORDING = load("studio/icons/profiler/toolbar/stop-recording.svg", 4257595885381349255L, 2);
      /** 16x16 */ public static final @NotNull Icon STOP_SESSION = load("studio/icons/profiler/toolbar/stop-session.svg", -1439702489817924309L, 2);
    }
  }

  public static final class ResourcePicker {
    /** 16x16 */ public static final @NotNull Icon WEB_FONT = load("studio/icons/resource-picker/web-font.svg", 7054039795166324247L, 2);
  }

  public static final class Shell {
    public static final class Filetree {
      /** 16x16 */ public static final @NotNull Icon ANDROID_FILE = load("studio/icons/shell/filetree/android-file.svg", -7646675327706247476L, 2);
      /** 16x16 */ public static final @NotNull Icon ANDROID_MODULE = load("studio/icons/shell/filetree/android-module.svg", 1253676115065769980L, 2);
      /** 16x16 */ public static final @NotNull Icon ANDROID_PROJECT = load("studio/icons/shell/filetree/android-project.svg", -5995830102990121245L, 2);
      /** 16x16 */ public static final @NotNull Icon ANDROID_TEST_ROOT = load("studio/icons/shell/filetree/android-test-root.svg", 220921841549302897L, 2);
      /** 16x16 */ public static final @NotNull Icon CONFIG_FILE = load("studio/icons/shell/filetree/config-file.svg", -106060135782725079L, 2);
      /** 16x16 */ public static final @NotNull Icon DATABASE_FILE = load("studio/icons/shell/filetree/database-file.svg", 5868679549416755882L, 2);
      /** 16x16 */ public static final @NotNull Icon FEATURE_MODULE = load("studio/icons/shell/filetree/feature-module.svg", 6041859618374397895L, 2);
      /** 16x16 */ public static final @NotNull Icon FONT_FILE = load("studio/icons/shell/filetree/font-file.svg", -8383567552441944074L, 2);
      /** 16x16 */ public static final @NotNull Icon GRADLE_FILE = load("studio/icons/shell/filetree/gradle-file.svg", 8502588591117002610L, 2);
      /** 16x16 */ public static final @NotNull Icon INSTANT_APPS = load("studio/icons/shell/filetree/instant-apps.svg", -416659434112169187L, 2);
      /** 16x16 */ public static final @NotNull Icon LIBRARY_MODULE = load("studio/icons/shell/filetree/library-module.svg", -7495810937168166045L, 2);
      /** 16x16 */ public static final @NotNull Icon LIBRARY_UNKNOWN = load("studio/icons/shell/filetree/library-unknown.svg", -1084061156140578695L, 2);
      /** 16x16 */ public static final @NotNull Icon LIBRARY_WARNING = load("studio/icons/shell/filetree/library-warning.svg", 1860463973103052837L, 2);
      /** 16x16 */ public static final @NotNull Icon MANIFEST_FILE = load("studio/icons/shell/filetree/manifest-file.svg", 5587539169853152755L, 2);
      /** 16x16 */ public static final @NotNull Icon MAVEN = load("studio/icons/shell/filetree/maven.svg", 9146646909590119762L, 2);
      /** 16x16 */ public static final @NotNull Icon RENDER_SCRIPT = load("studio/icons/shell/filetree/render-script.svg", 7038334729406890614L, 2);
      /** 16x16 */ public static final @NotNull Icon SCENEFORM_ASSET_DESCRIPTION_FILE = load("studio/icons/shell/filetree/sceneform-asset-description-file.svg", -2558801497140325987L, 2);
      /** 16x16 */ public static final @NotNull Icon SCENEFORM_BINARY = load("studio/icons/shell/filetree/sceneform-binary.svg", -2714868365945178821L, 2);
      /** 16x16 */ public static final @NotNull Icon SQL_FILE = load("studio/icons/shell/filetree/sql-file.svg", 1231221119353062147L, 2);
      /** 16x16 */ public static final @NotNull Icon TFLITE_FILE = load("studio/icons/shell/filetree/tflite-file.svg", 420757718966459232L, 2);
    }

    public static final class Menu {
      /** 16x16 */ public static final @NotNull Icon ANDROID_PREVIEW = load("studio/icons/shell/menu/android-preview.svg", 2893708398343195662L, 2);
      /** 16x16 */ public static final @NotNull Icon AVD_MANAGER = load("studio/icons/shell/menu/avd-manager.svg", 1788321619504684044L, 2);
      /** 16x16 */ public static final @NotNull Icon LAYOUT_INSPECTOR = load("studio/icons/shell/menu/layout-inspector.svg", 1189077149919135642L, 2);
      /** 16x16 */ public static final @NotNull Icon PROFILER = load("studio/icons/shell/menu/profiler.svg", 4551157701195856815L, 2);
      /** 16x16 */ public static final @NotNull Icon THEME_EDITOR = load("studio/icons/shell/menu/theme-editor.svg", 8337911850572134079L, 2);
    }

    public static final class StatusBar {
      /** 16x16 */ public static final @NotNull Icon ADB_MANAGED = load("studio/icons/shell/status-bar/adb-managed.svg", -1474639234076055702L, 2);
      /** 16x16 */ public static final @NotNull Icon ADB_UNMANAGED = load("studio/icons/shell/status-bar/adb-unmanaged.svg", -931275202495224616L, 2);
      /** 16x16 */ public static final @NotNull Icon LOCK = load("studio/icons/shell/status-bar/lock.svg", 838828826612792780L, 2);
      /** 16x16 */ public static final @NotNull Icon WINDOW_TOGGLE = load("studio/icons/shell/status-bar/window-toggle.svg", 1808960838448338925L, 2);
      /** 16x16 */ public static final @NotNull Icon WINDOW_TOGGLED = load("studio/icons/shell/status-bar/window-toggled.svg", -8360427489124195801L, 2);
    }

    public static final class Telemetry {
      /** 24x24 */ public static final @NotNull Icon SENTIMENT_DISSATISFIED = load("studio/icons/shell/telemetry/sentiment-dissatisfied.svg", -5297832406993908541L, 2);
      /** 16x16 */ public static final @NotNull Icon SENTIMENT_NEGATIVE = load("studio/icons/shell/telemetry/sentiment-negative.svg", -3822177325498744831L, 2);
      /** 24x24 */ public static final @NotNull Icon SENTIMENT_NEUTRAL = load("studio/icons/shell/telemetry/sentiment-neutral.svg", -3765483347954226907L, 2);
      /** 16x16 */ public static final @NotNull Icon SENTIMENT_POSITIVE = load("studio/icons/shell/telemetry/sentiment-positive.svg", 5225040686475033453L, 2);
      /** 24x24 */ public static final @NotNull Icon SENTIMENT_SATISFIED = load("studio/icons/shell/telemetry/sentiment-satisfied.svg", 2453948797583984713L, 2);
      /** 24x24 */ public static final @NotNull Icon SENTIMENT_VERY_DISSATISFIED = load("studio/icons/shell/telemetry/sentiment-very-dissatisfied.svg", -385308350251314210L, 2);
      /** 24x24 */ public static final @NotNull Icon SENTIMENT_VERY_SATISFIED = load("studio/icons/shell/telemetry/sentiment-very-satisfied.svg", 3212818039666602201L, 2);
    }

    public static final class ToolWindows {
      /** 13x13 */ public static final @NotNull Icon ANDROID_MODEL = load("studio/icons/shell/tool-windows/android-model.svg", 3105413642305715238L, 2);
      /** 13x13 */ public static final @NotNull Icon ANDROID_PREVIEW = load("studio/icons/shell/tool-windows/android-preview.svg", 1211263411936674836L, 2);
      /** 13x13 */ public static final @NotNull Icon ANDROID_PROFILER = load("studio/icons/shell/tool-windows/android-profiler.svg", 5437860435448780612L, 2);
      /** 13x13 */ public static final @NotNull Icon ASSISTANT = load("studio/icons/shell/tool-windows/assistant.svg", 7885249903887217557L, 2);
      /** 13x13 */ public static final @NotNull Icon ATTRIBUTES = load("studio/icons/shell/tool-windows/attributes.svg", -787591139451974226L, 2);
      /** 13x13 */ public static final @NotNull Icon BUILD_VARIANTS = load("studio/icons/shell/tool-windows/build-variants.svg", 2723465239372529643L, 2);
      /** 13x13 */ public static final @NotNull Icon BUILD = load("studio/icons/shell/tool-windows/build.svg", 4646877502283555958L, 2);
      /** 13x13 */ public static final @NotNull Icon CAPTURES = load("studio/icons/shell/tool-windows/captures.svg", -7443512150104460083L, 2);
      /** 13x13 */ public static final @NotNull Icon COMPONENT_TREE = load("studio/icons/shell/tool-windows/component-tree.svg", 8891043829469934027L, 2);
      /** 13x13 */ public static final @NotNull Icon DATABASE_INSPECTOR = load("studio/icons/shell/tool-windows/database-inspector.svg", 6775728072390968007L, 2);
      /** 13x13 */ public static final @NotNull Icon DEBUG = load("studio/icons/shell/tool-windows/debug.svg", 4459900335700040564L, 2);
      /** 13x13 */ public static final @NotNull Icon DEVICE_EXPLORER = load("studio/icons/shell/tool-windows/device-explorer.svg", -1875340899116918212L, 2);
      /** 13x13 */ public static final @NotNull Icon EMULATOR = load("studio/icons/shell/tool-windows/emulator.svg", 8389568884130461406L, 2);
      /** 13x13 */ public static final @NotNull Icon EVENT_LOG = load("studio/icons/shell/tool-windows/event-log.svg", 1416493895161713658L, 2);
      /** 13x13 */ public static final @NotNull Icon FAVORITES = load("studio/icons/shell/tool-windows/favorites.svg", -8737852993983395151L, 2);
      /** 13x13 */ public static final @NotNull Icon GRADLE = load("studio/icons/shell/tool-windows/gradle.svg", 5969402708449197389L, 2);
      /** 16x16 */ public static final @NotNull Icon INSPECTION = load("studio/icons/shell/tool-windows/inspection.svg", -8586974481938809590L, 2);
      /** 13x13 */ public static final @NotNull Icon LINT = load("studio/icons/shell/tool-windows/lint.svg", 2115692427898684871L, 2);
      /** 13x13 */ public static final @NotNull Icon LOGCAT = load("studio/icons/shell/tool-windows/logcat.svg", -6093538926275798567L, 2);
      /** 13x13 */ public static final @NotNull Icon MULTI_PREVIEW = load("studio/icons/shell/tool-windows/multi-preview.svg", 5330415733058102363L, 2);
      /** 13x13 */ public static final @NotNull Icon PALETTE = load("studio/icons/shell/tool-windows/palette.svg", -4854468410824278391L, 2);
      /** 13x13 */ public static final @NotNull Icon PROJECT = load("studio/icons/shell/tool-windows/project.svg", 1317925982473169742L, 2);
      /** 13x13 */ public static final @NotNull Icon RUN = load("studio/icons/shell/tool-windows/run.svg", -4205421879746176765L, 2);
      /** 13x13 */ public static final @NotNull Icon SEARCH = load("studio/icons/shell/tool-windows/search.svg", -7352613769671750787L, 2);
      /** 13x13 */ public static final @NotNull Icon STRUCTURE = load("studio/icons/shell/tool-windows/structure.svg", 6090530207153338890L, 2);
      /** 13x13 */ public static final @NotNull Icon TERMINAL = load("studio/icons/shell/tool-windows/terminal.svg", -4160681481180355351L, 2);
      /** 13x13 */ public static final @NotNull Icon TODO = load("studio/icons/shell/tool-windows/todo.svg", -8272204151906150438L, 2);
      /** 13x13 */ public static final @NotNull Icon TOGGLE_PROPERTIES = load("studio/icons/shell/tool-windows/toggle-properties.svg", -7522007823043769142L, 2);
      /** 13x13 */ public static final @NotNull Icon TOOL_WINDOW = load("studio/icons/shell/tool-windows/tool-window.svg", -1666961880254144856L, 2);
      /** 13x13 */ public static final @NotNull Icon VERSION_CONTROL = load("studio/icons/shell/tool-windows/version-control.svg", 757095299915967496L, 2);
      /** 13x13 */ public static final @NotNull Icon VISUAL_ASSETS = load("studio/icons/shell/tool-windows/visual-assets.svg", -3128022902776131193L, 2);
    }

    public static final class Toolbar {
      /** 16x16 */ public static final @NotNull Icon APPLY_ALL_CHANGES = load("studio/icons/shell/toolbar/apply-all-changes.svg", -5870806389439344281L, 2);
      /** 16x16 */ public static final @NotNull Icon APPLY_CODE_SWAP = load("studio/icons/shell/toolbar/apply-code-swap.svg", -5993307414820741969L, 2);
      /** 16x16 */ public static final @NotNull Icon ATTACH_DEBUGGER = load("studio/icons/shell/toolbar/attach-debugger.svg", -7247215501019191967L, 2);
      /** 16x16 */ public static final @NotNull Icon BUILD = load("studio/icons/shell/toolbar/build.svg", -7988951020995812589L, 2);
      /** 16x16 */ public static final @NotNull Icon DEBUG = load("studio/icons/shell/toolbar/debug.svg", 3795714837180522076L, 2);
      /** 16x16 */ public static final @NotNull Icon DEVICE_MANAGER = load("studio/icons/shell/toolbar/device-manager.svg", -9153566041703739763L, 2);
      /** 16x16 */ public static final @NotNull Icon GRADLE_SYNC = load("studio/icons/shell/toolbar/gradle-sync.svg", 4195698423798966675L, 2);
      /** 16x16 */ public static final @NotNull Icon INSTANT_RUN = load("studio/icons/shell/toolbar/instant-run.svg", -7128428532509879697L, 2);
      /** 16x16 */ public static final @NotNull Icon PROFILER = load("studio/icons/shell/toolbar/profiler.svg", -3533137939583288778L, 2);
      /** 16x16 */ public static final @NotNull Icon PROJECT_STRUCTURE = load("studio/icons/shell/toolbar/project-structure.svg", 2035313859943448482L, 2);
      /** 16x16 */ public static final @NotNull Icon RUN_WITH_COVERAGE = load("studio/icons/shell/toolbar/run-with-coverage.svg", -70217462564568903L, 2);
      /** 16x16 */ public static final @NotNull Icon RUN = load("studio/icons/shell/toolbar/run.svg", 315030659650671846L, 2);
      /** 16x16 */ public static final @NotNull Icon SDK_MANAGER = load("studio/icons/shell/toolbar/sdk-manager.svg", -672387422563045584L, 2);
      /** 16x16 */ public static final @NotNull Icon SEARCH = load("studio/icons/shell/toolbar/search.svg", -7883409931600775129L, 2);
      /** 16x16 */ public static final @NotNull Icon STOP = load("studio/icons/shell/toolbar/stop.svg", -216498989436263185L, 2);
      /** 16x16 */ public static final @NotNull Icon USER_PROFILE_ACTIVE = load("studio/icons/shell/toolbar/user-profile-active.svg", 105514235442856842L, 2);
      /** 16x16 */ public static final @NotNull Icon USER_PROFILE = load("studio/icons/shell/toolbar/user-profile.svg", 8757161221281122299L, 2);
    }
  }

  public static final class Test {
    /** 16x16 */ public static final @NotNull Icon RECORD_ESPRESSO_TEST = load("studio/icons/test/record-espresso-test.svg", -5735679820649522903L, 2);
  }
}
