/*
 * Copyright 2005 Sascha Weinreuter
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.intellij.lang.xpath;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import icons.XpathIcons;
import org.jetbrains.annotations.NotNull;

import javax.swing.*;

public final class XPathFileType extends LanguageFileType {

    public static final XPathFileType XPATH = new XPathFileType(new XPathLanguage());
    public static final XPathFileType XPATH2 = new XPathFileType(new XPath2Language());

    private XPathFileType(Language language) {
        super(language);
    }

    @Override
    @NotNull
    @NlsSafe
    public String getName() {
        return getLanguage().getID();
    }

    @Override
    @NotNull
    public String getDescription() {
        return getName();
    }

    @Override
    @NotNull
    public String getDefaultExtension() {
        return StringUtil.toLowerCase(getLanguage().getID());
    }

    @Override
    public Icon getIcon() {
        return XpathIcons.Xpath;
    }
}
