/*
 * Copyright 2000-2010 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jetbrains.android.dom.manifest;

import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.Convert;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.converters.ApiVersionConverter;

public interface UsesSdk extends ManifestElementWithName {
  @Attribute("minSdkVersion")
  @Convert(ApiVersionConverter.class)
  AndroidAttributeValue<String> getMinSdkVersion();

  @Attribute("targetSdkVersion")
  @Convert(ApiVersionConverter.class)
  AndroidAttributeValue<String> getTargetSdkVersion();

  @Attribute("maxSdkVersion")
  @Convert(ApiVersionConverter.class)
  AndroidAttributeValue<String> getMaxSdkVersion();
}
