// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.presentation.Presentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.*;

public class PresentationAnnotationInspection extends DevKitUastInspectionBase {

  public PresentationAnnotationInspection() {
    super(UClass.class);
  }

  @Override
  public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
    final UAnnotation annotation = aClass.findAnnotation(Presentation.class.getCanonicalName());
    if (annotation == null) {
      return null;
    }

    UExpression iconExpression = annotation.findDeclaredAttributeValue("icon");
    if (!(iconExpression instanceof ULiteralExpression)) {
      return null;
    }

    PsiElement iconExpressionPsi = UastLiteralUtils.getPsiLanguageInjectionHost((ULiteralExpression)iconExpression);
    if (iconExpressionPsi == null) {
      return null;
    }

    ProblemsHolder holder = new ProblemsHolder(manager, iconExpressionPsi.getContainingFile(), isOnTheFly);
    PsiReference[] references = iconExpressionPsi.getReferences();
    for (PsiReference reference : references) {
      if (reference.resolve() == null) {
        holder.registerProblem(reference);
      }
    }
    return holder.getResultsArray();
  }
}
