// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package org.jetbrains.idea.devkit.themes;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import org.jetbrains.annotations.NotNull;

/**
 * @author Konstantin Bulenkov
 */
public class EditThemeEditorColorSchemeAction extends DumbAwareAction {
  @Override
  public void actionPerformed(@NotNull AnActionEvent e) {
    if (ApplyThemeAction.applyTempTheme(e)) {
      EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
      if (EditorColorsManagerImpl.isTempScheme(scheme)) {
        Configurable[] configurables = new ColorAndFontOptions().getConfigurables();
        ApplicationManager.getApplication().invokeLater(() ->
          ShowSettingsUtil.getInstance().showSettingsDialog(e.getProject(), configurables[0].getClass())
        );
      }
    }
  }
}
