/*
 * Copyright 2000-2010 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jetbrains.idea.svn.history;

import com.google.common.base.MoreObjects;

public class CopyData {
  private final long myCopySourceRevision;
  private final long myCopyTargetRevision;
  private final boolean myTrunkSupposedCorrect;

  public CopyData(long copySourceRevision, long copyTargetRevision, boolean trunkSupposedCorrect) {
    myCopySourceRevision = copySourceRevision;
    myCopyTargetRevision = copyTargetRevision;
    myTrunkSupposedCorrect = trunkSupposedCorrect;
  }

  public long getCopySourceRevision() {
    return myCopySourceRevision;
  }

  public long getCopyTargetRevision() {
    return myCopyTargetRevision;
  }

  public boolean isTrunkSupposedCorrect() {
    return myTrunkSupposedCorrect;
  }

  @Override
  public String toString() {
    return MoreObjects.toStringHelper(this)
      .add("source", myCopySourceRevision)
      .add("target", myCopyTargetRevision)
      .add("correct", myTrunkSupposedCorrect)
      .toString();
  }
}
