// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package org.jetbrains.jps.builders;

import com.intellij.openapi.util.io.FileFilters;
import org.jetbrains.annotations.NotNull;

import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.Set;

/**
 * Describes a source root of a build target.
 */
public abstract class BuildRootDescriptor {
  /**
   * Returns the serializable ID of the root, used for writing caches. May return simply the file path.
   */
  public abstract String getRootId();

  /**
   * Returns the directory of the source root.
   */
  public abstract File getRootFile();

  /**
   * Returns the target to which this source root belongs.
   */
  public abstract BuildTarget<?> getTarget();

  /**
   * Creates the file filter specifying which files under the specified root belong to this build target.
   */
  public @NotNull FileFilter createFileFilter() {
    return FileFilters.EVERYTHING;
  }

  /**
   * @return the set of excluded directories under this root.
   */
  public @NotNull Set<File> getExcludedRoots() {
    return Collections.emptySet();
  }

  /**
   * Returns {@code true} if the whole content of this source root was automatically generated by the JPS build process.
   */
  public boolean isGenerated() {
    return false;
  }

  public boolean canUseFileCache() {
    return false;
  }
}
