// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package org.jetbrains.plugins.github.pullrequest

import com.intellij.icons.AllIcons
import com.intellij.ide.FileIconProvider
import com.intellij.openapi.project.Project
import com.intellij.openapi.vfs.VirtualFile
import javax.swing.Icon

class GHPRVirtualFileIconProvider : FileIconProvider {

  override fun getIcon(file: VirtualFile, flags: Int, project: Project?): Icon? {
    return when (file) {
      is GHNewPRDiffVirtualFile -> AllIcons.Actions.Diff
      is GHPRTimelineVirtualFile -> file.getIcon()
      is GHPRDiffVirtualFile -> AllIcons.Actions.Diff
      else -> null
    }
  }
}