/*
 * Copyright 2007-2008 Dave Griffith
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;

public abstract class GroovyMethodMetricInspection extends BaseInspection {

  public int m_limit;

  public GroovyMethodMetricInspection(int defaultLimit) {
    m_limit = defaultLimit;
  }

  protected int getLimit() {
    return m_limit;
  }
}
