// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.

/* The following code was generated by JFlex 1.7.0 tweaked for IntelliJ platform */

package org.jetbrains.plugins.groovy.lang.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import static org.jetbrains.plugins.groovy.lang.groovydoc.parser.GroovyDocElementTypes.*;
import static org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes.*;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.7.0
 * from the specification file <tt>groovy.flex</tt>
 */
public class _GroovyLexer extends GroovyLexerBase implements FlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int IN_INJECTION = 2;
  public static final int IN_INJECTION_BRACES = 4;
  public static final int DIVISION_EXPECTED = 6;
  public static final int IN_TRIPLE_STRING = 8;
  public static final int IN_SINGLE_GSTRING = 10;
  public static final int IN_TRIPLE_GSTRING = 12;
  public static final int IN_SLASHY_STRING = 14;
  public static final int IN_DOLLAR_SLASH_STRING = 16;
  public static final int IN_GSTRING_DOLLAR = 18;
  public static final int IN_GSTRING_DOT = 20;
  public static final int IN_GSTRING_DOT_IDENT = 22;
  public static final int NLS_AFTER_LBRACE = 24;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12
  };

  /** 
   * Translates characters to character classes
   * Chosen bits are [11, 6, 4]
   * Total runtime size is 14112 bytes
   */
  public static int ZZ_CMAP(int ch) {
    return ZZ_CMAP_A[(ZZ_CMAP_Y[(ZZ_CMAP_Z[ch>>10]<<6)|((ch>>4)&0x3f)]<<4)|(ch&0xf)];
  }

  /* The ZZ_CMAP_Z table has 1088 entries */
  static final char ZZ_CMAP_Z[] = zzUnpackCMap(
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7\1\10\2\11\1\12\1\13\6\14\1\15\23\14\1\16"+
    "\1\14\1\17\1\20\12\14\1\21\10\11\1\22\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1"+
    "\32\1\33\1\34\1\35\2\11\1\14\1\36\3\11\1\37\10\11\1\40\1\41\5\14\1\42\1\43"+
    "\11\11\1\44\2\11\1\45\5\11\1\46\4\11\1\47\1\50\4\11\51\14\1\51\3\14\1\52\1"+
    "\53\4\14\1\54\12\11\1\55\u0381\11");

  /* The ZZ_CMAP_Y table has 2944 entries */
  static final char ZZ_CMAP_Y[] = zzUnpackCMap(
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\1\1\11\1\12\1\13\1\14\1\13\1\14\34"+
    "\13\1\15\1\16\1\17\10\1\1\20\1\21\1\13\1\22\4\13\1\23\10\13\1\24\12\13\1\25"+
    "\1\13\1\26\1\25\1\13\1\27\4\1\1\13\1\30\1\31\2\1\2\13\1\30\1\1\1\32\1\25\5"+
    "\13\1\33\1\34\1\35\1\1\1\36\1\13\1\1\1\37\5\13\1\40\1\41\1\42\1\13\1\30\1"+
    "\43\1\13\1\44\1\45\1\1\1\13\1\46\4\1\1\13\1\47\4\1\1\50\2\13\1\51\1\1\1\52"+
    "\1\16\1\25\1\53\1\54\1\55\1\56\1\57\1\60\2\16\1\61\1\54\1\55\1\62\1\1\1\63"+
    "\1\1\1\64\1\65\1\22\1\55\1\66\1\1\1\67\1\16\1\70\1\71\1\54\1\55\1\66\1\1\1"+
    "\60\1\16\1\41\1\72\1\73\1\74\1\75\1\1\1\67\2\1\1\76\1\36\1\55\1\51\1\1\1\77"+
    "\1\16\1\1\1\100\1\36\1\55\1\101\1\1\1\57\1\16\1\102\1\76\1\36\1\13\1\103\1"+
    "\57\1\104\1\16\1\42\1\105\1\106\1\13\1\107\1\110\3\1\1\25\2\13\1\111\1\110"+
    "\3\1\1\112\1\113\1\114\1\115\1\116\1\117\2\1\1\67\3\1\1\120\1\13\1\121\1\1"+
    "\1\122\7\1\2\13\1\30\1\123\1\1\1\124\1\125\1\126\1\127\1\1\2\13\1\130\2\13"+
    "\1\131\24\13\1\132\1\133\2\13\1\132\2\13\1\134\1\135\1\14\3\13\1\135\3\13"+
    "\1\30\2\1\1\13\1\1\5\13\1\136\1\25\45\13\1\137\1\13\1\25\1\30\4\13\1\30\1"+
    "\140\1\141\1\16\1\13\1\16\1\13\1\16\1\141\1\67\3\13\1\142\1\1\1\143\4\1\5"+
    "\13\1\27\1\144\1\13\1\145\4\13\1\40\1\13\1\146\3\1\1\13\1\147\1\150\2\13\1"+
    "\151\1\13\1\75\3\1\1\13\1\110\3\13\1\150\4\1\1\152\5\1\1\105\2\13\1\142\1"+
    "\153\3\1\1\154\1\13\1\155\1\42\2\13\1\40\1\1\2\13\1\142\1\1\1\37\1\42\1\13"+
    "\1\147\1\46\5\1\1\156\1\157\14\13\4\1\21\13\1\136\2\13\1\136\1\160\1\13\1"+
    "\147\3\13\1\161\1\162\1\163\1\121\1\162\2\1\1\164\4\1\1\165\1\1\1\121\6\1"+
    "\1\166\1\167\1\170\1\171\1\172\3\1\1\173\147\1\2\13\1\146\2\13\1\146\10\13"+
    "\1\174\1\175\2\13\1\130\3\13\1\176\1\1\1\13\1\110\4\177\4\1\1\123\35\1\1\200"+
    "\2\1\1\201\1\25\4\13\1\202\1\25\4\13\1\131\1\105\1\13\1\147\1\25\4\13\1\146"+
    "\1\1\1\13\1\30\3\1\1\13\40\1\133\13\1\40\4\1\135\13\1\40\2\1\10\13\1\121\4"+
    "\1\2\13\1\147\20\13\1\121\1\13\1\203\1\1\2\13\1\146\1\123\1\13\1\147\4\13"+
    "\1\40\2\1\1\204\1\205\5\13\1\206\1\13\1\146\1\27\3\1\1\204\1\207\1\13\1\31"+
    "\1\1\3\13\1\142\1\205\2\13\1\142\3\1\1\210\1\42\1\13\1\40\1\13\1\110\1\1\1"+
    "\13\1\121\1\50\2\13\1\31\1\123\1\1\1\211\1\212\2\13\1\46\1\1\1\213\1\1\1\13"+
    "\1\214\3\13\1\215\1\216\1\217\1\30\1\64\1\220\1\221\1\177\2\13\1\131\1\40"+
    "\7\13\1\31\1\1\72\13\1\142\1\13\1\222\2\13\1\151\20\1\26\13\1\147\6\13\1\75"+
    "\2\1\1\110\1\223\1\55\1\224\1\225\6\13\1\16\1\1\1\154\25\13\1\147\1\1\4\13"+
    "\1\205\2\13\1\27\2\1\1\151\7\1\1\211\7\13\1\121\2\1\1\25\1\30\1\25\1\30\1"+
    "\226\4\13\1\146\1\227\1\230\2\1\1\231\1\13\1\14\1\232\2\147\2\1\7\13\1\30"+
    "\30\1\1\13\1\121\3\13\1\67\2\1\2\13\1\1\1\13\1\233\2\13\1\40\1\13\1\147\2"+
    "\13\1\234\3\1\11\13\1\147\1\1\2\13\1\234\1\13\1\151\2\13\1\27\3\13\1\142\11"+
    "\1\23\13\1\110\1\13\1\40\1\27\11\1\1\235\2\13\1\236\1\13\1\40\1\13\1\110\1"+
    "\13\1\146\4\1\1\13\1\237\1\13\1\40\1\13\1\75\4\1\3\13\1\240\4\1\1\67\1\241"+
    "\1\13\1\142\2\1\1\13\1\121\1\13\1\121\2\1\1\120\1\13\1\150\1\1\3\13\1\40\1"+
    "\13\1\40\1\13\1\31\1\13\1\16\6\1\4\13\1\46\3\1\3\13\1\31\3\13\1\31\60\1\1"+
    "\154\2\13\1\27\4\1\1\154\2\13\2\1\1\13\1\46\1\1\1\154\1\13\1\110\2\1\2\13"+
    "\1\242\1\154\2\13\1\31\1\243\1\244\2\1\1\13\1\22\1\151\5\1\1\245\1\246\1\46"+
    "\2\13\1\146\2\1\1\71\1\54\1\55\1\66\1\1\1\247\1\16\11\1\3\13\1\150\1\250\3"+
    "\1\3\13\1\1\1\251\13\1\2\13\1\146\2\1\1\252\2\1\3\13\1\1\1\253\3\1\2\13\1"+
    "\30\5\1\1\13\1\75\30\1\4\13\1\1\1\123\34\1\3\13\1\46\20\1\1\55\1\13\1\146"+
    "\1\1\1\67\2\1\1\205\1\13\67\1\71\13\1\75\16\1\14\13\1\142\53\1\2\13\1\146"+
    "\75\1\44\13\1\110\33\1\43\13\1\46\1\13\1\146\7\1\1\13\1\147\1\1\3\13\1\1\1"+
    "\142\1\1\1\154\1\254\1\13\67\1\4\13\1\150\1\67\3\1\1\154\4\1\1\67\1\1\76\13"+
    "\1\121\1\1\57\13\1\31\20\1\1\16\77\1\6\13\1\30\1\121\1\46\1\75\66\1\5\13\1"+
    "\211\3\13\1\141\1\255\1\256\1\257\3\13\1\260\1\261\1\13\1\262\1\263\1\36\24"+
    "\13\1\264\1\13\1\36\1\131\1\13\1\131\1\13\1\211\1\13\1\211\1\146\1\13\1\146"+
    "\1\13\1\55\1\13\1\55\1\13\1\213\3\1\14\13\1\150\3\1\4\13\1\142\113\1\1\257"+
    "\1\13\1\265\1\266\1\267\1\270\1\271\1\272\1\273\1\151\1\274\1\151\24\1\55"+
    "\13\1\110\2\1\103\13\1\150\15\13\1\147\150\13\1\16\25\1\41\13\1\147\36\1");

  /* The ZZ_CMAP_A table has 3024 entries */
  static final char ZZ_CMAP_A[] = zzUnpackCMap(
    "\11\0\1\4\1\2\1\1\1\5\1\3\22\0\1\4\1\12\1\46\1\11\1\44\1\104\1\107\1\45\1"+
    "\70\1\71\1\10\1\31\1\100\1\32\1\42\1\7\1\34\1\37\10\14\1\77\1\110\1\101\1"+
    "\75\1\102\1\76\1\111\1\13\1\36\1\13\1\26\1\30\1\20\1\16\1\43\1\24\2\43\1\22"+
    "\13\43\1\41\2\43\1\72\1\6\1\73\1\105\1\33\1\0\1\50\1\35\1\51\1\25\1\27\1\17"+
    "\1\15\1\64\1\23\1\43\1\52\1\21\1\56\1\61\1\57\1\47\1\43\1\55\1\53\1\54\1\62"+
    "\1\60\1\66\1\40\1\63\1\65\1\67\1\106\1\74\1\103\6\0\1\1\24\0\1\43\12\0\1\43"+
    "\4\0\1\43\5\0\27\43\1\0\12\43\4\0\14\43\16\0\5\43\7\0\1\43\1\0\1\43\1\0\5"+
    "\43\1\0\2\43\2\0\4\43\1\0\1\43\6\0\1\43\1\0\3\43\1\0\1\43\1\0\4\43\1\0\23"+
    "\43\1\0\13\43\10\0\6\43\1\0\26\43\2\0\1\43\6\0\10\43\10\0\13\43\5\0\3\43\33"+
    "\0\6\43\1\0\1\43\17\0\2\43\7\0\2\43\12\0\3\43\2\0\2\43\1\0\16\43\15\0\11\43"+
    "\13\0\1\43\30\0\6\43\4\0\2\43\4\0\1\43\5\0\6\43\4\0\1\43\11\0\1\43\3\0\1\43"+
    "\7\0\11\43\7\0\5\43\1\0\10\43\6\0\26\43\3\0\1\43\2\0\1\43\7\0\11\43\4\0\10"+
    "\43\2\0\2\43\2\0\26\43\1\0\7\43\1\0\1\43\3\0\4\43\3\0\1\43\20\0\1\43\15\0"+
    "\2\43\1\0\1\43\5\0\6\43\4\0\2\43\1\0\2\43\1\0\2\43\1\0\2\43\17\0\4\43\1\0"+
    "\1\43\3\0\3\43\20\0\11\43\1\0\2\43\1\0\2\43\1\0\5\43\3\0\1\43\2\0\1\43\30"+
    "\0\1\43\13\0\10\43\2\0\1\43\3\0\1\43\1\0\6\43\3\0\3\43\1\0\4\43\3\0\2\43\1"+
    "\0\1\43\1\0\2\43\3\0\2\43\3\0\3\43\3\0\14\43\13\0\10\43\1\0\2\43\10\0\3\43"+
    "\5\0\1\43\4\0\10\43\1\0\6\43\1\0\5\43\3\0\1\43\3\0\2\43\15\0\13\43\2\0\1\43"+
    "\6\0\3\43\10\0\1\43\5\0\22\43\3\0\10\43\1\0\11\43\1\0\1\43\2\0\7\43\11\0\1"+
    "\43\1\0\2\43\15\0\2\43\1\0\1\43\2\0\2\43\1\0\1\43\2\0\1\43\6\0\4\43\1\0\7"+
    "\43\1\0\3\43\1\0\1\43\1\0\1\43\2\0\2\43\1\0\4\43\1\0\2\43\11\0\1\43\2\0\5"+
    "\43\1\0\1\43\25\0\14\43\1\0\24\43\13\0\5\43\22\0\7\43\4\0\4\43\3\0\1\43\3"+
    "\0\2\43\7\0\3\43\4\0\15\43\14\0\1\43\1\0\6\43\1\0\1\43\5\0\1\43\2\0\13\43"+
    "\1\0\15\43\1\0\4\43\2\0\7\43\1\0\1\43\1\0\4\43\2\0\1\43\1\0\4\43\2\0\7\43"+
    "\1\0\1\43\1\0\4\43\2\0\16\43\2\0\6\43\2\0\15\43\2\0\1\43\1\0\10\43\7\0\15"+
    "\43\1\0\6\43\23\0\1\43\4\0\1\43\3\0\5\43\2\0\22\43\1\0\1\43\5\0\17\43\1\0"+
    "\16\43\2\0\5\43\13\0\14\43\13\0\1\43\15\0\7\43\7\0\16\43\15\0\2\43\11\0\4"+
    "\43\1\0\4\43\3\0\2\43\11\0\10\43\1\0\1\43\1\0\1\43\1\0\1\43\1\0\6\43\1\0\7"+
    "\43\1\0\1\43\3\0\3\43\1\0\7\43\3\0\4\43\2\0\6\43\14\0\2\1\7\0\1\43\15\0\1"+
    "\43\2\0\1\43\4\0\1\43\2\0\12\43\1\0\1\43\3\0\5\43\6\0\1\43\1\0\1\43\1\0\1"+
    "\43\1\0\4\43\1\0\13\43\2\0\4\43\5\0\5\43\4\0\1\43\4\0\2\43\13\0\5\43\6\0\4"+
    "\43\3\0\2\43\14\0\10\43\7\0\10\43\1\0\7\43\6\0\2\43\12\0\5\43\5\0\2\43\3\0"+
    "\7\43\6\0\3\43\12\0\2\43\13\0\11\43\2\0\27\43\2\0\7\43\1\0\3\43\1\0\4\43\1"+
    "\0\4\43\2\0\6\43\3\0\1\43\1\0\1\43\2\0\5\43\1\0\12\43\12\0\5\43\1\0\3\43\1"+
    "\0\10\43\4\0\7\43\3\0\1\43\3\0\2\43\1\0\1\43\3\0\2\43\2\0\5\43\2\0\1\43\1"+
    "\0\1\43\30\0\3\43\3\0\6\43\2\0\6\43\2\0\6\43\11\0\7\43\4\0\5\43\3\0\5\43\5"+
    "\0\1\43\1\0\10\43\1\0\5\43\1\0\1\43\1\0\2\43\1\0\2\43\1\0\12\43\6\0\12\43"+
    "\2\0\6\43\2\0\6\43\2\0\6\43\2\0\3\43\3\0\14\43\1\0\16\43\1\0\2\43\1\0\2\43"+
    "\1\0\10\43\6\0\4\43\4\0\16\43\2\0\1\43\1\0\14\43\1\0\2\43\3\0\1\43\2\0\4\43"+
    "\1\0\2\43\12\0\10\43\6\0\6\43\1\0\3\43\1\0\12\43\3\0\1\43\12\0\4\43\25\0\1"+
    "\43\1\0\1\43\3\0\7\43\1\0\1\43\1\0\4\43\1\0\17\43\1\0\2\43\14\0\3\43\7\0\4"+
    "\43\11\0\2\43\1\0\1\43\20\0\4\43\10\0\1\43\13\0\10\43\5\0\3\43\2\0\1\43\2"+
    "\0\2\43\2\0\4\43\1\0\14\43\1\0\1\43\1\0\7\43\1\0\21\43\1\0\4\43\2\0\10\43"+
    "\1\0\7\43\1\0\14\43\1\0\4\43\1\0\5\43\1\0\1\43\3\0\14\43\2\0\10\43\1\0\2\43"+
    "\1\0\1\43\2\0\1\43\1\0\12\43\1\0\4\43\1\0\1\43\1\0\1\43\6\0\1\43\4\0\1\43"+
    "\1\0\1\43\1\0\1\43\1\0\3\43\1\0\2\43\1\0\1\43\2\0\1\43\1\0\1\43\1\0\1\43\1"+
    "\0\1\43\1\0\1\43\1\0\2\43\1\0\1\43\2\0\4\43\1\0\7\43\1\0\4\43\1\0\4\43\1\0"+
    "\1\43\1\0\12\43\1\0\5\43\1\0\3\43\1\0\5\43\1\0\5\43");

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\15\0\1\1\1\2\2\3\1\1\1\4\1\5\1\1"+
    "\1\6\1\7\1\10\5\7\1\11\1\12\1\10\1\7"+
    "\1\13\1\7\1\14\1\15\11\7\1\16\1\17\1\20"+
    "\1\21\1\22\1\23\1\24\1\25\1\26\1\27\1\30"+
    "\1\31\1\32\1\33\1\34\1\35\1\36\1\37\1\40"+
    "\1\41\1\42\1\43\2\44\1\45\1\44\3\46\1\47"+
    "\1\50\1\47\1\51\1\52\3\47\2\53\1\54\1\51"+
    "\2\55\1\51\1\56\20\57\1\60\2\61\1\62\1\63"+
    "\1\3\1\63\1\0\1\3\1\64\1\65\1\66\1\67"+
    "\1\70\1\71\1\0\1\72\1\73\1\74\1\75\1\10"+
    "\1\76\3\0\5\7\1\77\1\7\1\100\1\7\1\101"+
    "\3\7\1\102\1\103\1\104\1\105\1\106\2\0\3\7"+
    "\1\107\1\110\1\111\1\14\1\0\1\14\2\0\1\112"+
    "\4\7\1\113\22\7\1\114\1\115\1\116\1\117\1\120"+
    "\1\121\1\122\1\0\1\123\1\0\1\124\1\125\1\126"+
    "\1\127\1\130\1\131\1\132\1\133\1\134\1\0\4\47"+
    "\1\53\1\135\1\136\1\137\1\55\5\57\1\77\1\57"+
    "\1\100\1\57\1\101\12\57\1\113\22\57\1\140\1\0"+
    "\1\65\1\141\1\142\1\0\1\143\1\144\1\0\1\144"+
    "\3\7\1\145\3\7\1\146\1\147\4\7\2\10\3\7"+
    "\1\150\1\151\3\14\1\152\1\112\2\0\1\153\23\7"+
    "\1\154\3\7\1\155\2\7\1\156\3\7\1\157\1\160"+
    "\1\161\1\162\1\163\1\0\1\164\3\0\1\165\3\57"+
    "\1\145\3\57\1\146\1\147\32\57\1\154\3\57\1\155"+
    "\2\57\1\156\3\57\1\65\2\141\1\166\1\0\1\144"+
    "\1\0\3\7\1\167\6\7\1\170\1\7\1\171\2\0"+
    "\2\7\1\172\11\0\7\7\1\173\2\7\1\174\10\7"+
    "\1\175\1\176\3\7\1\177\1\7\1\200\1\7\1\201"+
    "\3\57\1\167\6\57\1\170\1\57\1\171\2\57\1\172"+
    "\7\57\1\173\2\57\1\174\10\57\1\175\1\176\3\57"+
    "\1\177\1\57\1\200\1\57\1\65\1\0\1\141\1\0"+
    "\1\202\1\203\1\204\7\7\1\205\1\7\1\14\4\0"+
    "\6\7\1\206\1\207\3\7\1\210\1\7\1\211\1\7"+
    "\1\212\1\7\1\213\3\7\1\214\1\202\1\203\1\204"+
    "\7\57\1\205\7\57\1\206\1\207\3\57\1\210\1\57"+
    "\1\211\1\57\1\212\1\57\1\213\3\57\1\214\2\0"+
    "\2\7\1\215\3\7\1\216\2\7\1\217\3\7\1\220"+
    "\1\7\1\221\1\7\1\222\2\7\1\223\1\7\1\224"+
    "\1\225\1\7\1\226\2\57\1\215\3\57\1\216\5\57"+
    "\1\220\1\57\1\221\1\57\1\222\2\57\1\223\1\57"+
    "\1\224\1\225\1\57\1\226\1\0\1\227\3\7\1\230"+
    "\1\231\1\232\1\233\1\234\7\7\1\227\3\57\1\230"+
    "\1\231\1\232\1\233\1\234\7\57\1\0\4\7\1\235"+
    "\1\236\1\237\2\7\1\240\4\57\1\235\1\236\1\237"+
    "\2\57\1\240\1\0\2\7\1\241\1\242\1\7\1\243"+
    "\2\57\1\241\1\242\1\57\1\243\1\0\1\244\1\245"+
    "\1\7\1\244\1\245\1\57\1\0\1\7\1\57\1\246"+
    "\2\247";

  private static int [] zzUnpackAction() {
    int [] result = new int[697];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\112\0\224\0\336\0\u0128\0\u0172\0\u01bc\0\u0206"+
    "\0\u0250\0\u029a\0\u02e4\0\u032e\0\u0378\0\u03c2\0\u040c\0\u03c2"+
    "\0\u040c\0\u0456\0\u04a0\0\u04ea\0\u0534\0\u057e\0\u05c8\0\u0612"+
    "\0\u065c\0\u06a6\0\u06f0\0\u073a\0\u0784\0\u07ce\0\u0818\0\u0862"+
    "\0\u08ac\0\u08f6\0\u0940\0\u098a\0\u09d4\0\u0a1e\0\u0a68\0\u0ab2"+
    "\0\u0afc\0\u0b46\0\u0b90\0\u0bda\0\u0c24\0\u0c6e\0\u03c2\0\u03c2"+
    "\0\u03c2\0\u03c2\0\u03c2\0\u03c2\0\u0cb8\0\u0d02\0\u0d4c\0\u03c2"+
    "\0\u0d96\0\u0de0\0\u03c2\0\u0e2a\0\u0e74\0\u0ebe\0\u0f08\0\u03c2"+
    "\0\u03c2\0\u03c2\0\u03c2\0\u03c2\0\u03c2\0\u0456\0\u0f52\0\u0f9c"+
    "\0\u03c2\0\u0fe6\0\u1030\0\u107a\0\u03c2\0\u10c4\0\u03c2\0\u03c2"+
    "\0\u110e\0\u1158\0\u11a2\0\u11ec\0\u1236\0\u03c2\0\u1280\0\u12ca"+
    "\0\u1314\0\u135e\0\u03c2\0\u13a8\0\u13f2\0\u143c\0\u1486\0\u14d0"+
    "\0\u151a\0\u1564\0\u15ae\0\u15f8\0\u1642\0\u168c\0\u16d6\0\u1720"+
    "\0\u176a\0\u17b4\0\u17fe\0\u03c2\0\u03c2\0\u1848\0\u03c2\0\u03c2"+
    "\0\u1892\0\u18dc\0\u1926\0\u1970\0\u19ba\0\u1a04\0\u1a4e\0\u03c2"+
    "\0\u03c2\0\u1a98\0\u1ae2\0\u1b2c\0\u03c2\0\u03c2\0\u03c2\0\u03c2"+
    "\0\u03c2\0\u1b76\0\u1bc0\0\u1c0a\0\u1c54\0\u1c9e\0\u1ce8\0\u1d32"+
    "\0\u1d7c\0\u05c8\0\u1dc6\0\u1e10\0\u1e5a\0\u1ea4\0\u1eee\0\u1f38"+
    "\0\u1f82\0\u03c2\0\u03c2\0\u03c2\0\u03c2\0\u03c2\0\u1fcc\0\u2016"+
    "\0\u2060\0\u20aa\0\u20f4\0\u213e\0\u03c2\0\u03c2\0\u2188\0\u21d2"+
    "\0\u221c\0\u2266\0\u22b0\0\u22fa\0\u2344\0\u238e\0\u23d8\0\u2422"+
    "\0\u246c\0\u24b6\0\u2500\0\u254a\0\u2594\0\u25de\0\u2628\0\u2672"+
    "\0\u26bc\0\u2706\0\u2750\0\u279a\0\u27e4\0\u282e\0\u2878\0\u28c2"+
    "\0\u290c\0\u2956\0\u29a0\0\u29ea\0\u03c2\0\u03c2\0\u03c2\0\u03c2"+
    "\0\u03c2\0\u2a34\0\u2a7e\0\u03c2\0\u2ac8\0\u03c2\0\u03c2\0\u03c2"+
    "\0\u03c2\0\u03c2\0\u03c2\0\u03c2\0\u03c2\0\u03c2\0\u2b12\0\u03c2"+
    "\0\u2b5c\0\u2ba6\0\u2bf0\0\u03c2\0\u03c2\0\u03c2\0\u03c2\0\u03c2"+
    "\0\u2c3a\0\u2c84\0\u2cce\0\u2d18\0\u2d62\0\u13a8\0\u2dac\0\u2df6"+
    "\0\u2e40\0\u2e8a\0\u2ed4\0\u2f1e\0\u2f68\0\u2fb2\0\u2ffc\0\u3046"+
    "\0\u3090\0\u30da\0\u3124\0\u316e\0\u31b8\0\u3202\0\u324c\0\u3296"+
    "\0\u32e0\0\u332a\0\u3374\0\u33be\0\u3408\0\u3452\0\u349c\0\u34e6"+
    "\0\u3530\0\u357a\0\u35c4\0\u360e\0\u3658\0\u36a2\0\u36ec\0\u3736"+
    "\0\u18dc\0\u3780\0\u37ca\0\u03c2\0\u3814\0\u03c2\0\u385e\0\u38a8"+
    "\0\u38f2\0\u393c\0\u3986\0\u39d0\0\u05c8\0\u3a1a\0\u3a64\0\u3aae"+
    "\0\u3af8\0\u3b42\0\u3b8c\0\u3bd6\0\u3c20\0\u3c6a\0\u3cb4\0\u3cfe"+
    "\0\u3d48\0\u3d92\0\u3ddc\0\u03c2\0\u03c2\0\u03c2\0\u3e26\0\u3e70"+
    "\0\u03c2\0\u03c2\0\u3eba\0\u3f04\0\u3f4e\0\u3f98\0\u3fe2\0\u402c"+
    "\0\u4076\0\u40c0\0\u410a\0\u4154\0\u419e\0\u41e8\0\u4232\0\u427c"+
    "\0\u42c6\0\u4310\0\u435a\0\u43a4\0\u43ee\0\u4438\0\u4482\0\u44cc"+
    "\0\u05c8\0\u4516\0\u4560\0\u45aa\0\u05c8\0\u45f4\0\u463e\0\u05c8"+
    "\0\u4688\0\u46d2\0\u471c\0\u03c2\0\u03c2\0\u03c2\0\u03c2\0\u03c2"+
    "\0\u4766\0\u03c2\0\u2b5c\0\u2ba6\0\u47b0\0\u03c2\0\u47fa\0\u4844"+
    "\0\u488e\0\u13a8\0\u48d8\0\u4922\0\u496c\0\u49b6\0\u4a00\0\u4a4a"+
    "\0\u4a94\0\u4ade\0\u4b28\0\u4b72\0\u4bbc\0\u4c06\0\u4c50\0\u4c9a"+
    "\0\u4ce4\0\u4d2e\0\u4d78\0\u4dc2\0\u4e0c\0\u4e56\0\u4ea0\0\u4eea"+
    "\0\u4f34\0\u4f7e\0\u4fc8\0\u5012\0\u505c\0\u50a6\0\u50f0\0\u513a"+
    "\0\u5184\0\u13a8\0\u51ce\0\u5218\0\u5262\0\u13a8\0\u52ac\0\u52f6"+
    "\0\u13a8\0\u5340\0\u538a\0\u53d4\0\u541e\0\u5468\0\u03c2\0\u03c2"+
    "\0\u54b2\0\u03c2\0\u54fc\0\u5546\0\u5590\0\u55da\0\u05c8\0\u5624"+
    "\0\u566e\0\u56b8\0\u5702\0\u574c\0\u5796\0\u05c8\0\u57e0\0\u05c8"+
    "\0\u582a\0\u5874\0\u58be\0\u5908\0\u05c8\0\u5952\0\u599c\0\u59e6"+
    "\0\u5a30\0\u5a7a\0\u5ac4\0\u3f4e\0\u5b0e\0\u5b58\0\u5ba2\0\u5bec"+
    "\0\u5c36\0\u5c80\0\u5cca\0\u5d14\0\u5d5e\0\u05c8\0\u5da8\0\u5df2"+
    "\0\u05c8\0\u5e3c\0\u5e86\0\u5ed0\0\u5f1a\0\u5f64\0\u5fae\0\u5ff8"+
    "\0\u6042\0\u05c8\0\u05c8\0\u608c\0\u60d6\0\u6120\0\u05c8\0\u616a"+
    "\0\u05c8\0\u61b4\0\u03c2\0\u61fe\0\u6248\0\u6292\0\u13a8\0\u62dc"+
    "\0\u6326\0\u6370\0\u63ba\0\u6404\0\u644e\0\u13a8\0\u6498\0\u13a8"+
    "\0\u64e2\0\u652c\0\u13a8\0\u6576\0\u65c0\0\u660a\0\u6654\0\u669e"+
    "\0\u66e8\0\u6732\0\u13a8\0\u677c\0\u67c6\0\u13a8\0\u6810\0\u685a"+
    "\0\u68a4\0\u68ee\0\u6938\0\u6982\0\u69cc\0\u6a16\0\u13a8\0\u13a8"+
    "\0\u6a60\0\u6aaa\0\u6af4\0\u13a8\0\u6b3e\0\u13a8\0\u6b88\0\u03c2"+
    "\0\u541e\0\u6bd2\0\u6c1c\0\u05c8\0\u6c66\0\u05c8\0\u6cb0\0\u6cfa"+
    "\0\u6d44\0\u6d8e\0\u6dd8\0\u6e22\0\u6e6c\0\u05c8\0\u6eb6\0\u6f00"+
    "\0\u6f4a\0\u6f94\0\u6fde\0\u7028\0\u7072\0\u70bc\0\u7106\0\u7150"+
    "\0\u719a\0\u71e4\0\u05c8\0\u05c8\0\u722e\0\u7278\0\u72c2\0\u05c8"+
    "\0\u730c\0\u05c8\0\u7356\0\u05c8\0\u73a0\0\u73ea\0\u7434\0\u747e"+
    "\0\u74c8\0\u05c8\0\u13a8\0\u7512\0\u13a8\0\u755c\0\u75a6\0\u75f0"+
    "\0\u763a\0\u7684\0\u76ce\0\u7718\0\u13a8\0\u7762\0\u77ac\0\u77f6"+
    "\0\u7840\0\u788a\0\u78d4\0\u791e\0\u13a8\0\u13a8\0\u7968\0\u79b2"+
    "\0\u79fc\0\u13a8\0\u7a46\0\u13a8\0\u7a90\0\u13a8\0\u7ada\0\u7b24"+
    "\0\u7b6e\0\u7bb8\0\u7c02\0\u13a8\0\u6bd2\0\u7c4c\0\u7c96\0\u7ce0"+
    "\0\u05c8\0\u7d2a\0\u7d74\0\u7dbe\0\u05c8\0\u7e08\0\u7e52\0\u03c2"+
    "\0\u7e9c\0\u7ee6\0\u7f30\0\u05c8\0\u7f7a\0\u05c8\0\u7fc4\0\u05c8"+
    "\0\u800e\0\u8058\0\u05c8\0\u80a2\0\u05c8\0\u05c8\0\u80ec\0\u05c8"+
    "\0\u8136\0\u8180\0\u13a8\0\u81ca\0\u8214\0\u825e\0\u13a8\0\u82a8"+
    "\0\u82f2\0\u833c\0\u8386\0\u83d0\0\u13a8\0\u841a\0\u13a8\0\u8464"+
    "\0\u13a8\0\u84ae\0\u84f8\0\u13a8\0\u8542\0\u13a8\0\u13a8\0\u858c"+
    "\0\u13a8\0\u85d6\0\u05c8\0\u8620\0\u866a\0\u86b4\0\u05c8\0\u05c8"+
    "\0\u05c8\0\u05c8\0\u05c8\0\u86fe\0\u8748\0\u8792\0\u87dc\0\u8826"+
    "\0\u8870\0\u88ba\0\u13a8\0\u8904\0\u894e\0\u8998\0\u13a8\0\u13a8"+
    "\0\u13a8\0\u13a8\0\u13a8\0\u89e2\0\u8a2c\0\u8a76\0\u8ac0\0\u8b0a"+
    "\0\u8b54\0\u8b9e\0\u8be8\0\u8c32\0\u8c7c\0\u8cc6\0\u8d10\0\u05c8"+
    "\0\u05c8\0\u05c8\0\u8d5a\0\u8da4\0\u05c8\0\u8dee\0\u8e38\0\u8e82"+
    "\0\u8ecc\0\u13a8\0\u13a8\0\u13a8\0\u8f16\0\u8f60\0\u13a8\0\u8faa"+
    "\0\u8ff4\0\u903e\0\u05c8\0\u05c8\0\u9088\0\u05c8\0\u90d2\0\u911c"+
    "\0\u13a8\0\u13a8\0\u9166\0\u13a8\0\u91b0\0\u05c8\0\u05c8\0\u91fa"+
    "\0\u13a8\0\u13a8\0\u9244\0\u928e\0\u92d8\0\u9322\0\u03c2\0\u05c8"+
    "\0\u13a8";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[697];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\16\3\17\1\20\1\21\1\22\1\23\1\24\1\25"+
    "\1\26\1\27\1\30\2\27\1\31\1\27\1\32\1\27"+
    "\1\33\1\27\1\34\1\27\1\35\1\27\1\36\1\37"+
    "\1\27\1\40\1\41\1\27\1\30\2\27\1\42\1\27"+
    "\1\43\1\44\1\45\1\46\1\47\1\50\1\27\1\51"+
    "\1\52\1\53\2\27\1\54\1\55\4\27\1\56\1\57"+
    "\1\60\1\61\1\62\1\63\1\64\1\65\1\66\1\67"+
    "\1\70\1\71\1\72\1\73\1\74\1\75\1\76\1\77"+
    "\1\100\1\101\1\16\3\17\1\20\1\21\1\22\1\23"+
    "\1\24\1\25\1\26\1\27\1\30\2\27\1\31\1\27"+
    "\1\32\1\27\1\33\1\27\1\34\1\27\1\35\1\27"+
    "\1\36\1\37\1\27\1\40\1\41\1\27\1\30\2\27"+
    "\1\42\1\27\1\43\1\44\1\45\1\46\1\47\1\50"+
    "\1\27\1\51\1\52\1\53\2\27\1\54\1\55\4\27"+
    "\1\56\1\102\1\60\1\61\1\62\1\63\1\103\1\65"+
    "\1\66\1\67\1\70\1\71\1\72\1\73\1\74\1\75"+
    "\1\76\1\77\1\100\1\101\1\16\3\17\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\1\26\1\27\1\30\14\27"+
    "\1\36\1\37\1\27\1\40\2\27\1\30\2\27\1\42"+
    "\1\27\1\43\1\44\1\45\20\27\1\102\1\60\1\61"+
    "\1\62\1\63\1\104\1\65\1\66\1\67\1\70\1\71"+
    "\1\72\1\73\1\74\1\75\1\76\1\77\1\100\1\101"+
    "\4\105\2\20\1\106\1\107\34\105\1\110\45\105\6\111"+
    "\1\112\36\111\1\113\44\111\2\114\2\115\2\114\1\116"+
    "\35\114\1\117\1\114\1\120\43\114\6\121\1\122\35\121"+
    "\1\117\1\121\1\123\43\121\6\124\1\125\1\126\34\124"+
    "\1\127\45\124\7\130\1\131\34\130\1\132\45\130\13\133"+
    "\1\134\1\133\2\134\1\135\1\134\1\136\1\134\1\137"+
    "\1\134\1\140\1\134\1\141\1\134\2\133\1\134\1\133"+
    "\1\142\1\134\1\133\2\134\1\133\1\134\3\133\1\143"+
    "\1\144\1\145\1\134\1\146\1\147\1\150\2\134\1\151"+
    "\1\152\4\134\1\153\1\154\22\133\42\155\1\156\47\155"+
    "\13\157\1\134\1\157\14\134\2\157\1\134\1\157\2\134"+
    "\1\157\2\134\1\157\1\134\3\157\20\134\23\157\1\160"+
    "\5\161\1\162\103\160\113\0\5\17\1\163\104\0\2\20"+
    "\1\164\1\0\1\20\113\0\1\165\1\166\111\0\1\167"+
    "\31\0\1\170\32\0\1\171\26\0\1\172\122\0\1\173"+
    "\51\0\1\174\27\0\16\27\2\0\7\27\1\0\2\27"+
    "\2\0\20\27\37\0\1\30\2\175\2\176\2\177\2\200"+
    "\2\201\2\202\2\0\1\203\1\30\2\0\1\30\2\0"+
    "\1\204\62\0\6\27\1\205\1\27\1\206\5\27\2\0"+
    "\7\27\1\0\2\27\2\0\1\27\1\207\6\27\1\210"+
    "\7\27\36\0\16\27\2\0\7\27\1\0\2\27\2\0"+
    "\10\27\1\211\7\27\36\0\4\27\1\212\11\27\2\0"+
    "\7\27\1\0\2\27\2\0\7\27\1\213\2\27\1\214"+
    "\5\27\36\0\14\27\1\215\1\27\2\0\7\27\1\0"+
    "\2\27\2\0\10\27\1\216\7\27\36\0\6\27\1\217"+
    "\7\27\2\0\5\27\1\220\1\27\1\0\2\27\2\0"+
    "\12\27\1\221\5\27\54\0\1\222\43\0\1\223\46\0"+
    "\1\224\42\0\1\225\4\0\1\226\23\0\1\30\2\175"+
    "\2\176\2\177\2\200\2\201\2\202\2\0\1\203\1\30"+
    "\2\227\1\30\2\230\1\204\62\0\16\27\2\0\7\27"+
    "\1\0\2\27\2\0\6\27\1\231\1\27\1\232\3\27"+
    "\1\233\3\27\65\0\1\234\44\0\1\235\11\0\1\236"+
    "\3\0\16\27\2\0\7\27\1\0\2\27\2\0\20\27"+
    "\23\0\2\237\2\0\2\237\1\240\36\237\1\241\44\237"+
    "\2\242\2\0\2\242\1\243\35\242\1\0\1\242\1\244"+
    "\43\242\13\0\16\27\2\0\7\27\1\0\2\27\2\0"+
    "\1\27\1\245\4\27\1\246\4\27\1\247\4\27\36\0"+
    "\16\27\2\0\2\27\1\250\4\27\1\0\2\27\2\0"+
    "\4\27\1\251\13\27\36\0\6\27\1\252\7\27\2\0"+
    "\7\27\1\0\2\27\2\0\1\27\1\253\6\27\1\254"+
    "\4\27\1\255\2\27\36\0\16\27\2\0\7\27\1\0"+
    "\2\27\2\0\5\27\1\256\5\27\1\257\1\260\1\261"+
    "\1\27\1\262\36\0\16\27\2\0\7\27\1\0\2\27"+
    "\2\0\6\27\1\263\6\27\1\264\2\27\36\0\14\27"+
    "\1\265\1\27\2\0\7\27\1\0\2\27\2\0\20\27"+
    "\36\0\16\27\2\0\7\27\1\0\2\27\2\0\1\27"+
    "\1\266\6\27\1\267\7\27\36\0\14\27\1\270\1\27"+
    "\2\0\7\27\1\0\2\27\2\0\1\27\1\271\11\27"+
    "\1\272\4\27\36\0\16\27\2\0\7\27\1\0\2\27"+
    "\2\0\15\27\1\273\2\27\120\0\1\274\5\0\1\275"+
    "\50\0\1\276\32\0\1\277\1\0\1\300\111\0\1\301"+
    "\107\0\1\302\3\0\1\303\105\0\1\304\4\0\1\305"+
    "\104\0\1\306\111\0\1\307\111\0\1\310\10\0\1\311"+
    "\100\0\1\312\11\0\1\313\11\0\2\314\64\0\1\315"+
    "\23\0\1\316\102\0\112\111\45\0\1\317\44\0\2\114"+
    "\2\0\2\114\1\0\35\114\1\0\1\114\1\0\43\114"+
    "\4\320\2\321\1\322\103\320\6\121\1\0\35\121\1\0"+
    "\1\121\1\0\43\121\1\320\3\0\1\320\1\0\104\320"+
    "\46\0\1\323\43\0\6\124\2\0\34\124\1\0\45\124"+
    "\7\0\1\324\102\0\13\325\1\0\1\325\14\0\2\325"+
    "\1\0\1\325\2\0\1\325\2\0\1\325\1\0\3\325"+
    "\21\0\22\325\7\130\1\0\34\130\1\0\45\130\44\0"+
    "\1\326\45\0\7\327\1\330\3\327\1\0\1\327\14\0"+
    "\2\327\1\0\1\327\2\0\1\327\2\0\1\327\1\0"+
    "\1\330\2\327\21\0\22\327\13\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\20\134\36\0\6\134\1\331\1\134"+
    "\1\332\5\134\2\0\7\134\1\0\1\134\3\0\1\134"+
    "\1\333\6\134\1\334\7\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\10\134\1\335\7\134\36\0\4\134"+
    "\1\336\11\134\2\0\7\134\1\0\1\134\3\0\7\134"+
    "\1\337\2\134\1\340\5\134\36\0\14\134\1\341\1\134"+
    "\2\0\7\134\1\0\1\134\3\0\10\134\1\342\7\134"+
    "\36\0\6\134\1\343\7\134\2\0\5\134\1\344\1\134"+
    "\1\0\1\134\3\0\12\134\1\345\5\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\6\134\1\346\1\134"+
    "\1\347\3\134\1\350\3\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\1\134\1\351\4\134\1\352\4\134"+
    "\1\353\4\134\36\0\16\134\2\0\2\134\1\354\4\134"+
    "\1\0\1\134\3\0\4\134\1\355\13\134\36\0\6\134"+
    "\1\356\7\134\2\0\7\134\1\0\1\134\3\0\1\134"+
    "\1\357\6\134\1\360\4\134\1\361\2\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\5\134\1\362\5\134"+
    "\1\363\1\364\1\365\1\134\1\366\36\0\16\134\2\0"+
    "\7\134\1\0\1\134\3\0\6\134\1\367\6\134\1\370"+
    "\2\134\36\0\14\134\1\371\1\134\2\0\7\134\1\0"+
    "\1\134\3\0\20\134\36\0\16\134\2\0\7\134\1\0"+
    "\1\134\3\0\1\134\1\372\6\134\1\373\7\134\36\0"+
    "\14\134\1\374\1\134\2\0\7\134\1\0\1\134\3\0"+
    "\1\134\1\375\11\134\1\376\4\134\36\0\16\134\2\0"+
    "\7\134\1\0\1\134\3\0\15\134\1\377\2\134\36\0"+
    "\1\u0100\1\0\14\u0100\2\0\1\u0100\1\0\2\u0100\1\0"+
    "\2\u0100\1\0\1\u0100\3\0\20\u0100\24\0\5\161\1\u0101"+
    "\104\0\3\161\1\0\1\161\105\0\3\17\1\0\1\17"+
    "\106\0\1\20\107\0\2\165\2\0\106\165\10\u0102\1\u0103"+
    "\101\u0102\75\0\1\u0104\14\0\2\172\2\0\106\172\61\0"+
    "\1\u0105\125\0\1\u0106\30\0\1\u0107\14\0\2\u0108\1\0"+
    "\1\u0107\2\0\1\u0107\66\0\1\30\16\0\1\203\1\30"+
    "\2\0\1\30\66\0\1\u0109\17\0\1\u0109\2\0\1\u0109"+
    "\65\0\16\27\2\0\7\27\1\0\2\27\2\0\10\27"+
    "\1\u010a\7\27\36\0\16\27\2\0\7\27\1\0\2\27"+
    "\2\0\12\27\1\u010b\5\27\36\0\6\27\1\u010c\7\27"+
    "\2\0\7\27\1\0\2\27\2\0\20\27\36\0\16\27"+
    "\2\0\7\27\1\0\2\27\2\0\6\27\1\u010d\11\27"+
    "\36\0\16\27\2\0\7\27\1\0\2\27\2\0\12\27"+
    "\1\u010e\5\27\36\0\16\27\2\0\7\27\1\0\2\27"+
    "\2\0\1\u010f\17\27\36\0\16\27\2\0\7\27\1\0"+
    "\2\27\2\0\4\27\1\u0110\1\u0111\12\27\36\0\4\27"+
    "\1\u0112\11\27\2\0\7\27\1\0\2\27\2\0\20\27"+
    "\36\0\16\27\2\0\7\27\1\0\2\27\2\0\13\27"+
    "\1\u0113\4\27\36\0\16\27\2\0\7\27\1\0\2\27"+
    "\2\0\4\27\1\u0114\13\27\36\0\16\27\2\0\7\27"+
    "\1\0\2\27\2\0\5\27\1\u0115\12\27\36\0\16\27"+
    "\2\0\7\27\1\0\2\27\2\0\13\27\1\u0116\4\27"+
    "\57\0\1\u0117\2\0\1\u0117\65\0\2\u0118\2\0\2\u0118"+
    "\4\0\4\u0118\3\0\4\u0118\10\0\2\u0118\53\0\14\27"+
    "\1\u0119\1\27\2\0\7\27\1\0\2\27\2\0\20\27"+
    "\36\0\16\27\2\0\7\27\1\0\2\27\2\0\10\27"+
    "\1\u011a\7\27\36\0\16\27\2\0\7\27\1\0\2\27"+
    "\2\0\5\27\1\u011b\12\27\65\0\1\u011c\36\0\1\u011d"+
    "\10\0\2\237\2\0\2\237\1\240\36\237\1\u011e\50\237"+
    "\2\u011f\1\u0120\103\237\45\0\1\u0121\44\0\2\242\2\0"+
    "\2\242\1\243\35\242\1\0\1\242\1\u0122\47\242\2\u0123"+
    "\1\u0124\103\242\46\0\1\u0125\56\0\16\27\2\0\7\27"+
    "\1\0\2\27\2\0\2\27\1\u0126\15\27\36\0\10\27"+
    "\1\u0127\5\27\2\0\7\27\1\0\2\27\2\0\10\27"+
    "\1\u0128\7\27\36\0\16\27\2\0\2\27\1\u0129\4\27"+
    "\1\0\2\27\2\0\20\27\36\0\16\27\2\0\7\27"+
    "\1\0\2\27\2\0\4\27\1\u012a\13\27\36\0\16\27"+
    "\2\0\7\27\1\0\2\27\2\0\4\27\1\u012b\13\27"+
    "\36\0\16\27\2\0\7\27\1\0\2\27\2\0\1\27"+
    "\1\u012c\16\27\36\0\16\27\2\0\7\27\1\0\2\27"+
    "\2\0\4\27\1\u012d\1\u012e\12\27\36\0\16\27\2\0"+
    "\7\27\1\0\2\27\2\0\12\27\1\u012f\5\27\36\0"+
    "\16\27\2\0\7\27\1\0\2\27\2\0\1\27\1\u0130"+
    "\16\27\36\0\16\27\2\0\7\27\1\0\2\27\2\0"+
    "\1\27\1\u0131\4\27\1\u0132\11\27\36\0\16\27\2\0"+
    "\7\27\1\0\2\27\2\0\1\u0133\17\27\36\0\16\27"+
    "\2\0\7\27\1\0\2\27\2\0\12\27\1\u0134\5\27"+
    "\36\0\16\27\2\0\7\27\1\0\2\27\2\0\10\27"+
    "\1\u0135\7\27\36\0\10\27\1\u0136\5\27\2\0\7\27"+
    "\1\0\2\27\2\0\20\27\36\0\16\27\2\0\7\27"+
    "\1\0\2\27\2\0\1\27\1\u0137\11\27\1\u0138\1\u0139"+
    "\3\27\36\0\10\27\1\u013a\5\27\2\0\7\27\1\0"+
    "\2\27\2\0\6\27\1\u013b\11\27\36\0\16\27\2\0"+
    "\7\27\1\0\2\27\2\0\5\27\1\u013c\12\27\36\0"+
    "\16\27\2\0\7\27\1\0\2\27\2\0\6\27\1\u013d"+
    "\11\27\36\0\6\27\1\u013e\1\27\1\u013f\5\27\2\0"+
    "\7\27\1\0\2\27\2\0\20\27\36\0\16\27\2\0"+
    "\7\27\1\0\2\27\2\0\17\27\1\u0140\36\0\16\27"+
    "\2\0\7\27\1\0\2\27\2\0\5\27\1\u0141\12\27"+
    "\36\0\6\27\1\u0142\7\27\2\0\7\27\1\0\2\27"+
    "\2\0\20\27\36\0\10\27\1\u0143\5\27\2\0\7\27"+
    "\1\0\2\27\2\0\20\27\120\0\1\u0144\5\0\1\u0145"+
    "\110\0\1\u0146\104\0\1\u0147\111\0\1\u0148\4\0\1\u0149"+
    "\54\0\1\u014a\46\0\2\320\2\u014b\1\u014c\104\0\2\u014b"+
    "\1\u014d\1\0\1\u014b\152\0\1\u014e\56\0\16\134\2\0"+
    "\7\134\1\0\1\134\3\0\10\134\1\u014f\7\134\36\0"+
    "\16\134\2\0\7\134\1\0\1\134\3\0\12\134\1\u0150"+
    "\5\134\36\0\6\134\1\u0151\7\134\2\0\7\134\1\0"+
    "\1\134\3\0\20\134\36\0\16\134\2\0\7\134\1\0"+
    "\1\134\3\0\6\134\1\u0152\11\134\36\0\16\134\2\0"+
    "\7\134\1\0\1\134\3\0\12\134\1\u0153\5\134\36\0"+
    "\16\134\2\0\7\134\1\0\1\134\3\0\1\u0154\17\134"+
    "\36\0\16\134\2\0\7\134\1\0\1\134\3\0\4\134"+
    "\1\u0155\1\u0156\12\134\36\0\4\134\1\u0157\11\134\2\0"+
    "\7\134\1\0\1\134\3\0\20\134\36\0\16\134\2\0"+
    "\7\134\1\0\1\134\3\0\13\134\1\u0158\4\134\36\0"+
    "\16\134\2\0\7\134\1\0\1\134\3\0\4\134\1\u0159"+
    "\13\134\36\0\16\134\2\0\7\134\1\0\1\134\3\0"+
    "\5\134\1\u015a\12\134\36\0\16\134\2\0\7\134\1\0"+
    "\1\134\3\0\13\134\1\u015b\4\134\36\0\14\134\1\u015c"+
    "\1\134\2\0\7\134\1\0\1\134\3\0\20\134\36\0"+
    "\16\134\2\0\7\134\1\0\1\134\3\0\10\134\1\u015d"+
    "\7\134\36\0\16\134\2\0\7\134\1\0\1\134\3\0"+
    "\5\134\1\u015e\12\134\36\0\16\134\2\0\7\134\1\0"+
    "\1\134\3\0\2\134\1\u015f\15\134\36\0\10\134\1\u0160"+
    "\5\134\2\0\7\134\1\0\1\134\3\0\10\134\1\u0161"+
    "\7\134\36\0\16\134\2\0\2\134\1\u0162\4\134\1\0"+
    "\1\134\3\0\20\134\36\0\16\134\2\0\7\134\1\0"+
    "\1\134\3\0\4\134\1\u0163\13\134\36\0\16\134\2\0"+
    "\7\134\1\0\1\134\3\0\4\134\1\u0164\13\134\36\0"+
    "\16\134\2\0\7\134\1\0\1\134\3\0\1\134\1\u0165"+
    "\16\134\36\0\16\134\2\0\7\134\1\0\1\134\3\0"+
    "\4\134\1\u0166\1\u0167\12\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\12\134\1\u0168\5\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\1\134\1\u0169\16\134"+
    "\36\0\16\134\2\0\7\134\1\0\1\134\3\0\1\134"+
    "\1\u016a\4\134\1\u016b\11\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\1\u016c\17\134\36\0\16\134\2\0"+
    "\7\134\1\0\1\134\3\0\12\134\1\u016d\5\134\36\0"+
    "\16\134\2\0\7\134\1\0\1\134\3\0\10\134\1\u016e"+
    "\7\134\36\0\10\134\1\u016f\5\134\2\0\7\134\1\0"+
    "\1\134\3\0\20\134\36\0\16\134\2\0\7\134\1\0"+
    "\1\134\3\0\1\134\1\u0170\11\134\1\u0171\1\u0172\3\134"+
    "\36\0\10\134\1\u0173\5\134\2\0\7\134\1\0\1\134"+
    "\3\0\6\134\1\u0174\11\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\5\134\1\u0175\12\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\6\134\1\u0176\11\134"+
    "\36\0\6\134\1\u0177\1\134\1\u0178\5\134\2\0\7\134"+
    "\1\0\1\134\3\0\20\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\17\134\1\u0179\36\0\16\134\2\0"+
    "\7\134\1\0\1\134\3\0\5\134\1\u017a\12\134\36\0"+
    "\6\134\1\u017b\7\134\2\0\7\134\1\0\1\134\3\0"+
    "\20\134\36\0\10\134\1\u017c\5\134\2\0\7\134\1\0"+
    "\1\134\3\0\20\134\36\0\16\u0100\2\0\7\u0100\1\0"+
    "\1\u0100\3\0\20\u0100\23\0\10\u0102\1\u017d\101\u0102\7\u017e"+
    "\1\u017f\1\u0103\101\u017e\13\u0180\16\0\2\u0180\7\0\1\u0180"+
    "\2\0\2\u0180\4\0\1\u0181\13\0\23\u0180\14\0\1\u0107"+
    "\2\u0182\2\176\4\0\2\201\4\0\1\u0108\1\u0107\2\0"+
    "\1\u0107\66\0\1\u0107\17\0\1\u0107\2\0\1\u0107\66\0"+
    "\1\u0109\2\u0182\2\176\4\0\2\201\2\202\2\0\1\u0183"+
    "\1\u0109\2\0\1\u0109\65\0\16\27\2\0\7\27\1\0"+
    "\2\27\2\0\1\27\1\u0184\16\27\36\0\16\27\2\0"+
    "\7\27\1\0\2\27\2\0\1\27\1\u0185\16\27\36\0"+
    "\16\27\2\0\7\27\1\0\2\27\2\0\4\27\1\u0186"+
    "\13\27\36\0\2\27\1\u0187\13\27\2\0\7\27\1\0"+
    "\2\27\2\0\20\27\36\0\6\27\1\u0188\7\27\2\0"+
    "\7\27\1\0\2\27\2\0\10\27\1\u0189\7\27\36\0"+
    "\16\27\2\0\7\27\1\0\2\27\2\0\5\27\1\u018a"+
    "\12\27\36\0\14\27\1\u018b\1\27\2\0\7\27\1\0"+
    "\2\27\2\0\20\27\36\0\16\27\2\0\7\27\1\0"+
    "\2\27\2\0\1\27\1\u018c\16\27\36\0\16\27\2\0"+
    "\2\27\1\u018d\4\27\1\0\2\27\2\0\20\27\36\0"+
    "\14\27\1\u018e\1\27\2\0\7\27\1\0\2\27\2\0"+
    "\20\27\36\0\14\27\1\u018f\1\27\2\0\7\27\1\0"+
    "\2\27\2\0\20\27\36\0\16\27\2\0\7\27\1\0"+
    "\2\27\2\0\7\27\1\u0190\10\27\40\0\2\175\2\0"+
    "\2\177\2\200\6\0\1\u0191\1\u0117\2\0\1\u0117\65\0"+
    "\2\u0118\2\175\2\u0118\2\177\2\200\4\u0118\2\0\1\u0192"+
    "\4\u0118\10\0\2\u0118\53\0\16\27\2\0\7\27\1\0"+
    "\2\27\2\0\1\27\1\u0193\16\27\36\0\6\27\1\u0194"+
    "\7\27\2\0\7\27\1\0\2\27\2\0\20\27\36\0"+
    "\14\27\1\u0195\1\27\2\0\7\27\1\0\2\27\2\0"+
    "\20\27\23\0\4\237\2\u011f\1\u0196\36\237\1\u011e\45\237"+
    "\1\u011f\1\u0197\1\u0198\1\237\1\u011f\1\240\36\237\1\u011e"+
    "\44\237\4\242\2\u0123\1\u0199\35\242\1\0\1\242\1\u0122"+
    "\44\242\1\u0123\1\u019a\1\u019b\1\242\1\u0123\1\243\35\242"+
    "\1\0\1\242\1\u0122\43\242\6\u019c\1\u019d\35\u019c\1\0"+
    "\1\u019c\1\u019e\43\u019c\13\0\16\27\2\0\7\27\1\0"+
    "\2\27\2\0\3\27\1\u019f\14\27\36\0\16\27\2\0"+
    "\7\27\1\0\2\27\2\0\11\27\1\u01a0\6\27\36\0"+
    "\16\27\2\0\7\27\1\0\2\27\2\0\5\27\1\u01a1"+
    "\12\27\36\0\6\27\1\u01a2\7\27\2\0\7\27\1\0"+
    "\2\27\2\0\20\27\36\0\16\27\2\0\7\27\1\0"+
    "\2\27\2\0\5\27\1\u01a3\12\27\36\0\14\27\1\u01a4"+
    "\1\27\2\0\7\27\1\0\2\27\2\0\20\27\36\0"+
    "\16\27\2\0\7\27\1\0\2\27\2\0\4\27\1\u01a5"+
    "\13\27\36\0\14\27\1\u01a6\1\27\2\0\7\27\1\0"+
    "\2\27\2\0\20\27\36\0\16\27\2\0\7\27\1\0"+
    "\2\27\2\0\2\27\1\u01a7\15\27\36\0\16\27\2\0"+
    "\7\27\1\0\2\27\2\0\5\27\1\u01a8\12\27\36\0"+
    "\16\27\2\0\7\27\1\0\2\27\2\0\6\27\1\u01a9"+
    "\11\27\36\0\16\27\2\0\7\27\1\0\2\27\2\0"+
    "\5\27\1\u01aa\12\27\36\0\10\27\1\u01ab\5\27\2\0"+
    "\7\27\1\0\2\27\2\0\20\27\36\0\14\27\1\u01ac"+
    "\1\27\2\0\7\27\1\0\2\27\2\0\20\27\36\0"+
    "\16\27\2\0\7\27\1\0\2\27\2\0\2\27\1\u01ad"+
    "\15\27\36\0\16\27\2\0\7\27\1\0\2\27\2\0"+
    "\6\27\1\u01ae\11\27\36\0\16\27\2\0\7\27\1\0"+
    "\2\27\2\0\5\27\1\u01af\12\27\36\0\10\27\1\u01b0"+
    "\5\27\2\0\7\27\1\0\2\27\2\0\12\27\1\u01b1"+
    "\5\27\36\0\14\27\1\u01b2\1\27\2\0\7\27\1\0"+
    "\2\27\2\0\20\27\36\0\16\27\2\0\7\27\1\0"+
    "\2\27\2\0\4\27\1\u01b3\13\27\36\0\16\27\2\0"+
    "\7\27\1\0\2\27\2\0\10\27\1\u01b4\7\27\36\0"+
    "\16\27\2\0\7\27\1\0\2\27\2\0\13\27\1\u01b5"+
    "\4\27\36\0\16\27\2\0\7\27\1\0\2\27\2\0"+
    "\1\27\1\u01b6\16\27\36\0\12\27\1\u01b7\3\27\2\0"+
    "\7\27\1\0\2\27\2\0\20\27\36\0\10\27\1\u01b8"+
    "\5\27\2\0\7\27\1\0\2\27\2\0\20\27\36\0"+
    "\6\27\1\u01b9\7\27\2\0\7\27\1\0\2\27\2\0"+
    "\20\27\36\0\6\27\1\u01ba\7\27\2\0\7\27\1\0"+
    "\2\27\2\0\20\27\120\0\1\u01bb\16\0\1\321\1\320"+
    "\2\u014b\1\u014c\116\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\1\134\1\u01bc\16\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\1\134\1\u01bd\16\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\4\134\1\u01be\13\134"+
    "\36\0\2\134\1\u01bf\13\134\2\0\7\134\1\0\1\134"+
    "\3\0\20\134\36\0\6\134\1\u01c0\7\134\2\0\7\134"+
    "\1\0\1\134\3\0\10\134\1\u01c1\7\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\5\134\1\u01c2\12\134"+
    "\36\0\14\134\1\u01c3\1\134\2\0\7\134\1\0\1\134"+
    "\3\0\20\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\1\134\1\u01c4\16\134\36\0\16\134\2\0\2\134"+
    "\1\u01c5\4\134\1\0\1\134\3\0\20\134\36\0\14\134"+
    "\1\u01c6\1\134\2\0\7\134\1\0\1\134\3\0\20\134"+
    "\36\0\14\134\1\u01c7\1\134\2\0\7\134\1\0\1\134"+
    "\3\0\20\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\7\134\1\u01c8\10\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\1\134\1\u01c9\16\134\36\0\6\134"+
    "\1\u01ca\7\134\2\0\7\134\1\0\1\134\3\0\20\134"+
    "\36\0\14\134\1\u01cb\1\134\2\0\7\134\1\0\1\134"+
    "\3\0\20\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\3\134\1\u01cc\14\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\11\134\1\u01cd\6\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\5\134\1\u01ce\12\134"+
    "\36\0\6\134\1\u01cf\7\134\2\0\7\134\1\0\1\134"+
    "\3\0\20\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\5\134\1\u01d0\12\134\36\0\14\134\1\u01d1\1\134"+
    "\2\0\7\134\1\0\1\134\3\0\20\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\4\134\1\u01d2\13\134"+
    "\36\0\14\134\1\u01d3\1\134\2\0\7\134\1\0\1\134"+
    "\3\0\20\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\2\134\1\u01d4\15\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\5\134\1\u01d5\12\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\6\134\1\u01d6\11\134"+
    "\36\0\16\134\2\0\7\134\1\0\1\134\3\0\5\134"+
    "\1\u01d7\12\134\36\0\10\134\1\u01d8\5\134\2\0\7\134"+
    "\1\0\1\134\3\0\20\134\36\0\14\134\1\u01d9\1\134"+
    "\2\0\7\134\1\0\1\134\3\0\20\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\2\134\1\u01da\15\134"+
    "\36\0\16\134\2\0\7\134\1\0\1\134\3\0\6\134"+
    "\1\u01db\11\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\5\134\1\u01dc\12\134\36\0\10\134\1\u01dd\5\134"+
    "\2\0\7\134\1\0\1\134\3\0\12\134\1\u01de\5\134"+
    "\36\0\14\134\1\u01df\1\134\2\0\7\134\1\0\1\134"+
    "\3\0\20\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\4\134\1\u01e0\13\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\10\134\1\u01e1\7\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\13\134\1\u01e2\4\134"+
    "\36\0\16\134\2\0\7\134\1\0\1\134\3\0\1\134"+
    "\1\u01e3\16\134\36\0\12\134\1\u01e4\3\134\2\0\7\134"+
    "\1\0\1\134\3\0\20\134\36\0\10\134\1\u01e5\5\134"+
    "\2\0\7\134\1\0\1\134\3\0\20\134\36\0\6\134"+
    "\1\u01e6\7\134\2\0\7\134\1\0\1\134\3\0\20\134"+
    "\36\0\6\134\1\u01e7\7\134\2\0\7\134\1\0\1\134"+
    "\3\0\20\134\23\0\7\u0102\1\u01e8\1\u01e9\101\u0102\10\u017e"+
    "\1\u01ea\101\u017e\54\0\1\u01eb\51\0\1\u0109\16\0\1\u0183"+
    "\1\u0109\2\0\1\u0109\65\0\16\27\2\0\7\27\1\0"+
    "\2\27\2\0\5\27\1\u01ec\12\27\36\0\6\27\1\u01ed"+
    "\7\27\2\0\7\27\1\0\2\27\2\0\20\27\36\0"+
    "\14\27\1\u01ee\1\27\2\0\7\27\1\0\2\27\2\0"+
    "\20\27\36\0\14\27\1\u01ef\1\27\2\0\7\27\1\0"+
    "\2\27\2\0\20\27\36\0\16\27\2\0\7\27\1\0"+
    "\2\27\2\0\6\27\1\u01f0\11\27\36\0\16\27\2\0"+
    "\7\27\1\0\2\27\2\0\1\27\1\u01f1\16\27\36\0"+
    "\16\27\2\0\7\27\1\0\2\27\2\0\6\27\1\u01f2"+
    "\11\27\36\0\16\27\2\0\7\27\1\0\2\27\2\0"+
    "\13\27\1\u01f3\4\27\36\0\6\27\1\u01f4\7\27\2\0"+
    "\7\27\1\0\2\27\2\0\20\27\36\0\16\27\2\0"+
    "\7\27\1\0\2\27\2\0\12\27\1\u01f5\5\27\56\0"+
    "\1\u0191\1\u0117\2\0\1\u0117\65\0\2\u0118\2\0\2\u0118"+
    "\4\0\4\u0118\2\0\1\u0192\4\u0118\10\0\2\u0118\53\0"+
    "\16\27\2\0\7\27\1\0\2\27\2\0\3\27\1\u01f6"+
    "\14\27\36\0\14\27\1\u01f7\1\27\2\0\7\27\1\0"+
    "\2\27\2\0\20\27\23\0\1\237\2\u011f\1\u01f8\2\u011f"+
    "\1\u0120\103\237\2\0\2\237\2\u0197\1\u01f9\105\0\1\u011f"+
    "\1\237\2\u0197\1\u01f9\103\0\1\242\2\u0123\1\u01fa\2\u0123"+
    "\1\u0124\103\242\2\0\2\242\2\u019a\1\u01fb\105\0\1\u0123"+
    "\1\242\2\u019a\1\u01fb\103\0\120\u019c\1\0\35\u019c\1\0"+
    "\1\u019c\1\u01fc\43\u019c\13\0\16\27\2\0\7\27\1\0"+
    "\2\27\2\0\1\27\1\u01fd\16\27\36\0\16\27\2\0"+
    "\7\27\1\0\2\27\2\0\1\27\1\u01fe\16\27\36\0"+
    "\14\27\1\u01ff\1\27\2\0\7\27\1\0\2\27\2\0"+
    "\20\27\36\0\10\27\1\u0200\5\27\2\0\7\27\1\0"+
    "\2\27\2\0\20\27\36\0\16\27\2\0\7\27\1\0"+
    "\2\27\2\0\6\27\1\u0201\11\27\36\0\16\27\2\0"+
    "\7\27\1\0\2\27\2\0\6\27\1\u0202\11\27\36\0"+
    "\16\27\2\0\7\27\1\0\2\27\2\0\4\27\1\u0203"+
    "\13\27\36\0\16\27\2\0\7\27\1\0\2\27\2\0"+
    "\15\27\1\u0204\2\27\36\0\10\27\1\u0205\5\27\2\0"+
    "\7\27\1\0\2\27\2\0\20\27\36\0\10\27\1\u0206"+
    "\5\27\2\0\7\27\1\0\2\27\2\0\20\27\36\0"+
    "\16\27\2\0\7\27\1\0\2\27\2\0\2\27\1\u0207"+
    "\15\27\36\0\16\27\2\0\7\27\1\0\2\27\2\0"+
    "\6\27\1\u0208\11\27\36\0\16\27\2\0\7\27\1\0"+
    "\2\27\2\0\15\27\1\u0209\2\27\36\0\16\27\2\0"+
    "\7\27\1\0\2\27\2\0\5\27\1\u020a\12\27\36\0"+
    "\16\27\2\0\7\27\1\0\2\27\2\0\2\27\1\u020b"+
    "\15\27\36\0\16\27\2\0\7\27\1\0\2\27\2\0"+
    "\5\27\1\u020c\12\27\36\0\16\27\2\0\7\27\1\0"+
    "\2\27\2\0\4\27\1\u020d\13\27\36\0\16\27\2\0"+
    "\7\27\1\0\2\27\2\0\17\27\1\u020e\36\0\16\27"+
    "\2\0\7\27\1\0\2\27\2\0\6\27\1\u020f\11\27"+
    "\36\0\16\27\2\0\7\27\1\0\2\27\2\0\5\27"+
    "\1\u0210\12\27\36\0\16\27\2\0\7\27\1\0\2\27"+
    "\2\0\11\27\1\u0211\6\27\36\0\14\27\1\u0212\1\27"+
    "\2\0\7\27\1\0\2\27\2\0\20\27\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\5\134\1\u0213\12\134"+
    "\36\0\6\134\1\u0214\7\134\2\0\7\134\1\0\1\134"+
    "\3\0\20\134\36\0\14\134\1\u0215\1\134\2\0\7\134"+
    "\1\0\1\134\3\0\20\134\36\0\14\134\1\u0216\1\134"+
    "\2\0\7\134\1\0\1\134\3\0\20\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\6\134\1\u0217\11\134"+
    "\36\0\16\134\2\0\7\134\1\0\1\134\3\0\1\134"+
    "\1\u0218\16\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\6\134\1\u0219\11\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\13\134\1\u021a\4\134\36\0\6\134"+
    "\1\u021b\7\134\2\0\7\134\1\0\1\134\3\0\20\134"+
    "\36\0\16\134\2\0\7\134\1\0\1\134\3\0\12\134"+
    "\1\u021c\5\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\3\134\1\u021d\14\134\36\0\14\134\1\u021e\1\134"+
    "\2\0\7\134\1\0\1\134\3\0\20\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\1\134\1\u021f\16\134"+
    "\36\0\16\134\2\0\7\134\1\0\1\134\3\0\1\134"+
    "\1\u0220\16\134\36\0\14\134\1\u0221\1\134\2\0\7\134"+
    "\1\0\1\134\3\0\20\134\36\0\10\134\1\u0222\5\134"+
    "\2\0\7\134\1\0\1\134\3\0\20\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\6\134\1\u0223\11\134"+
    "\36\0\16\134\2\0\7\134\1\0\1\134\3\0\6\134"+
    "\1\u0224\11\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\4\134\1\u0225\13\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\15\134\1\u0226\2\134\36\0\10\134"+
    "\1\u0227\5\134\2\0\7\134\1\0\1\134\3\0\20\134"+
    "\36\0\10\134\1\u0228\5\134\2\0\7\134\1\0\1\134"+
    "\3\0\20\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\2\134\1\u0229\15\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\6\134\1\u022a\11\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\15\134\1\u022b\2\134"+
    "\36\0\16\134\2\0\7\134\1\0\1\134\3\0\5\134"+
    "\1\u022c\12\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\2\134\1\u022d\15\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\5\134\1\u022e\12\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\4\134\1\u022f\13\134"+
    "\36\0\16\134\2\0\7\134\1\0\1\134\3\0\17\134"+
    "\1\u0230\36\0\16\134\2\0\7\134\1\0\1\134\3\0"+
    "\6\134\1\u0231\11\134\36\0\16\134\2\0\7\134\1\0"+
    "\1\134\3\0\5\134\1\u0232\12\134\36\0\16\134\2\0"+
    "\7\134\1\0\1\134\3\0\11\134\1\u0233\6\134\36\0"+
    "\14\134\1\u0234\1\134\2\0\7\134\1\0\1\134\3\0"+
    "\20\134\23\0\7\u017e\1\u017f\1\u0235\101\u017e\50\0\1\u0236"+
    "\54\0\6\27\1\u0237\7\27\2\0\7\27\1\0\2\27"+
    "\2\0\20\27\36\0\16\27\2\0\7\27\1\0\2\27"+
    "\2\0\7\27\1\u0238\10\27\36\0\16\27\2\0\7\27"+
    "\1\0\2\27\2\0\5\27\1\u0239\12\27\36\0\16\27"+
    "\2\0\7\27\1\0\2\27\2\0\12\27\1\u023a\5\27"+
    "\36\0\4\27\1\u023b\11\27\2\0\7\27\1\0\2\27"+
    "\2\0\20\27\36\0\6\27\1\u023c\7\27\2\0\7\27"+
    "\1\0\2\27\2\0\20\27\36\0\14\27\1\u023d\1\27"+
    "\2\0\7\27\1\0\2\27\2\0\20\27\36\0\12\27"+
    "\1\u023e\3\27\2\0\7\27\1\0\2\27\2\0\20\27"+
    "\36\0\16\27\2\0\7\27\1\0\2\27\2\0\1\27"+
    "\1\u023f\16\27\23\0\2\237\1\u011f\1\237\2\u011f\1\u0196"+
    "\36\237\1\u011e\44\237\1\0\2\u0197\1\u0198\1\0\1\u0197"+
    "\104\0\2\242\1\u0123\1\242\2\u0123\1\u0199\35\242\1\0"+
    "\1\242\1\u0122\43\242\1\0\2\u019a\1\u019b\1\0\1\u019a"+
    "\104\0\6\u019c\1\0\35\u019c\1\0\1\u019c\1\u0240\43\u019c"+
    "\13\0\2\27\1\u0241\13\27\2\0\7\27\1\0\2\27"+
    "\2\0\20\27\36\0\16\27\2\0\7\27\1\0\2\27"+
    "\2\0\5\27\1\u0242\12\27\36\0\16\27\2\0\7\27"+
    "\1\0\2\27\2\0\2\27\1\u0243\15\27\36\0\16\27"+
    "\2\0\7\27\1\0\2\27\2\0\2\27\1\u0244\15\27"+
    "\36\0\16\27\2\0\7\27\1\0\2\27\2\0\1\27"+
    "\1\u0245\16\27\36\0\16\27\2\0\7\27\1\0\2\27"+
    "\2\0\5\27\1\u0246\12\27\36\0\16\27\2\0\7\27"+
    "\1\0\2\27\2\0\12\27\1\u0247\5\27\36\0\16\27"+
    "\2\0\7\27\1\0\2\27\2\0\2\27\1\u0248\15\27"+
    "\36\0\16\27\2\0\7\27\1\0\2\27\2\0\5\27"+
    "\1\u0249\12\27\36\0\16\27\2\0\7\27\1\0\2\27"+
    "\2\0\6\27\1\u024a\11\27\36\0\16\27\2\0\7\27"+
    "\1\0\2\27\2\0\15\27\1\u024b\2\27\36\0\10\27"+
    "\1\u024c\5\27\2\0\7\27\1\0\2\27\2\0\20\27"+
    "\36\0\16\27\2\0\7\27\1\0\2\27\2\0\4\27"+
    "\1\u024d\13\27\36\0\16\27\2\0\7\27\1\0\2\27"+
    "\2\0\12\27\1\u024e\5\27\36\0\10\27\1\u024f\5\27"+
    "\2\0\7\27\1\0\2\27\2\0\20\27\36\0\14\27"+
    "\1\u0250\1\27\2\0\7\27\1\0\2\27\2\0\20\27"+
    "\36\0\6\134\1\u0251\7\134\2\0\7\134\1\0\1\134"+
    "\3\0\20\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\7\134\1\u0252\10\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\5\134\1\u0253\12\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\12\134\1\u0254\5\134"+
    "\36\0\4\134\1\u0255\11\134\2\0\7\134\1\0\1\134"+
    "\3\0\20\134\36\0\6\134\1\u0256\7\134\2\0\7\134"+
    "\1\0\1\134\3\0\20\134\36\0\14\134\1\u0257\1\134"+
    "\2\0\7\134\1\0\1\134\3\0\20\134\36\0\12\134"+
    "\1\u0258\3\134\2\0\7\134\1\0\1\134\3\0\20\134"+
    "\36\0\16\134\2\0\7\134\1\0\1\134\3\0\1\134"+
    "\1\u0259\16\134\36\0\2\134\1\u025a\13\134\2\0\7\134"+
    "\1\0\1\134\3\0\20\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\5\134\1\u025b\12\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\2\134\1\u025c\15\134"+
    "\36\0\16\134\2\0\7\134\1\0\1\134\3\0\2\134"+
    "\1\u025d\15\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\1\134\1\u025e\16\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\5\134\1\u025f\12\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\12\134\1\u0260\5\134"+
    "\36\0\16\134\2\0\7\134\1\0\1\134\3\0\2\134"+
    "\1\u0261\15\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\5\134\1\u0262\12\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\6\134\1\u0263\11\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\15\134\1\u0264\2\134"+
    "\36\0\10\134\1\u0265\5\134\2\0\7\134\1\0\1\134"+
    "\3\0\20\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\4\134\1\u0266\13\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\12\134\1\u0267\5\134\36\0\10\134"+
    "\1\u0268\5\134\2\0\7\134\1\0\1\134\3\0\20\134"+
    "\36\0\14\134\1\u0269\1\134\2\0\7\134\1\0\1\134"+
    "\3\0\20\134\104\0\1\u026a\43\0\16\27\2\0\7\27"+
    "\1\0\2\27\2\0\14\27\1\u026b\3\27\36\0\14\27"+
    "\1\u026c\1\27\2\0\7\27\1\0\2\27\2\0\20\27"+
    "\36\0\16\27\2\0\7\27\1\0\2\27\2\0\2\27"+
    "\1\u026d\15\27\36\0\16\27\2\0\7\27\1\0\2\27"+
    "\2\0\1\27\1\u026e\16\27\36\0\16\27\2\0\7\27"+
    "\1\0\2\27\2\0\5\27\1\u026f\12\27\36\0\16\27"+
    "\2\0\7\27\1\0\2\27\2\0\4\27\1\u0270\13\27"+
    "\36\0\16\27\2\0\7\27\1\0\2\27\2\0\12\27"+
    "\1\u0271\5\27\36\0\14\27\1\u0272\1\27\2\0\7\27"+
    "\1\0\2\27\2\0\20\27\36\0\14\27\1\u0273\1\27"+
    "\2\0\7\27\1\0\2\27\2\0\20\27\36\0\16\27"+
    "\2\0\7\27\1\0\2\27\2\0\5\27\1\u0274\12\27"+
    "\36\0\16\27\2\0\7\27\1\0\2\27\2\0\2\27"+
    "\1\u0275\15\27\36\0\16\27\2\0\7\27\1\0\2\27"+
    "\2\0\13\27\1\u0276\4\27\36\0\4\27\1\u0277\11\27"+
    "\2\0\7\27\1\0\2\27\2\0\20\27\36\0\16\27"+
    "\2\0\7\27\1\0\2\27\2\0\10\27\1\u0278\7\27"+
    "\36\0\14\27\1\u0279\1\27\2\0\7\27\1\0\2\27"+
    "\2\0\20\27\36\0\6\27\1\u027a\7\27\2\0\7\27"+
    "\1\0\2\27\2\0\20\27\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\14\134\1\u027b\3\134\36\0\14\134"+
    "\1\u027c\1\134\2\0\7\134\1\0\1\134\3\0\20\134"+
    "\36\0\16\134\2\0\7\134\1\0\1\134\3\0\2\134"+
    "\1\u027d\15\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\1\134\1\u027e\16\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\5\134\1\u027f\12\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\4\134\1\u0280\13\134"+
    "\36\0\16\134\2\0\7\134\1\0\1\134\3\0\12\134"+
    "\1\u0281\5\134\36\0\14\134\1\u0282\1\134\2\0\7\134"+
    "\1\0\1\134\3\0\20\134\36\0\14\134\1\u0283\1\134"+
    "\2\0\7\134\1\0\1\134\3\0\20\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\5\134\1\u0284\12\134"+
    "\36\0\16\134\2\0\7\134\1\0\1\134\3\0\2\134"+
    "\1\u0285\15\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\13\134\1\u0286\4\134\36\0\4\134\1\u0287\11\134"+
    "\2\0\7\134\1\0\1\134\3\0\20\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\10\134\1\u0288\7\134"+
    "\36\0\14\134\1\u0289\1\134\2\0\7\134\1\0\1\134"+
    "\3\0\20\134\36\0\6\134\1\u028a\7\134\2\0\7\134"+
    "\1\0\1\134\3\0\20\134\74\0\1\u028b\53\0\16\27"+
    "\2\0\7\27\1\0\2\27\2\0\12\27\1\u028c\5\27"+
    "\36\0\14\27\1\u028d\1\27\2\0\7\27\1\0\2\27"+
    "\2\0\20\27\36\0\16\27\2\0\7\27\1\0\2\27"+
    "\2\0\2\27\1\u028e\15\27\36\0\14\27\1\u028f\1\27"+
    "\2\0\7\27\1\0\2\27\2\0\20\27\36\0\16\27"+
    "\2\0\7\27\1\0\2\27\2\0\5\27\1\u0290\12\27"+
    "\36\0\14\27\1\u0291\1\27\2\0\7\27\1\0\2\27"+
    "\2\0\20\27\36\0\16\27\2\0\7\27\1\0\2\27"+
    "\2\0\1\u0292\17\27\36\0\16\27\2\0\7\27\1\0"+
    "\2\27\2\0\12\27\1\u0293\5\27\36\0\16\27\2\0"+
    "\7\27\1\0\2\27\2\0\12\27\1\u0294\5\27\36\0"+
    "\14\27\1\u0295\1\27\2\0\7\27\1\0\2\27\2\0"+
    "\20\27\36\0\16\134\2\0\7\134\1\0\1\134\3\0"+
    "\12\134\1\u0296\5\134\36\0\14\134\1\u0297\1\134\2\0"+
    "\7\134\1\0\1\134\3\0\20\134\36\0\16\134\2\0"+
    "\7\134\1\0\1\134\3\0\2\134\1\u0298\15\134\36\0"+
    "\14\134\1\u0299\1\134\2\0\7\134\1\0\1\134\3\0"+
    "\20\134\36\0\16\134\2\0\7\134\1\0\1\134\3\0"+
    "\5\134\1\u029a\12\134\36\0\14\134\1\u029b\1\134\2\0"+
    "\7\134\1\0\1\134\3\0\20\134\36\0\16\134\2\0"+
    "\7\134\1\0\1\134\3\0\1\u029c\17\134\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\12\134\1\u029d\5\134"+
    "\36\0\16\134\2\0\7\134\1\0\1\134\3\0\12\134"+
    "\1\u029e\5\134\36\0\14\134\1\u029f\1\134\2\0\7\134"+
    "\1\0\1\134\3\0\20\134\52\0\1\u02a0\75\0\16\27"+
    "\2\0\7\27\1\0\2\27\2\0\5\27\1\u02a1\12\27"+
    "\36\0\16\27\2\0\7\27\1\0\2\27\2\0\10\27"+
    "\1\u02a2\7\27\36\0\14\27\1\u02a3\1\27\2\0\7\27"+
    "\1\0\2\27\2\0\20\27\36\0\12\27\1\u02a4\3\27"+
    "\2\0\7\27\1\0\2\27\2\0\20\27\36\0\10\27"+
    "\1\u02a5\5\27\2\0\7\27\1\0\2\27\2\0\20\27"+
    "\36\0\16\27\2\0\7\27\1\0\2\27\2\0\5\27"+
    "\1\u02a6\12\27\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\5\134\1\u02a7\12\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\10\134\1\u02a8\7\134\36\0\14\134"+
    "\1\u02a9\1\134\2\0\7\134\1\0\1\134\3\0\20\134"+
    "\36\0\12\134\1\u02aa\3\134\2\0\7\134\1\0\1\134"+
    "\3\0\20\134\36\0\10\134\1\u02ab\5\134\2\0\7\134"+
    "\1\0\1\134\3\0\20\134\36\0\16\134\2\0\7\134"+
    "\1\0\1\134\3\0\5\134\1\u02ac\12\134\102\0\1\u02ad"+
    "\45\0\16\27\2\0\7\27\1\0\2\27\2\0\4\27"+
    "\1\u02ae\13\27\36\0\4\27\1\u02af\11\27\2\0\7\27"+
    "\1\0\2\27\2\0\20\27\36\0\16\27\2\0\7\27"+
    "\1\0\2\27\2\0\16\27\1\u02b0\1\27\36\0\16\134"+
    "\2\0\7\134\1\0\1\134\3\0\4\134\1\u02b1\13\134"+
    "\36\0\4\134\1\u02b2\11\134\2\0\7\134\1\0\1\134"+
    "\3\0\20\134\36\0\16\134\2\0\7\134\1\0\1\134"+
    "\3\0\16\134\1\u02b3\1\134\42\0\1\u02b4\105\0\14\27"+
    "\1\u02b5\1\27\2\0\7\27\1\0\2\27\2\0\20\27"+
    "\36\0\14\134\1\u02b6\1\134\2\0\7\134\1\0\1\134"+
    "\3\0\20\134\23\0\13\u02b7\16\0\2\u02b7\7\0\1\u02b7"+
    "\2\0\2\u02b7\20\0\23\u02b7\13\0\12\27\1\u02b8\3\27"+
    "\2\0\7\27\1\0\2\27\2\0\20\27\36\0\12\134"+
    "\1\u02b9\3\134\2\0\7\134\1\0\1\134\3\0\20\134"+
    "\23\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[37740];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\15\0\1\11\1\1\1\11\36\1\6\11\3\1\1\11"+
    "\2\1\1\11\4\1\6\11\3\1\1\11\3\1\1\11"+
    "\1\1\2\11\5\1\1\11\4\1\1\11\20\1\2\11"+
    "\1\1\2\11\2\1\1\0\4\1\2\11\1\1\1\0"+
    "\1\1\5\11\3\0\15\1\5\11\2\0\4\1\2\11"+
    "\1\1\1\0\1\1\2\0\31\1\5\11\1\1\1\0"+
    "\1\11\1\0\11\11\1\0\1\11\3\1\5\11\50\1"+
    "\1\0\2\1\1\11\1\0\1\11\1\1\1\0\23\1"+
    "\3\11\2\1\2\11\2\0\37\1\5\11\1\0\1\11"+
    "\3\0\1\11\60\1\2\11\1\0\1\11\1\0\15\1"+
    "\2\0\3\1\11\0\34\1\1\11\54\1\1\11\1\0"+
    "\1\1\1\0\15\1\4\0\70\1\2\0\11\1\1\11"+
    "\51\1\1\0\40\1\1\0\24\1\1\0\14\1\1\0"+
    "\6\1\1\0\2\1\1\11\2\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[697];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
  @Override
  protected int getInitialState() {
    return YYINITIAL;
  }

  @Override
  protected int getDivisionExpectedState() {
    return DIVISION_EXPECTED;
  }

  @Override
  protected int[] getDivisionStates() {
    return new int[] {YYINITIAL, IN_INJECTION};
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public _GroovyLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    int size = 0;
    for (int i = 0, length = packed.length(); i < length; i += 2) {
      size += packed.charAt(i);
    }
    char[] map = new char[size];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < packed.length()) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    resetState();
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      {@code false}, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position {@code pos} from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + ZZ_CMAP(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        switch (zzLexicalState) {
            case IN_TRIPLE_STRING: {
              yyendstate(IN_TRIPLE_STRING); return storeToken(STRING_TSQ);
            }  // fall though
            case 698: break;
            default:
        return null;
        }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return T_WRONG;
            } 
            // fall through
          case 168: break;
          case 2: 
            { return storeToken(NL);
            } 
            // fall through
          case 169: break;
          case 3: 
            { return TokenType.WHITE_SPACE;
            } 
            // fall through
          case 170: break;
          case 4: 
            { yybeginstate(IN_SLASHY_STRING);
                                            return storeToken(SLASHY_BEGIN);
            } 
            // fall through
          case 171: break;
          case 5: 
            { return storeToken(T_STAR);
            } 
            // fall through
          case 172: break;
          case 6: 
            { return storeToken(T_NOT);
            } 
            // fall through
          case 173: break;
          case 7: 
            { return storeToken(IDENTIFIER);
            } 
            // fall through
          case 174: break;
          case 8: 
            { return storeToken(NUM_INT);
            } 
            // fall through
          case 175: break;
          case 9: 
            { return storeToken(T_PLUS);
            } 
            // fall through
          case 176: break;
          case 10: 
            { return storeToken(T_MINUS);
            } 
            // fall through
          case 177: break;
          case 11: 
            { return storeToken(T_DOT);
            } 
            // fall through
          case 178: break;
          case 12: 
            { return storeToken(STRING_SQ);
            } 
            // fall through
          case 179: break;
          case 13: 
            { yybeginstate(IN_SINGLE_GSTRING);
                                            return storeToken(GSTRING_BEGIN);
            } 
            // fall through
          case 180: break;
          case 14: 
            { yybeginstate(NLS_AFTER_LBRACE); return storeToken(T_LBRACE);
            } 
            // fall through
          case 181: break;
          case 15: 
            { return storeToken(T_LPAREN);
            } 
            // fall through
          case 182: break;
          case 16: 
            { return storeToken(T_RPAREN);
            } 
            // fall through
          case 183: break;
          case 17: 
            { return storeToken(T_LBRACK);
            } 
            // fall through
          case 184: break;
          case 18: 
            { return storeToken(T_RBRACK);
            } 
            // fall through
          case 185: break;
          case 19: 
            { return storeToken(T_RBRACE);
            } 
            // fall through
          case 186: break;
          case 20: 
            { return storeToken(T_ASSIGN);
            } 
            // fall through
          case 187: break;
          case 21: 
            { return storeToken(T_Q);
            } 
            // fall through
          case 188: break;
          case 22: 
            { return storeToken(T_COLON);
            } 
            // fall through
          case 189: break;
          case 23: 
            { return storeToken(T_COMMA);
            } 
            // fall through
          case 190: break;
          case 24: 
            { return storeToken(T_LT);
            } 
            // fall through
          case 191: break;
          case 25: 
            { return storeToken(T_GT);
            } 
            // fall through
          case 192: break;
          case 26: 
            { return storeToken(T_BNOT);
            } 
            // fall through
          case 193: break;
          case 27: 
            { return storeToken(T_REM);
            } 
            // fall through
          case 194: break;
          case 28: 
            { return storeToken(T_XOR);
            } 
            // fall through
          case 195: break;
          case 29: 
            { return storeToken(T_BOR);
            } 
            // fall through
          case 196: break;
          case 30: 
            { return storeToken(T_BAND);
            } 
            // fall through
          case 197: break;
          case 31: 
            { return storeToken(T_SEMI);
            } 
            // fall through
          case 198: break;
          case 32: 
            { return storeToken(T_AT);
            } 
            // fall through
          case 199: break;
          case 33: 
            { yybeginstate(NLS_AFTER_LBRACE, IN_INJECTION_BRACES); return storeToken(T_LBRACE);
            } 
            // fall through
          case 200: break;
          case 34: 
            { yyendstate(IN_INJECTION, IN_GSTRING_DOLLAR); return storeToken(T_RBRACE);
            } 
            // fall through
          case 201: break;
          case 35: 
            { yyendstate(IN_INJECTION_BRACES); return storeToken(T_RBRACE);
            } 
            // fall through
          case 202: break;
          case 36: 
            { yypushback(1);
    yyendstate(DIVISION_EXPECTED);
            } 
            // fall through
          case 203: break;
          case 37: 
            { yyendstate(DIVISION_EXPECTED);
    return storeToken(T_DIV);
            } 
            // fall through
          case 204: break;
          case 38: 
            { 
            } 
            // fall through
          case 205: break;
          case 39: 
            { return storeToken(GSTRING_CONTENT);
            } 
            // fall through
          case 206: break;
          case 40: 
            { yypushback(1);
    yyendstate(IN_SINGLE_GSTRING);
            } 
            // fall through
          case 207: break;
          case 41: 
            { yybeginstate(IN_GSTRING_DOLLAR);
    return storeToken(T_DOLLAR);
            } 
            // fall through
          case 208: break;
          case 42: 
            { yyendstate(IN_SINGLE_GSTRING);
    return storeToken(GSTRING_END);
            } 
            // fall through
          case 209: break;
          case 43: 
            { return storeToken(SLASHY_CONTENT);
            } 
            // fall through
          case 210: break;
          case 44: 
            { yyendstate(IN_SLASHY_STRING);
    return storeToken(SLASHY_END);
            } 
            // fall through
          case 211: break;
          case 45: 
            { return storeToken(DOLLAR_SLASHY_CONTENT);
            } 
            // fall through
          case 212: break;
          case 46: 
            { yypushback(1);
    yyendstate(IN_GSTRING_DOLLAR);
            } 
            // fall through
          case 213: break;
          case 47: 
            { yybeginstate(IN_GSTRING_DOT);
    return storeToken(IDENTIFIER);
            } 
            // fall through
          case 214: break;
          case 48: 
            { yybeginstate(IN_INJECTION, NLS_AFTER_LBRACE);
    return storeToken(T_LBRACE);
            } 
            // fall through
          case 215: break;
          case 49: 
            { yypushback(1);
    yyendstate(IN_GSTRING_DOT);
            } 
            // fall through
          case 216: break;
          case 50: 
            { yypushback(1);
    yyendstate(IN_GSTRING_DOT_IDENT);
            } 
            // fall through
          case 217: break;
          case 51: 
            { yypushback(1);
    yyendstate(NLS_AFTER_LBRACE);
            } 
            // fall through
          case 218: break;
          case 52: 
            { return storeToken(SL_COMMENT);
            } 
            // fall through
          case 219: break;
          case 53: 
            { return storeToken(ML_COMMENT);
            } 
            // fall through
          case 220: break;
          case 54: 
            { return storeToken(T_POW);
            } 
            // fall through
          case 221: break;
          case 55: 
            { return storeToken(T_SPREAD_DOT);
            } 
            // fall through
          case 222: break;
          case 56: 
            { return storeToken(T_STAR_ASSIGN);
            } 
            // fall through
          case 223: break;
          case 57: 
            { return storeToken(SH_COMMENT);
            } 
            // fall through
          case 224: break;
          case 58: 
            { return storeToken(T_NEQ);
            } 
            // fall through
          case 225: break;
          case 59: 
            { return storeToken(NUM_BIG_INT);
            } 
            // fall through
          case 226: break;
          case 60: 
            { return storeToken(NUM_FLOAT);
            } 
            // fall through
          case 227: break;
          case 61: 
            { return storeToken(NUM_LONG);
            } 
            // fall through
          case 228: break;
          case 62: 
            { return storeToken(NUM_DOUBLE);
            } 
            // fall through
          case 229: break;
          case 63: 
            { return storeToken(KW_IF);
            } 
            // fall through
          case 230: break;
          case 64: 
            { return storeToken(KW_IN);
            } 
            // fall through
          case 231: break;
          case 65: 
            { return storeToken(KW_DO);
            } 
            // fall through
          case 232: break;
          case 66: 
            { return storeToken(T_INC);
            } 
            // fall through
          case 233: break;
          case 67: 
            { return storeToken(T_PLUS_ASSIGN);
            } 
            // fall through
          case 234: break;
          case 68: 
            { return storeToken(T_DEC);
            } 
            // fall through
          case 235: break;
          case 69: 
            { return storeToken(T_MINUS_ASSIGN);
            } 
            // fall through
          case 236: break;
          case 70: 
            { return storeToken(T_ARROW);
            } 
            // fall through
          case 237: break;
          case 71: 
            { return storeToken(T_RANGE);
            } 
            // fall through
          case 238: break;
          case 72: 
            { return storeToken(T_METHOD_CLOSURE);
            } 
            // fall through
          case 239: break;
          case 73: 
            { yybeginstate(IN_DOLLAR_SLASH_STRING);
                                            return storeToken(DOLLAR_SLASHY_BEGIN);
            } 
            // fall through
          case 240: break;
          case 74: 
            { return storeToken(STRING_DQ);
            } 
            // fall through
          case 241: break;
          case 75: 
            { return storeToken(KW_AS);
            } 
            // fall through
          case 242: break;
          case 76: 
            { return storeToken(T_EQ);
            } 
            // fall through
          case 243: break;
          case 77: 
            { return storeToken(T_REGEX_FIND);
            } 
            // fall through
          case 244: break;
          case 78: 
            { return storeToken(T_SAFE_DOT);
            } 
            // fall through
          case 245: break;
          case 79: 
            { return storeToken(T_ELVIS_ASSIGN);
            } 
            // fall through
          case 246: break;
          case 80: 
            { return storeToken(T_ELVIS);
            } 
            // fall through
          case 247: break;
          case 81: 
            { return storeToken(T_METHOD_REFERENCE);
            } 
            // fall through
          case 248: break;
          case 82: 
            { return storeToken(T_LE);
            } 
            // fall through
          case 249: break;
          case 83: 
            { return storeToken(T_GE);
            } 
            // fall through
          case 250: break;
          case 84: 
            { return storeToken(T_REM_ASSIGN);
            } 
            // fall through
          case 251: break;
          case 85: 
            { return storeToken(T_XOR_ASSIGN);
            } 
            // fall through
          case 252: break;
          case 86: 
            { return storeToken(T_BOR_ASSIGN);
            } 
            // fall through
          case 253: break;
          case 87: 
            { return storeToken(T_LOR);
            } 
            // fall through
          case 254: break;
          case 88: 
            { return storeToken(T_BAND_ASSIGN);
            } 
            // fall through
          case 255: break;
          case 89: 
            { return storeToken(T_LAND);
            } 
            // fall through
          case 256: break;
          case 90: 
            { yypushback(2);
    yyendstate(DIVISION_EXPECTED);
            } 
            // fall through
          case 257: break;
          case 91: 
            { yyendstate(DIVISION_EXPECTED);
    return storeToken(T_DIV_ASSIGN);
            } 
            // fall through
          case 258: break;
          case 92: 
            { yypushback(1);
    yyendstate(DIVISION_EXPECTED);
    return storeToken(T_DOLLAR);
            } 
            // fall through
          case 259: break;
          case 93: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 1);
            { return storeToken(SLASHY_CONTENT);
            } 
            // fall through
          case 260: break;
          case 94: 
            { yyendstate(IN_DOLLAR_SLASH_STRING);
    return storeToken(DOLLAR_SLASHY_END);
            } 
            // fall through
          case 261: break;
          case 95: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 1);
            { return storeToken(DOLLAR_SLASHY_CONTENT);
            } 
            // fall through
          case 262: break;
          case 96: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 1);
            { yybeginstate(IN_GSTRING_DOT_IDENT);
    return storeToken(T_DOT);
            } 
            // fall through
          case 263: break;
          case 97: 
            { return storeToken(GROOVY_DOC_COMMENT);
            } 
            // fall through
          case 264: break;
          case 98: 
            { return storeToken(T_POW_ASSIGN);
            } 
            // fall through
          case 265: break;
          case 99: 
            { return storeToken(T_NID);
            } 
            // fall through
          case 266: break;
          case 100: 
            { return storeToken(NUM_BIG_DECIMAL);
            } 
            // fall through
          case 267: break;
          case 101: 
            { return storeToken(KW_FOR);
            } 
            // fall through
          case 268: break;
          case 102: 
            { return storeToken(KW_INT);
            } 
            // fall through
          case 269: break;
          case 103: 
            { return storeToken(KW_DEF);
            } 
            // fall through
          case 270: break;
          case 104: 
            { return storeToken(T_ELLIPSIS);
            } 
            // fall through
          case 271: break;
          case 105: 
            { return storeToken(T_RANGE_EX);
            } 
            // fall through
          case 272: break;
          case 106: 
            { yybeginstate(IN_TRIPLE_STRING);
            } 
            // fall through
          case 273: break;
          case 107: 
            { yybeginstate(IN_TRIPLE_GSTRING);
                                            return storeToken(GSTRING_BEGIN);
            } 
            // fall through
          case 274: break;
          case 108: 
            { return storeToken(KW_TRY);
            } 
            // fall through
          case 275: break;
          case 109: 
            { return storeToken(KW_VAR);
            } 
            // fall through
          case 276: break;
          case 110: 
            { return storeToken(KW_NEW);
            } 
            // fall through
          case 277: break;
          case 111: 
            { return storeToken(T_ID);
            } 
            // fall through
          case 278: break;
          case 112: 
            { return storeToken(T_REGEX_MATCH);
            } 
            // fall through
          case 279: break;
          case 113: 
            { return storeToken(T_COMPARE);
            } 
            // fall through
          case 280: break;
          case 114: 
            { return storeToken(T_LSH_ASSIGN);
            } 
            // fall through
          case 281: break;
          case 115: 
            { return storeToken(T_RSH_ASSIGN);
            } 
            // fall through
          case 282: break;
          case 116: 
            { yyendstate(IN_TRIPLE_STRING); return storeToken(STRING_TSQ);
            } 
            // fall through
          case 283: break;
          case 117: 
            { yyendstate(IN_TRIPLE_GSTRING);
    return storeToken(GSTRING_END);
            } 
            // fall through
          case 284: break;
          case 118: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 3);
            { return storeToken(T_NOT_IN);
            } 
            // fall through
          case 285: break;
          case 119: 
            { return storeToken(KW_LONG);
            } 
            // fall through
          case 286: break;
          case 120: 
            { return storeToken(KW_ELSE);
            } 
            // fall through
          case 287: break;
          case 121: 
            { return storeToken(KW_ENUM);
            } 
            // fall through
          case 288: break;
          case 122: 
            { return storeToken(KW_BYTE);
            } 
            // fall through
          case 289: break;
          case 123: 
            { return storeToken(KW_CASE);
            } 
            // fall through
          case 290: break;
          case 124: 
            { return storeToken(KW_CHAR);
            } 
            // fall through
          case 291: break;
          case 125: 
            { return storeToken(KW_TRUE);
            } 
            // fall through
          case 292: break;
          case 126: 
            { return storeToken(KW_THIS);
            } 
            // fall through
          case 293: break;
          case 127: 
            { return storeToken(KW_VOID);
            } 
            // fall through
          case 294: break;
          case 128: 
            { return storeToken(KW_NULL);
            } 
            // fall through
          case 295: break;
          case 129: 
            { return storeToken(T_RSHU_ASSIGN);
            } 
            // fall through
          case 296: break;
          case 130: 
            { return storeToken(KW_FLOAT);
            } 
            // fall through
          case 297: break;
          case 131: 
            { return storeToken(KW_FINAL);
            } 
            // fall through
          case 298: break;
          case 132: 
            { return storeToken(KW_FALSE);
            } 
            // fall through
          case 299: break;
          case 133: 
            { return storeToken(KW_BREAK);
            } 
            // fall through
          case 300: break;
          case 134: 
            { return storeToken(KW_CLASS);
            } 
            // fall through
          case 301: break;
          case 135: 
            { return storeToken(KW_CATCH);
            } 
            // fall through
          case 302: break;
          case 136: 
            { return storeToken(KW_SUPER);
            } 
            // fall through
          case 303: break;
          case 137: 
            { return storeToken(KW_SHORT);
            } 
            // fall through
          case 304: break;
          case 138: 
            { return storeToken(KW_TRAIT);
            } 
            // fall through
          case 305: break;
          case 139: 
            { return storeToken(KW_THROW);
            } 
            // fall through
          case 306: break;
          case 140: 
            { return storeToken(KW_WHILE);
            } 
            // fall through
          case 307: break;
          case 141: 
            { return storeToken(KW_IMPORT);
            } 
            // fall through
          case 308: break;
          case 142: 
            { return storeToken(KW_DOUBLE);
            } 
            // fall through
          case 309: break;
          case 143: 
            { return storeToken(STRING_TDQ);
            } 
            // fall through
          case 310: break;
          case 144: 
            { return storeToken(KW_PUBLIC);
            } 
            // fall through
          case 311: break;
          case 145: 
            { return storeToken(KW_ASSERT);
            } 
            // fall through
          case 312: break;
          case 146: 
            { return storeToken(KW_STATIC);
            } 
            // fall through
          case 313: break;
          case 147: 
            { return storeToken(KW_SWITCH);
            } 
            // fall through
          case 314: break;
          case 148: 
            { return storeToken(KW_THROWS);
            } 
            // fall through
          case 315: break;
          case 149: 
            { return storeToken(KW_RETURN);
            } 
            // fall through
          case 316: break;
          case 150: 
            { return storeToken(KW_NATIVE);
            } 
            // fall through
          case 317: break;
          case 151: 
            { return storeToken(KW_FINALLY);
            } 
            // fall through
          case 318: break;
          case 152: 
            { return storeToken(KW_DEFAULT);
            } 
            // fall through
          case 319: break;
          case 153: 
            { return storeToken(KW_EXTENDS);
            } 
            // fall through
          case 320: break;
          case 154: 
            { return storeToken(KW_BOOLEAN);
            } 
            // fall through
          case 321: break;
          case 155: 
            { return storeToken(KW_PACKAGE);
            } 
            // fall through
          case 322: break;
          case 156: 
            { return storeToken(KW_PRIVATE);
            } 
            // fall through
          case 323: break;
          case 157: 
            { return storeToken(KW_ABSTRACT);
            } 
            // fall through
          case 324: break;
          case 158: 
            { return storeToken(KW_CONTINUE);
            } 
            // fall through
          case 325: break;
          case 159: 
            { return storeToken(KW_STRICTFP);
            } 
            // fall through
          case 326: break;
          case 160: 
            { return storeToken(KW_VOLATILE);
            } 
            // fall through
          case 327: break;
          case 161: 
            { return storeToken(KW_INTERFACE);
            } 
            // fall through
          case 328: break;
          case 162: 
            { return storeToken(KW_PROTECTED);
            } 
            // fall through
          case 329: break;
          case 163: 
            { return storeToken(KW_TRANSIENT);
            } 
            // fall through
          case 330: break;
          case 164: 
            { return storeToken(KW_IMPLEMENTS);
            } 
            // fall through
          case 331: break;
          case 165: 
            { return storeToken(KW_INSTANCEOF);
            } 
            // fall through
          case 332: break;
          case 166: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 11);
            { return storeToken(T_NOT_INSTANCEOF);
            } 
            // fall through
          case 333: break;
          case 167: 
            { return storeToken(KW_SYNCHRONIZED);
            } 
            // fall through
          case 334: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
