/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.plugins.groovy.lang.psi.api.statements;

import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;

/**
 * @author: Dmitry.Krasilschikov
 * @date: 21.03.2007
 */
public interface GrStatement extends GrTopStatement, GrCondition {
  GrStatement[] EMPTY_ARRAY = new GrStatement[0];
  
  <T extends GrStatement> T replaceWithStatement (T statement);

  void removeStatement() throws IncorrectOperationException;
}
