/* The following code was generated by JFlex 1.7.0 tweaked for IntelliJ platform */

package org.jetbrains.yaml.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.yaml.YAMLTokenTypes;

/* Auto generated File */

/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.7.0
 * from the specification file <tt>yaml.flex</tt>
 */
public class _YAMLLexer implements FlexLexer, YAMLTokenTypes {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int LINE_START_STATE = 2;
  public static final int BLOCK_STATE = 4;
  public static final int FLOW_STATE = 6;
  public static final int POSSIBLE_PLAIN_TEXT_STATE = 8;
  public static final int ANCHOR_MODE = 10;
  public static final int ALIAS_MODE = 12;
  public static final int KEY_MODE = 14;
  public static final int BS_HEADER_TAIL_STATE = 16;
  public static final int BS_BODY_STATE = 18;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6, 
     7,  7,  8, 8
  };

  /** 
   * Translates characters to character classes
   * Chosen bits are [10, 6, 5]
   * Total runtime size is 4224 bytes
   */
  public static int ZZ_CMAP(int ch) {
    return ZZ_CMAP_A[(ZZ_CMAP_Y[(ZZ_CMAP_Z[ch>>11]<<6)|((ch>>5)&0x3f)]<<5)|(ch&0x1f)];
  }

  /* The ZZ_CMAP_Z table has 544 entries */
  static final char ZZ_CMAP_Z[] = zzUnpackCMap(
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\15\5\1\7\1\10\11\5\1\11\1\12\1\5\1\13\1\14\11"+
    "\5\1\15\14\5\1\16\2\5\1\17\u01e2\5");

  /* The ZZ_CMAP_Y table has 1024 entries */
  static final char ZZ_CMAP_Y[] = zzUnpackCMap(
    "\1\0\1\1\1\2\1\3\1\4\1\5\55\6\1\7\3\6\1\10\6\6\1\7\14\6\1\11\3\6\1\11\3\6"+
    "\1\11\3\6\1\11\3\6\1\11\3\6\1\11\3\6\1\11\3\6\1\11\3\6\1\11\3\6\1\11\2\6\1"+
    "\10\3\6\1\10\2\6\1\7\10\6\1\7\1\6\1\10\57\6\1\5\12\6\1\7\1\10\11\6\1\11\3"+
    "\6\1\10\5\6\1\12\5\6\1\10\2\6\1\10\4\6\1\12\35\6\1\13\1\14\1\15\175\6\1\5"+
    "\160\6\1\7\24\6\1\10\1\6\1\7\5\6\2\10\2\6\1\10\14\6\1\10\130\6\1\10\54\6\1"+
    "\7\35\6\1\11\3\6\1\10\1\6\1\16\4\6\1\10\10\6\1\10\12\6\1\10\3\6\1\10\13\6"+
    "\1\10\3\6\1\7\2\6\1\10\15\6\1\7\32\6\1\10\60\6\1\7\6\6\1\10\143\6\1\17\1\20"+
    "\12\6\1\10\65\6");

  /* The ZZ_CMAP_A table has 544 entries */
  static final char ZZ_CMAP_A[] = zzUnpackCMap(
    "\11\0\1\10\1\7\2\32\1\1\22\0\1\13\1\30\1\21\1\6\1\26\1\17\1\35\1\22\2\26\1"+
    "\36\1\33\1\3\1\12\1\34\1\26\12\24\1\5\1\26\1\31\1\26\1\14\1\4\1\27\6\23\24"+
    "\25\1\37\1\20\1\11\1\0\1\26\1\2\6\23\24\25\1\15\1\40\1\16\1\26\6\0\1\32\32"+
    "\0\1\32\77\0\12\24\46\0\12\24\14\0\12\24\20\0\12\24\6\0\12\24\6\0\13\32\35"+
    "\0\2\32\5\0\1\32\57\0\1\32\26\0\12\24\16\0\62\24");

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\20\0\1\1\1\2\2\1\1\3\1\4\1\5\1\6"+
    "\1\7\1\10\1\11\1\12\1\4\1\13\1\14\1\15"+
    "\6\4\1\16\1\17\1\4\1\20\1\5\1\6\1\21"+
    "\1\4\1\14\4\4\1\22\1\23\2\4\1\24\1\25"+
    "\1\26\1\4\1\27\1\30\1\31\13\0\1\32\1\0"+
    "\2\33\2\13\5\0\1\34\2\0\1\35\1\0\2\36"+
    "\4\0\1\37\1\40\2\17\1\0\1\41\5\0\1\42"+
    "\7\0\2\4\3\0\1\4\1\0\1\43\16\0\1\44"+
    "\1\45\1\3\1\0\1\13\1\0\1\4\3\0\1\34"+
    "\1\46\1\0\1\35\3\0\1\17\1\4\3\0\1\4"+
    "\2\0\1\47\1\0\1\4\1\0\1\4\1\42\3\0"+
    "\3\4\1\0\1\50\2\0\2\4\7\0\1\51\1\4"+
    "\3\0\1\4\1\0\1\4\2\0\1\52\1\4\4\0"+
    "\1\4\2\0\2\4\1\0\3\47\1\0\1\42\1\0"+
    "\1\50\1\0\1\4\1\0\2\4\1\0\1\53\1\0"+
    "\1\4\3\0\3\4\2\0\2\4\1\47\2\4\1\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[238];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\41\0\102\0\143\0\204\0\245\0\306\0\347"+
    "\0\u0108\0\u0129\0\u014a\0\u016b\0\u018c\0\u01ad\0\u01ce\0\u01ef"+
    "\0\u0210\0\u0231\0\u0252\0\u0273\0\u0294\0\u0210\0\u02b5\0\u02b5"+
    "\0\u02d6\0\u0210\0\u02f7\0\u0210\0\u0318\0\u0339\0\u035a\0\u0210"+
    "\0\u037b\0\u039c\0\u03bd\0\u03de\0\u03ff\0\u0420\0\u0210\0\u0441"+
    "\0\u0462\0\u0210\0\u0483\0\u0483\0\u04a4\0\u04c5\0\u04e6\0\u0507"+
    "\0\u0528\0\u0549\0\u056a\0\u058b\0\u0210\0\u05ac\0\u05cd\0\u05ee"+
    "\0\u060f\0\u0210\0\u0630\0\u0210\0\u0651\0\u0672\0\u0693\0\u0210"+
    "\0\u06b4\0\u06d5\0\u06f6\0\u0717\0\u0738\0\u0759\0\u077a\0\u079b"+
    "\0\u07bc\0\u07dd\0\u07fe\0\u0210\0\u081f\0\u0840\0\u0861\0\u0882"+
    "\0\u08a3\0\u039c\0\u08c4\0\u08e5\0\u0906\0\u03bd\0\u0927\0\u0948"+
    "\0\u0969\0\u0210\0\u098a\0\u09ab\0\u09cc\0\u09ed\0\u0a0e\0\u03ff"+
    "\0\u0420\0\u0a2f\0\u0a50\0\u0a71\0\u0a92\0\u0ab3\0\u0ad4\0\u0af5"+
    "\0\u0b16\0\u0b37\0\u0b58\0\u0b79\0\u0b9a\0\u0bbb\0\u0bdc\0\u0bfd"+
    "\0\u0c1e\0\u0c3f\0\u0c60\0\u0c81\0\u0ca2\0\u0cc3\0\u0ce4\0\u0d05"+
    "\0\u0d26\0\u0210\0\u0672\0\u0d47\0\u0d68\0\u0d89\0\u0d47\0\u0daa"+
    "\0\u0dcb\0\u0210\0\u0dec\0\u0e0d\0\u0e2e\0\u0e4f\0\u0e70\0\u0e91"+
    "\0\u0eb2\0\u0eb2\0\u07fe\0\u0ed3\0\u0210\0\u0ef4\0\u0f15\0\u0f36"+
    "\0\u0f57\0\u0f78\0\u0210\0\u0210\0\u0906\0\u0f99\0\u0fba\0\u0fdb"+
    "\0\u0ffc\0\u0210\0\u0ab3\0\u101d\0\u103e\0\u105f\0\u1080\0\u10a1"+
    "\0\u10c2\0\u0b79\0\u10e3\0\u0bbb\0\u1104\0\u1125\0\u1146\0\u1167"+
    "\0\u1188\0\u11a9\0\u0c3f\0\u11ca\0\u11eb\0\u120c\0\u0b9a\0\u11eb"+
    "\0\u122d\0\u0ce4\0\u124e\0\u126f\0\u1290\0\u12b1\0\u12d2\0\u0e2e"+
    "\0\u12f3\0\u0e91\0\u0210\0\u1314\0\u1335\0\u1356\0\u1377\0\u1398"+
    "\0\u13b9\0\u13da\0\u13fb\0\u141c\0\u143d\0\u145e\0\u147f\0\u14a0"+
    "\0\u14c1\0\u14e2\0\u1503\0\u1524\0\u1545\0\u1566\0\u0b79\0\u1587"+
    "\0\u15a8\0\u15c9\0\u15ea\0\u160b\0\u162c\0\u164d\0\u0210\0\u166e"+
    "\0\u168f\0\u16b0\0\u16d1\0\u16f2\0\u1713\0\u0210\0\u1734\0\u1755"+
    "\0\u1776\0\u1797\0\u17b8\0\u17d9\0\u1524\0\u17fa\0\u181b\0\u17fa"+
    "\0\u183c\0\u185d\0\u1167\0\u13b9\0\u15a8\0\u15ea";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[238];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\10\21\1\22\1\21\1\23\1\22\20\21\1\24\4\21"+
    "\1\25\3\26\1\27\1\30\1\31\1\32\1\33\1\34"+
    "\1\35\1\33\1\36\1\37\1\40\1\41\1\25\1\42"+
    "\1\43\4\25\1\26\1\44\4\25\1\45\1\46\1\47"+
    "\1\50\1\51\2\26\1\52\1\53\1\54\1\31\1\55"+
    "\1\33\1\34\1\56\1\33\1\36\1\57\1\40\1\60"+
    "\1\51\1\42\1\43\4\51\1\26\1\44\4\51\1\45"+
    "\1\46\1\47\1\50\1\61\1\26\2\62\1\63\1\64"+
    "\1\31\1\65\1\33\1\62\1\63\1\33\4\62\1\61"+
    "\1\66\1\67\4\61\2\62\4\61\4\62\1\70\1\26"+
    "\1\70\1\26\1\70\1\26\1\70\3\26\1\70\1\26"+
    "\1\70\2\26\13\70\1\26\4\70\1\26\1\70\1\71"+
    "\1\26\1\71\1\26\1\71\1\26\1\71\3\26\1\71"+
    "\1\26\1\71\2\26\13\71\1\26\4\71\1\26\1\71"+
    "\5\26\1\72\2\26\1\33\2\26\1\33\25\26\6\73"+
    "\1\31\1\74\1\33\2\73\1\33\25\73\7\75\1\76"+
    "\1\33\2\75\1\33\25\75\30\0\1\77\17\0\1\100"+
    "\1\101\2\0\1\101\46\0\1\102\1\103\23\0\1\101"+
    "\33\0\1\104\3\0\2\105\4\0\1\105\5\0\1\104"+
    "\2\0\4\104\2\0\4\104\4\0\1\106\3\0\2\107"+
    "\4\0\1\107\5\0\1\106\2\0\4\106\2\0\4\106"+
    "\4\0\1\15\1\0\5\15\2\0\2\15\1\0\25\15"+
    "\51\0\1\22\2\0\1\22\37\0\1\110\62\0\1\111"+
    "\4\0\1\25\1\0\3\25\1\112\1\25\1\0\1\113"+
    "\2\25\1\113\26\25\1\0\5\25\2\0\2\25\1\0"+
    "\25\25\7\31\1\0\31\31\10\0\1\33\2\0\1\33"+
    "\25\0\1\25\1\0\5\25\1\114\1\115\2\25\1\115"+
    "\25\25\12\0\1\116\11\0\1\117\6\0\1\116\22\0"+
    "\1\120\40\0\1\121\23\0\7\122\1\123\10\122\1\124"+
    "\1\125\17\122\7\126\1\127\12\126\1\130\16\126\4\0"+
    "\3\131\1\132\1\133\1\0\1\134\1\133\3\0\1\135"+
    "\2\0\1\131\3\134\2\131\1\136\1\137\1\0\4\131"+
    "\2\0\1\140\1\0\1\140\1\0\1\140\1\0\1\140"+
    "\3\0\1\140\1\0\1\140\2\0\13\140\1\0\4\140"+
    "\1\0\1\140\1\141\1\0\1\141\1\0\1\141\1\0"+
    "\1\141\3\0\1\141\1\0\1\141\2\0\13\141\1\0"+
    "\4\141\1\0\1\141\12\0\1\142\11\0\1\143\6\0"+
    "\1\142\5\0\1\51\1\0\1\51\1\144\1\51\1\145"+
    "\1\51\1\0\1\146\1\144\1\51\1\146\1\51\2\144"+
    "\20\51\1\144\2\51\1\0\1\51\1\0\3\51\3\0"+
    "\1\51\1\0\1\51\2\0\20\51\1\0\1\51\12\0"+
    "\1\147\21\0\1\150\4\0\1\51\1\0\1\51\1\0"+
    "\3\51\1\114\1\115\1\0\1\51\1\115\1\51\2\0"+
    "\20\51\1\0\1\51\15\0\1\151\40\0\1\152\23\0"+
    "\1\61\1\0\3\61\1\153\1\61\1\0\1\154\2\61"+
    "\1\154\25\61\1\62\1\0\3\62\1\155\1\62\1\0"+
    "\1\156\2\62\1\156\25\62\1\61\1\0\3\61\1\157"+
    "\1\61\1\0\1\156\2\61\1\156\26\61\1\0\5\61"+
    "\2\0\2\61\1\0\25\61\1\66\1\160\3\66\1\161"+
    "\1\66\1\0\1\162\2\66\1\162\4\66\1\163\1\164"+
    "\17\66\1\67\1\165\3\67\1\166\1\67\1\0\1\167"+
    "\2\67\1\167\6\67\1\170\16\67\1\70\1\0\1\70"+
    "\1\0\1\70\1\0\1\70\3\0\1\70\1\0\1\70"+
    "\2\0\13\70\1\0\4\70\1\0\1\70\1\71\1\0"+
    "\1\71\1\0\1\71\1\0\1\71\3\0\1\71\1\0"+
    "\1\71\2\0\13\71\1\0\4\71\1\0\1\71\7\73"+
    "\1\0\1\171\2\73\1\171\25\73\7\75\1\0\31\75"+
    "\1\172\1\0\5\172\1\0\1\173\2\172\1\173\25\172"+
    "\4\0\3\174\3\0\1\175\4\0\1\176\2\0\1\174"+
    "\3\175\2\174\1\177\1\200\1\0\4\174\12\0\1\101"+
    "\2\0\1\101\25\0\7\102\1\0\10\102\1\201\1\202"+
    "\17\102\7\103\1\0\12\103\1\203\16\103\1\104\1\0"+
    "\3\104\1\204\1\104\1\0\1\205\2\104\1\205\26\104"+
    "\1\0\5\104\2\0\2\104\1\0\25\104\1\106\1\0"+
    "\1\106\1\206\1\106\1\207\1\106\1\0\1\210\1\206"+
    "\1\106\1\210\1\106\2\206\20\106\1\206\2\106\1\0"+
    "\1\106\1\0\3\106\3\0\1\106\1\0\1\106\2\0"+
    "\20\106\1\0\1\106\12\0\1\211\62\0\1\212\4\0"+
    "\1\213\1\0\5\213\2\0\2\213\1\0\25\213\1\25"+
    "\1\0\3\25\1\112\1\214\1\0\1\113\2\25\1\113"+
    "\25\25\10\0\1\115\2\0\1\115\51\0\1\116\26\0"+
    "\1\215\11\0\1\117\6\0\1\215\5\0\6\216\2\0"+
    "\1\216\3\0\1\216\2\0\20\216\1\0\1\216\1\217"+
    "\3\121\2\220\1\121\1\0\2\121\1\220\3\121\1\221"+
    "\1\121\1\217\2\121\4\217\2\121\4\217\4\121\20\123"+
    "\1\222\1\223\17\123\7\122\1\123\31\122\5\0\1\224"+
    "\2\0\1\225\2\0\1\225\25\0\22\127\1\226\16\127"+
    "\5\0\1\224\2\0\1\225\2\0\1\225\6\0\1\126"+
    "\22\0\3\131\1\132\1\133\1\0\1\131\1\133\3\0"+
    "\1\135\2\0\6\131\3\0\4\131\12\0\1\133\2\0"+
    "\1\133\31\0\3\131\1\132\1\133\1\0\1\134\1\133"+
    "\3\0\1\135\2\0\1\131\3\134\2\131\1\136\2\0"+
    "\4\131\25\0\2\227\20\0\3\131\3\0\1\131\4\0"+
    "\1\135\2\0\6\131\3\0\4\131\5\0\4\230\2\0"+
    "\2\230\4\0\1\231\2\0\7\230\2\0\5\230\25\0"+
    "\1\142\26\0\1\232\11\0\1\143\6\0\1\232\13\0"+
    "\1\233\32\0\1\233\1\0\1\233\1\0\3\233\3\0"+
    "\1\233\1\0\1\233\2\0\20\233\1\0\1\233\1\51"+
    "\1\0\1\51\1\144\1\51\1\145\1\144\1\0\1\146"+
    "\1\144\1\51\1\146\1\51\2\144\20\51\1\144\1\51"+
    "\12\0\1\234\62\0\1\235\4\0\6\236\2\0\1\236"+
    "\3\0\1\236\2\0\20\236\1\0\1\236\1\237\3\152"+
    "\2\240\1\152\1\0\2\152\1\240\3\152\1\241\1\152"+
    "\1\237\2\152\4\237\2\152\4\237\4\152\1\242\1\0"+
    "\5\242\2\0\2\242\1\0\25\242\1\61\1\0\3\61"+
    "\1\153\1\243\1\0\1\154\2\61\1\154\25\61\1\244"+
    "\1\0\5\244\2\0\2\244\1\0\25\244\1\62\1\0"+
    "\3\62\1\155\1\245\1\0\1\156\2\62\1\156\25\62"+
    "\1\246\1\0\3\246\1\247\1\246\1\0\1\250\2\246"+
    "\1\250\25\246\7\160\1\0\10\160\1\251\1\252\17\160"+
    "\1\253\1\160\5\253\1\0\1\160\2\253\1\160\4\253"+
    "\1\254\1\255\17\253\1\66\1\160\3\66\1\161\1\256"+
    "\1\0\1\162\2\66\1\162\4\66\1\163\1\164\20\66"+
    "\1\160\3\66\1\161\1\66\1\0\1\162\2\66\1\162"+
    "\25\66\1\62\1\0\3\62\1\257\1\62\1\0\1\260"+
    "\2\62\1\260\25\62\7\165\1\0\12\165\1\261\16\165"+
    "\1\262\1\165\5\262\1\0\1\165\2\262\1\165\6\262"+
    "\1\263\16\262\1\67\1\165\3\67\1\166\1\264\1\0"+
    "\1\167\2\67\1\167\6\67\1\170\16\67\1\62\1\0"+
    "\3\62\1\257\1\62\1\0\1\260\2\62\1\260\6\62"+
    "\1\67\16\62\6\73\2\0\1\171\2\73\1\171\25\73"+
    "\4\0\3\174\3\0\1\174\4\0\1\176\2\0\6\174"+
    "\3\0\4\174\6\0\3\174\3\0\1\175\4\0\1\176"+
    "\2\0\1\174\3\175\2\174\1\177\2\0\4\174\25\0"+
    "\2\265\17\0\4\266\2\0\2\266\4\0\1\267\2\0"+
    "\7\266\2\0\5\266\1\0\7\102\1\0\31\102\22\0"+
    "\1\103\16\0\1\270\1\0\5\270\2\0\2\270\1\0"+
    "\25\270\1\104\1\0\3\104\1\204\1\271\1\0\1\205"+
    "\2\104\1\205\25\104\6\0\1\272\32\0\1\272\1\0"+
    "\1\272\1\0\3\272\3\0\1\272\1\0\1\272\2\0"+
    "\20\272\1\0\1\272\1\106\1\0\1\106\1\206\1\106"+
    "\1\207\1\206\1\0\1\210\1\206\1\106\1\210\1\106"+
    "\2\206\20\106\1\206\1\106\1\273\1\0\5\273\2\0"+
    "\2\273\1\0\25\273\6\0\1\213\32\0\1\274\3\216"+
    "\1\275\1\276\2\0\1\216\1\0\1\275\1\216\2\0"+
    "\1\277\1\216\1\274\2\216\4\274\2\216\4\274\2\216"+
    "\1\0\1\216\1\217\1\121\2\217\1\300\1\220\1\217"+
    "\1\0\1\301\1\217\1\300\1\301\2\217\1\302\23\217"+
    "\1\121\2\217\2\300\1\217\1\0\1\121\1\217\1\300"+
    "\1\121\2\217\1\302\22\217\1\62\3\0\2\276\4\0"+
    "\1\276\5\0\1\62\2\0\4\62\2\0\4\62\4\0"+
    "\41\123\22\0\1\127\41\0\2\131\17\0\4\230\2\0"+
    "\2\230\1\0\1\303\2\0\1\231\2\0\7\230\2\0"+
    "\5\230\24\0\2\304\26\0\1\305\62\0\1\305\4\0"+
    "\1\306\3\236\1\307\1\310\2\0\1\236\1\0\1\307"+
    "\1\236\2\0\1\311\1\236\1\306\2\236\4\306\2\236"+
    "\4\306\2\236\1\0\1\236\1\237\1\152\1\237\1\312"+
    "\1\313\1\240\1\237\1\0\1\314\1\312\1\313\1\314"+
    "\1\237\1\312\1\315\20\237\1\312\2\237\1\152\1\237"+
    "\1\152\2\313\1\237\1\0\2\152\1\313\1\152\1\237"+
    "\1\152\1\241\20\237\1\152\1\237\1\316\3\0\2\310"+
    "\4\0\1\310\5\0\1\316\2\0\4\316\2\0\4\316"+
    "\12\0\1\317\40\0\1\244\32\0\1\61\1\0\3\61"+
    "\1\153\1\320\1\0\1\154\2\61\1\154\25\61\1\321"+
    "\1\0\3\321\1\322\1\323\1\0\1\156\2\321\1\156"+
    "\25\321\1\324\1\0\3\324\1\325\1\326\1\0\1\250"+
    "\2\324\1\250\25\324\7\160\1\0\31\160\5\0\1\327"+
    "\2\0\1\252\2\0\1\252\25\0\1\66\1\160\3\66"+
    "\1\161\1\256\1\0\1\162\2\66\1\162\25\66\1\62"+
    "\1\0\3\62\1\257\1\245\1\0\1\260\2\62\1\260"+
    "\25\62\6\160\1\253\1\0\10\160\1\251\1\252\17\160"+
    "\5\0\1\327\2\0\1\252\2\0\1\252\6\0\1\165"+
    "\16\0\1\62\1\0\3\62\1\257\1\245\1\0\1\260"+
    "\2\62\1\260\6\62\1\67\16\62\6\165\1\262\1\0"+
    "\12\165\1\261\16\165\23\0\2\174\17\0\4\266\2\0"+
    "\2\266\1\0\1\202\2\0\1\267\2\0\7\266\2\0"+
    "\5\266\24\0\2\330\22\0\1\270\32\0\1\274\1\216"+
    "\2\274\1\331\1\276\1\62\1\0\1\332\1\62\1\331"+
    "\1\332\2\62\1\333\20\274\1\62\2\274\1\216\2\274"+
    "\1\331\1\334\1\62\1\0\1\216\1\62\1\331\1\216"+
    "\2\62\1\333\20\274\1\62\1\274\1\62\1\0\5\62"+
    "\2\0\2\62\1\0\26\62\3\0\2\276\4\0\1\276"+
    "\3\0\1\221\1\0\1\62\2\0\4\62\2\0\4\62"+
    "\4\0\1\217\1\121\2\217\2\300\1\217\1\0\1\301"+
    "\1\217\1\300\1\301\2\217\1\302\23\217\1\121\2\217"+
    "\1\300\1\220\1\335\1\0\1\301\1\217\1\300\1\301"+
    "\2\217\1\302\22\217\1\62\1\0\2\62\1\334\1\276"+
    "\1\62\1\0\1\156\1\62\1\334\1\156\25\62\7\0"+
    "\1\132\1\133\2\0\1\133\50\0\2\230\14\0\1\336"+
    "\1\0\5\336\2\0\2\336\1\0\25\336\1\306\1\236"+
    "\1\306\1\337\1\340\1\310\1\316\1\0\1\341\1\342"+
    "\1\340\1\341\1\316\1\342\1\343\20\306\1\342\2\306"+
    "\1\236\1\306\1\236\1\340\1\344\1\316\1\0\1\236"+
    "\1\0\1\340\1\236\1\316\1\0\1\311\20\306\1\0"+
    "\1\306\1\316\1\0\1\316\1\0\3\316\3\0\1\316"+
    "\1\0\1\316\2\0\20\316\1\0\2\316\3\0\2\310"+
    "\4\0\1\310\3\0\1\241\1\0\1\316\2\0\4\316"+
    "\2\0\4\316\4\0\1\237\3\152\2\240\1\345\1\0"+
    "\2\152\1\240\3\152\1\241\1\152\1\237\2\152\4\237"+
    "\2\152\4\237\4\152\1\237\1\152\1\237\1\312\2\313"+
    "\1\237\1\0\1\314\1\312\1\313\1\314\1\237\1\312"+
    "\1\315\20\237\1\312\2\237\1\152\1\237\1\312\1\313"+
    "\1\240\1\312\1\0\1\314\1\312\1\313\1\314\1\237"+
    "\1\312\1\315\20\237\1\312\1\237\1\316\3\0\2\310"+
    "\1\346\3\0\1\310\5\0\1\316\2\0\4\316\2\0"+
    "\4\316\4\0\1\316\1\0\1\316\1\342\1\316\1\347"+
    "\1\316\1\0\1\350\1\342\1\316\1\350\1\316\2\342"+
    "\20\316\1\342\1\316\1\324\1\0\3\324\1\325\1\246"+
    "\1\0\1\250\2\324\1\250\25\324\1\61\1\0\3\61"+
    "\1\153\1\351\1\0\1\154\2\61\1\154\25\61\1\246"+
    "\1\0\3\246\1\247\1\352\1\0\1\250\2\246\1\250"+
    "\25\246\1\324\1\0\3\324\1\325\1\352\1\0\1\250"+
    "\2\324\1\250\26\324\1\0\3\324\1\325\1\324\1\0"+
    "\1\250\2\324\1\250\25\324\1\353\1\0\5\353\2\0"+
    "\2\353\1\0\25\353\6\0\1\250\55\0\2\266\14\0"+
    "\1\274\1\216\2\274\1\331\1\334\1\62\1\0\1\332"+
    "\1\62\1\331\1\332\2\62\1\333\20\274\1\62\2\274"+
    "\1\216\2\274\1\331\1\276\1\245\1\0\1\332\1\62"+
    "\1\331\1\332\2\62\1\333\20\274\1\62\1\274\1\62"+
    "\1\0\2\62\1\334\1\276\1\62\1\0\1\156\1\62"+
    "\1\334\1\156\2\62\1\302\23\62\1\0\3\62\1\334"+
    "\1\62\1\0\1\156\2\62\1\156\25\62\1\217\3\121"+
    "\2\220\1\354\1\0\2\121\1\220\3\121\1\221\1\121"+
    "\1\217\2\121\4\217\2\121\4\217\4\121\1\306\3\236"+
    "\1\307\1\310\1\346\1\0\1\236\1\0\1\307\1\236"+
    "\2\0\1\311\1\236\1\306\2\236\4\306\2\236\4\306"+
    "\2\236\1\0\1\236\1\306\1\236\1\306\1\337\1\340"+
    "\1\344\1\316\1\0\1\341\1\342\1\340\1\341\1\316"+
    "\1\342\1\343\20\306\1\342\2\306\1\236\1\306\1\337"+
    "\1\340\1\310\1\342\1\0\1\341\1\342\1\340\1\341"+
    "\1\316\1\342\1\343\20\306\1\342\1\306\6\0\1\346"+
    "\32\0\1\316\3\0\2\310\1\346\3\0\1\310\3\0"+
    "\1\241\1\0\1\316\2\0\4\316\2\0\4\316\4\0"+
    "\1\316\1\0\1\316\1\342\1\316\1\344\1\316\1\0"+
    "\1\350\1\342\1\316\1\350\1\316\2\342\20\316\1\342"+
    "\2\316\1\0\1\316\1\342\1\316\1\347\1\342\1\0"+
    "\1\350\1\342\1\316\1\350\1\316\2\342\20\316\1\342"+
    "\1\316\1\346\1\0\1\346\1\0\3\346\3\0\1\346"+
    "\1\0\1\346\2\0\20\346\1\0\1\346\1\62\1\0"+
    "\3\62\1\155\1\355\1\0\1\156\2\62\1\156\26\62"+
    "\1\0\3\62\1\155\1\356\1\0\1\156\2\62\1\156"+
    "\25\62";

  private static int [] zzUnpackTrans() {
    int [] result = new int[6270];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\20\0\1\11\4\1\1\11\3\1\1\11\1\1\1\11"+
    "\3\1\1\11\6\1\1\11\2\1\1\11\12\1\1\11"+
    "\4\1\1\11\1\1\1\11\3\1\1\11\1\1\2\0"+
    "\1\1\1\0\1\1\3\0\1\1\1\0\1\11\3\1"+
    "\5\0\1\1\2\0\1\1\1\0\1\11\1\1\4\0"+
    "\4\1\1\0\1\1\5\0\1\1\7\0\2\1\3\0"+
    "\1\1\1\0\1\11\1\0\2\1\4\0\1\11\1\1"+
    "\5\0\3\1\1\0\1\11\1\0\1\1\3\0\2\11"+
    "\1\0\1\1\3\0\1\11\1\1\3\0\1\1\2\0"+
    "\1\1\1\0\1\1\1\0\2\1\3\0\3\1\1\0"+
    "\1\1\2\0\2\1\4\0\1\1\1\0\1\1\1\11"+
    "\1\1\3\0\1\1\1\0\1\1\2\0\2\1\4\0"+
    "\1\1\2\0\2\1\1\0\3\1\1\0\1\1\1\0"+
    "\1\11\1\0\1\1\1\0\2\1\1\0\1\11\1\0"+
    "\1\1\3\0\3\1\2\0\5\1\1\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[238];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /** For the backwards DFA of general lookahead statements */
  private boolean [] zzFin = new boolean [ZZ_BUFFERSIZE+1];

  /* user code: */
  /** The current column of the current line (starting with 0). It is standard field supported by the jflex. */
  protected int yycolumn = 0;

  /**
   * The number of open but not closed braces.
   * Note: lexer does not distinguish braces from brackets while counting them.
   */
  private int myBraceCount = 0;
  
  /** A token type of parsed block scalar */
  private IElementType myBlockScalarType = null;

  /** A state to be returned in (or it is used to calculate next state) */
  private int myReturnState = YYINITIAL;

  /**
   * An indent of block composite element (key or sequence marker).
   * It is used to identify range of block scalars and plain text scalars.
   */
  private int myPrevElementIndent = 0;

  /** This flag is set after the first plain scalar line until it ends */
  private boolean myPossiblePlainTextScalarContinue = false;

  //-------------------------------------------------------------------------------------------------------------------

  public boolean isCleanState() {
    return yystate() == YYINITIAL
           && myBraceCount == 0
           && yycolumn == 0
           && myPrevElementIndent == 0
           && !myPossiblePlainTextScalarContinue;
  }

  public void cleanMyState() {
    myBraceCount = 0;
    myBlockScalarType = null;

    yycolumn = 0;
    myReturnState = YYINITIAL;

    myPrevElementIndent = 0;
    myPossiblePlainTextScalarContinue = false;
    yybegin(YYINITIAL);
  }

  //-------------------------------------------------------------------------------------------------------------------

  /** @param offset offset from currently matched token start (could be negative) */
  private char getCharAtOffset(final int offset) {
    final int loc = getTokenStart() + offset;
    return 0 <= loc && loc < zzBuffer.length() ? zzBuffer.charAt(loc) : (char) -1;
  }

  private boolean isAfterEol() {
    final char prev = getCharAtOffset(-1);
    return prev == (char)-1 || prev == '\n';
  }

  private IElementType getWhitespaceType() {
    return isAfterEol() ? INDENT : WHITESPACE;
  }

  private void goToState(int state) {
    yybegin(state);
    yypushback(yylength());
  }

  //-------------------------------------------------------------------------------------------------------------------

  /**
   * @param indentLen The length of indent in the current line
   * @return the next state
   */
  private int getStateAfterLineStart(int indentLen) {
    if (myPossiblePlainTextScalarContinue && yycolumn + indentLen > myPrevElementIndent) {
      return POSSIBLE_PLAIN_TEXT_STATE;
    }
    else {
      myPossiblePlainTextScalarContinue = false;
      return BLOCK_STATE;
    }
  }

  private int getStateAfterBlockScalar() {
    return myReturnState == BLOCK_STATE ? LINE_START_STATE : FLOW_STATE;
  }

  private void openBrace() {
    myBraceCount++;
    if (myBraceCount != 0) {
      myPrevElementIndent = 0;
      myPossiblePlainTextScalarContinue = false;
      yybegin(FLOW_STATE);
    }
  }

  private void closeBrace() {
    if (myBraceCount > 0) {
      myBraceCount--;
    }
    if (myBraceCount == 0){
      yybegin(BLOCK_STATE);
    }
  }

  /**
   * This method stores return lexer state, stores indent information and moves to the key mode state
   * @return scalar key token
   */
  private IElementType processScalarKey(int returnState) {
    myPrevElementIndent = yycolumn;
    myReturnState = returnState;
    yybegin(KEY_MODE);
    return SCALAR_KEY;
  }

  private IElementType processScalarKey() {
    return processScalarKey(yystate());
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public _YAMLLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    int size = 0;
    for (int i = 0, length = packed.length(); i < length; i += 2) {
      size += packed.charAt(i);
    }
    char[] map = new char[size];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < packed.length()) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      {@code false}, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position {@code pos} from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzMarkedPosL*/);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn += zzCharCount;
        }
      }

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + ZZ_CMAP(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { goToState(getStateAfterLineStart(0));
            } 
            // fall through
          case 44: break;
          case 2: 
            { yybegin(getStateAfterLineStart(yylength()));
        return getWhitespaceType();
            } 
            // fall through
          case 45: break;
          case 3: 
            { myPossiblePlainTextScalarContinue = true;
        return TEXT;
            } 
            // fall through
          case 46: break;
          case 4: 
            { return TEXT;
            } 
            // fall through
          case 47: break;
          case 5: 
            { myPrevElementIndent = yycolumn;
        return QUESTION;
            } 
            // fall through
          case 48: break;
          case 6: 
            { myPrevElementIndent = yycolumn;
        return COLON;
            } 
            // fall through
          case 49: break;
          case 7: 
            { return COMMENT;
            } 
            // fall through
          case 50: break;
          case 8: 
            { if(!myPossiblePlainTextScalarContinue && myPrevElementIndent == 0) {
          // It is hard to find clean state in YAML lexer :(
          yybegin(YYINITIAL);
        }
        else {
          yybegin(LINE_START_STATE);
        }
        return EOL;
            } 
            // fall through
          case 51: break;
          case 9: 
            { return getWhitespaceType();
            } 
            // fall through
          case 52: break;
          case 10: 
            { closeBrace();
        return RBRACKET;
            } 
            // fall through
          case 53: break;
          case 11: 
            { myReturnState = yystate();
        yybegin(BS_HEADER_TAIL_STATE);
        myBlockScalarType = SCALAR_TEXT;
        return myBlockScalarType;
            } 
            // fall through
          case 54: break;
          case 12: 
            { openBrace();
        return LBRACE;
            } 
            // fall through
          case 55: break;
          case 13: 
            { closeBrace();
        return RBRACE;
            } 
            // fall through
          case 56: break;
          case 14: 
            { openBrace();
        return LBRACKET;
            } 
            // fall through
          case 57: break;
          case 15: 
            { myReturnState = yystate();
        yybegin(BS_HEADER_TAIL_STATE);
        myBlockScalarType = SCALAR_LIST;
        return myBlockScalarType;
            } 
            // fall through
          case 58: break;
          case 16: 
            { return COMMA;
            } 
            // fall through
          case 59: break;
          case 17: 
            { return EOL;
            } 
            // fall through
          case 60: break;
          case 18: 
            { goToState(BLOCK_STATE);
            } 
            // fall through
          case 61: break;
          case 19: 
            { yybegin(LINE_START_STATE);
        return EOL;
            } 
            // fall through
          case 62: break;
          case 20: 
            { yybegin(myReturnState);
        return ANCHOR;
            } 
            // fall through
          case 63: break;
          case 21: 
            { yybegin(myReturnState);
        return ALIAS;
            } 
            // fall through
          case 64: break;
          case 22: 
            { yybegin(myReturnState);
        return COLON;
            } 
            // fall through
          case 65: break;
          case 23: 
            { goToState(BS_BODY_STATE);
            } 
            // fall through
          case 66: break;
          case 24: 
            { assert yycolumn > myPrevElementIndent;
        return myBlockScalarType;
            } 
            // fall through
          case 67: break;
          case 25: 
            { return SCALAR_EOL;
            } 
            // fall through
          case 68: break;
          case 26: 
            // general lookahead, find correct zzMarkedPos
            { int zzFState = 13;
              int zzFPos = zzStartRead;
              if (zzFin.length <= zzBufferL.length()) { zzFin = new boolean[zzBufferL.length()+1]; }
              boolean zzFinL[] = zzFin;
              while (zzFState != -1 && zzFPos < zzMarkedPos) {
                zzFinL[zzFPos] = ((zzAttrL[zzFState] & 1) == 1);
                zzInput = Character.codePointAt(zzBufferL, zzFPos/*, zzMarkedPos*/);
                zzFPos += Character.charCount(zzInput);
                zzFState = zzTransL[ zzRowMapL[zzFState] + ZZ_CMAP(zzInput) ];
              }
              if (zzFState != -1) { zzFinL[zzFPos++] = ((zzAttrL[zzFState] & 1) == 1); } 
              while (zzFPos <= zzMarkedPos) {
                zzFinL[zzFPos++] = false;
              }

              zzFState = 12;
              zzFPos = zzMarkedPos;
              while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
                zzInput = Character.codePointBefore(zzBufferL, zzFPos/*, zzStartRead*/);
                zzFPos -= Character.charCount(zzInput);
                zzFState = zzTransL[ zzRowMapL[zzFState] + ZZ_CMAP(zzInput) ];
              };
              zzMarkedPos = zzFPos;
            }
            { return processScalarKey();
            } 
            // fall through
          case 69: break;
          case 27: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 1);
            { myPrevElementIndent = yycolumn;
        return SEQUENCE_MARKER;
            } 
            // fall through
          case 70: break;
          case 28: 
            { return SCALAR_DSTRING;
            } 
            // fall through
          case 71: break;
          case 29: 
            { return SCALAR_STRING;
            } 
            // fall through
          case 72: break;
          case 30: 
            // general lookahead, find correct zzMarkedPos
            { int zzFState = 9;
              int zzFPos = zzStartRead;
              if (zzFin.length <= zzBufferL.length()) { zzFin = new boolean[zzBufferL.length()+1]; }
              boolean zzFinL[] = zzFin;
              while (zzFState != -1 && zzFPos < zzMarkedPos) {
                zzFinL[zzFPos] = ((zzAttrL[zzFState] & 1) == 1);
                zzInput = Character.codePointAt(zzBufferL, zzFPos/*, zzMarkedPos*/);
                zzFPos += Character.charCount(zzInput);
                zzFState = zzTransL[ zzRowMapL[zzFState] + ZZ_CMAP(zzInput) ];
              }
              if (zzFState != -1) { zzFinL[zzFPos++] = ((zzAttrL[zzFState] & 1) == 1); } 
              while (zzFPos <= zzMarkedPos) {
                zzFinL[zzFPos++] = false;
              }

              zzFState = 10;
              zzFPos = zzMarkedPos;
              while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
                zzInput = Character.codePointBefore(zzBufferL, zzFPos/*, zzStartRead*/);
                zzFPos -= Character.charCount(zzInput);
                zzFState = zzTransL[ zzRowMapL[zzFState] + ZZ_CMAP(zzInput) ];
              };
              zzMarkedPos = zzFPos;
            }
            { return TAG;
            } 
            // fall through
          case 73: break;
          case 31: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 1);
            { myReturnState = yystate();
        yybegin(ANCHOR_MODE);
        return AMPERSAND;
            } 
            // fall through
          case 74: break;
          case 32: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 1);
            { myReturnState = yystate();
        yybegin(ALIAS_MODE);
        return STAR;
            } 
            // fall through
          case 75: break;
          case 33: 
            // general lookahead, find correct zzMarkedPos
            { int zzFState = 14;
              int zzFPos = zzStartRead;
              if (zzFin.length <= zzBufferL.length()) { zzFin = new boolean[zzBufferL.length()+1]; }
              boolean zzFinL[] = zzFin;
              while (zzFState != -1 && zzFPos < zzMarkedPos) {
                zzFinL[zzFPos] = ((zzAttrL[zzFState] & 1) == 1);
                zzInput = Character.codePointAt(zzBufferL, zzFPos/*, zzMarkedPos*/);
                zzFPos += Character.charCount(zzInput);
                zzFState = zzTransL[ zzRowMapL[zzFState] + ZZ_CMAP(zzInput) ];
              }
              if (zzFState != -1) { zzFinL[zzFPos++] = ((zzAttrL[zzFState] & 1) == 1); } 
              while (zzFPos <= zzMarkedPos) {
                zzFinL[zzFPos++] = false;
              }

              zzFState = 12;
              zzFPos = zzMarkedPos;
              while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
                zzInput = Character.codePointBefore(zzBufferL, zzFPos/*, zzStartRead*/);
                zzFPos -= Character.charCount(zzInput);
                zzFState = zzTransL[ zzRowMapL[zzFState] + ZZ_CMAP(zzInput) ];
              };
              zzMarkedPos = zzFPos;
            }
            { return processScalarKey();
            } 
            // fall through
          case 76: break;
          case 34: 
            // general lookahead, find correct zzMarkedPos
            { int zzFState = 13;
              int zzFPos = zzStartRead;
              if (zzFin.length <= zzBufferL.length()) { zzFin = new boolean[zzBufferL.length()+1]; }
              boolean zzFinL[] = zzFin;
              while (zzFState != -1 && zzFPos < zzMarkedPos) {
                zzFinL[zzFPos] = ((zzAttrL[zzFState] & 1) == 1);
                zzInput = Character.codePointAt(zzBufferL, zzFPos/*, zzMarkedPos*/);
                zzFPos += Character.charCount(zzInput);
                zzFState = zzTransL[ zzRowMapL[zzFState] + ZZ_CMAP(zzInput) ];
              }
              if (zzFState != -1) { zzFinL[zzFPos++] = ((zzAttrL[zzFState] & 1) == 1); } 
              while (zzFPos <= zzMarkedPos) {
                zzFinL[zzFPos++] = false;
              }

              zzFState = 12;
              zzFPos = zzMarkedPos;
              while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
                zzInput = Character.codePointBefore(zzBufferL, zzFPos/*, zzStartRead*/);
                zzFPos -= Character.charCount(zzInput);
                zzFState = zzTransL[ zzRowMapL[zzFState] + ZZ_CMAP(zzInput) ];
              };
              zzMarkedPos = zzFPos;
            }
            { return processScalarKey(BLOCK_STATE);
            } 
            // fall through
          case 77: break;
          case 35: 
            // lookahead expression with fixed lookahead length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzMarkedPos, -1);
            { int indent = yylength() - 1;
        yypushback(indent);
        if (indent <= myPrevElementIndent) {
          yybegin(getStateAfterBlockScalar());
          return EOL;
        } else {
          return SCALAR_EOL;
        }
            } 
            // fall through
          case 78: break;
          case 36: 
            { return DOCUMENT_MARKER;
            } 
            // fall through
          case 79: break;
          case 37: 
            { return DOCUMENT_END;
            } 
            // fall through
          case 80: break;
          case 38: 
            // general lookahead, find correct zzMarkedPos
            { int zzFState = 11;
              int zzFPos = zzStartRead;
              if (zzFin.length <= zzBufferL.length()) { zzFin = new boolean[zzBufferL.length()+1]; }
              boolean zzFinL[] = zzFin;
              while (zzFState != -1 && zzFPos < zzMarkedPos) {
                zzFinL[zzFPos] = ((zzAttrL[zzFState] & 1) == 1);
                zzInput = Character.codePointAt(zzBufferL, zzFPos/*, zzMarkedPos*/);
                zzFPos += Character.charCount(zzInput);
                zzFState = zzTransL[ zzRowMapL[zzFState] + ZZ_CMAP(zzInput) ];
              }
              if (zzFState != -1) { zzFinL[zzFPos++] = ((zzAttrL[zzFState] & 1) == 1); } 
              while (zzFPos <= zzMarkedPos) {
                zzFinL[zzFPos++] = false;
              }

              zzFState = 12;
              zzFPos = zzMarkedPos;
              while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
                zzInput = Character.codePointBefore(zzBufferL, zzFPos/*, zzStartRead*/);
                zzFPos -= Character.charCount(zzInput);
                zzFState = zzTransL[ zzRowMapL[zzFState] + ZZ_CMAP(zzInput) ];
              };
              zzMarkedPos = zzFPos;
            }
            { return processScalarKey();
            } 
            // fall through
          case 81: break;
          case 39: 
            // general lookahead, find correct zzMarkedPos
            { int zzFState = 13;
              int zzFPos = zzStartRead;
              if (zzFin.length <= zzBufferL.length()) { zzFin = new boolean[zzBufferL.length()+1]; }
              boolean zzFinL[] = zzFin;
              while (zzFState != -1 && zzFPos < zzMarkedPos) {
                zzFinL[zzFPos] = ((zzAttrL[zzFState] & 1) == 1);
                zzInput = Character.codePointAt(zzBufferL, zzFPos/*, zzMarkedPos*/);
                zzFPos += Character.charCount(zzInput);
                zzFState = zzTransL[ zzRowMapL[zzFState] + ZZ_CMAP(zzInput) ];
              }
              if (zzFState != -1) { zzFinL[zzFPos++] = ((zzAttrL[zzFState] & 1) == 1); } 
              while (zzFPos <= zzMarkedPos) {
                zzFinL[zzFPos++] = false;
              }

              zzFState = 15;
              zzFPos = zzMarkedPos;
              while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
                zzInput = Character.codePointBefore(zzBufferL, zzFPos/*, zzStartRead*/);
                zzFPos -= Character.charCount(zzInput);
                zzFState = zzTransL[ zzRowMapL[zzFState] + ZZ_CMAP(zzInput) ];
              };
              zzMarkedPos = zzFPos;
            }
            { return TEXT;
            } 
            // fall through
          case 82: break;
          case 40: 
            // general lookahead, find correct zzMarkedPos
            { int zzFState = 11;
              int zzFPos = zzStartRead;
              if (zzFin.length <= zzBufferL.length()) { zzFin = new boolean[zzBufferL.length()+1]; }
              boolean zzFinL[] = zzFin;
              while (zzFState != -1 && zzFPos < zzMarkedPos) {
                zzFinL[zzFPos] = ((zzAttrL[zzFState] & 1) == 1);
                zzInput = Character.codePointAt(zzBufferL, zzFPos/*, zzMarkedPos*/);
                zzFPos += Character.charCount(zzInput);
                zzFState = zzTransL[ zzRowMapL[zzFState] + ZZ_CMAP(zzInput) ];
              }
              if (zzFState != -1) { zzFinL[zzFPos++] = ((zzAttrL[zzFState] & 1) == 1); } 
              while (zzFPos <= zzMarkedPos) {
                zzFinL[zzFPos++] = false;
              }

              zzFState = 12;
              zzFPos = zzMarkedPos;
              while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
                zzInput = Character.codePointBefore(zzBufferL, zzFPos/*, zzStartRead*/);
                zzFPos -= Character.charCount(zzInput);
                zzFState = zzTransL[ zzRowMapL[zzFState] + ZZ_CMAP(zzInput) ];
              };
              zzMarkedPos = zzFPos;
            }
            { return processScalarKey(BLOCK_STATE);
            } 
            // fall through
          case 83: break;
          case 41: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 3);
            { goToState(getStateAfterLineStart(0));
            } 
            // fall through
          case 84: break;
          case 42: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 1);
            { cleanMyState(); return EOL;
            } 
            // fall through
          case 85: break;
          case 43: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 1);
            { return EOL;
            } 
            // fall through
          case 86: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
