// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package org.jetbrains.yaml.psi;

import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.ApiStatus;

/** See <a href="http://www.yaml.org/spec/1.2/spec.html#id2793652">8.1. Block Scalar Styles</a> */
public interface YAMLBlockScalar extends YAMLScalar {
  /** It is temporary solution. Please Do not use it in production! */
  @ApiStatus.Internal
  Key<Boolean> FORCE_KEEP_CHOMPING = new Key<>("Force keep chomping indicator");

  boolean hasExplicitIndent();
}
