/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zmlx.hg4idea.push;

import com.intellij.dvcs.push.PushSource;
import com.intellij.openapi.util.NlsSafe;
import org.jetbrains.annotations.NotNull;

public class HgPushSource implements PushSource {
  @NotNull private final @NlsSafe String myBranch;

  public HgPushSource(@NotNull @NlsSafe String branch) {
    myBranch = branch;
  }

  @NotNull
  @Override
  public String getPresentation() {
    return myBranch;
  }

  @NlsSafe
  @NotNull
  public String getBranch() {
    return myBranch;   // presentation may differ from branch
  }
}
