/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.query.ComponentShowingQuery;

public final class JMenuItemLocation {
    private Component parentOrInvoker;
    private JPopupMenu parentPopup;
    private final boolean inMenuBar;

    @RunsInCurrentThread
    public JMenuItemLocation(@Nonnull JMenuItem menuItem) {
        this.parentOrInvoker = menuItem.getParent();
        if (this.parentOrInvoker instanceof JPopupMenu) {
            this.parentPopup = (JPopupMenu)this.parentOrInvoker;
            this.parentOrInvoker = Preconditions.checkNotNull(this.parentPopup.getInvoker());
        }
        this.inMenuBar = this.parentOrInvoker instanceof JMenuBar;
    }

    public boolean inMenuBar() {
        return this.inMenuBar;
    }

    @RunsInEDT
    public boolean isParentAMenu() {
        if (!(this.parentOrInvoker instanceof JMenuItem)) {
            return false;
        }
        return this.parentPopup == null || !ComponentShowingQuery.isShowing(this.parentPopup);
    }

    @Nonnull
    public Component parentOrInvoker() {
        return this.parentOrInvoker;
    }

    @Nullable
    public JPopupMenu parentPopup() {
        return this.parentPopup;
    }
}

