/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0013H\u0002J*\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/SelectClickedCellEventDispatcher;", "Lcom/intellij/ide/IdeEventQueue$EventDispatcher;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "installed", "", "ensureInstalled", "", "dispose", "dispatch", "e", "Ljava/awt/AWTEvent;", "getEditor", "Lcom/intellij/openapi/editor/Editor;", "component", "Ljava/awt/Component;", "allowsClickProcessing", "editor", "Ljavax/swing/JComponent;", "handleComponent", "depthFirstTraverse", "x", "", "y", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nSelectClickedCellEventDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectClickedCellEventDispatcher.kt\ncom/intellij/jupyter/core/jupyter/editor/SelectClickedCellEventDispatcher\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n19#2:161\n1#3:162\n*S KotlinDebug\n*F\n+ 1 SelectClickedCellEventDispatcher.kt\ncom/intellij/jupyter/core/jupyter/editor/SelectClickedCellEventDispatcher\n*L\n68#1:161\n*E\n"})
public final class SelectClickedCellEventDispatcher
implements IdeEventQueue.EventDispatcher,
Disposable {
    private boolean installed;

    public final void ensureInstalled() {
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.installed) {
            IdeEventQueue.Companion.getInstance().addDispatcher((IdeEventQueue.EventDispatcher)this, (Disposable)this);
            this.installed = true;
        }
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatch(@NotNull AWTEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getID() != 502) {
            return false;
        }
        MouseEvent cfr_ignored_0 = (MouseEvent)e;
        if (((MouseEvent)e).isConsumed()) {
            return false;
        }
        Object object = ((MouseEvent)e).getSource();
        Component component2 = object instanceof Component ? (Component)object : null;
        if (component2 == null) {
            return false;
        }
        Component sourceComponent = component2;
        Component component3 = sourceComponent;
        while (true) {
            Editor editor;
            if ((editor = this.getEditor(component3)) != null) {
                this.handleComponent(editor, (JComponent)sourceComponent);
                return false;
            }
            Container container = component3.getParent();
            if (container == null) {
                break;
            }
            component3 = container;
        }
        this.depthFirstTraverse(sourceComponent, this.getEditor(sourceComponent), ((MouseEvent)e).getX(), ((MouseEvent)e).getY());
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Editor getEditor(Component component2) {
        EditorImpl editorImpl;
        Object object;
        Component $this$asSafely$iv = component2;
        boolean $i$f$asSafely = false;
        Component component3 = $this$asSafely$iv;
        if (!(component3 instanceof EditorComponentImpl)) {
            component3 = null;
        }
        if ((object = (EditorComponentImpl)component3) != null) {
            EditorComponentImpl editorComponentImpl;
            EditorComponentImpl it = editorComponentImpl = object;
            boolean bl = false;
            object = BackedNotebookVirtualFile.Companion.isBacked(it.getEditor().getVirtualFile()) ? editorComponentImpl : null;
            if (object != null) {
                editorImpl = object.getEditor();
                return (Editor)editorImpl;
            }
        }
        editorImpl = null;
        return (Editor)editorImpl;
    }

    private final boolean allowsClickProcessing(Editor editor, JComponent component2) {
        for (Component component3 = (Component)component2; component3 != null; component3 = (Component)component3.getParent()) {
            if (Intrinsics.areEqual((Object)component3, (Object)editor.getContentComponent())) {
                return false;
            }
            Component component4 = component3;
            JComponent jComponent = component4 instanceof JComponent ? (JComponent)component4 : null;
            if ((jComponent != null ? jComponent.getClientProperty("SkipClickProcessingForCellSelection") : null) == null) continue;
            return false;
        }
        return true;
    }

    private final void handleComponent(Editor editor, JComponent component2) {
        if (editor.getContentComponent() == component2) {
            if (NotebookEditorModeKt.getCurrentMode((Editor)editor) == NotebookEditorMode.EDIT) {
                Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
                ((EditorImpl)editor).setCaretEnabled(true);
                ((EditorImpl)editor).getSettings().setCaretRowShown(true);
            }
            return;
        }
        if (!this.allowsClickProcessing(editor, component2)) {
            return;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)component2);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        NotebookCellLines.Interval interval = JupyterHelper.INSTANCE.getHoveredInterval(dataContext2);
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval hoveredInterval = interval;
        TextRange fullCellRange = hoveredInterval.getCellRange(editor);
        TextRange contentCellRange = hoveredInterval.getCellRange(editor);
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        Caret caret2 = caret;
        WriteIntentReadAction.compute(() -> SelectClickedCellEventDispatcher.handleComponent$lambda$1(caret2, fullCellRange, contentCellRange, editor, component2));
    }

    private final boolean depthFirstTraverse(Component component2, Editor editor, int x, int y) {
        if (component2 instanceof Container && ((Container)component2).isVisible() && component2.contains(x, y)) {
            Iterator iterator = ArrayIteratorKt.iterator((Object[])((Container)component2).getComponents());
            while (iterator.hasNext()) {
                Component child = (Component)iterator.next();
                if (child == null) continue;
                Point loc = child.getLocation();
                Editor editor2 = editor;
                if (editor2 == null) {
                    editor2 = this.getEditor(child);
                }
                if (!this.depthFirstTraverse(child, editor2, x - loc.x, y - loc.y)) continue;
                return true;
            }
            if (component2 instanceof JComponent && editor != null) {
                WriteIntentReadAction.run(() -> SelectClickedCellEventDispatcher.depthFirstTraverse$lambda$2(this, editor, component2));
                return true;
            }
        }
        return false;
    }

    private static final Unit handleComponent$lambda$1(Caret $caret, TextRange $fullCellRange, TextRange $contentCellRange, Editor $editor, JComponent $component) {
        if ($caret.getOffset() < $fullCellRange.getStartOffset() || $caret.getOffset() > $fullCellRange.getEndOffset()) {
            TextRange cellLastChild = $contentCellRange;
            int startOffset = cellLastChild.getStartOffset();
            int endOffset = cellLastChild.getEndOffset();
            int firstLineY = $editor.offsetToXY((int)startOffset).y;
            int componentRelativeY = SwingUtilities.convertPoint((Component)((Component)$component), (int)0, (int)0, (Component)((Component)$editor.getContentComponent())).y;
            $caret.moveToOffset(firstLineY < componentRelativeY && startOffset < endOffset ? endOffset - 1 : startOffset);
            if ($caret.getOffset() != $caret.getSelectionStart() && $caret.getOffset() != $caret.getSelectionEnd()) {
                $caret.removeSelection();
            }
            $component.requestFocus();
            Intrinsics.checkNotNull((Object)$editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            ((EditorImpl)$editor).setCaretEnabled(false);
            ((EditorImpl)$editor).getSettings().setCaretRowShown(false);
        }
        return Unit.INSTANCE;
    }

    private static final void depthFirstTraverse$lambda$2(SelectClickedCellEventDispatcher this$0, Editor $editor, Component $component) {
        this$0.handleComponent($editor, (JComponent)$component);
    }
}

