/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.relevance;

import com.intellij.internal.ml.DecisionFunction;
import com.intellij.internal.ml.FeatureMapper;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.ml.inline.completion.impl.CoreUtilsKt;
import com.intellij.ml.inline.completion.impl.relevance.RelevanceModelResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\fJ\u001a\u0010\u000e\u001a\u00020\u00032\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/inline/completion/impl/relevance/RelevanceChecker;", "", "threshold", "", "decisionFunction", "Lcom/intellij/internal/ml/DecisionFunction;", "randomPassProbability", "<init>", "(DLcom/intellij/internal/ml/DecisionFunction;D)V", "predict", "Lcom/intellij/ml/inline/completion/impl/relevance/RelevanceModelResponse;", "features", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "runPrediction", "renameIfNeeded", "", "featureName", "normalizeData", "data", "intellij.fullLine.core.completion"})
@SourceDebugExtension(value={"SMAP\nCheckers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Checkers.kt\ncom/intellij/ml/inline/completion/impl/relevance/RelevanceChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1202#2,2:63\n1230#2,4:65\n1557#2:69\n1628#2,3:70\n1734#2,3:73\n1557#2:76\n1628#2,3:77\n*S KotlinDebug\n*F\n+ 1 Checkers.kt\ncom/intellij/ml/inline/completion/impl/relevance/RelevanceChecker\n*L\n25#1:63,2\n25#1:65,4\n52#1:69\n52#1:70,3\n53#1:73,3\n54#1:76\n54#1:77,3\n*E\n"})
public final class RelevanceChecker {
    private final double threshold;
    @NotNull
    private final DecisionFunction decisionFunction;
    private final double randomPassProbability;

    public RelevanceChecker(double threshold, @NotNull DecisionFunction decisionFunction, double randomPassProbability) {
        Intrinsics.checkNotNullParameter((Object)decisionFunction, (String)"decisionFunction");
        this.threshold = threshold;
        this.decisionFunction = decisionFunction;
        this.randomPassProbability = randomPassProbability;
    }

    @NotNull
    public final RelevanceModelResponse predict(@NotNull List<? extends EventPair<?>> features) {
        Intrinsics.checkNotNullParameter(features, (String)"features");
        double prediction = this.runPrediction(features);
        RelevanceModelResponse.Decision decision = CoreUtilsKt.randomPass(this.randomPassProbability) ? RelevanceModelResponse.Decision.RANDOM_PASS : (prediction >= this.threshold ? RelevanceModelResponse.Decision.PASS : RelevanceModelResponse.Decision.SKIP);
        return new RelevanceModelResponse(prediction, decision);
    }

    /*
     * WARNING - void declaration
     */
    private final double runPrediction(List<? extends EventPair<?>> features) {
        void $this$associateByTo$iv$iv;
        double[] array = new double[this.decisionFunction.getFeaturesOrder().length];
        Iterable $this$associateBy$iv = features;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            EventPair eventPair = (EventPair)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getField().getName(), element$iv$iv);
        }
        Map featurePerSerializedName = destination$iv$iv;
        int n = this.decisionFunction.getFeaturesOrder().length;
        for (int featureI = 0; featureI < n; ++featureI) {
            double featureValue;
            FeatureMapper featureMapper = this.decisionFunction.getFeaturesOrder()[featureI];
            String string = featureMapper.getFeatureName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFeatureName(...)");
            String featureSerializedName = this.renameIfNeeded(string);
            EventPair eventPair = (EventPair)featurePerSerializedName.get(featureSerializedName);
            array[featureI] = featureValue = featureMapper.asArrayValue(this.normalizeData(eventPair != null ? eventPair.getData() : null));
        }
        return this.decisionFunction.predict(array);
    }

    private final String renameIfNeeded(String featureName) {
        return switch (featureName) {
            case "checks_time" -> "analyze_time";
            case "inference_time" -> "full_inference_time";
            case "language" -> "file_language";
            case "suggestion_length" -> "proposal_length";
            default -> featureName;
        };
    }

    private final Object normalizeData(Object data2) {
        if (data2 instanceof Class) {
            return ((Class)data2).getName();
        }
        if (data2 instanceof List) {
            boolean bl;
            List normalized_list;
            Object it;
            Collection collection;
            Object item$iv$iv;
            Iterator iterator;
            Object $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            boolean $i$f$map;
            Iterable $this$map$iv;
            block8: {
                $this$map$iv = (Iterable)data2;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object t = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(this.normalizeData(it));
                }
                normalized_list = (List)destination$iv$iv;
                Iterable $this$all$iv = normalized_list;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    $this$mapTo$iv$iv = $this$all$iv.iterator();
                    while ($this$mapTo$iv$iv.hasNext()) {
                        Object element$iv;
                        Object it2 = element$iv = $this$mapTo$iv$iv.next();
                        boolean bl3 = false;
                        if (it2 instanceof String) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (bl) {
                $this$map$iv = normalized_list;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    it = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add("'" + it + "'");
                }
                return (List)destination$iv$iv;
            }
            return normalized_list;
        }
        return data2;
    }
}

