/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.xml.ConvertContext;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesConverter;
import org.jetbrains.idea.maven.dom.converters.MavenConsumerPomUtil;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.reposearch.DependencySearchService;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesVersionConverter;", "Lorg/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter;", "<init>", "()V", "fromString", "", "s", "context", "Lcom/intellij/util/xml/ConvertContext;", "doIsValid", "", "id", "Lorg/jetbrains/idea/maven/model/MavenId;", "manager", "Lorg/jetbrains/idea/maven/indices/MavenIndicesManager;", "doGetVariants", "", "searchService", "Lorg/jetbrains/idea/reposearch/DependencySearchService;", "Companion", "intellij.maven"})
public final class MavenArtifactCoordinatesVersionConverter
extends MavenArtifactCoordinatesConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Pattern MAGIC_VERSION_PATTERN = Pattern.compile("\\s*(?:LATEST|RELEASE|[(\\[].*|.*-20\\d{6}\\.[0-2]\\d{5}-\\d+)\\s*");

    @Override
    @Nullable
    public String fromString(@Nullable String s, @NotNull ConvertContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (s != null) {
            return super.fromString(s, context2);
        }
        if (MavenConsumerPomUtil.isAutomaticVersionFeatureEnabled(context2)) {
            return MavenConsumerPomUtil.getAutomaticParentVersion(context2);
        }
        return null;
    }

    @Override
    protected boolean doIsValid(@NotNull MavenId id, @NotNull MavenIndicesManager manager, @NotNull ConvertContext context2) {
        MavenProject mavenProject;
        VirtualFile projectFile2;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (StringUtil.isEmpty((String)id.getGroupId()) || StringUtil.isEmpty((String)id.getArtifactId())) {
            return false;
        }
        PsiDirectory psiDirectory = context2.getFile().getContainingDirectory();
        String path = psiDirectory != null && (psiDirectory = psiDirectory.getVirtualFile()) != null ? psiDirectory.getPath() : null;
        String mavenVersion = MavenDistributionsCache.getInstance(context2.getProject()).getMavenDistribution(path).getVersion();
        if (VersionComparatorUtil.compare((String)mavenVersion, (String)"3.6.3") <= 0 && id.getVersion() == null) {
            return false;
        }
        if (id.getVersion() == null) {
            return MavenConsumerPomUtil.getAutomaticParentVersion(context2) != null;
        }
        String string = id.getVersion();
        Intrinsics.checkNotNull((Object)string);
        if (StringsKt.isBlank((CharSequence)string)) {
            return false;
        }
        String string2 = id.getVersion();
        Intrinsics.checkNotNull((Object)string2);
        if (MAGIC_VERSION_PATTERN.matcher(string2).matches()) {
            return true;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(context2.getProject());
        if (projectsManager.findProject(id) != null) {
            return true;
        }
        VirtualFile virtualFile = projectFile2 = this.getMavenProjectFile(context2);
        MavenProject mavenProject2 = mavenProject = virtualFile == null ? null : projectsManager.findProject(virtualFile);
        if (mavenProject != null) {
            for (MavenArtifact artifact : mavenProject.findDependencies(id)) {
                if (!artifact.isResolved()) continue;
                return true;
            }
        }
        boolean hasLocalVersion = manager.hasLocalVersion(id.getGroupId(), id.getArtifactId(), id.getVersion());
        return hasLocalVersion;
    }

    @Override
    @NotNull
    protected Set<String> doGetVariants(@NotNull MavenId id, @NotNull DependencySearchService searchService) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)searchService, (String)"searchService");
        return SetsKt.emptySet();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesVersionConverter$Companion;", "", "<init>", "()V", "MAGIC_VERSION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

