/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.tree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.workspace.jps.entities.LibraryRootTypeId;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.importing.MavenProjectImporterUtil;
import org.jetbrains.idea.maven.importing.StandardMavenModuleType;
import org.jetbrains.idea.maven.importing.tree.LanguageLevels;
import org.jetbrains.idea.maven.importing.tree.MavenProjectImportContextProviderKt;
import org.jetbrains.idea.maven.importing.tree.MavenProjectImportData;
import org.jetbrains.idea.maven.importing.tree.MavenTreeModuleImportData;
import org.jetbrains.idea.maven.importing.tree.ModuleData;
import org.jetbrains.idea.maven.importing.tree.dependency.AttachedJarDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.BaseDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.LibraryDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.MavenImportDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.ModuleDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.SystemDependency;
import org.jetbrains.idea.maven.importing.workspaceModel.WorkspaceModuleImporter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectModifications;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.utils.MavenLog;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0004\b\f\u0010\rJ \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\nJ*\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00150\nH\u0002J6\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u000f2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00150\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u0018\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0002J\"\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010'\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u0018\u0010*\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020)H\u0002J(\u0010,\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\u00122\u0006\u0010+\u001a\u00020)H\u0002J(\u0010/\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\u00122\u0006\u0010+\u001a\u00020)H\u0002J \u00100\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/idea/maven/importing/tree/MavenProjectImportContextProvider;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myProjectsTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "dependencyTypes", "", "", "myMavenProjectToModuleName", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/idea/maven/project/MavenProjectsTree;Ljava/util/Set;Ljava/util/Map;)V", "getAllModules", "", "Lorg/jetbrains/idea/maven/importing/tree/MavenTreeModuleImportData;", "projectsWithChanges", "Lorg/jetbrains/idea/maven/project/MavenProjectModifications;", "splitToModules", "importData", "Lorg/jetbrains/idea/maven/importing/tree/MavenProjectImportData;", "moduleImportDataByMavenId", "Lorg/jetbrains/idea/maven/model/MavenId;", "getDependency", "Lorg/jetbrains/idea/maven/importing/tree/dependency/MavenImportDependency;", "artifact", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "mavenProject", "createCopyForLocalRepo", "project", "getModuleName", "data", "isTestJar", "", "createAttachArtifactDependency", "Lorg/jetbrains/idea/maven/importing/tree/dependency/AttachedJarDependency;", "scope", "Lcom/intellij/openapi/roots/DependencyScope;", "getAttachedJarsLibName", "getLanguageLevels", "Lorg/jetbrains/idea/maven/importing/tree/LanguageLevels;", "needCreateCompoundModule", "languageLevels", "getModuleImportDataSingle", "moduleName", "changes", "getModuleImportDataCompound", "getModuleImportData", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenProjectImportContextProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenProjectImportContextProvider.kt\norg/jetbrains/idea/maven/importing/tree/MavenProjectImportContextProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,393:1\n1863#2,2:394\n1557#2:396\n1628#2,3:397\n*S KotlinDebug\n*F\n+ 1 MavenProjectImportContextProvider.kt\norg/jetbrains/idea/maven/importing/tree/MavenProjectImportContextProvider\n*L\n96#1:394,2\n342#1:396\n342#1:397,3\n*E\n"})
public final class MavenProjectImportContextProvider {
    @NotNull
    private final Project myProject;
    @NotNull
    private final MavenProjectsTree myProjectsTree;
    @NotNull
    private final Set<String> dependencyTypes;
    @NotNull
    private final Map<MavenProject, String> myMavenProjectToModuleName;

    public MavenProjectImportContextProvider(@NotNull Project myProject, @NotNull MavenProjectsTree myProjectsTree, @NotNull Set<String> dependencyTypes, @NotNull Map<MavenProject, String> myMavenProjectToModuleName) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)myProjectsTree, (String)"myProjectsTree");
        Intrinsics.checkNotNullParameter(dependencyTypes, (String)"dependencyTypes");
        Intrinsics.checkNotNullParameter(myMavenProjectToModuleName, (String)"myMavenProjectToModuleName");
        this.myProject = myProject;
        this.myProjectsTree = myProjectsTree;
        this.dependencyTypes = dependencyTypes;
        this.myMavenProjectToModuleName = myMavenProjectToModuleName;
    }

    @NotNull
    public final List<MavenTreeModuleImportData> getAllModules(@NotNull Map<MavenProject, ? extends MavenProjectModifications> projectsWithChanges) {
        Intrinsics.checkNotNullParameter(projectsWithChanges, (String)"projectsWithChanges");
        List allModules = new ArrayList();
        Map moduleImportDataByMavenId = new TreeMap(Comparator.comparing(MavenProjectImportContextProvider::getAllModules$lambda$0));
        for (Map.Entry<MavenProject, ? extends MavenProjectModifications> each : projectsWithChanges.entrySet()) {
            MavenProject project = each.getKey();
            MavenProjectModifications changes = each.getValue();
            String moduleName = this.myMavenProjectToModuleName.get(project);
            if (StringUtil.isEmpty((String)moduleName)) {
                MavenLog.LOG.warn("[import context] empty module name for project " + project);
                continue;
            }
            String string = moduleName;
            Intrinsics.checkNotNull((Object)string);
            MavenProjectImportData mavenProjectImportData = this.getModuleImportData(project, string, changes);
            moduleImportDataByMavenId.put(project.getMavenId(), mavenProjectImportData);
            allModules.add(mavenProjectImportData);
        }
        List allModuleDataWithDependencies = new ArrayList();
        for (MavenProjectImportData importData : allModules) {
            List<MavenTreeModuleImportData> mavenModuleImportDataList = this.splitToModules(importData, moduleImportDataByMavenId);
            for (MavenTreeModuleImportData moduleImportData : mavenModuleImportDataList) {
                allModuleDataWithDependencies.add(moduleImportData);
            }
        }
        return allModuleDataWithDependencies;
    }

    private final List<MavenTreeModuleImportData> splitToModules(MavenProjectImportData importData, Map<MavenId, MavenProjectImportData> moduleImportDataByMavenId) {
        List<ModuleData> submodules = importData.getSubmodules();
        MavenProject project = importData.getMavenProject();
        ModuleData module = importData.getModule();
        MavenProjectModifications changes = importData.getChanges();
        MavenProject mavenProject = importData.getMavenProject();
        MavenLog.LOG.debug("Creating dependencies for " + mavenProject + ": " + mavenProject.getDependencies().size());
        List mainDependencies = new ArrayList(mavenProject.getDependencies().size());
        List testDependencies = new ArrayList(4);
        Iterable $this$forEach$iv = importData.getMainSubmodules();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleData moduleData = (ModuleData)element$iv;
            boolean bl = false;
            testDependencies.add(new ModuleDependency(moduleData.getModuleName(), DependencyScope.COMPILE, false));
        }
        List<ModuleData> testSubmodules = importData.getTestSubmodules();
        for (MavenArtifact mavenArtifact : mavenProject.getDependencies()) {
            for (MavenImportDependency mavenImportDependency : this.getDependency(moduleImportDataByMavenId, mavenArtifact, mavenProject)) {
                boolean bl = !((Collection)testSubmodules).isEmpty() && mavenImportDependency.getScope() == DependencyScope.TEST ? testDependencies.add(mavenImportDependency) : mainDependencies.add(mavenImportDependency);
            }
        }
        if (submodules.isEmpty()) {
            return CollectionsKt.listOf((Object)new MavenTreeModuleImportData(project, module, CollectionsKt.plus((Collection)mainDependencies, (Iterable)testDependencies), changes));
        }
        Object[] objectArray = new MavenTreeModuleImportData[]{new MavenTreeModuleImportData(project, module, CollectionsKt.emptyList(), changes)};
        List result2 = CollectionsKt.mutableListOf((Object[])objectArray);
        ModuleData moduleData = importData.getDefaultMainSubmodule();
        List additionalMainDependencies = moduleData == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new ModuleDependency(moduleData.getModuleName(), DependencyScope.COMPILE, false));
        for (ModuleData submodule : submodules) {
            List list = switch (WhenMappings.$EnumSwitchMapping$0[submodule.getType().ordinal()]) {
                case 1 -> mainDependencies;
                case 2 -> CollectionsKt.plus((Collection)mainDependencies, (Iterable)additionalMainDependencies);
                case 3 -> CollectionsKt.plus((Collection)testDependencies, (Iterable)mainDependencies);
                default -> null;
            };
            if (list == null) continue;
            List dependencies = list;
            result2.add(new MavenTreeModuleImportData(project, submodule, dependencies, changes));
        }
        return result2;
    }

    private final List<MavenImportDependency<?>> getDependency(Map<MavenId, MavenProjectImportData> moduleImportDataByMavenId, MavenArtifact artifact, MavenProject mavenProject) {
        String dependencyType = artifact.getType();
        MavenLog.LOG.trace("Creating dependency from " + mavenProject + " to " + artifact + ", type " + dependencyType);
        if (!this.dependencyTypes.contains(dependencyType) && !mavenProject.getDependencyTypesFromImporters(SupportedRequestType.FOR_IMPORT).contains(dependencyType)) {
            MavenLog.LOG.trace("Dependency skipped");
            return CollectionsKt.emptyList();
        }
        DependencyScope scope = MavenProjectImporterUtil.selectScope(artifact.getScope());
        MavenProject depProject = this.myProjectsTree.findProject(artifact.getMavenId());
        if (depProject != null) {
            MavenLog.LOG.trace("Dependency project " + depProject);
            if (depProject == mavenProject) {
                MavenLog.LOG.trace("Project depends on itself");
                return CollectionsKt.emptyList();
            }
            MavenProjectImportData mavenProjectImportData = moduleImportDataByMavenId.get(depProject.getMavenId());
            boolean depProjectIgnored = this.myProjectsTree.isIgnored(depProject);
            if (mavenProjectImportData == null || depProjectIgnored) {
                MavenLog.LOG.trace("Created base dependency, project ignored: " + depProjectIgnored + ", import data: " + mavenProjectImportData);
                return CollectionsKt.listOf((Object)new BaseDependency(this.createCopyForLocalRepo(artifact, mavenProject), scope));
            }
            ArrayList<MavenImportDependency> result2 = new ArrayList<MavenImportDependency>();
            boolean isTestJar = Intrinsics.areEqual((Object)"test-jar", (Object)dependencyType) || Intrinsics.areEqual((Object)"tests", (Object)artifact.getClassifier());
            String moduleName = this.getModuleName(mavenProjectImportData, isTestJar);
            ContainerUtil.addIfNotNull((Collection)result2, (Object)this.createAttachArtifactDependency(depProject, scope, artifact));
            String classifier = artifact.getClassifier();
            if (classifier != null && MavenProjectImportContextProviderKt.access$getIMPORTED_CLASSIFIERS$p().contains(classifier) && !isTestJar && !Intrinsics.areEqual((Object)"system", (Object)artifact.getScope()) && !Intrinsics.areEqual((Object)"false", (Object)System.getProperty("idea.maven.classifier.dep"))) {
                MavenLog.LOG.trace("Created library dependency");
                result2.add(new LibraryDependency(this.createCopyForLocalRepo(artifact, mavenProject), scope));
            }
            MavenLog.LOG.trace("Created module dependency");
            result2.add(new ModuleDependency(moduleName, scope, isTestJar));
            return result2;
        }
        if (Intrinsics.areEqual((Object)"system", (Object)artifact.getScope())) {
            MavenLog.LOG.trace("Created system dependency");
            return CollectionsKt.listOf((Object)new SystemDependency(artifact, scope));
        }
        boolean isBundle = Intrinsics.areEqual((Object)"bundle", (Object)dependencyType);
        MavenArtifact finalArtifact = isBundle ? new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), "jar", artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), "jar", null, mavenProject.getLocalRepositoryPath().toFile(), false, false) : artifact;
        MavenLog.LOG.trace("Created base dependency, bundle: " + isBundle);
        return CollectionsKt.listOf((Object)new BaseDependency(finalArtifact, scope));
    }

    private final MavenArtifact createCopyForLocalRepo(MavenArtifact artifact, MavenProject project) {
        return new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), artifact.getType(), artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), artifact.getExtension(), null, project.getLocalRepositoryPath().toFile(), false, false);
    }

    private final String getModuleName(MavenProjectImportData data, boolean isTestJar) {
        ModuleData submodule = isTestJar ? (ModuleData)CollectionsKt.firstOrNull(data.getTestSubmodules()) : (ModuleData)CollectionsKt.firstOrNull(data.getMainSubmodules());
        Object object = submodule;
        if (object == null || (object = ((ModuleData)object).getModuleName()) == null) {
            object = data.getModule().getModuleName();
        }
        return object;
    }

    private final AttachedJarDependency createAttachArtifactDependency(MavenProject mavenProject, DependencyScope scope, MavenArtifact artifact) {
        Element buildHelperCfg = mavenProject.getPluginGoalConfiguration("org.codehaus.mojo", "build-helper-maven-plugin", "attach-artifact");
        if (buildHelperCfg == null) {
            return null;
        }
        ArrayList<Pair> roots = new ArrayList<Pair>();
        boolean create2 = false;
        for (Element artifactsElement : buildHelperCfg.getChildren("artifacts")) {
            for (Element artifactElement : artifactsElement.getChildren("artifact")) {
                String filePath;
                String typeString = artifactElement.getChildTextTrim("type");
                if (typeString != null && !Intrinsics.areEqual((Object)typeString, (Object)"jar") || StringUtil.isEmpty((String)(filePath = artifactElement.getChildTextTrim("file")))) continue;
                String classifier = artifactElement.getChildTextTrim("classifier");
                String string = classifier;
                boolean bl = Intrinsics.areEqual((Object)string, (Object)"sources") ? roots.add(new Pair((Object)filePath, (Object)LibraryRootTypeId.Companion.getSOURCES())) : (Intrinsics.areEqual((Object)string, (Object)"javadoc") ? roots.add(new Pair((Object)filePath, (Object)WorkspaceModuleImporter.Companion.getJAVADOC_TYPE())) : roots.add(new Pair((Object)filePath, (Object)LibraryRootTypeId.Companion.getCOMPILED())));
                create2 = true;
            }
        }
        return create2 ? new AttachedJarDependency(this.getAttachedJarsLibName(artifact), (List<Pair<String, LibraryRootTypeId>>)roots, scope) : null;
    }

    private final String getAttachedJarsLibName(MavenArtifact artifact) {
        Object libraryName = artifact.getLibraryName();
        String string = libraryName;
        Intrinsics.checkNotNull((Object)string);
        boolean bl = StringsKt.startsWith$default((String)string, (String)"Maven: ", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        String string3 = libraryName;
        Intrinsics.checkNotNull((Object)string3);
        int n = 7;
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        libraryName = "Maven: ATTACHED-JAR: " + string4;
        return libraryName;
    }

    private final LanguageLevels getLanguageLevels(MavenProject project) {
        LanguageLevel setUpSourceLevel = MavenImportUtil.INSTANCE.getSourceLanguageLevel$intellij_maven(project);
        LanguageLevel setUpTestSourceLevel = MavenImportUtil.INSTANCE.getTestSourceLanguageLevel$intellij_maven(project);
        LanguageLevel setUpTargetLevel = MavenImportUtil.INSTANCE.getTargetLanguageLevel$intellij_maven(project);
        LanguageLevel setUpTestTargetLevel = MavenImportUtil.INSTANCE.getTestTargetLanguageLevel$intellij_maven(project);
        LanguageLevel sourceLevel = setUpSourceLevel == null ? null : MavenImportUtil.adjustLevelAndNotify(this.myProject, setUpSourceLevel);
        LanguageLevel testSourceLevel = setUpTestSourceLevel == null ? null : MavenImportUtil.adjustLevelAndNotify(this.myProject, setUpTestSourceLevel);
        LanguageLevel targetLevel = setUpTargetLevel == null ? null : MavenImportUtil.adjustLevelAndNotify(this.myProject, setUpTargetLevel);
        LanguageLevel testTargetLevel = setUpTestTargetLevel == null ? null : MavenImportUtil.adjustLevelAndNotify(this.myProject, setUpTestTargetLevel);
        return new LanguageLevels(sourceLevel, testSourceLevel, targetLevel, testTargetLevel);
    }

    private final boolean needCreateCompoundModule(MavenProject project, LanguageLevels languageLevels) {
        if (!Registry.Companion.is("maven.import.separate.main.and.test.modules.when.needed")) {
            return false;
        }
        if (project.isAggregator()) {
            return false;
        }
        if (!MavenImportUtil.INSTANCE.isCompilerTestSupport$intellij_maven(project)) {
            return false;
        }
        if (languageLevels.mainAndTestLevelsDiffer()) {
            return true;
        }
        if (MavenImportUtil.INSTANCE.hasTestCompilerArgs$intellij_maven(project)) {
            return true;
        }
        if (MavenImportUtil.INSTANCE.hasExecutionsForTests$intellij_maven(project)) {
            return true;
        }
        return !((Collection)MavenImportUtil.INSTANCE.getNonDefaultCompilerExecutions$intellij_maven(project)).isEmpty();
    }

    private final MavenProjectImportData getModuleImportDataSingle(MavenProject project, String moduleName, MavenProjectModifications changes, LanguageLevels languageLevels) {
        StandardMavenModuleType type = project.isAggregator() ? StandardMavenModuleType.AGGREGATOR : StandardMavenModuleType.SINGLE_MODULE;
        LanguageLevel sourceLevel = languageLevels.getSourceLevel();
        ModuleData moduleData = new ModuleData(moduleName, type, sourceLevel);
        return new MavenProjectImportData(project, moduleData, changes, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private final MavenProjectImportData getModuleImportDataCompound(MavenProject project, String moduleName, MavenProjectModifications changes, LanguageLevels languageLevels) {
        void $this$mapTo$iv$iv;
        LanguageLevel sourceLevel = languageLevels.getSourceLevel();
        LanguageLevel testSourceLevel = languageLevels.getTestSourceLevel();
        ModuleData moduleData = new ModuleData(moduleName, StandardMavenModuleType.COMPOUND_MODULE, sourceLevel);
        String moduleMainName = moduleName + ".main";
        ModuleData mainData = new ModuleData(moduleMainName, StandardMavenModuleType.MAIN_ONLY, sourceLevel);
        String moduleTestName = moduleName + ".test";
        ModuleData testData = new ModuleData(moduleTestName, StandardMavenModuleType.TEST_ONLY, testSourceLevel);
        Iterable $this$map$iv = MavenImportUtil.INSTANCE.getNonDefaultCompilerExecutions$intellij_maven(project);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String suffix = MavenImportUtil.INSTANCE.escapeCompileSourceRootModuleSuffix$intellij_maven((String)it);
            LanguageLevel sourceRootLevel = MavenImportUtil.INSTANCE.getSourceLanguageLevel$intellij_maven(project, (String)it);
            collection.add(new ModuleData(moduleName + "." + suffix, StandardMavenModuleType.MAIN_ONLY_ADDITIONAL, sourceRootLevel));
        }
        List compileSourceRootModules = (List)destination$iv$iv;
        List otherModules = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)mainData), (Iterable)compileSourceRootModules), (Object)testData);
        return new MavenProjectImportData(project, moduleData, changes, otherModules);
    }

    private final MavenProjectImportData getModuleImportData(MavenProject project, String moduleName, MavenProjectModifications changes) {
        LanguageLevels languageLevels = this.getLanguageLevels(project);
        boolean needCreateCompoundModule = this.needCreateCompoundModule(project, languageLevels);
        if (needCreateCompoundModule) {
            return this.getModuleImportDataCompound(project, moduleName, changes, languageLevels);
        }
        return this.getModuleImportDataSingle(project, moduleName, changes, languageLevels);
    }

    private static final String getAllModules$lambda$0(MavenId obj) {
        MavenId mavenId = obj;
        Intrinsics.checkNotNull((Object)mavenId);
        return mavenId.getKey();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StandardMavenModuleType.values().length];
            try {
                nArray[StandardMavenModuleType.MAIN_ONLY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardMavenModuleType.MAIN_ONLY_ADDITIONAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardMavenModuleType.TEST_ONLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

