/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.project.MavenEmbedderWrapperLegacyImpl;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\tJ\u001a\u0010\u0010\u001a\u00020\u00112\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0015\u001a\u00020\nJ\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/idea/maven/project/MavenEmbeddersManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myPool", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/util/Key;", "", "Lorg/jetbrains/idea/maven/project/MavenEmbedderWrapperLegacyImpl;", "myEmbeddersInUse", "", "reset", "", "getEmbedder", "Lorg/jetbrains/idea/maven/server/MavenEmbedderWrapper;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "kind", "multiModuleProjectDirectory", "createEmbedder", "release", "embedder", "Companion", "intellij.maven"})
@ApiStatus.Obsolete
public final class MavenEmbeddersManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<Pair<Key<?>, String>, MavenEmbedderWrapperLegacyImpl> myPool;
    @NotNull
    private final Set<MavenEmbedderWrapperLegacyImpl> myEmbeddersInUse;
    @JvmField
    @NotNull
    public static final Key<?> FOR_DEPENDENCIES_RESOLVE;

    public MavenEmbeddersManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Map map = ContainerUtil.createSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createSoftValueMap(...)");
        this.myPool = map;
        this.myEmbeddersInUse = new HashSet();
    }

    public final synchronized void reset() {
        for (Pair<Key<?>, String> each : this.myPool.keySet()) {
            MavenEmbedderWrapperLegacyImpl embedder2 = this.myPool.get(each);
            if (embedder2 == null || this.myEmbeddersInUse.contains(embedder2)) continue;
            embedder2.release();
        }
        this.myPool.clear();
        this.myEmbeddersInUse.clear();
    }

    @NotNull
    public final synchronized MavenEmbedderWrapper getEmbedder(@NotNull MavenProject mavenProject, @NotNull Key<?> kind) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter(kind, (String)"kind");
        String baseDir = ((Object)MavenUtil.getBaseDir(mavenProject.getDirectoryFile())).toString();
        return this.getEmbedder(kind, baseDir);
    }

    @NotNull
    public final synchronized MavenEmbedderWrapper getEmbedder(@NotNull Key<?> kind, @NotNull String multiModuleProjectDirectory) {
        Intrinsics.checkNotNullParameter(kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)multiModuleProjectDirectory, (String)"multiModuleProjectDirectory");
        String embedderDir = MavenImportUtil.INSTANCE.guessExistingEmbedderDir$intellij_maven(this.project, multiModuleProjectDirectory);
        Pair pair = Pair.create(kind, (Object)embedderDir);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
        Pair key = pair;
        MavenEmbedderWrapperLegacyImpl result2 = this.myPool.get(key);
        if (result2 != null && !result2.isCompatibleWith(this.project, multiModuleProjectDirectory)) {
            this.myPool.remove(key);
            this.myEmbeddersInUse.remove(result2);
            result2 = null;
        }
        if (result2 == null) {
            result2 = this.createEmbedder(embedderDir);
            this.myPool.put(key, result2);
        }
        if (this.myEmbeddersInUse.contains(result2)) {
            MavenLog.LOG.warn("embedder " + key + " is already used");
            return this.createEmbedder(embedderDir);
        }
        this.myEmbeddersInUse.add(result2);
        return result2;
    }

    private final MavenEmbedderWrapperLegacyImpl createEmbedder(String multiModuleProjectDirectory) {
        MavenServerConnector connector = MavenServerManager.Companion.getInstance().getConnectorBlocking(this.project, multiModuleProjectDirectory);
        return new MavenEmbedderWrapperLegacyImpl(this.project, multiModuleProjectDirectory, connector);
    }

    public final synchronized void release(@NotNull MavenEmbedderWrapper embedder2) {
        Intrinsics.checkNotNullParameter((Object)embedder2, (String)"embedder");
        if (!CollectionsKt.contains((Iterable)this.myEmbeddersInUse, (Object)embedder2)) {
            embedder2.release();
            return;
        }
        TypeIntrinsics.asMutableCollection((Object)this.myEmbeddersInUse).remove(embedder2);
    }

    static {
        Key key = Key.create((String)(MavenEmbeddersManager.class + ".FOR_DEPENDENCIES_RESOLVE"));
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        FOR_DEPENDENCIES_RESOLVE = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/idea/maven/project/MavenEmbeddersManager$Companion;", "", "<init>", "()V", "FOR_DEPENDENCIES_RESOLVE", "Lcom/intellij/openapi/util/Key;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

