/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.eel;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelTunnelsApi;
import com.intellij.platform.eel.provider.utils.IjentTunnelsUtil;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMISocketFactory;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.AbstractMavenServerRemoteProcessSupport;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.eel.EelMavenCmdState;
import org.jetbrains.idea.maven.server.eel.RetryingSocketFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001dB;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0007H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rH\u0014J\b\u0010\u001c\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/idea/maven/server/eel/EelMavenServerRemoteProcessSupport;", "Lorg/jetbrains/idea/maven/server/AbstractMavenServerRemoteProcessSupport;", "eel", "Lcom/intellij/platform/eel/EelApi;", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "vmOptions", "", "mavenDistribution", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "project", "Lcom/intellij/openapi/project/Project;", "debugPort", "", "<init>", "(Lcom/intellij/platform/eel/EelApi;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Lorg/jetbrains/idea/maven/server/MavenDistribution;Lcom/intellij/openapi/project/Project;Ljava/lang/Integer;)V", "getRunProfileState", "Lcom/intellij/execution/configurations/RunProfileState;", "target", "", "configuration", "executor", "Lcom/intellij/execution/Executor;", "getRemoteHost", "getClientSocketFactory", "Ljava/rmi/server/RMIClientSocketFactory;", "publishPort", "port", "type", "CoroutineService", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nEelMavenServerRemoteProcessSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelMavenServerRemoteProcessSupport.kt\norg/jetbrains/idea/maven/server/eel/EelMavenServerRemoteProcessSupport\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,213:1\n31#2,2:214\n*S KotlinDebug\n*F\n+ 1 EelMavenServerRemoteProcessSupport.kt\norg/jetbrains/idea/maven/server/eel/EelMavenServerRemoteProcessSupport\n*L\n74#1:214,2\n*E\n"})
public final class EelMavenServerRemoteProcessSupport
extends AbstractMavenServerRemoteProcessSupport {
    @NotNull
    private final EelApi eel;

    public EelMavenServerRemoteProcessSupport(@NotNull EelApi eel, @NotNull Sdk jdk, @Nullable String vmOptions, @NotNull MavenDistribution mavenDistribution, @NotNull Project project, @Nullable Integer debugPort) {
        Intrinsics.checkNotNullParameter((Object)eel, (String)"eel");
        Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
        Intrinsics.checkNotNullParameter((Object)mavenDistribution, (String)"mavenDistribution");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(jdk, vmOptions, mavenDistribution, project, debugPort);
        this.eel = eel;
    }

    @NotNull
    protected RunProfileState getRunProfileState(@NotNull Object target, @NotNull Object configuration, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        Sdk sdk = this.myJdk;
        Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"myJdk");
        MavenDistribution mavenDistribution = this.myDistribution;
        Intrinsics.checkNotNullExpressionValue((Object)mavenDistribution, (String)"myDistribution");
        return (RunProfileState)new EelMavenCmdState(this.eel, project, sdk, this.myOptions, mavenDistribution, this.myDebugPort);
    }

    @NotNull
    protected String getRemoteHost() {
        return "127.0.0.1";
    }

    @NotNull
    protected RMIClientSocketFactory getClientSocketFactory() {
        RMISocketFactory rMISocketFactory = RMISocketFactory.getSocketFactory();
        if (rMISocketFactory == null) {
            rMISocketFactory = RMISocketFactory.getDefaultSocketFactory();
        }
        RMISocketFactory delegate = rMISocketFactory;
        Intrinsics.checkNotNull((Object)delegate);
        return new RetryingSocketFactory(delegate);
    }

    protected int publishPort(int port) {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<CoroutineService> serviceClass$iv = CoroutineService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        BuildersKt.launch$default((CoroutineScope)((CoroutineService)object).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, port, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ EelMavenServerRemoteProcessSupport this$0;
            final /* synthetic */ int $port;
            {
                this.this$0 = $receiver;
                this.$port = $port;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        IjentTunnelsUtil.forwardLocalPort((CoroutineScope)$this$launch, (EelTunnelsApi)EelMavenServerRemoteProcessSupport.access$getEel$p(this.this$0).getTunnels(), (int)this.$port, (EelTunnelsApi.HostAddress)EelTunnelsApi.HostAddress.Companion.Builder-xj2QHRw(UShort.constructor-impl((short)((short)this.$port))).hostname(this.this$0.getRemoteHost()).build());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return port;
    }

    @Override
    @NotNull
    public String type() {
        return "EEL";
    }

    public static final /* synthetic */ EelApi access$getEel$p(EelMavenServerRemoteProcessSupport $this) {
        return $this.eel;
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/maven/server/eel/EelMavenServerRemoteProcessSupport$CoroutineService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "intellij.maven"})
    private static final class CoroutineService {
        @NotNull
        private final CoroutineScope coroutineScope;

        public CoroutineService(@NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.coroutineScope = coroutineScope;
        }

        @NotNull
        public final CoroutineScope getCoroutineScope() {
            return this.coroutineScope;
        }
    }
}

