/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.ui;

import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import javax.swing.Icon;
import javax.swing.SortOrder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.statistics.MavenActionsUsagesCollector;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0014J\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0014\u00a2\u0006\u0002\u0010\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0014J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0002H\u0014J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0014J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u00022\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/idea/maven/server/ui/ConnectorTable;", "Lcom/intellij/execution/util/ListTableWithButtons;", "Lorg/jetbrains/idea/maven/server/MavenServerConnector;", "<init>", "()V", "stop", "Lcom/intellij/openapi/actionSystem/AnAction;", "getStop", "()Lcom/intellij/openapi/actionSystem/AnAction;", "refresh", "getRefresh", "createListModel", "Lcom/intellij/util/ui/ListTableModel;", "createExtraToolbarActions", "", "()[Lcom/intellij/openapi/actionSystem/AnAction;", "createElement", "isEmpty", "", "element", "canDeleteElement", "selection", "createRemoveAction", "Lcom/intellij/ui/AnActionButtonRunnable;", "createAddAction", "cloneElement", "variable", "TableColumn", "intellij.maven"})
public final class ConnectorTable
extends ListTableWithButtons<MavenServerConnector> {
    @NotNull
    private final AnAction stop;
    @NotNull
    private final AnAction refresh;

    public ConnectorTable() {
        String string = MavenConfigurableBundle.message("connector.ui.stop", new Object[0]);
        Icon icon = AllIcons.Debugger.KillProcess;
        this.stop = new AnAction(this, string, icon){
            final /* synthetic */ ConnectorTable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                MavenActionsUsagesCollector.trigger(e.getProject(), MavenActionsUsagesCollector.KILL_MAVEN_CONNECTOR);
                MavenServerConnector mavenServerConnector = (MavenServerConnector)this.this$0.getTableView().getSelectedObject();
                if (mavenServerConnector == null) {
                    return;
                }
                MavenServerConnector connector = mavenServerConnector;
                MavenServerManager.Companion.getInstance().shutdownConnector(connector, true);
                this.this$0.refreshValues();
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                MavenServerConnector connector = (MavenServerConnector)this.this$0.getTableView().getSelectedObject();
                MavenServerConnector mavenServerConnector = connector;
                e.getPresentation().setEnabled((mavenServerConnector != null ? mavenServerConnector.getState() : null) == MavenServerConnector.State.RUNNING);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }
        };
        string = MavenConfigurableBundle.message("connector.ui.refresh", new Object[0]);
        icon = AllIcons.Actions.Refresh;
        this.refresh = new AnAction(this, string, icon){
            final /* synthetic */ ConnectorTable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getTableView().setModelAndUpdateColumns(this.this$0.createListModel());
                ConnectorTable.access$setModified(this.this$0);
            }
        };
        this.getTableView().getSelectionModel().setSelectionMode(0);
    }

    @NotNull
    public final AnAction getStop() {
        return this.stop;
    }

    @NotNull
    public final AnAction getRefresh() {
        return this.refresh;
    }

    @NotNull
    protected ListTableModel<MavenServerConnector> createListModel() {
        String string = MavenConfigurableBundle.message("connector.ui.project", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        TableColumn project = new TableColumn(string, (Function1<? super MavenServerConnector, String>)((Function1)ConnectorTable::createListModel$lambda$0));
        String string2 = MavenConfigurableBundle.message("connector.ui.jdk", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        TableColumn jdk = new TableColumn(string2, (Function1<? super MavenServerConnector, String>)((Function1)ConnectorTable::createListModel$lambda$1));
        String string3 = MavenConfigurableBundle.message("connector.ui.vmOptions", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        TableColumn vmopts = new TableColumn(string3, (Function1<? super MavenServerConnector, String>)((Function1)ConnectorTable::createListModel$lambda$2));
        String string4 = MavenConfigurableBundle.message("connector.ui.dir", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        TableColumn dir = new TableColumn(string4, (Function1<? super MavenServerConnector, String>)((Function1)ConnectorTable::createListModel$lambda$3));
        String string5 = MavenConfigurableBundle.message("connector.ui.maven", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        TableColumn maven = new TableColumn(string5, (Function1<? super MavenServerConnector, String>)((Function1)ConnectorTable::createListModel$lambda$4));
        String string6 = MavenConfigurableBundle.message("connector.ui.state", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        TableColumn state = new TableColumn(string6, (Function1<? super MavenServerConnector, String>)((Function1)ConnectorTable::createListModel$lambda$5));
        String string7 = MavenConfigurableBundle.message("connector.ui.type", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        TableColumn type = new TableColumn(string7, (Function1<? super MavenServerConnector, String>)((Function1)ConnectorTable::createListModel$lambda$6));
        TableColumn[] tableColumnArray = new TableColumn[]{project, dir, type, maven, state};
        TableColumn[] columnInfos = tableColumnArray;
        return new ListTableModel((ColumnInfo[])columnInfos, CollectionsKt.toList((Iterable)MavenServerManager.Companion.getInstance().getAllConnectors()), 3, SortOrder.DESCENDING);
    }

    @NotNull
    protected AnAction[] createExtraToolbarActions() {
        AnAction[] anActionArray = new AnAction[]{this.refresh, this.stop};
        return anActionArray;
    }

    @Nullable
    protected MavenServerConnector createElement() {
        return null;
    }

    protected boolean isEmpty(@Nullable MavenServerConnector element) {
        return element == null;
    }

    protected boolean canDeleteElement(@NotNull MavenServerConnector selection) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        return false;
    }

    @Nullable
    protected AnActionButtonRunnable createRemoveAction() {
        return null;
    }

    @Nullable
    protected AnActionButtonRunnable createAddAction() {
        return null;
    }

    @Nullable
    protected MavenServerConnector cloneElement(@Nullable MavenServerConnector variable) {
        return null;
    }

    private static final String createListModel$lambda$0(MavenServerConnector it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getProject();
        if (object == null || (object = object.getName()) == null) {
            object = "!Indexer";
        }
        return object;
    }

    private static final String createListModel$lambda$1(MavenServerConnector it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getJdk().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final String createListModel$lambda$2(MavenServerConnector it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getVmOptions();
    }

    private static final String createListModel$lambda$3(MavenServerConnector it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.joinToString$default((Iterable)it.getMultimoduleDirectories(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    private static final String createListModel$lambda$4(MavenServerConnector it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMavenDistribution().getVersion() + " " + it.getMavenDistribution().getMavenHome();
    }

    private static final String createListModel$lambda$5(MavenServerConnector it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getState().toString();
    }

    private static final String createListModel$lambda$6(MavenServerConnector it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSupportType();
    }

    public static final /* synthetic */ void access$setModified(ConnectorTable $this) {
        $this.setModified();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/maven/server/ui/ConnectorTable$TableColumn;", "Lcom/intellij/execution/util/ListTableWithButtons$ElementsColumnInfoBase;", "Lorg/jetbrains/idea/maven/server/MavenServerConnector;", "name", "", "supplier", "Lkotlin/Function1;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getSupplier", "()Lkotlin/jvm/functions/Function1;", "getDescription", "element", "valueOf", "item", "intellij.maven"})
    private static final class TableColumn
    extends ListTableWithButtons.ElementsColumnInfoBase<MavenServerConnector> {
        @NotNull
        private final Function1<MavenServerConnector, String> supplier;

        public TableColumn(@NlsContexts.ColumnName @NotNull String name, @NotNull Function1<? super MavenServerConnector, String> supplier) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            super(name);
            this.supplier = supplier;
        }

        @NotNull
        public final Function1<MavenServerConnector, String> getSupplier() {
            return this.supplier;
        }

        @Nullable
        protected String getDescription(@Nullable MavenServerConnector element) {
            return null;
        }

        @NotNull
        public String valueOf(@NotNull MavenServerConnector item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return (String)this.supplier.invoke((Object)item);
        }
    }
}

