/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileVisitor<T> {
    private boolean myFollowSymLinks;
    private boolean mySkipRoot;
    private int myDepthLimit;
    private int myLevel;
    private Stack<T> myValueStack;
    private T myValue;
    public static final Option NO_FOLLOW_SYMLINKS = new Option();
    public static final Option SKIP_ROOT = new Option();
    public static final Option ONE_LEVEL_DEEP = VirtualFileVisitor.limit(1);
    public static final Result CONTINUE = new Result(false, null);
    public static final Result SKIP_CHILDREN = new Result(true, null);

    protected VirtualFileVisitor(Option ... options) {
        if (options == null) {
            VirtualFileVisitor.$$$reportNull$$$0(0);
        }
        this.myFollowSymLinks = true;
        this.myDepthLimit = -1;
        for (Option option : options) {
            if (option == NO_FOLLOW_SYMLINKS) {
                this.myFollowSymLinks = false;
                continue;
            }
            if (option == SKIP_ROOT) {
                this.mySkipRoot = true;
                continue;
            }
            if (!(option instanceof Option.LimitOption)) continue;
            this.myDepthLimit = ((Option.LimitOption)option).limit;
        }
    }

    @NotNull
    public static Option limit(int maxDepth) {
        return new Option.LimitOption(maxDepth);
    }

    public static Result skipTo(@NotNull VirtualFile parentToSkipTo) {
        if (parentToSkipTo == null) {
            VirtualFileVisitor.$$$reportNull$$$0(1);
        }
        return new Result(true, parentToSkipTo);
    }

    public boolean visitFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualFileVisitor.$$$reportNull$$$0(2);
        }
        return true;
    }

    @NotNull
    public Result visitFileEx(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualFileVisitor.$$$reportNull$$$0(3);
        }
        Result result2 = this.visitFile(file2) ? CONTINUE : SKIP_CHILDREN;
        if (result2 == null) {
            VirtualFileVisitor.$$$reportNull$$$0(4);
        }
        return result2;
    }

    public void afterChildrenVisited(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualFileVisitor.$$$reportNull$$$0(5);
        }
    }

    @Nullable
    public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualFileVisitor.$$$reportNull$$$0(6);
        }
        return null;
    }

    public final void setValueForChildren(@Nullable T value2) {
        this.myValue = value2;
        if (this.myValueStack == null) {
            this.myValueStack = new Stack();
        }
    }

    public final T getCurrentValue() {
        return this.myValue;
    }

    final boolean allowVisitFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualFileVisitor.$$$reportNull$$$0(7);
        }
        return this.myLevel > 0 || !this.mySkipRoot;
    }

    final boolean allowVisitChildren(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualFileVisitor.$$$reportNull$$$0(8);
        }
        if (!file2.is(VFileProperty.SYMLINK)) {
            return true;
        }
        if (!this.myFollowSymLinks) {
            return false;
        }
        return !file2.isRecursiveOrCircularSymlink();
    }

    final boolean depthLimitReached() {
        return this.myDepthLimit >= 0 && this.myLevel >= this.myDepthLimit;
    }

    final void saveValue() {
        ++this.myLevel;
        if (this.myValueStack != null) {
            this.myValueStack.push(this.myValue);
        }
    }

    final void restoreValue(boolean pushed) {
        if (pushed) {
            --this.myLevel;
            if (this.myValueStack != null && !this.myValueStack.isEmpty()) {
                this.myValueStack.pop();
            }
        }
        if (this.myValueStack != null) {
            this.myValue = this.myValueStack.isEmpty() ? null : this.myValueStack.peek();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentToSkipTo";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/VirtualFileVisitor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/VirtualFileVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "visitFileEx";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "skipTo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitFileEx";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "afterChildrenVisited";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenIterable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "allowVisitFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "allowVisitChildren";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Option {
        private Option() {
        }

        private static final class LimitOption
        extends Option {
            private final int limit;

            private LimitOption(int limit) {
                this.limit = limit;
            }
        }
    }

    public static final class Result {
        public final boolean skipChildren;
        public final VirtualFile skipToParent;

        private Result(boolean skipChildren, @Nullable VirtualFile skipToParent) {
            this.skipChildren = skipChildren;
            this.skipToParent = skipToParent;
        }

        public String toString() {
            return "(" + (this.skipChildren ? "skip," + this.skipToParent : "continue") + ")";
        }
    }

    protected static class VisitorException
    extends RuntimeException {
    }
}

