/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.JBIterable;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiInvalidElementAccessException
extends RuntimeException
implements ExceptionWithAttachments {
    private static final Key<Object> INVALIDATION_TRACE = Key.create("INVALIDATION_TRACE");
    private static final Key<Boolean> REPORTING_EXCEPTION = Key.create("REPORTING_EXCEPTION");
    private final SoftReference<PsiElement> myElementReference;
    private final Attachment[] myDiagnostic;
    @NonNls
    private final String myMessage;

    public PsiInvalidElementAccessException(@Nullable PsiElement element) {
        this(element, null, null);
    }

    public PsiInvalidElementAccessException(@Nullable PsiElement element, @Nullable @NonNls String message2) {
        this(element, message2, null);
    }

    public PsiInvalidElementAccessException(@Nullable PsiElement element, @Nullable Throwable cause) {
        this(element, null, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiInvalidElementAccessException(@Nullable PsiElement element, @Nullable @NonNls String message2, @Nullable Throwable cause) {
        super(null, cause);
        this.myElementReference = new SoftReference<PsiElement>(element);
        if (element == null) {
            this.myMessage = message2;
            this.myDiagnostic = Attachment.EMPTY_ARRAY;
        } else if (element == PsiUtilCore.NULL_PSI_ELEMENT) {
            this.myMessage = "NULL_PSI_ELEMENT ;" + message2;
            this.myDiagnostic = Attachment.EMPTY_ARRAY;
        } else {
            boolean recursiveInvocation = Boolean.TRUE.equals(element.getUserData(REPORTING_EXCEPTION));
            element.putUserData(REPORTING_EXCEPTION, Boolean.TRUE);
            try {
                Object trace = recursiveInvocation ? null : PsiInvalidElementAccessException.getPsiInvalidationTrace(element);
                this.myMessage = PsiInvalidElementAccessException.getMessageWithReason(element, message2, recursiveInvocation, trace);
                this.myDiagnostic = PsiInvalidElementAccessException.createAttachments(trace);
            }
            finally {
                element.putUserData(REPORTING_EXCEPTION, null);
            }
        }
    }

    private PsiInvalidElementAccessException(@NotNull ASTNode node, @Nullable @NonNls String message2) {
        if (node == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(0);
        }
        this.myElementReference = new SoftReference<Object>(null);
        IElementType elementType = node.getElementType();
        this.myMessage = "Element " + node.getClass() + " of type " + elementType + " (" + elementType.getClass() + ")" + (message2 == null ? "" : "; " + message2);
        this.myDiagnostic = PsiInvalidElementAccessException.createAttachments(PsiInvalidElementAccessException.findInvalidationTrace(node));
    }

    @NotNull
    public static PsiInvalidElementAccessException createByNode(@NotNull ASTNode node, @Nullable @NonNls String message2) {
        if (node == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(1);
        }
        return new PsiInvalidElementAccessException(node, message2);
    }

    private static Attachment @NotNull [] createAttachments(@Nullable Object trace) {
        Attachment[] attachmentArray;
        if (trace == null) {
            attachmentArray = Attachment.EMPTY_ARRAY;
        } else {
            Attachment[] attachmentArray2 = new Attachment[1];
            attachmentArray = attachmentArray2;
            Attachment attachment = attachmentArray2[0] = trace instanceof Throwable ? new Attachment("invalidation", (Throwable)trace) : new Attachment("diagnostic.txt", trace.toString());
        }
        if (attachmentArray == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(2);
        }
        return attachmentArray;
    }

    @Nullable
    private static Object getPsiInvalidationTrace(@NotNull PsiElement element) {
        Object trace;
        if (element == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(3);
        }
        if ((trace = PsiInvalidElementAccessException.getInvalidationTrace(element)) != null) {
            return trace;
        }
        if (element instanceof PsiFile) {
            return PsiInvalidElementAccessException.getInvalidationTrace(((PsiFile)element).getOriginalFile());
        }
        return PsiInvalidElementAccessException.findInvalidationTrace(element.getNode());
    }

    @NotNull
    private static String getMessageWithReason(@NotNull PsiElement element, @Nullable String message2, boolean recursiveInvocation, @Nullable Object trace) {
        if (element == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(4);
        }
        @NonNls String reason = "Element: " + element.getClass();
        if (!recursiveInvocation) {
            try {
                reason = reason + " #" + PsiInvalidElementAccessException.getLanguage(element).getID() + " ";
            }
            catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
                // empty catch block
            }
            String traceText = !PsiInvalidElementAccessException.isTrackingInvalidation() ? "disabled" : (trace != null ? "see attachment" : "no info");
            try {
                reason = reason + " because: " + PsiInvalidElementAccessException.findOutInvalidationReason(element);
            }
            catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
                // empty catch block
            }
            reason = reason + "\ninvalidated at: " + traceText;
        }
        String string2 = reason + (message2 == null ? "" : "; " + message2);
        if (string2 == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    private static Language getLanguage(@NotNull PsiElement element) {
        if (element == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(6);
        }
        Language language2 = element instanceof ASTNode ? ((ASTNode)((Object)element)).getElementType().getLanguage() : element.getLanguage();
        if (language2 == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(7);
        }
        return language2;
    }

    @Override
    public String getMessage() {
        return this.myMessage;
    }

    @Override
    public Attachment @NotNull [] getAttachments() {
        if (this.myDiagnostic == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(8);
        }
        return this.myDiagnostic;
    }

    public static Object findInvalidationTrace(@Nullable ASTNode element) {
        while (element != null) {
            Object trace = element.getUserData(INVALIDATION_TRACE);
            if (trace != null) {
                return trace;
            }
            ASTNode parent2 = element.getTreeParent();
            if (parent2 == null && element instanceof FileASTNode) {
                PsiElement psi = element.getPsi();
                Object object = trace = psi == null ? null : psi.getUserData(INVALIDATION_TRACE);
                if (trace != null) {
                    return trace;
                }
            }
            element = parent2;
        }
        return null;
    }

    @NonNls
    @NotNull
    public static String findOutInvalidationReason(@NotNull PsiElement root) {
        PsiElement context2;
        PsiElement element;
        if (root == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(9);
        }
        if (root == PsiUtilCore.NULL_PSI_ELEMENT) {
            return "NULL_PSI_ELEMENT";
        }
        PsiElement lastParent = root;
        PsiElement psiElement = element = root instanceof PsiFile ? root : root.getParent();
        if (element == null) {
            @NonNls String m2 = "parent is null";
            if (root instanceof StubBasedPsiElement) {
                for (Object stub = ((StubBasedPsiElement)root).getStub(); stub != null; stub = stub.getParentStub()) {
                    m2 = m2 + "\n  each stub=" + stub;
                    if (!(stub instanceof PsiFileStub)) continue;
                    m2 = m2 + "; fileStub.psi=" + stub.getPsi() + "; reason=" + ((PsiFileStub)stub).getInvalidationReason();
                }
            }
            String string2 = m2;
            if (string2 == null) {
                PsiInvalidElementAccessException.$$$reportNull$$$0(10);
            }
            return string2;
        }
        String hierarchy = "";
        while (element != null && !(element instanceof PsiFile)) {
            hierarchy = hierarchy + (hierarchy.isEmpty() ? "" : ", ") + element.getClass();
            lastParent = element;
            element = element.getParent();
        }
        PsiFile psiFile = (PsiFile)element;
        if (psiFile == null) {
            PsiElement context3 = lastParent.getContext();
            String string3 = "containing file is null; hierarchy=" + hierarchy + ", context=" + context3 + ", contextFile=" + JBIterable.generate(context3, PsiElement::getParent).find(e2 -> e2 instanceof PsiFile);
            if (string3 == null) {
                PsiInvalidElementAccessException.$$$reportNull$$$0(11);
            }
            return string3;
        }
        FileViewProvider provider2 = psiFile.getViewProvider();
        VirtualFile vFile = provider2.getVirtualFile();
        if (!vFile.isValid()) {
            String string4 = vFile + " is invalid";
            if (string4 == null) {
                PsiInvalidElementAccessException.$$$reportNull$$$0(12);
            }
            return string4;
        }
        if (!provider2.isPhysical() && (context2 = psiFile.getContext()) != null && !context2.isValid()) {
            String string5 = "invalid context: " + PsiInvalidElementAccessException.findOutInvalidationReason(context2);
            if (string5 == null) {
                PsiInvalidElementAccessException.$$$reportNull$$$0(13);
            }
            return string5;
        }
        PsiFile original = psiFile.getOriginalFile();
        if (original != psiFile && !original.isValid()) {
            String string6 = "invalid original: " + PsiInvalidElementAccessException.findOutInvalidationReason(original);
            if (string6 == null) {
                PsiInvalidElementAccessException.$$$reportNull$$$0(14);
            }
            return string6;
        }
        PsiManager manager = psiFile.getManager();
        if (manager.getProject().isDisposed()) {
            String string7 = "project is disposed: " + manager.getProject();
            if (string7 == null) {
                PsiInvalidElementAccessException.$$$reportNull$$$0(15);
            }
            return string7;
        }
        Language language2 = psiFile.getLanguage();
        if (language2 != provider2.getBaseLanguage()) {
            String string8 = "File language:" + language2 + " != Provider base language:" + provider2.getBaseLanguage();
            if (string8 == null) {
                PsiInvalidElementAccessException.$$$reportNull$$$0(16);
            }
            return string8;
        }
        FileViewProvider p2 = manager.findCachedViewProvider(vFile);
        if (provider2 != p2) {
            String string9 = "different providers: " + provider2 + "(" + PsiInvalidElementAccessException.id(provider2) + "); " + p2 + "(" + PsiInvalidElementAccessException.id(p2) + ")";
            if (string9 == null) {
                PsiInvalidElementAccessException.$$$reportNull$$$0(17);
            }
            return string9;
        }
        if (!provider2.isPhysical()) {
            String string10 = "non-physical provider: " + provider2;
            if (string10 == null) {
                PsiInvalidElementAccessException.$$$reportNull$$$0(18);
            }
            return string10;
        }
        return "psi is outdated";
    }

    @NotNull
    private static String id(@Nullable FileViewProvider provider2) {
        String string2 = Integer.toHexString(System.identityHashCode(provider2));
        if (string2 == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(19);
        }
        return string2;
    }

    public static void setInvalidationTrace(@NotNull UserDataHolder element, Object trace) {
        if (element == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(20);
        }
        element.putUserData(INVALIDATION_TRACE, trace);
    }

    public static Object getInvalidationTrace(@NotNull UserDataHolder element) {
        if (element == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(21);
        }
        return element.getUserData(INVALIDATION_TRACE);
    }

    public static boolean isTrackingInvalidation() {
        return Registry.is("psi.track.invalidation", true);
    }

    @Nullable
    public PsiElement getPsiElement() {
        return this.myElementReference.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiInvalidElementAccessException";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiInvalidElementAccessException";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageWithReason";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachments";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findOutInvalidationReason";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "id";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createByNode";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPsiInvalidationTrace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMessageWithReason";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findOutInvalidationReason";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setInvalidationTrace";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidationTrace";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

