/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public final class StringLiteralManipulator
extends AbstractElementManipulator<PsiLiteralExpression> {
    @Override
    public PsiLiteralExpression handleContentChange(@NotNull PsiLiteralExpression expr, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String oldText;
        if (expr == null) {
            StringLiteralManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            StringLiteralManipulator.$$$reportNull$$$0(1);
        }
        if ((oldText = expr.getText()).startsWith("\"")) {
            newContent = StringUtil.escapeStringCharacters(newContent);
        } else if (oldText.startsWith("'") && newContent.length() <= 1) {
            newContent = newContent.length() == 1 && newContent.charAt(0) == '\'' ? "\\'" : newContent;
        } else {
            throw new IncorrectOperationException("cannot handle content change for: " + oldText + ", expr: " + expr);
        }
        String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        PsiExpression newExpr = JavaPsiFacade.getElementFactory(expr.getProject()).createExpressionFromText(newText, null);
        return (PsiLiteralExpression)expr.replace(newExpr);
    }

    @Override
    @NotNull
    public TextRange getRangeInElement(@NotNull PsiLiteralExpression element) {
        if (element == null) {
            StringLiteralManipulator.$$$reportNull$$$0(2);
        }
        return StringLiteralManipulator.getValueRange(element);
    }

    @NotNull
    public static TextRange getValueRange(@NotNull PsiLiteralExpression expression2) {
        if (expression2 == null) {
            StringLiteralManipulator.$$$reportNull$$$0(3);
        }
        if (expression2 instanceof PsiLanguageInjectionHost) {
            TextRange textRange = ((PsiLanguageInjectionHost)((Object)expression2)).createLiteralTextEscaper().getRelevantTextRange();
            if (textRange == null) {
                StringLiteralManipulator.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        if (expression2.isTextBlock()) {
            throw new UnsupportedOperationException();
        }
        int length = expression2.getTextLength();
        PsiType type2 = expression2.getType();
        boolean isQuoted = PsiTypes.charType().equals(type2) || type2 != null && type2.equalsToText("java.lang.String");
        TextRange textRange = isQuoted ? new TextRange(1, Math.max(1, length - 1)) : TextRange.from(0, length);
        if (textRange == null) {
            StringLiteralManipulator.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueRange";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValueRange";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

