/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FCTSBackedLighterAST;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.StackOverflowPreventedException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.AstSpine;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.CharTable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileElement
extends LazyParseableElement
implements FileASTNode {
    public static final FileElement[] EMPTY_ARRAY = new FileElement[0];
    private volatile CharTable myCharTable;
    private volatile boolean myDetached;
    private volatile AstSpine myStubbedSpine;

    @Override
    protected PsiElement createPsiNoLock() {
        return this.myDetached ? null : super.createPsiNoLock();
    }

    public void detachFromFile() {
        this.myDetached = true;
        this.clearPsi();
    }

    @Override
    @NotNull
    public CharTable getCharTable() {
        CharTable charTable = this.myCharTable;
        if (charTable == null) {
            FileElement.$$$reportNull$$$0(0);
        }
        return charTable;
    }

    @Override
    @NotNull
    public LighterAST getLighterAST() {
        IElementType contentType = this.getElementType();
        if (!this.isParsed() && contentType instanceof ILightStubFileElementType) {
            return new FCTSBackedLighterAST(this.getCharTable(), ((ILightStubFileElementType)contentType).parseContentsLight(this));
        }
        return new TreeBackedLighterAST(this);
    }

    public FileElement(@NotNull IElementType type2, CharSequence text) {
        if (type2 == null) {
            FileElement.$$$reportNull$$$0(1);
        }
        super(type2, text);
        this.myCharTable = new CharTableImpl();
    }

    @Override
    public PsiManagerEx getManager() {
        CompositeElement treeParent = this.getTreeParent();
        if (treeParent != null) {
            return treeParent.getManager();
        }
        PsiElement psi = this.getPsi();
        if (psi == null) {
            throw PsiInvalidElementAccessException.createByNode(this, null);
        }
        return (PsiManagerEx)psi.getManager();
    }

    @Override
    public ASTNode copyElement() {
        PsiFileImpl psiElement = (PsiFileImpl)this.getPsi();
        PsiFileImpl psiElementCopy = (PsiFileImpl)psiElement.copy();
        return psiElementCopy.getTreeElement();
    }

    public void setCharTable(@NotNull CharTable table) {
        if (table == null) {
            FileElement.$$$reportNull$$$0(2);
        }
        this.myCharTable = table;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myStubbedSpine = null;
    }

    @NotNull
    public final AstSpine getStubbedSpine() {
        AstSpine result2 = this.myStubbedSpine;
        if (result2 == null) {
            PsiFileImpl file2 = (PsiFileImpl)this.getPsi();
            IStubFileElementType<?> type2 = file2.getElementTypeForStubBuilder();
            if (type2 == null) {
                AstSpine astSpine = AstSpine.EMPTY_SPINE;
                if (astSpine == null) {
                    FileElement.$$$reportNull$$$0(3);
                }
                return astSpine;
            }
            result2 = RecursionManager.doPreventingRecursion(file2, false, () -> new AstSpine(this.calcStubbedDescendants(type2.getBuilder())));
            if (result2 == null) {
                throw new StackOverflowPreventedException("Endless recursion prevented");
            }
            this.myStubbedSpine = result2;
        }
        AstSpine astSpine = result2;
        if (astSpine == null) {
            FileElement.$$$reportNull$$$0(4);
        }
        return astSpine;
    }

    private List<CompositeElement> calcStubbedDescendants(final StubBuilder builder) {
        final ArrayList<CompositeElement> result2 = new ArrayList<CompositeElement>();
        result2.add(this);
        this.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitComposite(CompositeElement node) {
                CompositeElement parent2 = node.getTreeParent();
                if (parent2 != null && builder.skipChildProcessingWhenBuildingStubs(parent2, node)) {
                    return;
                }
                IElementType type2 = node.getElementType();
                if (type2 instanceof IStubElementType && ((IStubElementType)type2).shouldCreateStub(node)) {
                    result2.add(node);
                }
                super.visitNode(node);
            }
        });
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/FileElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharTable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/FileElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedSpine";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCharTable";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

