/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public final class PsiClassUtil {
    private PsiClassUtil() {
    }

    public static boolean isRunnableClass(PsiClass aClass, boolean mustBePublic) {
        return PsiClassUtil.isRunnableClass(aClass, mustBePublic, true);
    }

    public static boolean isRunnableClass(PsiClass aClass, boolean mustBePublic, boolean mustNotBeAbstract) {
        if (aClass instanceof PsiAnonymousClass) {
            return false;
        }
        if (mustBePublic && !aClass.hasModifierProperty("public") && (mustNotBeAbstract || !aClass.hasModifierProperty("abstract"))) {
            return false;
        }
        if (aClass.hasModifierProperty("private")) {
            return false;
        }
        if (mustNotBeAbstract && aClass.hasModifierProperty("abstract")) {
            return false;
        }
        return aClass.getContainingClass() == null || aClass.hasModifierProperty("static") || aClass.hasModifierProperty("abstract");
    }

    @NotNull
    public static Comparator<PsiClass> createScopeComparator(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            PsiClassUtil.$$$reportNull$$$0(0);
        }
        Comparator<PsiClass> comparator = Comparator.comparing(c2 -> PsiUtilCore.getVirtualFile(c2), Comparator.nullsFirst((file1, file2) -> scope2.compare((VirtualFile)file2, (VirtualFile)file1)));
        if (comparator == null) {
            PsiClassUtil.$$$reportNull$$$0(1);
        }
        return comparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiClassUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiClassUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeComparator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createScopeComparator";
                break;
            }
            case 1: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

