/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiSuperMethodUtil {
    private PsiSuperMethodUtil() {
    }

    public static boolean isSuperMethod(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (method == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(0);
        }
        if (superMethod == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(1);
        }
        HierarchicalMethodSignature signature = method.getHierarchicalMethodSignature();
        for (HierarchicalMethodSignature superSignature : signature.getSuperSignatures()) {
            PsiMethod supsigme = superSignature.getMethod();
            if (!superMethod.equals(supsigme) && !PsiSuperMethodUtil.isSuperMethod(supsigme, superMethod)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static PsiSubstitutor obtainFinalSubstitutor(@NotNull PsiClass superClass, @NotNull PsiSubstitutor superSubstitutor, @NotNull PsiSubstitutor derivedSubstitutor, boolean inRawContext) {
        if (superClass == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(2);
        }
        if (superSubstitutor == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(3);
        }
        if (derivedSubstitutor == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(4);
        }
        if (inRawContext) {
            Set<PsiTypeParameter> typeParams = superSubstitutor.getSubstitutionMap().keySet();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(superClass.getProject());
            superSubstitutor = factory.createRawSubstitutor(derivedSubstitutor, typeParams.toArray(PsiTypeParameter.EMPTY_ARRAY));
        }
        HashMap<PsiTypeParameter, PsiType> map = null;
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(superClass)) {
            PsiType type2 = superSubstitutor.substitute(typeParameter);
            PsiType t2 = derivedSubstitutor.substitute(type2);
            if (map == null) {
                map = new HashMap<PsiTypeParameter, PsiType>();
            }
            map.put(typeParameter, t2);
        }
        PsiSubstitutor psiSubstitutor = map == null ? PsiSubstitutor.EMPTY : JavaPsiFacade.getElementFactory(superClass.getProject()).createSubstitutor(map);
        if (psiSubstitutor == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(5);
        }
        return psiSubstitutor;
    }

    @NotNull
    public static Map<MethodSignature, Set<PsiMethod>> collectOverrideEquivalents(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(6);
        }
        Map<MethodSignature, Set<PsiMethod>> overrideEquivalent = MethodSignatureUtil.createErasedMethodSignatureMap();
        GlobalSearchScope resolveScope = aClass.getResolveScope();
        PsiClass[] supers = aClass.getSupers();
        for (int i2 = 0; i2 < supers.length; ++i2) {
            PsiClass superClass = supers[i2];
            boolean subType = false;
            for (int j2 = 0; j2 < supers.length; ++j2) {
                if (j2 == i2) continue;
                subType |= supers[j2].isInheritor(supers[i2], true);
            }
            if (subType) continue;
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass, PsiSubstitutor.EMPTY);
            for (HierarchicalMethodSignature hms : superClass.getVisibleSignatures()) {
                PsiSubstitutor containingClassSubstitutor;
                PsiClass containingClass;
                PsiClass methodClass;
                PsiMethod method = hms.getMethod();
                if (MethodSignatureUtil.findMethodBySignature(aClass, method.getSignature(superClassSubstitutor), false) != null || (methodClass = method.getContainingClass()) == null || (containingClass = PsiSuperMethodUtil.correctClassByScope(methodClass, resolveScope)) == null || (method = containingClass.findMethodBySignature(method, false)) == null || (containingClassSubstitutor = TypeConversionUtil.getClassSubstitutor(containingClass, aClass, PsiSubstitutor.EMPTY)) == null) continue;
                PsiSubstitutor finalSubstitutor = PsiSuperMethodUtil.obtainFinalSubstitutor(containingClass, containingClassSubstitutor, hms.getSubstitutor(), false);
                MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create(method, finalSubstitutor, false);
                Set methods2 = overrideEquivalent.computeIfAbsent(signature, __ -> new LinkedHashSet());
                methods2.add(method);
            }
        }
        Map<MethodSignature, Set<PsiMethod>> map = overrideEquivalent;
        if (map == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(7);
        }
        return map;
    }

    @Nullable
    public static PsiClass correctClassByScope(@NotNull PsiClass psiClass, @NotNull GlobalSearchScope resolveScope) {
        Module module2;
        String qualifiedName;
        if (psiClass == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(8);
        }
        if (resolveScope == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(9);
        }
        if ((qualifiedName = psiClass.getQualifiedName()) == null) {
            return psiClass;
        }
        PsiFile file2 = psiClass.getContainingFile();
        if (file2 == null || !file2.getViewProvider().isPhysical()) {
            return psiClass;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return psiClass;
        }
        FileIndexFacade index = FileIndexFacade.getInstance(file2.getProject());
        if (!index.isInSource(vFile) && !index.isInLibrary(vFile)) {
            return psiClass;
        }
        PsiClass aClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass(qualifiedName, resolveScope);
        VirtualFile mappedVFile = PsiUtilCore.getVirtualFile(aClass);
        if (mappedVFile != null && (module2 = index.getModuleForFile(vFile)) != null && module2 == index.getModuleForFile(mappedVFile)) {
            return psiClass;
        }
        return aClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superSubstitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedSubstitutor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiSuperMethodUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiSuperMethodUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainFinalSubstitutor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectOverrideEquivalents";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuperMethod";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "obtainFinalSubstitutor";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectOverrideEquivalents";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "correctClassByScope";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

