/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.SystemInfoRt;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathUtilRt {
    private static final Set<String> WINDOWS_RESERVED_NAMES = new HashSet<String>(Arrays.asList("CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"));
    private static final Charset FS_CHARSET = PathUtilRt.fsCharset();

    @NotNull
    public static String getFileName(@Nullable String path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        int end = PathUtilRt.lastNonSeparatorIndex(path);
        int start = PathUtilRt.lastSeparatorIndex(path, end);
        if (PathUtilRt.isWindowsUNCRoot(path, start)) {
            start = -1;
        }
        String string2 = path.substring(start + 1, end + 1);
        if (string2 == null) {
            PathUtilRt.$$$reportNull$$$0(0);
        }
        return string2;
    }

    private static int lastNonSeparatorIndex(@NotNull String path) {
        if (path == null) {
            PathUtilRt.$$$reportNull$$$0(1);
        }
        for (int index = path.length() - 1; index >= 0; --index) {
            char c2 = path.charAt(index);
            if (PathUtilRt.isSeparator(c2)) continue;
            return index;
        }
        return -1;
    }

    public static boolean isWindowsUNCRoot(@NotNull CharSequence path, int lastPathSeparatorPosition) {
        if (path == null) {
            PathUtilRt.$$$reportNull$$$0(7);
        }
        return Platform.CURRENT == Platform.WINDOWS && PathUtilRt.startsWithSeparatorSeparator(path) && lastPathSeparatorPosition >= 1 && !PathUtilRt.hasFileSeparatorsOrNavigatableDots(path, 2, lastPathSeparatorPosition);
    }

    private static boolean hasFileSeparatorsOrNavigatableDots(@NotNull CharSequence path, int start, int end) {
        if (path == null) {
            PathUtilRt.$$$reportNull$$$0(8);
        }
        for (int i2 = end - 1; i2 >= start; --i2) {
            char c2 = path.charAt(i2);
            if (PathUtilRt.isSeparator(c2)) {
                return true;
            }
            if (c2 != '.' || i2 != 2 && (i2 != 3 || path.charAt(2) != '.')) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithSeparatorSeparator(@NotNull CharSequence path) {
        if (path == null) {
            PathUtilRt.$$$reportNull$$$0(13);
        }
        return path.length() > 1 && PathUtilRt.isSeparator(path.charAt(0)) && path.charAt(1) == path.charAt(0);
    }

    public static boolean isSeparator(char c2) {
        return c2 == '/' || c2 == '\\';
    }

    public static int lastSeparatorIndex(@NotNull CharSequence s2, int endInclusive) {
        if (s2 == null) {
            PathUtilRt.$$$reportNull$$$0(14);
        }
        for (int i2 = endInclusive; i2 >= 0; --i2) {
            if (!PathUtilRt.isSeparator(s2.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    private static Charset fsCharset() {
        String property2;
        if (!SystemInfoRt.isWindows && !SystemInfoRt.isMac && (property2 = System.getProperty("sun.jnu.encoding")) != null) {
            try {
                return Charset.forName(property2);
            }
            catch (Exception e2) {
                LoggerRt.getInstance(PathUtilRt.class).warn("unknown JNU charset: " + property2, e2);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/PathUtilRt";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/PathUtilRt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentPathSequence";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestFileName";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "lastNonSeparatorIndex";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParentPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getParentPathSequence";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParentPathEndOffset";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isWindowsUNCRoot";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasFileSeparatorsOrNavigatableDots";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "suggestFileName";
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isValidFileName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "startsWithSeparatorSeparator";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lastSeparatorIndex";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Platform {
        UNIX,
        WINDOWS;

        public static final Platform CURRENT;

        static {
            CURRENT = SystemInfoRt.isWindows ? WINDOWS : UNIX;
        }
    }
}

