/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.Unsafe;
import com.intellij.util.lang.JavaVersion;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ByteBufferUtil {
    private static final MethodHandle invokeCleaner = ByteBufferUtil.findInvokeCleaner();
    private static final MethodHandle address = ByteBufferUtil.findAddress();
    private static final int byteArrayBaseOffset = ByteBufferUtil.byteArrayBaseOffset();

    @Nullable
    private static MethodHandle findInvokeCleaner() {
        MethodHandle invokeCleaner = null;
        try {
            if (JavaVersion.current().feature >= 9) {
                Object unsafe = ReflectionUtil.getUnsafe();
                MethodType type2 = MethodType.methodType(Void.TYPE, ByteBuffer.class);
                invokeCleaner = MethodHandles.publicLookup().findVirtual(unsafe.getClass(), "invokeCleaner", type2).bindTo(unsafe);
            }
        }
        catch (Throwable t2) {
            Logger.getInstance(ByteBufferUtil.class).warn(t2);
        }
        return invokeCleaner;
    }

    @Nullable
    private static MethodHandle findAddress() {
        MethodHandle address = null;
        try {
            if (JavaVersion.current().feature >= 9) {
                Class<?> directBufferClass = Class.forName("sun.nio.ch.DirectBuffer");
                address = MethodHandles.lookup().findVirtual(directBufferClass, "address", MethodType.methodType(Long.TYPE));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return address;
    }

    private static int byteArrayBaseOffset() {
        return Unsafe.arrayBaseOffset(byte[].class);
    }

    public static boolean cleanBuffer(@NotNull ByteBuffer buffer) {
        if (buffer == null) {
            ByteBufferUtil.$$$reportNull$$$0(0);
        }
        if (!buffer.isDirect()) {
            return true;
        }
        if (invokeCleaner != null) {
            try {
                invokeCleaner.invoke(buffer);
                return true;
            }
            catch (Throwable t2) {
                ByteBufferUtil.getLogger().warn(t2);
                return false;
            }
        }
        try {
            Class<?> directBufferClass = Class.forName("sun.nio.ch.DirectBuffer");
            Class<?> cleanerClass = Class.forName("sun.misc.Cleaner");
            Object cleaner = directBufferClass.getDeclaredMethod("cleaner", new Class[0]).invoke((Object)buffer, new Object[0]);
            if (cleaner != null) {
                cleanerClass.getDeclaredMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
            }
            return true;
        }
        catch (Exception e2) {
            ByteBufferUtil.getLogger().warn(e2);
            return false;
        }
    }

    public static void copyMemory(@NotNull ByteBuffer src, int index, byte[] dst, int dstIndex, int length) {
        if (src == null) {
            ByteBufferUtil.$$$reportNull$$$0(1);
        }
        if (address != null && src.isDirect()) {
            try {
                long address = ByteBufferUtil.address.invoke(src);
                Unsafe.copyMemory(null, address + (long)index, dst, byteArrayBaseOffset + dstIndex, length);
                return;
            }
            catch (Throwable e2) {
                ByteBufferUtil.getLogger().warn(e2);
            }
        }
        ByteBuffer buf = src.duplicate();
        buf.position(index);
        buf.get(dst, dstIndex, length);
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(ByteBufferUtil.class);
        if (logger == null) {
            ByteBufferUtil.$$$reportNull$$$0(3);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/ByteBufferUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/ByteBufferUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cleanBuffer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "copyMemory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAddress";
                break;
            }
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

