/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.dom;

import com.fasterxml.aalto.WFCException;
import com.fasterxml.aalto.impl.ErrorConsts;
import com.intellij.util.xml.dom.NoOpXmlInterner;
import com.intellij.util.xml.dom.StaxFactory;
import com.intellij.util.xml.dom.XmlElement;
import com.intellij.util.xml.dom.XmlElementBuilder;
import com.intellij.util.xml.dom.XmlInterner;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a$\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013\u001a\"\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u0015"}, d2={"nextTag", "", "reader", "Lorg/codehaus/stax2/XMLStreamReader2;", "readAndClose", "Lcom/intellij/util/xml/dom/XmlElement;", "readAttributes", "", "", "interner", "Lcom/intellij/util/xml/dom/XmlInterner;", "readXmlAsModel", "inputStream", "Ljava/io/InputStream;", "inputReader", "Ljava/io/Reader;", "file", "Ljava/nio/file/Path;", "inputData", "", "rootName", "intellij.platform.util.xmlDom"})
@JvmName(name="XmlDomReader")
public final class XmlDomReader {
    @NotNull
    public static final XmlElement readXmlAsModel(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        return XmlDomReader.readAndClose(StaxFactory.createXmlStreamReader(inputStream));
    }

    @NotNull
    public static final XmlElement readXmlAsModel(@NotNull byte[] inputData) {
        Intrinsics.checkNotNullParameter(inputData, "inputData");
        return XmlDomReader.readAndClose(StaxFactory.createXmlStreamReader(inputData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final XmlElement readAndClose(XMLStreamReader2 reader) {
        try {
            String rootName = XmlDomReader.nextTag(reader) == 1 ? reader.getLocalName() : null;
            XmlElement xmlElement = XmlDomReader.readXmlAsModel(reader, rootName, NoOpXmlInterner.INSTANCE);
            return xmlElement;
        }
        finally {
            reader.closeCompletely();
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static final XmlElement readXmlAsModel(@NotNull XMLStreamReader2 reader, @Nullable String rootName, @NotNull XmlInterner interner) {
        XmlElementBuilder fragment;
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(interner, "interner");
        String string2 = rootName;
        XmlElementBuilder current = fragment = new XmlElementBuilder(string2 == null ? "" : interner.name(string2), XmlDomReader.readAttributes(reader, interner));
        ArrayDeque<XmlElementBuilder> stack = new ArrayDeque<XmlElementBuilder>();
        ArrayDeque<XmlElementBuilder> elementPool = new ArrayDeque<XmlElementBuilder>();
        int depth = 1;
        block7: while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    String string3 = reader.getLocalName();
                    Intrinsics.checkNotNullExpressionValue(string3, "getLocalName(...)");
                    String name2 = interner.name(string3);
                    Map<String, String> attributes = XmlDomReader.readAttributes(reader, interner);
                    if (reader.isEmptyElement()) {
                        ArrayList<XmlElement> arrayList = current.children;
                        List<XmlElement> list = Collections.emptyList();
                        Intrinsics.checkNotNullExpressionValue(list, "emptyList(...)");
                        arrayList.add(new XmlElement(name2, attributes, list, null));
                        reader.skipElement();
                        continue block7;
                    }
                    XmlElementBuilder child = (XmlElementBuilder)elementPool.pollLast();
                    if (child == null) {
                        child = new XmlElementBuilder(name2, attributes);
                    } else {
                        child.name = name2;
                        child.attributes = attributes;
                    }
                    stack.addLast(current);
                    current = child;
                    ++depth;
                    continue block7;
                }
                case 2: {
                    List<XmlElement> children = null;
                    if (current.children.isEmpty()) {
                        List<XmlElement> list = Collections.emptyList();
                        Intrinsics.checkNotNullExpressionValue(list, "emptyList(...)");
                        children = list;
                    } else {
                        XmlElement[] xmlElementArray = current.children.toArray(new XmlElement[current.children.size()]);
                        List<XmlElement> list = Arrays.asList(Arrays.copyOf(xmlElementArray, xmlElementArray.length));
                        Intrinsics.checkNotNullExpressionValue(list, "asList(...)");
                        children = list;
                        current.children.clear();
                    }
                    XmlElement result2 = new XmlElement(current.name, current.attributes, children, current.content);
                    current.content = null;
                    elementPool.addLast(current);
                    if (--depth == 0) {
                        return result2;
                    }
                    Object e2 = stack.removeLast();
                    Intrinsics.checkNotNullExpressionValue(e2, "removeLast(...)");
                    current = (XmlElementBuilder)e2;
                    current.children.add(result2);
                    continue block7;
                }
                case 12: {
                    if (current.content == null) {
                        String string4 = current.name;
                        String string5 = reader.getText();
                        Intrinsics.checkNotNullExpressionValue(string5, "getText(...)");
                        current.content = interner.value(string4, string5);
                        continue block7;
                    }
                    XmlElementBuilder xmlElementBuilder = current;
                    xmlElementBuilder.content = xmlElementBuilder.content + reader.getText();
                    continue block7;
                }
                case 4: {
                    if (reader.isWhiteSpace()) continue block7;
                    if (current.content == null) {
                        current.content = reader.getText();
                        continue block7;
                    }
                    XmlElementBuilder xmlElementBuilder = current;
                    xmlElementBuilder.content = xmlElementBuilder.content + reader.getText();
                    continue block7;
                }
                case 3: 
                case 5: 
                case 6: 
                case 9: {
                    continue block7;
                }
            }
            throw new XMLStreamException("Unexpected XMLStream event " + reader.getEventType(), reader.getLocation());
        }
        throw new XMLStreamException("Unexpected end of input: " + reader.getEventType(), reader.getLocation());
    }

    private static final Map<String, String> readAttributes(XMLStreamReader2 reader, XmlInterner interner) {
        int attributeCount = reader.getAttributeCount();
        switch (attributeCount) {
            case 0: {
                Map<String, String> map = Collections.emptyMap();
                Intrinsics.checkNotNullExpressionValue(map, "emptyMap(...)");
                return map;
            }
            case 1: {
                String string2 = reader.getAttributeLocalName(0);
                Intrinsics.checkNotNullExpressionValue(string2, "getAttributeLocalName(...)");
                String name2 = interner.name(string2);
                String string3 = reader.getAttributeValue(0);
                Intrinsics.checkNotNullExpressionValue(string3, "getAttributeValue(...)");
                Map<String, String> map = Collections.singletonMap(name2, interner.value(name2, string3));
                Intrinsics.checkNotNullExpressionValue(map, "singletonMap(...)");
                return map;
            }
        }
        HashMap<String, String> result2 = new HashMap<String, String>(attributeCount);
        for (int i2 = 0; i2 < attributeCount; ++i2) {
            String string4 = reader.getAttributeLocalName(i2);
            Intrinsics.checkNotNullExpressionValue(string4, "getAttributeLocalName(...)");
            String name3 = interner.name(string4);
            String string5 = reader.getAttributeValue(i2);
            Intrinsics.checkNotNullExpressionValue(string5, "getAttributeValue(...)");
            result2.put(name3, interner.value(name3, string5));
        }
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final int nextTag(XMLStreamReader2 reader) {
        int next;
        block5: while (true) {
            next = reader.next();
            switch (next) {
                case 3: 
                case 5: 
                case 6: 
                case 11: {
                    continue block5;
                }
                case 4: 
                case 12: {
                    if (!reader.isWhiteSpace()) throw new WFCException("Received non-all-whitespace CHARACTERS or CDATA event in nextTag().", reader.getLocation());
                    continue block5;
                }
                case 1: 
                case 2: {
                    return next;
                }
            }
            break;
        }
        throw new WFCException("Received event " + ErrorConsts.tokenTypeDesc(next) + ", instead of START_ELEMENT or END_ELEMENT.", reader.getLocation());
    }
}

