/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.FunctionsFromAnyGenerator;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H$J\u001e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H$J\u001e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H$J\u0016\u0010\u001a\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0016\u0010\u001b\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0016\u0010\u001c\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00168DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001f\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/backend/common/FunctionsFromAnyGenerator;", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "generate", "", "generateToStringMethod", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "properties", "", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "generateHashCodeMethod", "generateEqualsMethod", "generateToStringIfNeeded", "generateHashCodeIfNeeded", "generateEqualsIfNeeded", "primaryConstructorProperties", "getPrimaryConstructorProperties", "()Ljava/util/List;", "primaryConstructorParameters", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getPrimaryConstructorParameters", "backend-common"})
@SourceDebugExtension(value={"SMAP\nFunctionsFromAnyGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionsFromAnyGenerator.kt\norg/jetbrains/kotlin/backend/common/FunctionsFromAnyGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n774#2:70\n865#2,2:71\n1563#2:73\n1634#2,3:74\n*S KotlinDebug\n*F\n+ 1 FunctionsFromAnyGenerator.kt\norg/jetbrains/kotlin/backend/common/FunctionsFromAnyGenerator\n*L\n63#1:70\n63#1:71,2\n64#1:73\n64#1:74,3\n*E\n"})
public abstract class FunctionsFromAnyGenerator {
    @NotNull
    private final KtClassOrObject declaration;
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final ClassDescriptor classDescriptor;

    public FunctionsFromAnyGenerator(@NotNull KtClassOrObject declaration, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        this.declaration = declaration;
        this.bindingContext = bindingContext;
        Object v2 = BindingContextUtils.getNotNull(this.bindingContext, BindingContext.CLASS, this.declaration);
        Intrinsics.checkNotNullExpressionValue(v2, "getNotNull(...)");
        this.classDescriptor = (ClassDescriptor)v2;
    }

    @NotNull
    protected final KtClassOrObject getDeclaration() {
        return this.declaration;
    }

    @NotNull
    protected final BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    protected final ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public void generate() {
        List<PropertyDescriptor> properties2 = this.getPrimaryConstructorProperties();
        this.generateToStringIfNeeded(properties2);
        this.generateHashCodeIfNeeded(properties2);
        this.generateEqualsIfNeeded(properties2);
    }

    protected abstract void generateToStringMethod(@NotNull FunctionDescriptor var1, @NotNull List<? extends PropertyDescriptor> var2);

    protected abstract void generateHashCodeMethod(@NotNull FunctionDescriptor var1, @NotNull List<? extends PropertyDescriptor> var2);

    protected abstract void generateEqualsMethod(@NotNull FunctionDescriptor var1, @NotNull List<? extends PropertyDescriptor> var2);

    private final void generateToStringIfNeeded(List<? extends PropertyDescriptor> properties2) {
        FunctionDescriptor functionDescriptor = CodegenUtil.INSTANCE.getMemberToGenerate(this.classDescriptor, "toString", generateToStringIfNeeded.function.1.INSTANCE, generateToStringIfNeeded.function.2.INSTANCE);
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor function2 = functionDescriptor;
        this.generateToStringMethod(function2, properties2);
    }

    private final void generateHashCodeIfNeeded(List<? extends PropertyDescriptor> properties2) {
        FunctionDescriptor functionDescriptor = CodegenUtil.INSTANCE.getMemberToGenerate(this.classDescriptor, "hashCode", generateHashCodeIfNeeded.function.1.INSTANCE, generateHashCodeIfNeeded.function.2.INSTANCE);
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor function2 = functionDescriptor;
        this.generateHashCodeMethod(function2, properties2);
    }

    private final void generateEqualsIfNeeded(List<? extends PropertyDescriptor> properties2) {
        FunctionDescriptor functionDescriptor = CodegenUtil.INSTANCE.getMemberToGenerate(this.classDescriptor, "equals", generateEqualsIfNeeded.function.1.INSTANCE, FunctionsFromAnyGenerator::generateEqualsIfNeeded$lambda$0);
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor function2 = functionDescriptor;
        this.generateEqualsMethod(function2, properties2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<PropertyDescriptor> getPrimaryConstructorProperties() {
        void $this$mapTo$iv$iv;
        KtParameter it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getPrimaryConstructorParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtParameter)element$iv$iv;
            boolean bl = false;
            if (!it.hasValOrVar()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (KtParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v2 = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, it);
            Intrinsics.checkNotNull(v2);
            collection.add((PropertyDescriptor)v2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected final List<KtParameter> getPrimaryConstructorParameters() {
        KtClassOrObject ktClassOrObject = this.declaration;
        KtClass ktClass = ktClassOrObject instanceof KtClass ? (KtClass)ktClassOrObject : null;
        List<KtParameter> list = ktClass != null ? ktClass.getPrimaryConstructorParameters() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final boolean generateEqualsIfNeeded$lambda$0(List parameters) {
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        return parameters.size() == 1 && KotlinBuiltIns.isNullableAny(((ValueParameterDescriptor)CollectionsKt.first(parameters)).getType());
    }
}

