/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.checkers.context;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.InlineFunctionUseSiteChecker;
import org.jetbrains.kotlin.backend.common.ScopeStack;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00120\u0010\b\u001a,\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\f\u0012\u0004\u0012\u00020\r0\tj\u0002`\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0016\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u000bJ\u001c\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0*J=\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\n2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0*2\u001f\b\u0002\u0010-\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0/\u0012\u0004\u0012\u00020\r0.\u00a2\u0006\u0002\b0R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R8\u0010\b\u001a,\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\f\u0012\u0004\u0012\u00020\r0\tj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001f\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "checkInlineFunctionUseSites", "Lorg/jetbrains/kotlin/backend/common/InlineFunctionUseSiteChecker;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "reportError", "Lkotlin/Function4;", "Lorg/jetbrains/kotlin/ir/IrElement;", "", "", "", "Lorg/jetbrains/kotlin/backend/common/ReportIrValidationError;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/backend/common/InlineFunctionUseSiteChecker;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lkotlin/jvm/functions/Function4;)V", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getCheckInlineFunctionUseSites", "()Lorg/jetbrains/kotlin/backend/common/InlineFunctionUseSiteChecker;", "getFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "parentChain", "", "getParentChain", "()Ljava/util/List;", "typeParameterScopeStack", "Lorg/jetbrains/kotlin/backend/common/ScopeStack;", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "getTypeParameterScopeStack", "()Lorg/jetbrains/kotlin/backend/common/ScopeStack;", "valueSymbolScopeStack", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "getValueSymbolScopeStack", "error", "element", "message", "withTypeParametersInScope", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "block", "Lkotlin/Function0;", "withScopeOwner", "owner", "populateScope", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nCheckerContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckerContext.kt\norg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1869#2,2:50\n*S KotlinDebug\n*F\n+ 1 CheckerContext.kt\norg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext\n*L\n36#1:50,2\n*E\n"})
public final class CheckerContext {
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @Nullable
    private final InlineFunctionUseSiteChecker checkInlineFunctionUseSites;
    @NotNull
    private final IrFile file;
    @NotNull
    private final Function4<IrFile, IrElement, String, List<? extends IrElement>, Unit> reportError;
    @NotNull
    private final List<IrElement> parentChain;
    @NotNull
    private final ScopeStack<IrTypeParameterSymbol> typeParameterScopeStack;
    @NotNull
    private final ScopeStack<IrValueSymbol> valueSymbolScopeStack;

    public CheckerContext(@NotNull IrBuiltIns irBuiltIns, @Nullable InlineFunctionUseSiteChecker checkInlineFunctionUseSites, @NotNull IrFile file2, @NotNull Function4<? super IrFile, ? super IrElement, ? super String, ? super List<? extends IrElement>, Unit> reportError) {
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(reportError, "reportError");
        this.irBuiltIns = irBuiltIns;
        this.checkInlineFunctionUseSites = checkInlineFunctionUseSites;
        this.file = file2;
        this.reportError = reportError;
        this.parentChain = new ArrayList();
        this.typeParameterScopeStack = new ScopeStack();
        this.valueSymbolScopeStack = new ScopeStack();
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @Nullable
    public final InlineFunctionUseSiteChecker getCheckInlineFunctionUseSites() {
        return this.checkInlineFunctionUseSites;
    }

    @NotNull
    public final IrFile getFile() {
        return this.file;
    }

    @NotNull
    public final List<IrElement> getParentChain() {
        return this.parentChain;
    }

    @NotNull
    public final ScopeStack<IrTypeParameterSymbol> getTypeParameterScopeStack() {
        return this.typeParameterScopeStack;
    }

    @NotNull
    public final ScopeStack<IrValueSymbol> getValueSymbolScopeStack() {
        return this.valueSymbolScopeStack;
    }

    public final void error(@NotNull IrElement element, @NotNull String message2) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(message2, "message");
        this.reportError.invoke(this.file, element, message2, this.parentChain);
    }

    public final void withTypeParametersInScope(@NotNull IrTypeParametersContainer container, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(block, "block");
        ScopeStack.withNewScope$default(this.typeParameterScopeStack, false, container instanceof IrClass && !((IrClass)container).isInner() && !Intrinsics.areEqual(((IrClass)container).getVisibility(), DescriptorVisibilities.LOCAL), arg_0 -> CheckerContext.withTypeParametersInScope$lambda$1(container, arg_0), block, 1, null);
    }

    public final void withScopeOwner(@NotNull IrElement owner, @NotNull Function0<Unit> block, @NotNull Function1<? super Set<IrValueSymbol>, Unit> populateScope) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(block, "block");
        Intrinsics.checkNotNullParameter(populateScope, "populateScope");
        ScopeStack<IrValueSymbol> scopeStack = this.valueSymbolScopeStack;
        boolean bl = owner instanceof IrScript;
        boolean bl2 = owner instanceof IrClass && !((IrClass)owner).isInner() && !Intrinsics.areEqual(((IrClass)owner).getVisibility(), DescriptorVisibilities.LOCAL);
        scopeStack.withNewScope(bl, bl2, populateScope, block);
    }

    public static /* synthetic */ void withScopeOwner$default(CheckerContext checkerContext, IrElement irElement, Function0 function0, Function1 function1, int n2, Object object) {
        if ((n2 & 4) != 0) {
            function1 = CheckerContext::withScopeOwner$lambda$2;
        }
        checkerContext.withScopeOwner(irElement, function0, function1);
    }

    private static final Unit withTypeParametersInScope$lambda$1(IrTypeParametersContainer $container, Set $this$withNewScope) {
        Intrinsics.checkNotNullParameter($this$withNewScope, "$this$withNewScope");
        Iterable $this$forEach$iv = $container.getTypeParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrTypeParameter it = (IrTypeParameter)element$iv;
            boolean bl = false;
            $this$withNewScope.add(it.getSymbol());
        }
        return Unit.INSTANCE;
    }

    private static final Unit withScopeOwner$lambda$2(Set set) {
        Intrinsics.checkNotNullParameter(set, "<this>");
        return Unit.INSTANCE;
    }
}

