/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.SpecialBridgeMethods;
import org.jetbrains.kotlin.backend.common.lower.SpecialMethodWithDefaultInfo;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmDefaultUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.JvmStringConcatenationLowering;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;

@PhaseDescription(name="ArgumentNullabilityAssertions", prerequisite={JvmStringConcatenationLowering.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 )2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0002()B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u001c\u0010\u001e\u001a\u00020\u00132\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0014\u0010$\u001a\u00020\t2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020\t*\u0004\u0018\u00010&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010'\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmArgumentNullabilityAssertionsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrTransformer;", "Lorg/jetbrains/kotlin/backend/jvm/lower/JvmArgumentNullabilityAssertionsLowering$AssertionScope;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "isWithUnifiedNullChecks", "", "isCallAssertionsDisabled", "isReceiverAssertionsDisabled", "specialBridgeMethods", "Lorg/jetbrains/kotlin/backend/common/lower/SpecialBridgeMethods;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "element", "data", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitMemberAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "isCallToMethodWithTypeCheckBarrier", "isOperatorWithNoNullabilityAssertionsOnExtensionReceiver", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "(Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;)Z", "AssertionScope", "Companion", "backend.jvm.lower"})
public final class JvmArgumentNullabilityAssertionsLowering
extends IrTransformer<AssertionScope>
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isWithUnifiedNullChecks;
    private final boolean isCallAssertionsDisabled;
    private final boolean isReceiverAssertionsDisabled;
    @NotNull
    private final SpecialBridgeMethods specialBridgeMethods;
    @NotNull
    private static final HashSet<IrStatementOriginImpl> operatorsWithNoNullabilityAssertionsOnExtensionReceiver;

    public JvmArgumentNullabilityAssertionsLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.isWithUnifiedNullChecks = context2.getConfig().getUnifiedNullChecks();
        this.isCallAssertionsDisabled = context2.getConfig().isCallAssertionsDisabled();
        this.isReceiverAssertionsDisabled = context2.getConfig().isReceiverAssertionsDisabled();
        this.specialBridgeMethods = new SpecialBridgeMethods(context2);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        irFile.transformChildren(this, AssertionScope.Enabled);
    }

    @Override
    @NotNull
    public IrElement visitElement(@NotNull IrElement element, @NotNull AssertionScope data) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter((Object)data, "data");
        return super.visitElement(element, (Object)AssertionScope.Enabled);
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull AssertionScope data) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter((Object)data, "data");
        return super.visitDeclaration(declaration, (Object)AssertionScope.Enabled);
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull AssertionScope data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter((Object)data, "data");
        return expression2.getOperator() == IrTypeOperator.IMPLICIT_NOTNULL && (data == AssertionScope.Disabled || this.isCallAssertionsDisabled) ? expression2.getArgument().transform((IrElementTransformer)this, (Object)data) : super.visitTypeOperator(expression2, (Object)data);
    }

    @Override
    @NotNull
    public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull AssertionScope data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter((Object)data, "data");
        IrExpression irExpression = expression2.getDispatchReceiver();
        expression2.setDispatchReceiver((IrExpression)(irExpression != null ? irExpression.transform((IrElementTransformer)this, (Object)AssertionScope.Disabled) : null));
        AssertionScope receiverAssertionScope = this.isReceiverAssertionsDisabled || !this.isWithUnifiedNullChecks && this.isOperatorWithNoNullabilityAssertionsOnExtensionReceiver(expression2.getOrigin()) ? AssertionScope.Disabled : AssertionScope.Enabled;
        IrExpression irExpression2 = expression2.getExtensionReceiver();
        expression2.setExtensionReceiver((IrExpression)(irExpression2 != null ? irExpression2.transform((IrElementTransformer)this, (Object)receiverAssertionScope) : null));
        AssertionScope parameterAssertionScope = this.isCallToMethodWithTypeCheckBarrier(expression2) ? AssertionScope.Disabled : AssertionScope.Enabled;
        int n2 = expression2.getValueArgumentsCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            IrExpression irArgument;
            if (expression2.getValueArgument(i2) == null) continue;
            boolean bl = false;
            expression2.putValueArgument(i2, (IrExpression)irArgument.transform((IrElementTransformer)this, (Object)parameterAssertionScope));
        }
        return expression2;
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull AssertionScope data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter((Object)data, "data");
        IrExpression irExpression = expression2.getReceiver();
        expression2.setReceiver((IrExpression)(irExpression != null ? irExpression.transform((IrElementTransformer)this, (Object)AssertionScope.Disabled) : null));
        return expression2;
    }

    @Override
    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2, @NotNull AssertionScope data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter((Object)data, "data");
        IrExpression irExpression = expression2.getReceiver();
        expression2.setReceiver((IrExpression)(irExpression != null ? irExpression.transform((IrElementTransformer)this, (Object)AssertionScope.Disabled) : null));
        expression2.setValue((IrExpression)expression2.getValue().transform((IrElementTransformer)this, (Object)data));
        return expression2;
    }

    private final boolean isCallToMethodWithTypeCheckBarrier(IrMemberAccessExpression<?> expression2) {
        boolean bl;
        IrSimpleFunction irSimpleFunction;
        IrSymbolOwner irSymbolOwner = expression2.getSymbol().getOwner();
        IrSimpleFunction irSimpleFunction2 = irSimpleFunction = irSymbolOwner instanceof IrSimpleFunction ? (IrSimpleFunction)irSymbolOwner : null;
        if (irSimpleFunction != null) {
            IrSimpleFunction it = irSimpleFunction;
            boolean bl2 = false;
            Pair<IrSimpleFunction, SpecialMethodWithDefaultInfo> bridgeInfo = this.specialBridgeMethods.findSpecialWithOverride(it, true);
            bl = bridgeInfo != null && !JvmDefaultUtilsKt.hasPlatformDependent(bridgeInfo.getFirst());
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isOperatorWithNoNullabilityAssertionsOnExtensionReceiver(IrStatementOrigin $this$isOperatorWithNoNullabilityAssertionsOnExtensionReceiver) {
        return $this$isOperatorWithNoNullabilityAssertionsOnExtensionReceiver instanceof IrStatementOrigin.COMPONENT_N || CollectionsKt.contains((Iterable)operatorsWithNoNullabilityAssertionsOnExtensionReceiver, $this$isOperatorWithNoNullabilityAssertionsOnExtensionReceiver);
    }

    static {
        IrStatementOriginImpl[] irStatementOriginImplArray = new IrStatementOriginImpl[]{IrStatementOrigin.Companion.getPREFIX_INCR(), IrStatementOrigin.Companion.getPOSTFIX_INCR(), IrStatementOrigin.Companion.getPREFIX_DECR(), IrStatementOrigin.Companion.getPOSTFIX_DECR()};
        operatorsWithNoNullabilityAssertionsOnExtensionReceiver = SetsKt.hashSetOf(irStatementOriginImplArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmArgumentNullabilityAssertionsLowering$AssertionScope;", "", "<init>", "(Ljava/lang/String;I)V", "Enabled", "Disabled", "backend.jvm.lower"})
    public static final class AssertionScope
    extends Enum<AssertionScope> {
        public static final /* enum */ AssertionScope Enabled = new AssertionScope();
        public static final /* enum */ AssertionScope Disabled = new AssertionScope();
        private static final /* synthetic */ AssertionScope[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AssertionScope[] values() {
            return (AssertionScope[])$VALUES.clone();
        }

        public static AssertionScope valueOf(String value2) {
            return Enum.valueOf(AssertionScope.class, value2);
        }

        @NotNull
        public static EnumEntries<AssertionScope> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = assertionScopeArray = new AssertionScope[]{AssertionScope.Enabled, AssertionScope.Disabled};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmArgumentNullabilityAssertionsLowering$Companion;", "", "<init>", "()V", "operatorsWithNoNullabilityAssertionsOnExtensionReceiver", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "Lkotlin/collections/HashSet;", "backend.jvm.lower"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

