/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.lower.FinallyBlocksLoweringKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LocationType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LocationUtilsKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LoopLabelType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.OptimisedWhenGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.SyntheticLocalType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VirtualMethodMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFileCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFunctionCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleMetadataCache;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleTypeTransformer;
import org.jetbrains.kotlin.backend.wasm.lower.TryCatchCanonicalizationKt;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.backend.wasm.utils.UtilsKt;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.lower.PrimaryConstructorLowering;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpKotlinLikeKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrTypeErasureUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.wasm.config.WasmConfigurationKeys;
import org.jetbrains.kotlin.wasm.ir.WasmAnyRef;
import org.jetbrains.kotlin.wasm.ir.WasmExnRefType;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmExternRef;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI16;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmI64;
import org.jetbrains.kotlin.wasm.ir.WasmI8;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmImmediateKind;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\n\u0010!\u001a\u00020\"*\u00020\u000fJ\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020\u001dJ\u0015\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)H\u0000\u00a2\u0006\u0002\b*J\u0010\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020)H\u0002J\u0010\u0010-\u001a\u00020\"2\u0006\u0010,\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\u0018\u00108\u001a\u00020\"2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\u0010\u00109\u001a\u00020\"2\u0006\u0010(\u001a\u000205H\u0016J\u0010\u0010:\u001a\u00020\"2\u0006\u0010(\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\"2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\"2\u0006\u0010=\u001a\u00020>H\u0002J\f\u0010@\u001a\u00020\"*\u00020AH\u0002J\f\u0010B\u001a\u00020\"*\u00020AH\u0002J\u0014\u0010C\u001a\u000203*\u00020.2\u0006\u0010D\u001a\u00020AH\u0002J\u0010\u0010E\u001a\u00020\"2\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010F\u001a\u00020\"2\u0006\u0010(\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020\"2\u0006\u0010(\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020\"2\u0006\u0010(\u001a\u00020KH\u0016J\u0018\u0010L\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010O\u001a\u00020\"2\u0006\u0010(\u001a\u00020PH\u0016J\u0010\u0010Q\u001a\u00020\"2\u0006\u0010(\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020\"2\u0006\u0010(\u001a\u00020TH\u0016J\u0010\u0010U\u001a\u00020\"2\u0006\u0010(\u001a\u00020VH\u0016J\u0010\u0010W\u001a\u00020\"2\u0006\u0010(\u001a\u00020XH\u0016J\u0018\u0010Y\u001a\u00020\"2\u0006\u0010Z\u001a\u00020[2\u0006\u0010M\u001a\u00020NH\u0002J\u000e\u0010\\\u001a\u00020\"2\u0006\u0010]\u001a\u00020^J\u0010\u0010_\u001a\u00020\"2\u0006\u0010(\u001a\u00020`H\u0016J\u0018\u0010a\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\u0006\u0010b\u001a\u00020cH\u0002J\u0010\u0010d\u001a\u00020\"2\u0006\u0010e\u001a\u00020fH\u0002J(\u0010g\u001a\u00020\"2\u0006\u0010h\u001a\u00020c2\u0006\u0010i\u001a\u00020c2\u0006\u0010j\u001a\u0002032\u0006\u0010M\u001a\u00020NH\u0002J \u0010k\u001a\u00020\"2\u0006\u0010h\u001a\u00020c2\u0006\u0010i\u001a\u00020c2\u0006\u0010M\u001a\u00020NH\u0002J\u0018\u0010l\u001a\u0002032\u0006\u0010h\u001a\u00020c2\u0006\u0010i\u001a\u00020cH\u0002J\u0018\u0010m\u001a\u0002032\u0006\u0010h\u001a\u00020c2\u0006\u0010i\u001a\u00020cH\u0002J\u0018\u0010n\u001a\u0002032\u0006\u0010e\u001a\u00020f2\u0006\u0010o\u001a\u00020pH\u0002J\u0010\u0010q\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020rH\u0016J\u0010\u0010s\u001a\u00020\"2\u0006\u0010t\u001a\u00020uH\u0016J\u0010\u0010v\u001a\u00020\"2\u0006\u0010(\u001a\u00020wH\u0016J\u0010\u0010x\u001a\u00020\"2\u0006\u0010(\u001a\u00020yH\u0002J\u0010\u0010z\u001a\u00020\"2\u0006\u0010(\u001a\u00020yH\u0016J\u0010\u0010{\u001a\u00020\"2\u0006\u0010|\u001a\u00020}H\u0016J\u0010\u0010~\u001a\u00020\"2\u0006\u0010|\u001a\u00020\u007fH\u0016J\u0012\u0010\u0080\u0001\u001a\u00020\"2\u0007\u0010(\u001a\u00030\u0081\u0001H\u0002J \u0010\u0082\u0001\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\u0007\u0010\u0083\u0001\u001a\u00020cH\u0000\u00a2\u0006\u0003\b\u0084\u0001J#\u0010\u0085\u0001\u001a\u00020\"2\u0007\u0010\u0086\u0001\u001a\u00020c2\u0007\u0010\u0083\u0001\u001a\u00020c2\u0006\u0010M\u001a\u00020NH\u0002J\u0012\u0010\u0087\u0001\u001a\u00020\"2\u0007\u0010(\u001a\u00030\u0081\u0001H\u0016J\u0012\u0010\u0088\u0001\u001a\u00020\"2\u0007\u0010(\u001a\u00030\u0089\u0001H\u0016J\u0013\u0010\u008a\u0001\u001a\u00020\"2\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001H\u0016J\u0013\u0010\u008d\u0001\u001a\u00020\"2\b\u0010\u008b\u0001\u001a\u00030\u008e\u0001H\u0016J\u0013\u0010\u008f\u0001\u001a\u00020\"2\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001H\u0016J\u0019\u0010\u0092\u0001\u001a\u0002032\u0006\u0010e\u001a\u00020f2\u0006\u0010o\u001a\u00020pH\u0002J\r\u0010\u0093\u0001\u001a\u00020N*\u000201H\u0002J\r\u0010\u0094\u0001\u001a\u00020N*\u000201H\u0002J\r\u0010\u0095\u0001\u001a\u00020N*\u000201H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u001b\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006\u0096\u0001"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/BodyGenerator;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "wasmFileCodegenContext", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;", "functionContext", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;", "wasmModuleMetadataCache", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleMetadataCache;", "wasmModuleTypeTransformer", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleTypeTransformer;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleMetadataCache;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleTypeTransformer;)V", "body", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getBody", "()Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "wasmSymbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "unitGetInstance", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getUnitGetInstance", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "unitGetInstance$delegate", "Lkotlin/Lazy;", "unitInstanceField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getUnitInstanceField", "()Lorg/jetbrains/kotlin/ir/declarations/IrField;", "unitInstanceField$delegate", "buildGetUnit", "", "getStructFieldRef", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "", "field", "generateExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "generateExpression$backend_wasm", "generateAsStatement", "statement", "generateStatement", "Lorg/jetbrains/kotlin/ir/IrStatement;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "tryGenerateConstVarargArray", "", "irVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "wasmArrayType", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$GcType;", "tryGenerateVarargArray", "visitVararg", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "generateTryFollowingNewProposal", "initializeCatchParameter", "Lorg/jetbrains/kotlin/ir/expressions/IrCatch;", "wrapJsThrownValueIntoJsException", "isSimpleRethrowing", "catchBlock", "generateTryFollowingOldProposal", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "generateInstanceFieldAccess", "location", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "generateAnyParameters", "klassSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "generateObjectCreationPrefixIfNeeded", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "generateBox", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "generateCall", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "generateRefCast", "fromType", "toType", "isRefNullCast", "generateRefTest", "isInvalidDownCast", "isDownCastAlwaysSuccessInRuntime", "tryToGenerateIntrinsicCall", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitInlinedFunctionBlock", "inlinedBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;", "visitReturnableBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrReturnableBlock;", "processContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitContainerExpression", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "visitFunctionReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "generateWithExpectedType", "expectedType", "generateWithExpectedType$backend_wasm", "recoverToExpectedType", "actualType", "visitReturn", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitDoWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "visitWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "visitVariable", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "tryToGenerateWasmOpIntrinsicCall", "getSourceLocation", "getSourceEndLocation", "nextLocation", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nBodyGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BodyGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/BodyGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 6 WasmExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder\n*L\n1#1,1316:1\n1761#2,3:1317\n1563#2:1320\n1634#2,3:1321\n1563#2:1324\n1634#2,3:1325\n1563#2:1328\n1634#2,3:1329\n1563#2:1332\n1634#2,3:1333\n1563#2:1336\n1634#2,3:1337\n1563#2:1340\n1634#2,3:1341\n1869#2,2:1344\n1869#2,2:1350\n1869#2,2:1408\n1878#2,3:1426\n1869#2,2:1437\n360#2,7:1439\n360#2,7:1454\n1869#2,2:1473\n1878#2,3:1479\n183#3,2:1346\n1#4:1348\n231#5:1349\n292#6,8:1352\n292#6,8:1360\n292#6,8:1368\n292#6,8:1376\n292#6,8:1384\n292#6,8:1392\n292#6,8:1400\n292#6,8:1410\n302#6,4:1418\n302#6,4:1422\n292#6,8:1429\n302#6,4:1446\n302#6,4:1450\n69#6,2:1461\n69#6,4:1463\n71#6,2:1467\n69#6,4:1469\n302#6,4:1475\n292#6,8:1482\n74#6,4:1490\n67#6,4:1494\n67#6,6:1498\n71#6,2:1504\n78#6,2:1506\n74#6,4:1508\n67#6,6:1512\n78#6,2:1518\n*S KotlinDebug\n*F\n+ 1 BodyGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/BodyGenerator\n*L\n101#1:1317,3\n103#1:1320\n103#1:1321,3\n106#1:1324\n106#1:1325,3\n107#1:1328\n107#1:1329,3\n108#1:1332\n108#1:1333,3\n109#1:1336\n109#1:1337,3\n110#1:1340\n110#1:1341,3\n125#1:1344,2\n286#1:1350,2\n565#1:1408,2\n603#1:1426,3\n680#1:1437,2\n697#1:1439,7\n726#1:1454,7\n947#1:1473,2\n975#1:1479,3\n139#1:1346,2\n249#1:1349\n464#1:1352,8\n487#1:1360,8\n504#1:1368,8\n508#1:1376,8\n526#1:1384,8\n532#1:1392,8\n559#1:1400,8\n568#1:1410,8\n578#1:1418,4\n596#1:1422,4\n634#1:1429,8\n703#1:1446,4\n718#1:1450,4\n833#1:1461,2\n834#1:1463,4\n833#1:1467,2\n901#1:1469,4\n957#1:1475,4\n1124#1:1482,8\n1201#1:1490,4\n1202#1:1494,4\n1203#1:1498,6\n1202#1:1504,2\n1201#1:1506,2\n1225#1:1508,4\n1226#1:1512,6\n1225#1:1518,2\n*E\n"})
public final class BodyGenerator
extends IrVisitorVoid {
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmFileCodegenContext wasmFileCodegenContext;
    @NotNull
    private final WasmFunctionCodegenContext functionContext;
    @NotNull
    private final WasmModuleMetadataCache wasmModuleMetadataCache;
    @NotNull
    private final WasmModuleTypeTransformer wasmModuleTypeTransformer;
    @NotNull
    private final WasmExpressionBuilder body;
    @NotNull
    private final WasmSymbols wasmSymbols;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Lazy unitGetInstance$delegate;
    @NotNull
    private final Lazy unitInstanceField$delegate;

    public BodyGenerator(@NotNull WasmBackendContext backendContext, @NotNull WasmFileCodegenContext wasmFileCodegenContext, @NotNull WasmFunctionCodegenContext functionContext, @NotNull WasmModuleMetadataCache wasmModuleMetadataCache, @NotNull WasmModuleTypeTransformer wasmModuleTypeTransformer) {
        Intrinsics.checkNotNullParameter(backendContext, "backendContext");
        Intrinsics.checkNotNullParameter(wasmFileCodegenContext, "wasmFileCodegenContext");
        Intrinsics.checkNotNullParameter(functionContext, "functionContext");
        Intrinsics.checkNotNullParameter(wasmModuleMetadataCache, "wasmModuleMetadataCache");
        Intrinsics.checkNotNullParameter(wasmModuleTypeTransformer, "wasmModuleTypeTransformer");
        this.backendContext = backendContext;
        this.wasmFileCodegenContext = wasmFileCodegenContext;
        this.functionContext = functionContext;
        this.wasmModuleMetadataCache = wasmModuleMetadataCache;
        this.wasmModuleTypeTransformer = wasmModuleTypeTransformer;
        this.body = this.functionContext.getBodyGen();
        this.wasmSymbols = this.backendContext.getWasmSymbols();
        this.irBuiltIns = this.backendContext.getIrBuiltIns();
        this.unitGetInstance$delegate = LazyKt.lazy(() -> BodyGenerator.unitGetInstance_delegate$lambda$0(this));
        this.unitInstanceField$delegate = LazyKt.lazy(() -> BodyGenerator.unitInstanceField_delegate$lambda$1(this));
    }

    @NotNull
    public final WasmExpressionBuilder getBody() {
        return this.body;
    }

    private final IrSimpleFunction getUnitGetInstance() {
        Lazy lazy = this.unitGetInstance$delegate;
        return (IrSimpleFunction)lazy.getValue();
    }

    private final IrField getUnitInstanceField() {
        Lazy lazy = this.unitInstanceField$delegate;
        return (IrField)lazy.getValue();
    }

    public final void buildGetUnit(@NotNull WasmExpressionBuilder $this$buildGetUnit) {
        Intrinsics.checkNotNullParameter($this$buildGetUnit, "<this>");
        $this$buildGetUnit.buildGetGlobal(this.wasmFileCodegenContext.referenceGlobalField(this.getUnitInstanceField().getSymbol()), SourceLocation.Companion.NoLocation("GET_UNIT"));
    }

    @NotNull
    public final WasmSymbol<Integer> getStructFieldRef(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter(field, "field");
        IrClass klass = IrUtilsKt.getParentAsClass(field);
        ClassMetadata metadata = this.wasmModuleMetadataCache.getClassMetadata(klass.getSymbol());
        int fieldId = metadata.getFields().indexOf(field) + 2;
        return new WasmSymbol<Integer>(fieldId);
    }

    public final void generateExpression$backend_wasm(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrVisitorsKt.acceptVoid((IrElement)expression2, this);
        if (IrTypePredicatesKt.isNothing(expression2.getType())) {
            LocationUtilsKt.buildUnreachableAfterNothingType(this.body);
        }
    }

    private final void generateAsStatement(IrExpression statement) {
        this.generateExpression$backend_wasm(statement);
        if (!Intrinsics.areEqual(statement.getType(), this.wasmSymbols.getVoidType())) {
            this.body.buildDrop(SourceLocation.Companion.NoLocation("DROP"));
        }
    }

    private final void generateStatement(IrStatement statement) {
        IrStatement irStatement = statement;
        if (irStatement instanceof IrExpression) {
            this.generateAsStatement((IrExpression)statement);
        } else if (irStatement instanceof IrVariable) {
            IrVisitorsKt.acceptVoid((IrElement)statement, this);
        } else {
            throw new IllegalStateException(("Unsupported node type: " + Reflection.getOrCreateKotlinClass(statement.getClass()).getSimpleName()).toString());
        }
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        throw new IllegalStateException(("Unexpected element of type " + Reflection.getOrCreateKotlinClass(element.getClass())).toString());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryGenerateConstVarargArray(IrVararg irVararg, WasmImmediate.GcType wasmArrayType) {
        Pair<List, WasmType> pair;
        Object it;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv;
        Collection collection;
        Iterator iterator2;
        void $this$mapTo$iv$iv2;
        Object element$iv2;
        boolean bl;
        block23: {
            if (irVararg.getElements().isEmpty()) {
                return false;
            }
            IrVarargElement irVarargElement = irVararg.getElements().get(0);
            Object object = irVarargElement instanceof IrConst ? (IrConst)irVarargElement : null;
            if (object == null || (object = ((IrConst)object).getKind()) == null) {
                return false;
            }
            Object kind = object;
            if (Intrinsics.areEqual(kind, IrConstKind.String.INSTANCE) || Intrinsics.areEqual(kind, IrConstKind.Null.INSTANCE)) {
                return false;
            }
            Iterable $this$any$iv = irVararg.getElements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    IrVarargElement it2 = (IrVarargElement)element$iv2;
                    boolean bl2 = false;
                    if (!(!(it2 instanceof IrConst) || !Intrinsics.areEqual(((IrConst)it2).getKind(), kind))) continue;
                    bl = true;
                    break block23;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        Iterable $this$map$iv2 = irVararg.getElements();
        boolean $i$f$map22 = false;
        element$iv2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it3;
            iterator2 = (IrVarargElement)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            Intrinsics.checkNotNull(it3, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst");
            Object object = ((IrConst)it3).getValue();
            Intrinsics.checkNotNull(object);
            collection.add(object);
        }
        List elementConstValues = (List)destination$iv$iv2;
        IrType $i$f$map22 = irVararg.getVarargElementType();
        if (Intrinsics.areEqual($i$f$map22, this.irBuiltIns.getByteType())) {
            $this$map$iv = elementConstValues;
            $i$f$map = false;
            Iterable $i$f$mapTo22 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv;
                Object e2 = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type kotlin.Byte");
                collection.add(Long.valueOf(((Byte)it).byteValue()));
            }
            pair = TuplesKt.to((List)destination$iv$iv, WasmI8.INSTANCE);
        } else if (Intrinsics.areEqual($i$f$map22, this.irBuiltIns.getBooleanType())) {
            $this$map$iv = elementConstValues;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv;
                it = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl5 = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type kotlin.Boolean");
                collection.add((Boolean)it != false ? 1L : 0L);
            }
            pair = TuplesKt.to((List)destination$iv$iv, WasmI8.INSTANCE);
        } else if (Intrinsics.areEqual($i$f$map22, this.irBuiltIns.getIntType())) {
            $this$map$iv = elementConstValues;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv;
                it = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl6 = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type kotlin.Int");
                collection.add(Long.valueOf(((Integer)it).intValue()));
            }
            pair = TuplesKt.to((List)destination$iv$iv, WasmI32.INSTANCE);
        } else if (Intrinsics.areEqual($i$f$map22, this.irBuiltIns.getShortType())) {
            $this$map$iv = elementConstValues;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv;
                it = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl7 = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type kotlin.Short");
                collection.add(Long.valueOf(((Short)it).shortValue()));
            }
            pair = TuplesKt.to((List)destination$iv$iv, WasmI16.INSTANCE);
        } else if (Intrinsics.areEqual($i$f$map22, this.irBuiltIns.getLongType())) {
            $this$map$iv = elementConstValues;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv;
                it = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl8 = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type kotlin.Long");
                collection.add(Long.valueOf((Long)it));
            }
            pair = TuplesKt.to((List)destination$iv$iv, WasmI64.INSTANCE);
        } else {
            return false;
        }
        Pair<List, WasmI8> resource = pair;
        WasmSymbol<Integer> constantArrayId = this.wasmFileCodegenContext.referenceConstantArray(resource);
        SourceLocation location = this.getSourceLocation(irVararg);
        boolean bl9 = false;
        this.body.buildConstI32(0, location);
        this.body.buildConstI32(irVararg.getElements().size(), location);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{wasmArrayType, new WasmImmediate.DataIdx(constantArrayId)};
        this.body.buildInstr(WasmOp.ARRAY_NEW_DATA, location, wasmImmediateArray);
        return true;
    }

    private final void tryGenerateVarargArray(IrVararg irVararg, WasmImmediate.GcType wasmArrayType) {
        Iterable $this$forEach$iv = irVararg.getElements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrVarargElement it = (IrVarargElement)element$iv;
            boolean bl = false;
            if (!(it instanceof IrExpression)) {
                throw new IllegalStateException("Check failed.");
            }
            this.generateExpression$backend_wasm((IrExpression)it);
        }
        WasmImmediate.ConstI32 length = new WasmImmediate.ConstI32(irVararg.getElements().size());
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{wasmArrayType, length};
        this.body.buildInstr(WasmOp.ARRAY_NEW_FIXED, this.getSourceLocation(irVararg), wasmImmediateArray);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visitVararg(@NotNull IrVararg expression) {
        block5: {
            Intrinsics.checkNotNullParameter(expression, "expression");
            v0 = IrTypesKt.getClass(expression.getType());
            Intrinsics.checkNotNull(v0);
            arrayClass = v0;
            var5_3 = SequencesKt.mapNotNull(IrUtilsKt.getConstructors(arrayClass), (Function1<IrConstructor, IrType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, visitVararg$lambda$11(org.jetbrains.kotlin.ir.declarations.IrConstructor ), (Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;)Lorg/jetbrains/kotlin/ir/types/IrType;)());
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                it = (IrType)element$iv;
                $i$a$-firstOrNull-BodyGenerator$visitVararg$wasmArrayType$2 = false;
                v1 = IrTypesKt.getClass((IrType)it);
                if (!((v1 != null ? AnnotationsKt.getWasmArrayAnnotation(v1) : null) != null)) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        var4_11 = v2;
        if (var4_11 == null || (var5_3 = TypeTransformerKt.getRuntimeClass(var4_11, this.irBuiltIns)) == null || (var6_5 = var5_3.getSymbol()) == null) ** GOTO lbl-1000
        var8_7 = var6_5;
        it = this.wasmFileCodegenContext;
        p0 = var8_7;
        $i$a$-let-BodyGenerator$visitVararg$wasmArrayType$3 = false;
        var7_6 = it.referenceGcType(p0);
        if (var7_6 != null) {
            p0 = var7_6;
            $i$a$-let-BodyGenerator$visitVararg$wasmArrayType$4 = false;
            v3 = new WasmImmediate.GcType((WasmSymbol<? extends WasmTypeDeclaration>)p0);
        } else lbl-1000:
        // 2 sources

        {
            v3 = wasmArrayType = null;
        }
        if (!(wasmArrayType != null)) {
            throw new IllegalStateException("Check failed.");
        }
        location = this.getSourceLocation(expression);
        this.generateAnyParameters(arrayClass.getSymbol(), location);
        if (!this.tryGenerateConstVarargArray(expression, wasmArrayType)) {
            this.tryGenerateVarargArray(expression, wasmArrayType);
        }
        this.body.buildStructNew(this.wasmFileCodegenContext.referenceGcType(TypeTransformerKt.getRuntimeClass(expression.getType(), this.irBuiltIns).getSymbol()), location);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.generateExpression$backend_wasm(expression2.getValue());
        if (this.backendContext.getConfiguration().getBoolean(WasmConfigurationKeys.WASM_USE_TRAPS_INSTEAD_OF_EXCEPTIONS)) {
            this.body.buildUnreachable(SourceLocation.Companion.NoLocation("Unreachable is inserted instead of a `throw` instruction"));
            return;
        }
        SourceLocation sourceLocation = this.getSourceLocation(expression2);
        if (!this.backendContext.isWasmJsTarget() || !this.backendContext.getConfiguration().getBoolean(WasmConfigurationKeys.WASM_USE_JS_TAG)) {
            this.body.buildThrow(this.wasmFileCodegenContext.getThrowableTagIndex(), sourceLocation);
            return;
        }
        IrType irType = expression2.getType();
        if (Intrinsics.areEqual(irType, IrTypesKt.getDefaultType(this.wasmSymbols.getJsRelatedSymbols().getJsException()))) {
            this.generateInstanceFieldAccess(this.wasmSymbols.getJsRelatedSymbols().getJsExceptionThrownValue(), this.getSourceLocation(expression2.getValue()));
            this.body.buildThrow(this.wasmFileCodegenContext.getJsExceptionTagIndex(), sourceLocation);
        } else if (Intrinsics.areEqual(irType, this.irBuiltIns.getThrowableType())) {
            WasmLocal tmp = this.functionContext.referenceLocal(this.functionContext.defineTmpVariable(this.wasmModuleTypeTransformer.transformType(this.irBuiltIns.getThrowableType())));
            this.body.buildSetLocal(tmp, SourceLocation.NoLocation.INSTANCE);
            this.body.buildGetLocal(tmp, SourceLocation.NoLocation.INSTANCE);
            this.body.buildRefTestStatic((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.wasmFileCodegenContext.referenceGcType(this.wasmSymbols.getJsRelatedSymbols().getJsException()), sourceLocation);
            WasmExpressionBuilder.buildIf$default(this.body, "is_js_exception", null, 2, null);
            this.body.buildGetLocal(tmp, SourceLocation.NoLocation.INSTANCE);
            this.body.buildRefCastStatic((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.wasmFileCodegenContext.referenceGcType(this.wasmSymbols.getJsRelatedSymbols().getJsException()), SourceLocation.NoLocation.INSTANCE);
            this.generateInstanceFieldAccess(this.wasmSymbols.getJsRelatedSymbols().getJsExceptionThrownValue(), this.getSourceLocation(expression2.getValue()));
            this.body.buildThrow(this.wasmFileCodegenContext.getJsExceptionTagIndex(), sourceLocation);
            WasmExpressionBuilder.buildElse$default(this.body, null, 1, null);
            this.body.buildGetLocal(tmp, SourceLocation.NoLocation.INSTANCE);
            this.body.buildThrow(this.wasmFileCodegenContext.getThrowableTagIndex(), sourceLocation);
            WasmExpressionBuilder.buildEnd$default(this.body, null, 1, null);
        } else {
            this.body.buildThrow(this.wasmFileCodegenContext.getThrowableTagIndex(), sourceLocation);
        }
    }

    @Override
    public void visitTry(@NotNull IrTry aTry) {
        Intrinsics.checkNotNullParameter(aTry, "aTry");
        boolean bl = UtilsKt.isCanonical(aTry, this.backendContext);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "expected canonical try/catch";
            throw new AssertionError((Object)string2);
        }
        if (this.backendContext.getConfiguration().getBoolean(WasmConfigurationKeys.WASM_USE_TRAPS_INSTEAD_OF_EXCEPTIONS)) {
            this.generateExpression$backend_wasm(aTry.getTryResult());
            return;
        }
        if (this.backendContext.getConfiguration().getBoolean(WasmConfigurationKeys.WASM_USE_NEW_EXCEPTION_PROPOSAL)) {
            this.generateTryFollowingNewProposal(aTry);
        } else {
            this.generateTryFollowingOldProposal(aTry);
        }
    }

    private final void generateTryFollowingNewProposal(IrTry aTry) {
        List<WasmImmediate.Catch> list;
        Integer n2;
        IrCatch firstCatchBlock;
        boolean canUseJsTag = this.backendContext.getConfiguration().getBoolean(WasmConfigurationKeys.WASM_USE_JS_TAG);
        IrCatch lastCatchBlock = CollectionsKt.last(aTry.getCatches());
        boolean hasOnlySingleCatchBlock = lastCatchBlock == (firstCatchBlock = CollectionsKt.first(aTry.getCatches()));
        WasmType resultType = this.wasmModuleTypeTransformer.transformBlockResultType(aTry.getType());
        boolean needCatchAllOnly = lastCatchBlock.getOrigin() == FinallyBlocksLoweringKt.getSYNTHETIC_CATCH_FOR_FINALLY_EXPRESSION();
        boolean areTwoCatchWithTheSameBody = this.backendContext.isWasmJsTarget() && firstCatchBlock.getOrigin() == TryCatchCanonicalizationKt.getSYNTHETIC_JS_EXCEPTION_HANDLER_TO_SUPPORT_CATCH_THROWABLE();
        int topLevelCatchLabel = this.body.buildBlock(resultType);
        boolean firstCatchParameterIsJsException = this.backendContext.isWasmJsTarget() && Intrinsics.areEqual(firstCatchBlock.getCatchParameter().getType(), IrTypesKt.getDefaultType(this.wasmSymbols.getJsRelatedSymbols().getJsException()));
        boolean condition$iv = !needCatchAllOnly && firstCatchParameterIsJsException && (!hasOnlySingleCatchBlock || !canUseJsTag);
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            n2 = this.body.buildBlock(this.wasmModuleTypeTransformer.transformBlockResultType(this.irBuiltIns.getThrowableType()));
        } else {
            n2 = null;
        }
        Integer nestedCatchLabel = n2;
        WasmType tryBlockType = needCatchAllOnly ? (WasmType)WasmExnRefType.INSTANCE : (firstCatchParameterIsJsException ? (WasmType)(canUseJsTag ? WasmExternRef.INSTANCE : null) : this.wasmModuleTypeTransformer.transformBlockResultType(this.irBuiltIns.getThrowableType()));
        int tryBlockLabel = this.body.buildBlock(tryBlockType);
        if (needCatchAllOnly) {
            list = CollectionsKt.listOf(this.body.createNewCatchAllRef(tryBlockLabel));
        } else if (nestedCatchLabel != null) {
            WasmImmediate.Catch[] catchArray = new WasmImmediate.Catch[]{this.body.createNewCatch(this.wasmFileCodegenContext.getThrowableTagIndex(), nestedCatchLabel), canUseJsTag ? this.body.createNewCatch(this.wasmFileCodegenContext.getJsExceptionTagIndex(), tryBlockLabel) : this.body.createNewCatchAll(tryBlockLabel)};
            list = CollectionsKt.listOf(catchArray);
        } else {
            list = CollectionsKt.listOf(this.body.createNewCatch(tryBlockType == WasmExternRef.INSTANCE ? this.wasmFileCodegenContext.getJsExceptionTagIndex() : this.wasmFileCodegenContext.getThrowableTagIndex(), tryBlockLabel));
        }
        List<WasmImmediate.Catch> catchList = list;
        this.body.buildTryTable(null, catchList, tryBlockType);
        this.generateExpression$backend_wasm(aTry.getTryResult());
        this.body.buildBr(topLevelCatchLabel, SourceLocation.Companion.NoLocation(""));
        WasmExpressionBuilder.buildEnd$default(this.body, null, 1, null);
        WasmExpressionBuilder.buildEnd$default(this.body, null, 1, null);
        if (needCatchAllOnly) {
            IrExpression irExpression = lastCatchBlock.getResult();
            Intrinsics.checkNotNull(irExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrComposite");
            IrComposite composite = (IrComposite)irExpression;
            boolean bl = this.isSimpleRethrowing(CollectionsKt.last(composite.getStatements()), lastCatchBlock);
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-BodyGenerator$generateTryFollowingNewProposal$22 = false;
                String $i$a$-assert-BodyGenerator$generateTryFollowingNewProposal$22 = "Last throw is not rethrowing";
                throw new AssertionError((Object)$i$a$-assert-BodyGenerator$generateTryFollowingNewProposal$22);
            }
            Iterable $this$forEach$iv = CollectionsKt.dropLast(composite.getStatements(), 1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrStatement p0 = (IrStatement)element$iv;
                boolean bl2 = false;
                this.generateStatement(p0);
            }
            this.body.buildThrowRef(SourceLocation.NoLocation.INSTANCE);
            WasmExpressionBuilder.buildEnd$default(this.body, null, 1, null);
            return;
        }
        if (nestedCatchLabel != null) {
            if (!canUseJsTag) {
                this.body.buildRefNull(WasmHeapType.Simple.Extern.INSTANCE, SourceLocation.Companion.NoLocation(""));
            }
            this.wrapJsThrownValueIntoJsException(firstCatchBlock);
            if (!areTwoCatchWithTheSameBody) {
                this.initializeCatchParameter(firstCatchBlock);
                this.generateExpression$backend_wasm(firstCatchBlock.getResult());
                this.body.buildBr(topLevelCatchLabel, SourceLocation.Companion.NoLocation(""));
            }
            WasmExpressionBuilder.buildEnd$default(this.body, null, 1, null);
            if (hasOnlySingleCatchBlock && !canUseJsTag) {
                this.body.buildThrow(this.wasmFileCodegenContext.getThrowableTagIndex(), SourceLocation.Companion.NoLocation(""));
                WasmExpressionBuilder.buildEnd$default(this.body, null, 1, null);
                return;
            }
        } else if (tryBlockType == WasmExternRef.INSTANCE) {
            this.wrapJsThrownValueIntoJsException(lastCatchBlock);
        }
        this.initializeCatchParameter(lastCatchBlock);
        this.generateExpression$backend_wasm(lastCatchBlock.getResult());
        WasmExpressionBuilder.buildEnd$default(this.body, null, 1, null);
    }

    private final void initializeCatchParameter(IrCatch $this$initializeCatchParameter) {
        IrVariableSymbol $this$initializeCatchParameter_u24lambda_u2418 = $this$initializeCatchParameter.getCatchParameter().getSymbol();
        boolean bl = false;
        this.functionContext.defineLocal($this$initializeCatchParameter_u24lambda_u2418);
        this.body.buildSetLocal(this.functionContext.referenceLocal($this$initializeCatchParameter_u24lambda_u2418), this.getSourceLocation((IrElement)$this$initializeCatchParameter_u24lambda_u2418.getOwner()));
    }

    private final void wrapJsThrownValueIntoJsException(IrCatch $this$wrapJsThrownValueIntoJsException) {
        this.body.buildCall(this.wasmFileCodegenContext.referenceFunction(this.wasmSymbols.getJsRelatedSymbols().getCreateJsException()), this.getSourceLocation($this$wrapJsThrownValueIntoJsException.getCatchParameter()));
    }

    private final boolean isSimpleRethrowing(IrStatement $this$isSimpleRethrowing, IrCatch catchBlock) {
        Intrinsics.checkNotNull($this$isSimpleRethrowing, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrThrow");
        IrExpression irExpression = ((IrThrow)$this$isSimpleRethrowing).getValue();
        Intrinsics.checkNotNull(irExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrGetValue");
        return Intrinsics.areEqual(((IrGetValue)irExpression).getSymbol(), catchBlock.getCatchParameter().getSymbol());
    }

    private final void generateTryFollowingOldProposal(IrTry aTry) {
        boolean lastCatchParameterIsJsException;
        IrCatch firstCatchBlock;
        boolean canUseJsTag = this.backendContext.getConfiguration().getBoolean(WasmConfigurationKeys.WASM_USE_JS_TAG);
        IrCatch lastCatchBlock = CollectionsKt.last(aTry.getCatches());
        boolean hasOnlySingleCatchBlock = lastCatchBlock == (firstCatchBlock = CollectionsKt.first(aTry.getCatches()));
        WasmType resultType = this.wasmModuleTypeTransformer.transformBlockResultType(aTry.getType());
        Integer topLevelBlockLabel = null;
        boolean areTwoCatchWithTheSameBody = this.backendContext.isWasmJsTarget() && (lastCatchBlock.getOrigin() == FinallyBlocksLoweringKt.getSYNTHETIC_CATCH_FOR_FINALLY_EXPRESSION() || firstCatchBlock.getOrigin() == TryCatchCanonicalizationKt.getSYNTHETIC_JS_EXCEPTION_HANDLER_TO_SUPPORT_CATCH_THROWABLE());
        boolean bl = lastCatchParameterIsJsException = this.backendContext.isWasmJsTarget() && Intrinsics.areEqual(lastCatchBlock.getCatchParameter().getType(), IrTypesKt.getDefaultType(this.wasmSymbols.getJsRelatedSymbols().getJsException()));
        if (areTwoCatchWithTheSameBody) {
            topLevelBlockLabel = this.body.buildBlock(resultType);
        }
        WasmType tryResultType = areTwoCatchWithTheSameBody ? this.wasmModuleTypeTransformer.transformBlockResultType(this.irBuiltIns.getThrowableType()) : resultType;
        this.body.buildTry(null, tryResultType);
        this.generateExpression$backend_wasm(aTry.getTryResult());
        Integer n2 = topLevelBlockLabel;
        if (n2 != null) {
            int it = ((Number)n2).intValue();
            boolean bl2 = false;
            this.body.buildBr(it, SourceLocation.Companion.NoLocation(""));
        }
        WasmSymbol<Integer> tag = !lastCatchParameterIsJsException || !canUseJsTag ? this.wasmFileCodegenContext.getThrowableTagIndex() : this.wasmFileCodegenContext.getJsExceptionTagIndex();
        this.body.buildCatch(tag, SourceLocation.NextLocation.INSTANCE);
        if (tag == this.wasmFileCodegenContext.getJsExceptionTagIndex()) {
            this.wrapJsThrownValueIntoJsException(lastCatchBlock);
        }
        if (lastCatchParameterIsJsException && !canUseJsTag) {
            this.body.buildThrow(this.wasmFileCodegenContext.getThrowableTagIndex(), SourceLocation.Companion.NoLocation(""));
        } else if (!areTwoCatchWithTheSameBody) {
            this.initializeCatchParameter(lastCatchBlock);
            this.generateExpression$backend_wasm(lastCatchBlock.getResult());
        }
        if (!hasOnlySingleCatchBlock || lastCatchParameterIsJsException && !canUseJsTag || areTwoCatchWithTheSameBody) {
            if (canUseJsTag) {
                WasmExpressionBuilder.buildCatch$default(this.body, this.wasmFileCodegenContext.getJsExceptionTagIndex(), null, 2, null);
            } else {
                this.body.buildCatchAll();
                this.body.buildRefNull(WasmHeapType.Simple.Extern.INSTANCE, SourceLocation.Companion.NoLocation(""));
            }
            this.wrapJsThrownValueIntoJsException(firstCatchBlock);
            if (!areTwoCatchWithTheSameBody) {
                this.initializeCatchParameter(firstCatchBlock);
                this.generateExpression$backend_wasm(firstCatchBlock.getResult());
            }
        }
        WasmExpressionBuilder.buildEnd$default(this.body, null, 1, null);
        if (areTwoCatchWithTheSameBody) {
            this.initializeCatchParameter(lastCatchBlock);
            this.generateExpression$backend_wasm(lastCatchBlock.getResult());
            WasmExpressionBuilder.buildEnd$default(this.body, null, 1, null);
        }
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()]) {
            case 1: {
                this.generateExpression$backend_wasm(expression2.getArgument());
                break;
            }
            case 2: {
                this.generateAsStatement(expression2.getArgument());
                this.buildGetUnit(this.body);
                break;
            }
            default: {
                if (!_Assertions.ENABLED) break;
                boolean bl = false;
                String string2 = "Other types of casts must be lowered";
                throw new AssertionError((Object)string2);
            }
        }
    }

    @Override
    public void visitConst(@NotNull IrConst expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        DeclarationGeneratorKt.generateConstExpression(expression2, this.body, this.wasmFileCodegenContext, this.backendContext, this.getSourceLocation(expression2));
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrField field = (IrField)expression2.getSymbol().getOwner();
        IrExpression receiver = expression2.getReceiver();
        SourceLocation location = this.getSourceLocation(expression2);
        if (receiver != null) {
            this.generateExpression$backend_wasm(receiver);
            if (!this.backendContext.getInlineClassesUtils().isClassInlineLike(IrUtilsKt.getParentAsClass(field))) {
                this.generateInstanceFieldAccess(field, location);
            }
        } else {
            this.body.buildGetGlobal(this.wasmFileCodegenContext.referenceGlobalField(field.getSymbol()), location);
            WasmExpressionBuilder this_$iv = this.body;
            boolean $i$f$commentPreviousInstr = false;
            if (!this_$iv.getSkipCommentInstructions()) {
                String string2;
                WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
                int n2 = 0;
                WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
                SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
                WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
                WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
                boolean bl = false;
                String string3 = string2 = "type: " + RenderIrElementKt.render$default(field.getType(), null, 1, null);
                wasmImmediateArray2[n2] = new WasmImmediate.ConstString(string3);
                wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
            }
        }
    }

    private final void generateInstanceFieldAccess(IrField field, SourceLocation location) {
        WasmImmediate[] wasmImmediateArray = field.getType();
        WasmOp opcode = Intrinsics.areEqual(wasmImmediateArray, this.irBuiltIns.getCharType()) ? WasmOp.STRUCT_GET_U : (Intrinsics.areEqual(wasmImmediateArray, this.irBuiltIns.getBooleanType()) || Intrinsics.areEqual(wasmImmediateArray, this.irBuiltIns.getByteType()) || Intrinsics.areEqual(wasmImmediateArray, this.irBuiltIns.getShortType()) ? WasmOp.STRUCT_GET_S : WasmOp.STRUCT_GET);
        wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(this.wasmFileCodegenContext.referenceGcType(IrUtilsKt.getParentAsClass(field).getSymbol())), new WasmImmediate.StructFieldIdx(this.getStructFieldRef(field))};
        this.body.buildInstr(opcode, location, wasmImmediateArray);
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentPreviousInstr = false;
        if (!this_$iv.getSkipCommentInstructions()) {
            String string2;
            WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[1];
            int n2 = 0;
            WasmImmediate[] wasmImmediateArray3 = wasmImmediateArray2;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string3 = string2 = "name: " + field.getName().asString() + ", type: " + RenderIrElementKt.render$default(field.getType(), null, 1, null);
            wasmImmediateArray3[n2] = new WasmImmediate.ConstString(string3);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray2);
        }
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrField field = (IrField)expression2.getSymbol().getOwner();
        IrExpression receiver = expression2.getReceiver();
        SourceLocation location = this.getSourceLocation(expression2);
        if (receiver != null) {
            this.generateExpression$backend_wasm(receiver);
            this.generateExpression$backend_wasm(expression2.getValue());
            this.body.buildStructSet(this.wasmFileCodegenContext.referenceGcType(IrUtilsKt.getParentAsClass(field).getSymbol()), this.getStructFieldRef(field), location);
            WasmExpressionBuilder this_$iv = this.body;
            boolean $i$f$commentPreviousInstr = false;
            if (!this_$iv.getSkipCommentInstructions()) {
                String string2;
                WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
                int n2 = 0;
                WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
                SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
                WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
                WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
                boolean bl = false;
                String string3 = string2 = "name: " + field.getName() + ", type: " + RenderIrElementKt.render$default(field.getType(), null, 1, null);
                wasmImmediateArray2[n2] = new WasmImmediate.ConstString(string3);
                wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
            }
        } else {
            this.generateExpression$backend_wasm(expression2.getValue());
            this.body.buildSetGlobal(this.wasmFileCodegenContext.referenceGlobalField(expression2.getSymbol()), location);
            WasmExpressionBuilder this_$iv = this.body;
            boolean $i$f$commentPreviousInstr = false;
            if (!this_$iv.getSkipCommentInstructions()) {
                String string4;
                WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
                int n3 = 0;
                WasmImmediate[] wasmImmediateArray3 = wasmImmediateArray;
                SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
                WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
                WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
                boolean bl = false;
                String string5 = string4 = "type: " + RenderIrElementKt.render$default(field.getType(), null, 1, null);
                wasmImmediateArray3[n3] = new WasmImmediate.ConstString(string5);
                wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
            }
        }
        this.buildGetUnit(this.body);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrValueSymbol valueSymbol = expression2.getSymbol();
        IrValueDeclaration valueDeclaration = valueSymbol.getOwner();
        this.body.buildGetLocal(MiscKt.isDispatchReceiver(valueDeclaration) ? this.functionContext.referenceLocal(0) : this.functionContext.referenceLocal(valueSymbol), this.getSourceLocation(expression2));
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentPreviousInstr = false;
        if (!this_$iv.getSkipCommentInstructions()) {
            String string2;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
            int n2 = 0;
            WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string3 = string2 = "type: " + RenderIrElementKt.render$default(valueDeclaration.getType(), null, 1, null);
            wasmImmediateArray2[n2] = new WasmImmediate.ConstString(string3);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
        }
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.generateExpression$backend_wasm(expression2.getValue());
        this.body.buildSetLocal(this.functionContext.referenceLocal(expression2.getSymbol()), this.getSourceLocation(expression2));
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentPreviousInstr = false;
        if (!this_$iv.getSkipCommentInstructions()) {
            String string2;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
            int n2 = 0;
            WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string3 = string2 = "type: " + RenderIrElementKt.render$default(expression2.getSymbol().getOwner().getType(), null, 1, null);
            wasmImmediateArray2[n2] = new WasmImmediate.ConstString(string3);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
        }
        this.buildGetUnit(this.body);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.generateCall(expression2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrClass klass = IrUtilsKt.getParentAsClass((IrDeclaration)expression2.getSymbol().getOwner());
        IrClassSymbol klassSymbol = klass.getSymbol();
        if (!(!this.backendContext.getInlineClassesUtils().isClassInlineLike(klass))) {
            boolean $i$a$-require-BodyGenerator$visitConstructorCall$32 = false;
            String $i$a$-require-BodyGenerator$visitConstructorCall$32 = "All inline class constructor calls must be lowered to static function calls";
            throw new IllegalArgumentException($i$a$-require-BodyGenerator$visitConstructorCall$32.toString());
        }
        WasmSymbol<WasmTypeDeclaration> wasmGcType = this.wasmFileCodegenContext.referenceGcType(klassSymbol);
        SourceLocation location = this.getSourceLocation(expression2);
        if (AnnotationsKt.getWasmArrayAnnotation(klass) != null) {
            if (!(expression2.getArguments().size() == 1)) {
                boolean $i$a$-require-BodyGenerator$visitConstructorCall$42 = false;
                String $i$a$-require-BodyGenerator$visitConstructorCall$42 = "@WasmArrayOf constructs must have exactly one argument";
                throw new IllegalArgumentException($i$a$-require-BodyGenerator$visitConstructorCall$42.toString());
            }
            Object e2 = expression2.getArguments().get(0);
            Intrinsics.checkNotNull(e2);
            this.generateExpression$backend_wasm((IrExpression)e2);
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(wasmGcType)};
            this.body.buildInstr(WasmOp.ARRAY_NEW_DEFAULT, location, wasmImmediateArray);
            WasmExpressionBuilder this_$iv = this.body;
            boolean $i$f$commentPreviousInstr = false;
            if (!this_$iv.getSkipCommentInstructions()) {
                String string2;
                WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[1];
                int n2 = 0;
                WasmImmediate[] wasmImmediateArray3 = wasmImmediateArray2;
                SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
                WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
                WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
                boolean bl = false;
                String string3 = string2 = "@WasmArrayOf ctor call: " + IrUtilsKt.getFqNameWhenAvailable(klass);
                wasmImmediateArray3[n2] = new WasmImmediate.ConstString(string3);
                wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray2);
            }
            return;
        }
        if (AnnotationsKt.hasWasmPrimitiveConstructorAnnotation((IrAnnotationContainer)expression2.getSymbol().getOwner())) {
            this.generateAnyParameters(klassSymbol, location);
            Iterable $this$forEach$iv = expression2.getArguments();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrExpression it = (IrExpression)element$iv;
                boolean bl = false;
                IrExpression irExpression = it;
                Intrinsics.checkNotNull(irExpression);
                this.generateExpression$backend_wasm(irExpression);
            }
            this.body.buildStructNew(wasmGcType, location);
            WasmExpressionBuilder this_$iv = this.body;
            boolean $i$f$commentPreviousInstr = false;
            if (!this_$iv.getSkipCommentInstructions()) {
                String string4;
                WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
                int n3 = 0;
                WasmImmediate[] wasmImmediateArray4 = wasmImmediateArray;
                SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
                WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
                WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
                boolean bl = false;
                String string5 = string4 = "@WasmPrimitiveConstructor ctor call: " + IrUtilsKt.getFqNameWhenAvailable(klass);
                wasmImmediateArray4[n3] = new WasmImmediate.ConstString(string5);
                wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
            }
            return;
        }
        this.body.buildRefNull(WasmHeapType.Simple.None.INSTANCE, location);
        this.generateCall(expression2);
    }

    private final void generateAnyParameters(IrClassSymbol klassSymbol, SourceLocation location) {
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentGroupStart = false;
        if (!this_$iv.getSkipCommentInstructions()) {
            String string2;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
            int n2 = 0;
            WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_GROUP_START;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string3 = string2 = "Any parameters";
            wasmImmediateArray2[n2] = new WasmImmediate.ConstString(string3);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
        }
        this.body.buildGetGlobal(this.wasmFileCodegenContext.referenceGlobalVTable(klassSymbol), location);
        if (ClassInfoKt.hasInterfaceSuperClass((IrClass)klassSymbol.getOwner())) {
            this.body.buildGetGlobal(this.wasmFileCodegenContext.referenceGlobalClassITable(klassSymbol), location);
        } else {
            this.body.buildRefNull(WasmHeapType.Simple.Struct.INSTANCE, location);
        }
        this.body.buildConstI32Symbol(this.wasmFileCodegenContext.referenceTypeId(klassSymbol), location);
        this.body.buildConstI32(0, location);
        this.body.commentGroupEnd();
    }

    /*
     * WARNING - void declaration
     */
    public final void generateObjectCreationPrefixIfNeeded(@NotNull IrConstructor constructor) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        IrClass parentClass = IrUtilsKt.getParentAsClass(constructor);
        if (Intrinsics.areEqual(constructor.getOrigin(), PrimaryConstructorLowering.Companion.getSYNTHETIC_PRIMARY_CONSTRUCTOR())) {
            return;
        }
        if (UtilsKt.isAbstractOrSealed(parentClass)) {
            return;
        }
        IrValueParameter irValueParameter = parentClass.getThisReceiver();
        Intrinsics.checkNotNull(irValueParameter);
        WasmLocal thisParameter = this.functionContext.referenceLocal(irValueParameter.getSymbol());
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentGroupStart = false;
        if (!this_$iv.getSkipCommentInstructions()) {
            String string2;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
            int n2 = 0;
            WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_GROUP_START;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string3 = string2 = "Object creation prefix";
            wasmImmediateArray2[n2] = new WasmImmediate.ConstString(string3);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
        }
        SourceLocation location = SourceLocation.Companion.NoLocation("Constructor preamble");
        boolean bl = false;
        this.body.buildGetLocal(thisParameter, location);
        this.body.buildInstr(WasmOp.REF_IS_NULL, location, new WasmImmediate[0]);
        WasmExpressionBuilder.buildIf$default(this.body, "this_init", null, 2, null);
        this.generateAnyParameters(parentClass.getSymbol(), location);
        List<IrField> irFields = ClassInfoKt.allFields(parentClass, this.backendContext.getIrBuiltIns());
        Iterable $this$forEachIndexed$iv = irFields;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void field;
            int n3;
            if ((n3 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrField irField = (IrField)item$iv;
            int index = n3;
            boolean bl2 = false;
            if (index <= 1) continue;
            DeclarationGeneratorKt.generateDefaultInitializerForType(this.wasmModuleTypeTransformer.transformType(field.getType()), this.body);
        }
        this.body.buildStructNew(this.wasmFileCodegenContext.referenceGcType(parentClass.getSymbol()), location);
        this.body.buildSetLocal(thisParameter, location);
        WasmExpressionBuilder.buildEnd$default(this.body, null, 1, null);
        this.body.commentGroupEnd();
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrFunction irFunction = this.functionContext.getIrFunction();
        Intrinsics.checkNotNull(irFunction);
        IrClass klass = IrUtilsKt.getParentAsClass(irFunction);
        if (IrTypePredicatesKt.isAny(IrUtilsKt.getDefaultType(klass))) {
            this.buildGetUnit(this.body);
            return;
        }
        this.body.buildGetLocal(this.functionContext.referenceLocal(0), SourceLocation.Companion.NoLocation("Get implicit dispatch receiver"));
        this.generateCall(expression2);
    }

    private final void generateBox(IrExpression expression2, IrType type2) {
        IrClassSymbol klassSymbol = TypeTransformerKt.getRuntimeClass(type2, this.irBuiltIns).getSymbol();
        SourceLocation location = this.getSourceLocation(expression2);
        this.generateAnyParameters(klassSymbol, location);
        this.generateExpression$backend_wasm(expression2);
        this.body.buildStructNew(this.wasmFileCodegenContext.referenceGcType(klassSymbol), location);
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentPreviousInstr = false;
        if (!this_$iv.getSkipCommentInstructions()) {
            String string2;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
            int n2 = 0;
            WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string3 = string2 = "box";
            wasmImmediateArray2[n2] = new WasmImmediate.ConstString(string3);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateCall(IrFunctionAccessExpression call2) {
        boolean isSuperCall;
        SourceLocation location;
        SourceLocation sourceLocation = location = call2.getOrigin() == IrStatementOrigin.Companion.getDEFAULT_DISPATCH_CALL() ? SourceLocation.Companion.NoLocation("Default dispatch") : this.getSourceLocation(call2);
        if (Intrinsics.areEqual(call2.getSymbol(), this.getUnitGetInstance().getSymbol())) {
            this.buildGetUnit(this.body);
            return;
        }
        if (Intrinsics.areEqual(call2.getSymbol(), this.wasmSymbols.getBoxBoolean())) {
            Object e2 = call2.getArguments().get(0);
            Intrinsics.checkNotNull(e2);
            this.generateBox((IrExpression)e2, this.irBuiltIns.getBooleanType());
            return;
        }
        if (Intrinsics.areEqual(call2.getSymbol(), this.wasmSymbols.getBoxIntrinsic())) {
            IrType irType = call2.getTypeArguments().get(0);
            Intrinsics.checkNotNull(irType);
            IrType type2 = irType;
            if (Intrinsics.areEqual(type2, this.irBuiltIns.getBooleanType())) {
                Object e3 = call2.getArguments().get(0);
                Intrinsics.checkNotNull(e3);
                this.generateExpression$backend_wasm((IrExpression)e3);
                this.body.buildCall(this.wasmFileCodegenContext.referenceFunction(this.backendContext.getWasmSymbols().getGetBoxedBoolean()), location);
            } else {
                Object e4 = call2.getArguments().get(0);
                Intrinsics.checkNotNull(e4);
                this.generateBox((IrExpression)e4, type2);
            }
            return;
        }
        if (!Intrinsics.areEqual(this.backendContext.getConfiguration().get(WasmConfigurationKeys.WASM_ENABLE_ARRAY_RANGE_CHECKS), true) && Intrinsics.areEqual(call2.getSymbol(), this.wasmSymbols.getRangeCheck())) {
            this.buildGetUnit(this.body);
            return;
        }
        if (!Intrinsics.areEqual(this.backendContext.getConfiguration().get(WasmConfigurationKeys.WASM_ENABLE_ASSERTS), true) && CollectionsKt.contains(this.wasmSymbols.getAsserts(), call2.getSymbol())) {
            this.buildGetUnit(this.body);
            return;
        }
        IrFunction function2 = IrResolveUtilsKt.getRealOverrideTarget(((IrFunctionSymbol)call2.getSymbol()).getOwner());
        Iterable $this$forEach$iv = call2.getArguments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrExpression it = (IrExpression)element$iv;
            boolean bl = false;
            IrExpression irExpression = it;
            Intrinsics.checkNotNull(irExpression);
            this.generateExpression$backend_wasm(irExpression);
        }
        if (this.tryToGenerateIntrinsicCall(call2, function2)) {
            if (IrTypePredicatesKt.isUnit(function2.getReturnType())) {
                this.buildGetUnit(this.body);
            }
            return;
        }
        if (AnnotationsKt.hasWasmPrimitiveConstructorAnnotation(function2.getSymbol().getOwner())) {
            return;
        }
        boolean bl = isSuperCall = call2 instanceof IrCall && ((IrCall)call2).getSuperQualifierSymbol() != null;
        if (function2 instanceof IrSimpleFunction && IrUtilsKt.isOverridable((IrSimpleFunction)function2) && !isSuperCall) {
            IrClass klass = IrUtilsKt.getParentAsClass(function2);
            if (!IrUtilsKt.isInterface(klass)) {
                int n2;
                WasmImmediate[] wasmImmediateArray;
                block22: {
                    ClassMetadata classMetadata = this.wasmModuleMetadataCache.getClassMetadata(klass.getSymbol());
                    List<VirtualMethodMetadata> $this$indexOfFirst$iv = classMetadata.getVirtualMethods();
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    wasmImmediateArray = $this$indexOfFirst$iv.iterator();
                    while (wasmImmediateArray.hasNext()) {
                        VirtualMethodMetadata item$iv;
                        VirtualMethodMetadata it = item$iv = wasmImmediateArray.next();
                        boolean bl2 = false;
                        if (Intrinsics.areEqual(it.getFunction(), function2)) {
                            n2 = index$iv;
                            break block22;
                        }
                        ++index$iv;
                    }
                    n2 = -1;
                }
                int vfSlot = n2;
                IrExpression irExpression = call2.getDispatchReceiver();
                Intrinsics.checkNotNull(irExpression);
                IrExpression receiver = irExpression;
                this.generateExpression$backend_wasm(receiver);
                WasmImmediate[] this_$iv2 = this.body;
                boolean $i$f$commentGroupStart = false;
                if (!this_$iv2.getSkipCommentInstructions()) {
                    String string2;
                    wasmImmediateArray = new WasmImmediate[1];
                    int n3 = 0;
                    WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
                    SourceLocation sourceLocation2 = SourceLocation.Companion.NoLocation("Pseudo-instruction");
                    WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_GROUP_START;
                    WasmImmediate[] wasmImmediateArray3 = this_$iv2;
                    boolean bl3 = false;
                    String string3 = string2 = "virtual call: " + IrUtilsKt.getFqNameWhenAvailable(function2);
                    wasmImmediateArray2[n3] = new WasmImmediate.ConstString(string3);
                    wasmImmediateArray3.buildInstr(wasmOp, sourceLocation2, wasmImmediateArray);
                }
                this.generateRefCast(receiver.getType(), IrUtilsKt.getDefaultType(klass), false, location);
                this.body.buildStructGet(this.wasmFileCodegenContext.referenceGcType(klass.getSymbol()), new WasmSymbol<Integer>(0), location);
                this.body.buildStructGet(this.wasmFileCodegenContext.referenceVTableGcType(klass.getSymbol()), new WasmSymbol<Integer>(vfSlot), location);
                this_$iv2 = new WasmImmediate[]{new WasmImmediate.TypeIdx((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.wasmFileCodegenContext.referenceFunctionType(((IrSimpleFunction)function2).getSymbol()))};
                this.body.buildInstr(WasmOp.CALL_REF, location, this_$iv2);
                this.body.commentGroupEnd();
            } else {
                int n4;
                IrClassSymbol symbol;
                block23: {
                    void $this$indexOfFirst$iv;
                    symbol = klass.getSymbol();
                    WasmImmediate[] vfSlot = new WasmImmediate[]{new WasmImmediate.SymbolI32(this.wasmFileCodegenContext.referenceClassITableInterfaceHasImplementors(symbol))};
                    this.body.buildInstr(WasmOp.MACRO_IF, location, vfSlot);
                    IrExpression irExpression = call2.getDispatchReceiver();
                    Intrinsics.checkNotNull(irExpression);
                    this.generateExpression$backend_wasm(irExpression);
                    WasmExpressionBuilder this_$iv = this.body;
                    boolean $i$f$commentGroupStart = false;
                    if (!this_$iv.getSkipCommentInstructions()) {
                        String string4;
                        WasmImmediate[] this_$iv2 = new WasmImmediate[1];
                        int n5 = 0;
                        WasmImmediate[] wasmImmediateArray = this_$iv2;
                        SourceLocation sourceLocation3 = SourceLocation.Companion.NoLocation("Pseudo-instruction");
                        WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_GROUP_START;
                        WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
                        boolean bl4 = false;
                        String string5 = string4 = "interface call: " + IrUtilsKt.getFqNameWhenAvailable(function2);
                        wasmImmediateArray[n5] = new WasmImmediate.ConstString(string5);
                        wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation3, this_$iv2);
                    }
                    this.body.buildStructGet(this.wasmFileCodegenContext.referenceGcType(this.irBuiltIns.getAnyClass()), new WasmSymbol<Integer>(1), location);
                    WasmSymbol<WasmTypeDeclaration> classITableReference = this.wasmFileCodegenContext.referenceClassITableGcType(symbol);
                    this.body.buildRefCastStatic((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)classITableReference, location);
                    this.body.buildStructGet(classITableReference, this.wasmFileCodegenContext.referenceClassITableInterfaceSlot(symbol), location);
                    List<VirtualMethodMetadata> this_$iv2 = this.wasmModuleMetadataCache.getInterfaceMetadata(symbol).getMethods();
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$indexOfFirst$iv) {
                        VirtualMethodMetadata it = (VirtualMethodMetadata)item$iv;
                        boolean bl5 = false;
                        if (Intrinsics.areEqual(it.getFunction(), function2)) {
                            n4 = index$iv;
                            break block23;
                        }
                        ++index$iv;
                    }
                    n4 = -1;
                }
                int vfSlot = n4;
                this.body.buildStructGet(this.wasmFileCodegenContext.referenceVTableGcType(symbol), new WasmSymbol<Integer>(vfSlot), location);
                WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.TypeIdx((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.wasmFileCodegenContext.referenceFunctionType(((IrSimpleFunction)function2).getSymbol()))};
                this.body.buildInstr(WasmOp.CALL_REF, location, wasmImmediateArray);
                this.body.commentGroupEnd();
                this.body.buildInstr(WasmOp.MACRO_ELSE, location, new WasmImmediate[0]);
                LocationUtilsKt.buildUnreachableForVerifier(this.body);
                this.body.buildInstr(WasmOp.MACRO_END_IF, location, new WasmImmediate[0]);
            }
        } else {
            this.body.buildCall(this.wasmFileCodegenContext.referenceFunction(function2.getSymbol()), location);
        }
        if (IrTypePredicatesKt.isUnit(function2.getReturnType()) && !(function2 instanceof IrConstructor) && !Intrinsics.areEqual(function2, this.getUnitGetInstance())) {
            this.buildGetUnit(this.body);
        }
    }

    private final void generateRefCast(IrType fromType, IrType toType, boolean isRefNullCast, SourceLocation location) {
        if (!this.isDownCastAlwaysSuccessInRuntime(fromType, toType)) {
            if (this.isInvalidDownCast(fromType, toType)) {
                this.body.buildUnreachable(location);
            } else {
                WasmSymbol<WasmTypeDeclaration> wasmToType = this.wasmFileCodegenContext.referenceGcType(TypeTransformerKt.getRuntimeClass(toType, this.irBuiltIns).getSymbol());
                if (isRefNullCast) {
                    this.body.buildRefCastNullStatic((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)wasmToType, location);
                } else {
                    this.body.buildRefCastStatic((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)wasmToType, location);
                }
            }
        }
    }

    private final void generateRefTest(IrType fromType, IrType toType, SourceLocation location) {
        if (this.isDownCastAlwaysSuccessInRuntime(fromType, toType)) {
            this.body.buildDrop(location);
            this.body.buildConstI32(1, location);
        } else if (this.isInvalidDownCast(fromType, toType)) {
            this.body.buildUnreachable(location);
        } else {
            this.body.buildRefTestStatic((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.wasmFileCodegenContext.referenceGcType(TypeTransformerKt.getRuntimeClass(toType, this.irBuiltIns).getSymbol()), location);
        }
    }

    private final boolean isInvalidDownCast(IrType fromType, IrType toType) {
        if (IrTypePredicatesKt.isAny(toType)) {
            return false;
        }
        Object object = IrTypesKt.getClassOrNull(fromType);
        if (object == null || (object = (IrClass)object.getOwner()) == null) {
            return false;
        }
        boolean fromTypeIsExternal = object.isExternal();
        Object object2 = IrTypesKt.getClassOrNull(toType);
        if (object2 == null || (object2 = (IrClass)object2.getOwner()) == null) {
            return false;
        }
        boolean toTypeIsExternal = object2.isExternal();
        return fromTypeIsExternal != toTypeIsExternal;
    }

    private final boolean isDownCastAlwaysSuccessInRuntime(IrType fromType, IrType toType) {
        IrClass upperBound = IrTypeErasureUtilsKt.getErasedUpperBound(fromType);
        if (IrTypeUtilsKt.isSubtypeOfClass(upperBound.getSymbol(), this.backendContext.getWasmSymbols().getWasmAnyRefClass())) {
            return false;
        }
        return IrUtilsKt.isSubclassOf(TypeTransformerKt.getRuntimeClass(fromType, this.irBuiltIns), TypeTransformerKt.getRuntimeClass(toType, this.irBuiltIns));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryToGenerateIntrinsicCall(IrFunctionAccessExpression call2, IrFunction function2) {
        if (this.tryToGenerateWasmOpIntrinsicCall(call2, function2)) {
            return true;
        }
        SourceLocation location = this.getSourceLocation(call2);
        IrFunctionSymbol irFunctionSymbol = function2.getSymbol();
        if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getWasmTypeId())) {
            IrType irType = call2.getTypeArguments().get(0);
            Intrinsics.checkNotNull(irType);
            IrClass irClass = IrTypesKt.getClass(irType);
            if (irClass == null) {
                throw new IllegalStateException("No class given for wasmTypeId intrinsic".toString());
            }
            IrClass klass = irClass;
            this.body.buildConstI32Symbol(this.wasmFileCodegenContext.referenceTypeId(klass.getSymbol()), location);
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getWasmIsInterface())) {
            void this_$iv;
            void this_$iv2;
            IrType irType = call2.getTypeArguments().get(0);
            Intrinsics.checkNotNull(irType);
            IrClass irClass = IrTypesKt.getClass(irType);
            if (irClass == null) {
                throw new IllegalStateException("No interface given for wasmIsInterface intrinsic".toString());
            }
            IrClass irInterface = irClass;
            boolean bl = IrUtilsKt.isInterface(irInterface);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.SymbolI32(this.wasmFileCodegenContext.referenceClassITableInterfaceHasImplementors(irInterface.getSymbol()))};
            this.body.buildInstr(WasmOp.MACRO_IF, location, wasmImmediateArray);
            WasmSymbol<WasmTypeDeclaration> classITable = this.wasmFileCodegenContext.referenceClassITableGcType(irInterface.getSymbol());
            WasmLocal parameterLocal = this.functionContext.referenceLocal(SyntheticLocalType.IS_INTERFACE_PARAMETER);
            this.body.buildSetLocal(parameterLocal, location);
            WasmExpressionBuilder wasmExpressionBuilder = this.body;
            String string3 = "isInterface";
            WasmType resultType$iv = WasmI32.INSTANCE;
            boolean $i$f$buildBlock = false;
            WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv)};
            this_$iv2.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray2);
            int outerLabel = this_$iv2.getNumberOfNestedBlocks();
            boolean bl2 = false;
            WasmExpressionBuilder wasmExpressionBuilder2 = this.body;
            String string4 = "isInterface";
            WasmType resultType$iv2 = new WasmRefNullType(WasmHeapType.Simple.Struct.INSTANCE);
            boolean $i$f$buildBlock2 = false;
            WasmImmediate[] wasmImmediateArray3 = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv2)};
            this_$iv.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray3);
            int innerLabel = this_$iv.getNumberOfNestedBlocks();
            boolean bl3 = false;
            this.body.buildGetLocal(parameterLocal, location);
            this.body.buildStructGet(this.wasmFileCodegenContext.referenceGcType(this.irBuiltIns.getAnyClass()), new WasmSymbol<Integer>(1), location);
            this.body.buildBrOnCastInstr(WasmOp.BR_ON_CAST_FAIL, innerLabel, true, false, WasmHeapType.Simple.Struct.INSTANCE, new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)classITable), location);
            this.body.buildStructGet(classITable, this.wasmFileCodegenContext.referenceClassITableInterfaceSlot(irInterface.getSymbol()), location);
            this.body.buildInstr(WasmOp.REF_IS_NULL, location, new WasmImmediate[0]);
            this.body.buildInstr(WasmOp.I32_EQZ, location, new WasmImmediate[0]);
            this.body.buildBr(outerLabel, location);
            WasmExpressionBuilder.buildEnd$default((WasmExpressionBuilder)this_$iv, null, 1, null);
            this.body.buildDrop(location);
            this.body.buildConstI32(0, location);
            WasmExpressionBuilder.buildEnd$default((WasmExpressionBuilder)this_$iv2, null, 1, null);
            this.body.buildInstr(WasmOp.MACRO_ELSE, location, new WasmImmediate[0]);
            this.body.buildDrop(location);
            this.body.buildConstI32(0, location);
            this.body.buildInstr(WasmOp.MACRO_END_IF, location, new WasmImmediate[0]);
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getRefCastNull())) {
            Object e2 = call2.getArguments().get(0);
            Intrinsics.checkNotNull(e2);
            IrType irType = ((IrExpression)e2).getType();
            IrType irType2 = call2.getTypeArguments().get(0);
            Intrinsics.checkNotNull(irType2);
            this.generateRefCast(irType, irType2, true, location);
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getRefTest())) {
            Object e3 = call2.getArguments().get(0);
            Intrinsics.checkNotNull(e3);
            IrType irType = ((IrExpression)e3).getType();
            IrType irType3 = call2.getTypeArguments().get(0);
            Intrinsics.checkNotNull(irType3);
            this.generateRefTest(irType, irType3, location);
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getUnboxIntrinsic())) {
            IrType irType = call2.getTypeArguments().get(0);
            Intrinsics.checkNotNull(irType);
            IrType fromType = irType;
            if (IrTypePredicatesKt.isNothing(fromType)) {
                LocationUtilsKt.buildUnreachableAfterNothingType(this.body);
                return true;
            }
            IrType irType4 = call2.getTypeArguments().get(1);
            Intrinsics.checkNotNull(irType4);
            IrType toType = irType4;
            IrClass irClass = this.backendContext.getInlineClassesUtils().getInlinedClass(toType);
            Intrinsics.checkNotNull(irClass);
            IrClass klass = irClass;
            IrField field = InlineClassesKt.getInlineClassBackingField(klass);
            this.generateRefCast(fromType, toType, false, location);
            this.generateInstanceFieldAccess(field, location);
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getUnsafeGetScratchRawMemory())) {
            this.body.buildConstI32Symbol(this.wasmFileCodegenContext.getScratchMemAddr(), location);
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getReturnArgumentIfItIsKotlinAny())) {
            void this_$iv;
            WasmExpressionBuilder fromType = this.body;
            String toType = "returnIfAny";
            WasmType resultType$iv = WasmAnyRef.INSTANCE;
            boolean $i$f$buildBlock = false;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv)};
            this_$iv.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray);
            int innerLabel = this_$iv.getNumberOfNestedBlocks();
            boolean bl = false;
            this.body.buildGetLocal(this.functionContext.referenceLocal(0), location);
            this.body.buildInstr(WasmOp.EXTERN_INTERNALIZE, location, new WasmImmediate[0]);
            this.body.buildBrOnCastInstr(WasmOp.BR_ON_CAST_FAIL, innerLabel, true, true, WasmHeapType.Simple.Any.INSTANCE, new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.wasmFileCodegenContext.referenceGcType(this.backendContext.getIrBuiltIns().getAnyClass())), location);
            this.body.buildInstr(WasmOp.RETURN, location, new WasmImmediate[0]);
            WasmExpressionBuilder.buildEnd$default((WasmExpressionBuilder)this_$iv, null, 1, null);
            this.body.buildDrop(location);
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getWasmArrayCopy())) {
            IrType irType = call2.getTypeArguments().get(0);
            Intrinsics.checkNotNull(irType);
            WasmImmediate.GcType immediate = new WasmImmediate.GcType(this.wasmFileCodegenContext.referenceGcType(TypeTransformerKt.getRuntimeClass(irType, this.irBuiltIns).getSymbol()));
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{immediate, immediate};
            this.body.buildInstr(WasmOp.ARRAY_COPY, location, wasmImmediateArray);
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getStringGetPoolSize())) {
            this.body.buildConstI32Symbol(this.wasmFileCodegenContext.getStringPoolSize(), location);
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getWasmArrayNewData0())) {
            IrType irType = call2.getTypeArguments().get(0);
            Intrinsics.checkNotNull(irType);
            WasmImmediate.GcType arrayGcType = new WasmImmediate.GcType(this.wasmFileCodegenContext.referenceGcType(TypeTransformerKt.getRuntimeClass(irType, this.irBuiltIns).getSymbol()));
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{arrayGcType, new WasmImmediate.DataIdx(0)};
            this.body.buildInstr(WasmOp.ARRAY_NEW_DATA, location, wasmImmediateArray);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        Iterable $this$forEach$iv = body2.getStatements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrStatement p0 = (IrStatement)element$iv;
            boolean bl = false;
            this.generateStatement(p0);
        }
        this.body.buildNop(this.getSourceEndLocation(body2));
    }

    @Override
    public void visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock) {
        Object object;
        Intrinsics.checkNotNullParameter(inlinedBlock, "inlinedBlock");
        IrFunctionSymbol irFunctionSymbol = inlinedBlock.getInlinedFunctionSymbol();
        IrFunction inlineFunction = irFunctionSymbol != null ? irFunctionSymbol.getOwner() : null;
        IrSimpleFunction irSimpleFunction = inlineFunction instanceof IrSimpleFunction ? (IrSimpleFunction)inlineFunction : null;
        IrPropertySymbol correspondingProperty = irSimpleFunction != null ? irSimpleFunction.getCorrespondingPropertySymbol() : null;
        Object object2 = correspondingProperty;
        IrElement owner = object2 != null && (object2 = (IrProperty)object2.getOwner()) != null ? (IrElement)object2 : (IrElement)inlineFunction;
        Object object3 = owner;
        if ((object3 == null || (object3 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object3)) == null || (object3 = ((FqName)object3).asString()) == null) && ((object = owner) != null && (object = ((IrDeclarationWithName)object).getName()) != null ? ((Name)object).asString() : (object3 = null)) == null) {
            object3 = "UNKNOWN";
        }
        Object name2 = object3;
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentGroupStart = false;
        if (!this_$iv.getSkipCommentInstructions()) {
            String string2;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
            int n2 = 0;
            WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_GROUP_START;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string3 = string2 = "Inlined call of `" + (String)name2 + '`';
            wasmImmediateArray2[n2] = new WasmImmediate.ConstString(string3);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
        }
        this.body.buildNop(this.getSourceLocation(inlinedBlock));
        this.functionContext.stepIntoInlinedFunction(inlinedBlock.getInlinedFunctionSymbol(), inlinedBlock.getInlinedFunctionFileEntry());
        super.visitInlinedFunctionBlock(inlinedBlock);
        this.functionContext.stepOutLastInlinedFunction();
    }

    @Override
    public void visitReturnableBlock(@NotNull IrReturnableBlock expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.functionContext.defineNonLocalReturnLevel(expression2.getSymbol(), this.body.buildBlock(this.wasmModuleTypeTransformer.transformBlockResultType(expression2.getType())));
        super.visitReturnableBlock(expression2);
    }

    /*
     * WARNING - void declaration
     */
    private final void processContainerExpression(IrContainerExpression expression2) {
        List<IrStatement> statements = expression2.getStatements();
        Iterable $this$forEachIndexed$iv = statements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void statement;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrStatement irStatement = (IrStatement)item$iv;
            int i2 = n2;
            boolean bl = false;
            if (i2 != CollectionsKt.getLastIndex(statements)) {
                this.generateStatement((IrStatement)statement);
                continue;
            }
            if (statement instanceof IrExpression) {
                this.generateWithExpectedType$backend_wasm((IrExpression)statement, expression2.getType());
                continue;
            }
            this.generateStatement((IrStatement)statement);
            if (Intrinsics.areEqual(expression2.getType(), this.wasmSymbols.getVoidType())) continue;
            this.buildGetUnit(this.body);
        }
        if (expression2 instanceof IrReturnableBlock) {
            WasmExpressionBuilder.buildEnd$default(this.body, null, 1, null);
            this.body.commentGroupEnd();
        }
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (expression2.getStatements().isEmpty()) {
            if (Intrinsics.areEqual(expression2.getType(), this.irBuiltIns.getUnitType())) {
                this.buildGetUnit(this.body);
            }
            return;
        }
        this.processContainerExpression(expression2);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump) {
        Intrinsics.checkNotNullParameter(jump, "jump");
        boolean bl = Intrinsics.areEqual(jump.getType(), this.irBuiltIns.getNothingType());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.body.buildBr(this.functionContext.referenceLoopLevel(jump.getLoop(), LoopLabelType.BREAK), this.getSourceLocation(jump));
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump) {
        Intrinsics.checkNotNullParameter(jump, "jump");
        boolean bl = Intrinsics.areEqual(jump.getType(), this.irBuiltIns.getNothingType());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.body.buildBr(this.functionContext.referenceLoopLevel(jump.getLoop(), LoopLabelType.CONTINUE), this.getSourceLocation(jump));
    }

    private final void visitFunctionReturn(IrReturn expression2) {
        IrType returnType = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.returnType(expression2.getReturnTargetSymbol().getOwner(), this.backendContext);
        boolean isGetUnitFunction = Intrinsics.areEqual(expression2.getReturnTargetSymbol().getOwner(), this.getUnitGetInstance());
        if (isGetUnitFunction) {
            this.generateExpression$backend_wasm(expression2.getValue());
        } else if (Intrinsics.areEqual(returnType, this.irBuiltIns.getUnitType())) {
            this.generateAsStatement(expression2.getValue());
        } else {
            this.generateWithExpectedType$backend_wasm(expression2.getValue(), returnType);
        }
        if (this.functionContext.getIrFunction() instanceof IrConstructor) {
            this.body.buildGetLocal(this.functionContext.referenceLocal(0), SourceLocation.Companion.NoLocation("Get implicit dispatch receiver"));
        }
        this.body.buildInstr(WasmOp.RETURN, this.getSourceLocation(expression2), new WasmImmediate[0]);
    }

    public final void generateWithExpectedType$backend_wasm(@NotNull IrExpression expression2, @NotNull IrType expectedType) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        IrType actualType = expression2.getType();
        if (Intrinsics.areEqual(expectedType, this.wasmSymbols.getVoidType())) {
            this.generateAsStatement(expression2);
            return;
        }
        if (IrTypePredicatesKt.isUnit(expectedType) && !IrTypePredicatesKt.isUnit(actualType)) {
            this.generateAsStatement(expression2);
            this.buildGetUnit(this.body);
            return;
        }
        this.generateExpression$backend_wasm(expression2);
        this.recoverToExpectedType(actualType, expectedType, this.getSourceLocation(expression2));
    }

    private final void recoverToExpectedType(IrType actualType, IrType expectedType, SourceLocation location) {
        boolean actualIsPrimitive;
        IrSimpleType actualTypeErased;
        if (IrTypePredicatesKt.isNothing(expectedType)) {
            LocationUtilsKt.buildUnreachableAfterNothingType(this.body);
            return;
        }
        if (IrTypePredicatesKt.isNothing(actualType)) {
            return;
        }
        if (IrTypePredicatesKt.isNullableNothing(actualType) && IrTypeUtilsKt.isNullable(expectedType)) {
            IrClass irClass = IrTypesKt.getClass(expectedType);
            boolean bl = irClass != null ? irClass.isExternal() : false;
            if (bl) {
                this.body.buildDrop(location);
                this.body.buildRefNull(WasmHeapType.Simple.NoExtern.INSTANCE, location);
            }
            return;
        }
        if (IrTypeUtilsKt.isNullable(actualType) && IrTypePredicatesKt.isNullableNothing(expectedType)) {
            IrClass irClass = IrTypesKt.getClass(expectedType);
            WasmHeapType.Simple type2 = (irClass != null ? irClass.isExternal() : false) ? (WasmHeapType.Simple)WasmHeapType.Simple.NoExtern.INSTANCE : (WasmHeapType.Simple)WasmHeapType.Simple.None.INSTANCE;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(type2)};
            this.body.buildInstr(WasmOp.REF_CAST_NULL, location, wasmImmediateArray);
            return;
        }
        IrClass expectedClassErased = TypeTransformerKt.getRuntimeClass(expectedType, this.irBuiltIns);
        if (expectedClassErased.isExternal()) {
            return;
        }
        IrClass actualClassErased = TypeTransformerKt.getRuntimeClass(actualType, this.irBuiltIns);
        IrSimpleType expectedTypeErased = IrUtilsKt.getDefaultType(expectedClassErased);
        if (Intrinsics.areEqual(expectedTypeErased, actualTypeErased = IrUtilsKt.getDefaultType(actualClassErased))) {
            return;
        }
        if (IrTypePredicatesKt.isNothing(expectedTypeErased) && !IrTypePredicatesKt.isNothing(actualTypeErased)) {
            LocationUtilsKt.buildUnreachableAfterNothingType(this.body);
            return;
        }
        if (IrUtilsKt.isSubclassOf(actualClassErased, expectedClassErased)) {
            return;
        }
        boolean expectedIsPrimitive = IrTypePredicatesKt.isPrimitiveType$default(expectedTypeErased, false, 1, null) && !IrTypeUtilsKt.isNullable(expectedType);
        boolean bl = actualIsPrimitive = IrTypePredicatesKt.isPrimitiveType$default(actualTypeErased, false, 1, null) && !IrTypeUtilsKt.isNullable(actualType);
        if (expectedIsPrimitive != actualIsPrimitive) {
            LocationUtilsKt.buildUnreachableForVerifier(this.body);
            return;
        }
        if (!expectedIsPrimitive) {
            if (IrUtilsKt.isSubclassOf(expectedClassErased, actualClassErased)) {
                this.generateRefCast(actualTypeErased, expectedTypeErased, IrTypeUtilsKt.isNullable(expectedType), location);
                WasmExpressionBuilder this_$iv = this.body;
                boolean $i$f$commentPreviousInstr = false;
                if (!this_$iv.getSkipCommentInstructions()) {
                    String string2;
                    WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
                    int n2 = 0;
                    WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
                    SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
                    WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
                    WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
                    boolean bl2 = false;
                    String string3 = string2 = "to make verifier happy";
                    wasmImmediateArray2[n2] = new WasmImmediate.ConstString(string3);
                    wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
                }
            } else {
                LocationUtilsKt.buildUnreachableForVerifier(this.body);
            }
        }
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        IrReturnableBlockSymbol nonLocalReturnSymbol;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrReturnTargetSymbol irReturnTargetSymbol = expression2.getReturnTargetSymbol();
        IrReturnableBlockSymbol irReturnableBlockSymbol = nonLocalReturnSymbol = irReturnTargetSymbol instanceof IrReturnableBlockSymbol ? (IrReturnableBlockSymbol)irReturnTargetSymbol : null;
        if (nonLocalReturnSymbol != null) {
            this.generateWithExpectedType$backend_wasm(expression2.getValue(), ((IrReturnableBlock)nonLocalReturnSymbol.getOwner()).getType());
            this.body.buildBr(this.functionContext.referenceNonLocalReturnLevel(nonLocalReturnSymbol), this.getSourceLocation(expression2));
        } else {
            this.visitFunctionReturn(expression2);
        }
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2) {
        IrWhen irWhen;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (!this.backendContext.isDebugFriendlyCompilation() && OptimisedWhenGeneratorKt.tryGenerateOptimisedWhen(this, expression2, this.backendContext.getWasmSymbols(), this.functionContext, this.wasmModuleTypeTransformer)) {
            return;
        }
        List<IrBranch> branches = expression2.getBranches();
        IrBranch onlyOneBranch = CollectionsKt.singleOrNull(branches);
        if (onlyOneBranch != null && IrUtilsKt.isElseBranch(onlyOneBranch)) {
            this.generateExpression$backend_wasm(onlyOneBranch.getResult());
            return;
        }
        WasmType resultType = this.wasmModuleTypeTransformer.transformBlockResultType(expression2.getType());
        int ifCount = 0;
        boolean seenElse = false;
        boolean isLogicalOperator = Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.Companion.getANDAND()) || Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.Companion.getOROR());
        IrWhen it = irWhen = expression2;
        boolean bl = false;
        IrWhen irWhen2 = isLogicalOperator ? irWhen : null;
        SourceLocation expressionLocation = irWhen2 != null ? this.getSourceLocation(irWhen2) : null;
        for (IrBranch irBranch : branches) {
            if (!IrUtilsKt.isElseBranch(irBranch)) {
                if (ifCount > 0) {
                    WasmExpressionBuilder.buildElse$default(this.body, null, 1, null);
                }
                this.generateExpression$backend_wasm(irBranch.getCondition());
                this.body.buildIf(null, resultType);
                this.generateWithExpectedType$backend_wasm(irBranch.getResult(), expression2.getType());
                ++ifCount;
                continue;
            }
            this.body.buildElse(expressionLocation);
            this.generateWithExpectedType$backend_wasm(irBranch.getResult(), expression2.getType());
            seenElse = true;
            break;
        }
        if (!seenElse && resultType != null) {
            boolean bl2;
            boolean bl3 = bl2 = !Intrinsics.areEqual(expression2.getType(), this.irBuiltIns.getNothingType());
            if (_Assertions.ENABLED && !bl2) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (IrTypePredicatesKt.isUnit(expression2.getType())) {
                if (!((Collection)branches).isEmpty()) {
                    WasmExpressionBuilder.buildElse$default(this.body, null, 1, null);
                }
                this.buildGetUnit(this.body);
            } else {
                throw new IllegalStateException(("'When' without else branch and non Unit type: " + DumpKotlinLikeKt.dumpKotlinLike(expression2.getType())).toString());
            }
        }
        for (int i2 = 0; i2 < ifCount; ++i2) {
            IrBranch irBranch;
            int n2 = i2;
            boolean bl4 = false;
            IrBranch it3 = irBranch = branches.get(CollectionsKt.getLastIndex(branches) - n2);
            boolean bl5 = false;
            IrBranch irBranch2 = !isLogicalOperator ? irBranch : null;
            SourceLocation endLocation = irBranch2 != null ? this.nextLocation(irBranch2) : null;
            this.body.buildEnd(endLocation);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop) {
        void $this$iv;
        void $this$iv2;
        Intrinsics.checkNotNullParameter(loop, "loop");
        String label = loop.getLabel();
        WasmExpressionBuilder $this$iv3 = this.body;
        WasmType resultType$iv = null;
        boolean $i$f$buildLoop = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv)};
        $this$iv3.buildInstr(WasmOp.LOOP, SourceLocation.Companion.NoLocation("LOOP"), wasmImmediateArray);
        int wasmLoop = $this$iv3.getNumberOfNestedBlocks();
        boolean bl = false;
        WasmExpressionBuilder wasmExpressionBuilder = this.body;
        String label$iv = "BREAK_" + label;
        WasmType resultType$iv2 = null;
        boolean $i$f$buildBlock = false;
        WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv2)};
        $this$iv2.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray2);
        int wasmBreakBlock = $this$iv2.getNumberOfNestedBlocks();
        boolean bl2 = false;
        WasmExpressionBuilder wasmExpressionBuilder2 = this.body;
        String label$iv2 = "CONTINUE_" + label;
        WasmType resultType$iv3 = null;
        boolean $i$f$buildBlock2 = false;
        WasmImmediate[] wasmImmediateArray3 = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv3)};
        $this$iv.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray3);
        int wasmContinueBlock = $this$iv.getNumberOfNestedBlocks();
        boolean bl3 = false;
        this.functionContext.defineLoopLevel(loop, LoopLabelType.BREAK, wasmBreakBlock);
        this.functionContext.defineLoopLevel(loop, LoopLabelType.CONTINUE, wasmContinueBlock);
        IrExpression irExpression = loop.getBody();
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl4 = false;
            this.generateAsStatement(it);
        }
        WasmExpressionBuilder.buildEnd$default((WasmExpressionBuilder)$this$iv, null, 1, null);
        this.generateExpression$backend_wasm(loop.getCondition());
        this.body.buildBrIf(wasmLoop, this.getSourceLocation(loop.getCondition()));
        WasmExpressionBuilder.buildEnd$default((WasmExpressionBuilder)$this$iv2, null, 1, null);
        WasmExpressionBuilder.buildEnd$default($this$iv3, null, 1, null);
        this.buildGetUnit(this.body);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop) {
        void $this$iv;
        Intrinsics.checkNotNullParameter(loop, "loop");
        String label = loop.getLabel();
        WasmExpressionBuilder $this$iv2 = this.body;
        WasmType resultType$iv = null;
        boolean $i$f$buildLoop = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv)};
        $this$iv2.buildInstr(WasmOp.LOOP, SourceLocation.Companion.NoLocation("LOOP"), wasmImmediateArray);
        int wasmLoop = $this$iv2.getNumberOfNestedBlocks();
        boolean bl = false;
        WasmExpressionBuilder wasmExpressionBuilder = this.body;
        String label$iv = "BREAK_" + label;
        WasmType resultType$iv2 = null;
        boolean $i$f$buildBlock = false;
        WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv2)};
        $this$iv.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray2);
        int wasmBreakBlock = $this$iv.getNumberOfNestedBlocks();
        boolean bl2 = false;
        this.functionContext.defineLoopLevel(loop, LoopLabelType.BREAK, wasmBreakBlock);
        this.functionContext.defineLoopLevel(loop, LoopLabelType.CONTINUE, wasmLoop);
        this.generateExpression$backend_wasm(loop.getCondition());
        SourceLocation location = this.getSourceLocation(loop.getCondition());
        this.body.buildInstr(WasmOp.I32_EQZ, location, new WasmImmediate[0]);
        this.body.buildBrIf(wasmBreakBlock, location);
        IrExpression irExpression = loop.getBody();
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl3 = false;
            this.generateAsStatement(it);
        }
        this.body.buildBr(wasmLoop, SourceLocation.Companion.NoLocation("Continue in the loop"));
        WasmExpressionBuilder.buildEnd$default((WasmExpressionBuilder)$this$iv, null, 1, null);
        WasmExpressionBuilder.buildEnd$default($this$iv2, null, 1, null);
        this.buildGetUnit(this.body);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        this.functionContext.defineLocal(declaration.getSymbol());
        if (declaration.getInitializer() == null) {
            return;
        }
        IrExpression irExpression = declaration.getInitializer();
        Intrinsics.checkNotNull(irExpression);
        IrExpression init = irExpression;
        this.generateExpression$backend_wasm(init);
        WasmLocal varName = this.functionContext.referenceLocal(declaration.getSymbol());
        this.body.buildSetLocal(varName, this.getSourceLocation(init));
    }

    private final boolean tryToGenerateWasmOpIntrinsicCall(IrFunctionAccessExpression call2, IrFunction function2) {
        if (AnnotationsKt.hasWasmNoOpCastAnnotation(function2)) {
            return true;
        }
        String opString = AnnotationsKt.getWasmOpAnnotation(function2);
        if (opString != null) {
            SourceLocation location = this.getSourceLocation(call2);
            WasmOp op = WasmOp.valueOf(opString);
            switch (op.getImmediates().size()) {
                case 0: {
                    this.body.buildInstr(op, location, new WasmImmediate[0]);
                    break;
                }
                case 1: {
                    WasmImmediate wasmImmediate;
                    WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
                    WasmImmediateKind imm = op.getImmediates().get(0);
                    switch (WhenMappings.$EnumSwitchMapping$1[imm.ordinal()]) {
                        case 1: {
                            wasmImmediate = new WasmImmediate.MemArg(0, 0, null);
                            break;
                        }
                        case 2: {
                            wasmImmediate = new WasmImmediate.GcType(BodyGenerator.tryToGenerateWasmOpIntrinsicCall$getReferenceGcType(function2, call2, this));
                            break;
                        }
                        case 3: {
                            wasmImmediate = new WasmImmediate.HeapType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)BodyGenerator.tryToGenerateWasmOpIntrinsicCall$getReferenceGcType(function2, call2, this)));
                            break;
                        }
                        case 4: {
                            wasmImmediate = new WasmImmediate.TypeIdx((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)BodyGenerator.tryToGenerateWasmOpIntrinsicCall$getReferenceGcType(function2, call2, this));
                            break;
                        }
                        case 5: {
                            wasmImmediate = new WasmImmediate.MemoryIdx(0);
                            break;
                        }
                        default: {
                            throw new IllegalStateException(("Immediate " + (Object)((Object)imm) + " is unsupported").toString());
                        }
                    }
                    wasmImmediateArray[0] = wasmImmediate;
                    WasmImmediate[] immediates = wasmImmediateArray;
                    this.body.buildInstr(op, location, Arrays.copyOf(immediates, immediates.length));
                    break;
                }
                default: {
                    throw new IllegalStateException(("Op " + opString + " is unsupported").toString());
                }
            }
            return true;
        }
        return false;
    }

    private final SourceLocation getSourceLocation(IrElement $this$getSourceLocation) {
        Object object;
        return LocationUtilsKt.getSourceLocation$default($this$getSourceLocation, this.functionContext.getCurrentFunctionSymbol(), (object = this.functionContext.getCurrentFunctionSymbol()) != null && (object = object.getOwner()) != null ? IrUtilsKt.getFileOrNull((IrDeclaration)object) : null, null, 4, null);
    }

    private final SourceLocation getSourceEndLocation(IrElement $this$getSourceEndLocation) {
        Object object;
        return LocationUtilsKt.getSourceLocation($this$getSourceEndLocation, this.functionContext.getCurrentFunctionSymbol(), (object = this.functionContext.getCurrentFunctionSymbol()) != null && (object = object.getOwner()) != null ? IrUtilsKt.getFileOrNull((IrDeclaration)object) : null, LocationType.END);
    }

    private final SourceLocation nextLocation(IrElement $this$nextLocation) {
        return this.getSourceLocation($this$nextLocation) instanceof SourceLocation.DefinedLocation ? (SourceLocation)SourceLocation.NextLocation.INSTANCE : (SourceLocation)SourceLocation.NoLocation.INSTANCE;
    }

    private static final IrSimpleFunction unitGetInstance_delegate$lambda$0(BodyGenerator this$0) {
        return MiscKt.findUnitGetInstanceFunction(this$0.backendContext);
    }

    private static final IrField unitInstanceField_delegate$lambda$1(BodyGenerator this$0) {
        return MiscKt.findUnitInstanceField(this$0.backendContext);
    }

    private static final IrType visitVararg$lambda$11(IrConstructor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        IrValueParameter irValueParameter = CollectionsKt.singleOrNull(it.getParameters());
        return irValueParameter != null ? irValueParameter.getType() : null;
    }

    private static final WasmSymbol<WasmTypeDeclaration> tryToGenerateWasmOpIntrinsicCall$getReferenceGcType(IrFunction $function, IrFunctionAccessExpression $call, BodyGenerator this$0) {
        IrAnnotationContainer irAnnotationContainer = $function.getDispatchReceiverParameter();
        if (irAnnotationContainer == null || (irAnnotationContainer = irAnnotationContainer.getType()) == null) {
            IrType irType = $call.getTypeArguments().get(0);
            Intrinsics.checkNotNull(irType);
            irAnnotationContainer = irType;
        }
        IrAnnotationContainer type2 = irAnnotationContainer;
        WasmFileCodegenContext wasmFileCodegenContext = this$0.wasmFileCodegenContext;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)type2);
        Intrinsics.checkNotNull(irClassSymbol);
        return wasmFileCodegenContext.referenceGcType(irClassSymbol);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.REINTERPRET_CAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[WasmImmediateKind.values().length];
            try {
                nArray[WasmImmediateKind.MEM_ARG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmImmediateKind.STRUCT_TYPE_IDX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmImmediateKind.HEAP_TYPE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmImmediateKind.TYPE_IDX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmImmediateKind.MEMORY_IDX.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

