/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.IdentityHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LocationType;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.LineAndColumn;
import org.jetbrains.kotlin.ir.backend.js.lower.CallableReferenceLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.EnumClassLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.coroutines.AbstractSuspendFunctionsLowering;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0011\u001a\u00020\u0012*\u00020\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u001a\u001a\n\u0010\u001b\u001a\u00020\u0019*\u00020\u001a\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\b\u001a\u00020\u0001*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\"\u0018\u0010\u000b\u001a\u00020\u0001*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\n\"\u0018\u0010\f\u001a\u00020\u0001*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\"\u001a\u0010\r\u001a\u00020\u0001*\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"hasSyntheticOrUndefinedLocation", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "getHasSyntheticOrUndefinedLocation", "(Lorg/jetbrains/kotlin/ir/IrElement;)Z", "debugFriendlyOrigins", "Ljava/util/IdentityHashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "isInlinedCode", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Z", "isStdlibDeclaration", "isArtificialDeclarationOfLambdaImpl", "shouldIgnore", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getShouldIgnore", "(Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;)Z", "getSourceLocation", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "declaration", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "type", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/LocationType;", "buildUnreachableForVerifier", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "buildUnreachableAfterNothingType", "backend.wasm"})
public final class LocationUtilsKt {
    @NotNull
    private static final IdentityHashMap<IrDeclarationOrigin, Boolean> debugFriendlyOrigins;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getHasSyntheticOrUndefinedLocation(IrElement $this$hasSyntheticOrUndefinedLocation) {
        boolean bl;
        int n2 = $this$hasSyntheticOrUndefinedLocation.getStartOffset();
        if (-2 <= n2) {
            if (n2 < 0) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        n2 = $this$hasSyntheticOrUndefinedLocation.getEndOffset();
        if (-2 > n2) return false;
        if (n2 >= 0) return false;
        return true;
    }

    private static final boolean isInlinedCode(IrDeclaration $this$isInlinedCode) {
        return $this$isInlinedCode instanceof IrFunction && (((IrFunction)$this$isInlinedCode).isInline() || Intrinsics.areEqual($this$isInlinedCode.getOrigin(), IrDeclarationOrigin.Companion.getINLINE_LAMBDA()));
    }

    private static final boolean isStdlibDeclaration(IrDeclaration $this$isStdlibDeclaration) {
        return IrUtilsKt.getPackageFragment($this$isStdlibDeclaration).getPackageFqName().startsWith(StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE());
    }

    private static final boolean isArtificialDeclarationOfLambdaImpl(IrDeclaration $this$isArtificialDeclarationOfLambdaImpl) {
        IrClass irClass = IrUtilsKt.getParentClassOrNull($this$isArtificialDeclarationOfLambdaImpl);
        return Intrinsics.areEqual(irClass != null ? irClass.getOrigin() : null, CallableReferenceLowering.Companion.getLAMBDA_IMPL()) && !Intrinsics.areEqual($this$isArtificialDeclarationOfLambdaImpl.getOrigin(), IrDeclarationOrigin.Companion.getDEFINED()) && !Intrinsics.areEqual($this$isArtificialDeclarationOfLambdaImpl.getOrigin(), AbstractSuspendFunctionsLowering.Companion.getDECLARATION_ORIGIN_COROUTINE_IMPL_INVOKE());
    }

    private static final boolean getShouldIgnore(IrSymbol $this$shouldIgnore) {
        IrSymbol irSymbol = $this$shouldIgnore;
        IrSymbolOwner irSymbolOwner = irSymbol != null ? irSymbol.getOwner() : null;
        IrDeclaration irDeclaration2 = irSymbolOwner instanceof IrDeclaration ? (IrDeclaration)irSymbolOwner : null;
        if (irDeclaration2 == null) {
            return false;
        }
        IrDeclaration owner = irDeclaration2;
        return LocationUtilsKt.isStdlibDeclaration(owner) || LocationUtilsKt.isArtificialDeclarationOfLambdaImpl(owner) || !((Map)debugFriendlyOrigins).containsKey(owner.getOrigin());
    }

    @NotNull
    public static final SourceLocation getSourceLocation(@NotNull IrElement $this$getSourceLocation, @Nullable IrSymbol declaration, @Nullable IrFile file2, @NotNull LocationType type2) {
        IrFileEntry fileEntry2;
        Intrinsics.checkNotNullParameter($this$getSourceLocation, "<this>");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        if (LocationUtilsKt.getShouldIgnore(declaration)) {
            return declaration instanceof IrFunctionSymbol && LocationUtilsKt.isInlinedCode(((IrFunctionSymbol)declaration).getOwner()) ? SourceLocation.Companion.NoLocation("Inlined function body") : (SourceLocation)SourceLocation.IgnoredLocation.INSTANCE;
        }
        IrFile irFile = file2;
        IrFileEntry irFileEntry = fileEntry2 = irFile != null ? irFile.getFileEntry() : null;
        if (fileEntry2 == null) {
            return SourceLocation.Companion.NoLocation("fileEntry is null");
        }
        if (LocationUtilsKt.getHasSyntheticOrUndefinedLocation($this$getSourceLocation)) {
            return SourceLocation.Companion.NoLocation("Synthetic declaration");
        }
        String path = fileEntry2.getName();
        LineAndColumn lineAndColumn = type2.getLineAndColumnNumberFor($this$getSourceLocation, fileEntry2);
        int line = lineAndColumn.component1();
        int column = lineAndColumn.component2();
        String string2 = file2.getModule().getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        return new SourceLocation.DefinedLocation(string2, path, line, column);
    }

    public static /* synthetic */ SourceLocation getSourceLocation$default(IrElement irElement, IrSymbol irSymbol, IrFile irFile, LocationType locationType, int n2, Object object) {
        if ((n2 & 4) != 0) {
            locationType = LocationType.START;
        }
        return LocationUtilsKt.getSourceLocation(irElement, irSymbol, irFile, locationType);
    }

    public static final void buildUnreachableForVerifier(@NotNull WasmExpressionBuilder $this$buildUnreachableForVerifier) {
        Intrinsics.checkNotNullParameter($this$buildUnreachableForVerifier, "<this>");
        $this$buildUnreachableForVerifier.buildUnreachable(SourceLocation.Companion.NoLocation("This instruction should never be reached, but required for wasm verifier"));
    }

    public static final void buildUnreachableAfterNothingType(@NotNull WasmExpressionBuilder $this$buildUnreachableAfterNothingType) {
        Intrinsics.checkNotNullParameter($this$buildUnreachableAfterNothingType, "<this>");
        $this$buildUnreachableAfterNothingType.buildUnreachable(SourceLocation.Companion.NoLocation("The unreachable instruction after an expression with Nothing type to make sure that execution doesn't come here (or it fails fast if so). It also might be required for wasm verifier."));
    }

    static {
        IdentityHashMap identityHashMap;
        IdentityHashMap $this$debugFriendlyOrigins_u24lambda_u240 = identityHashMap = new IdentityHashMap();
        boolean bl = false;
        ((Map)$this$debugFriendlyOrigins_u24lambda_u240).put(IrDeclarationOrigin.Companion.getDEFINED(), true);
        ((Map)$this$debugFriendlyOrigins_u24lambda_u240).put(IrDeclarationOrigin.Companion.getLOCAL_FUNCTION(), true);
        ((Map)$this$debugFriendlyOrigins_u24lambda_u240).put(IrDeclarationOrigin.Companion.getLOCAL_FUNCTION_FOR_LAMBDA(), true);
        ((Map)$this$debugFriendlyOrigins_u24lambda_u240).put(IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER(), true);
        ((Map)$this$debugFriendlyOrigins_u24lambda_u240).put(IrDeclarationOrigin.Companion.getLOWERED_SUSPEND_FUNCTION(), true);
        ((Map)$this$debugFriendlyOrigins_u24lambda_u240).put(AbstractSuspendFunctionsLowering.Companion.getDECLARATION_ORIGIN_COROUTINE_IMPL_INVOKE(), true);
        ((Map)$this$debugFriendlyOrigins_u24lambda_u240).put(EnumClassLoweringKt.getENUM_ENTRIES_INITIALIZER_ORIGIN(), true);
        debugFriendlyOrigins = identityHashMap;
    }
}

